// Persistence of Vision Ray Tracer Scene Description File
// File: EntryLamp.inc
// Vers: 3.5
// Desc: AnyTimeNow
// Date: 08/27/02
// Auth: Jeff M. Thomas
//

#macro mTop()
  #local PointCount = 8;
  #local ControllPoints = array[PointCount]
    {
      <0, .8, 0>,    
      <0, .8, 0>,     
      <0, .4, 0>,       
      <0, .4, 0>,       
      < .35, .2, 0>,
      < .15, -.1, 0>,
      < -.15, -.15, 0>,
      < -.1, 0, 0>,
//      < -.4, -.1, 0>,
   }
  #local ControllRadius = array[PointCount]
    {
        .1, .1, .09, .09, .09, .09, .09, .01//, .05
    }
  #local TopSize = .675;    
  #local TopPart=
  prism 
  {
    conic_sweep
    linear_spline
    1, // height 1
    0, // height 2
    5, // the number of points making up the shape...
    <TopSize,TopSize>,<-TopSize,TopSize>,<-TopSize,-TopSize>,<TopSize,-TopSize>,<TopSize,TopSize>
    rotate <180,0,0>
    scale <0,.5,0>
    texture{ Texture_LampMetal }
  }
  //top
  #declare Top=
  union
  {
    difference
    {
      object
      { 
        TopPart
        translate <0,1,0>
      }
      object
      { 
        TopPart
        scale .99
        translate <0,.99,0>
      }
    }
    sphere
    {
      <0,1,0>,.075
    }
    torus
    {
      .1,.02
      rotate x*90
      translate<0,1.1,0>
    }
    torus
    {
      .1,.02
      rotate <90,90,0>    
      translate<0,1.28,0>
    }
    sphere_sweep 
    {
      b_spline
      PointCount,
      #local Count = 0;
      #while( Count < PointCount )
        ControllPoints[Count], ControllRadius[Count]
        #local Count = Count + 1;
      #end                  
      tolerance 0.001
      scale .25
      rotate -90*z
      translate <-.038,1.4,0>

    }
    cylinder
    {
      -.4*x, .4*x, .024
      translate <.47,1.40,0>
    }
    box
    {
      <-.0125,-.5,-.04>
      < .0125, .5, .04>
      translate<.875,1.8,0>
    }
    box
    {
      <-.0125,-.55,-.04>
      < .0125, .55, .04>
      rotate -45*z
      translate<.475,1.8,0>
    }
    texture
    {
      Texture_LampMetal
    }
    translate <0,-.05,0>
 }
#end // macro mTop
#macro mGlassFlame()
  #declare GlassFlame=
  difference
  {
    blob 
    {
      threshold 0.3
      sphere { < 0, .06, 0>, .015, 1 }
      sphere { <-.004,  .05, 0>, .020, .45 }
      sphere { <-.006,  .04, 0>, .025, .45 }
      sphere { <-.005,  .025, 0>, .03, .45 }
      sphere { <0,  0, 0>, .04, 1 }
      cylinder { <0,  0, 0>, < 0,   .06,    0>, .01, 1 }
      material { Material_GlassFlame }
    }
    blob 
    {
      threshold 0.3
      sphere { < 0, .06, 0>, .015, 1 }
      sphere { <-.004,  .05, 0>, .020, .45 }
      sphere { <-.006,  .04, 0>, .025, .45 }
      sphere { <-.005,  .025, 0>, .03, .45 }
      sphere { <0,  0, 0>, .04, 1 }
      cylinder { <0,  0, 0>, < 0,   .06,    0>, .01, 1 }
      material { Material_GlassFlame }
      scale .99                
    }
    photons 
    { 
      target
      collect off
      refraction on
      reflection on
    }                
  }    
#end // macro GlassFlame
#macro mPane()
  #local Lean = 0;
  #declare Pane=
  difference
  {
    box
    {
      <-.2,-.3,-.01>
      < .2, .3, .01>
    }
    union
    {
      box
      {
        <-.08,-.31,-.01>
        < .08, .31, .01>
        rotate 10*y
        rotate Lean*z
        translate <-.215,0,-.01>
      }
      box
      {
        <-.08,-.31,-.01>
        < .08, .31, .01>
        rotate -10*y
        rotate Lean*z
        translate <-.215,0,.01>
      }
    }
    union
    {
      box
      {
        <-.08,-.31,-.01>
        < .08, .31, .01>
        rotate 10*y
        rotate Lean*z
        translate <-.215,0,-.01>
      }
      box
      {
        <-.08,-.31,-.01>
        < .08, .31, .01>
        rotate -10*y
        rotate Lean*z
        translate <-.215,0,.01>
      }
      rotate 180*y
    }
    union
    {
      box
      {
        <-.08,-.21,-.01>
        < .08, .21, .01>
        rotate 10*y
        translate <-.315,0,-.01>
      }
      box
      {
        <-.08,-.21,-.01>
        < .08, .21, .01>
        rotate -10*y
        translate <-.315,0,.01>
      }
      rotate 90*z
    }
    union
    {
      box
      {
        <-.08,-.21,-.01>
        < .08, .21, .01>
        rotate 10*y
        translate <-.315,0,-.01>
      }
      box
      {
        <-.08,-.21,-.01>
        < .08, .21, .01>
        rotate -10*y
        translate <-.315,0,.01>
      }
      rotate -90*z
    }
    photons 
    {
      target
      refraction on
      reflection on
    }                
    material { Material_Pane }  
  }
#end // macro mPane
 
#macro mEntryLamp(Material_Pane,Material_GlassFlame,Texture_LampMetal,WALL_LIGHT,RADIOSITY,PHOTONS)
  mPane()
  #declare EntryLamp= 
  union
  {                    
    object
    {
      Pane
      translate<0,0,.2>
    }
    object
    {
      Pane
      translate<0,0,-.2>
    }
    object
    {
      Pane
      translate<0,0,.2>
      rotate 90*y
    }
    object
    {
      Pane
      translate<0,0,-.2>
      rotate 90*y
    }
    union // base & posts
    {
      box
      {
        <-.020,-.3,-.020>
        < .020, .3, .020>
        translate<.2,0,-.2>
      }
      box
      {
        <-.020,-.3,-.020>
        < .020, .3, .020>
        translate<.2,0,.2>
      }
      box
      {
        <-.020,-.3,-.020>
        < .020, .3, .020>
        translate<-.2,0,-.2>
      }
      box
      {
        <-.020,-.3,-.020>
        < .020, .3, .020>
        translate<-.2,0,.2>
      }
      box
      {
        <-.22,-.3,-.22>
        < .22,-.34, .22>
      }
      texture{ Texture_LampMetal }
    }
    mGlassFlame() 
    union // plastic candlesticks
    {
      union
      {
        cylinder 
        { 
          <0, -.3, 0>, <0, .10, 0>, .04
          texture
          {
            pigment { color red 0.847059 green 0.847059 blue 0.74902 }
            finish{ phong .6 }
          }
        }
        object
        {
          GlassFlame
          translate<0,.12,0>
        }
        #if (WALL_LIGHT)
          light_source 
          {
            <0, 0, 0>
          #if (RADIOSITY)             
            color rgb <.25, .25, .15>
          #else
            color rgb <.95, .95, .85>
          #end // RADIOSITY
            translate<0,.13,0>
          #if (PHOTONS)
            photons {
              reflection on
              refraction on
            }
          #end
          } 
        #end // WALL_LIGHT
        translate<.08,0,.08> 
      }
      union
      {
        cylinder 
        { 
          <0, -.3, 0>, <0, .05, 0>, .04
          texture
          {
            pigment { color red 0.847059 green 0.847059 blue 0.74902 }
            finish{ phong .6 }
          }
        }
        object
        {
          GlassFlame
          rotate 180*y
          translate<0,.07,0>
        }
        #if (WALL_LIGHT)
          light_source 
          {
            <0, 0, 0>
          #if (RADIOSITY)             
            color rgb <.25, .25, .15>
          #else
            color rgb <.95, .95, .85>
          #end // RADIOSITY
            translate<0,.08,0>
          #if (PHOTONS)
            photons {
              reflection on
              refraction on
            }
          #end
          } 
        #end // WALL_LIGHT
        translate<.08,0,-.08> 
      }
      union
      {
        cylinder 
        { 
          <0, -.3, 0>, <0, .0, 0>, .04
          texture
          {
            pigment { color red 0.847059 green 0.847059 blue 0.74902 }
            finish{ phong .6 }
          }
        }
        object
        {
          GlassFlame
          rotate 100*y
          translate<0,.02,0>
        }
        #if (WALL_LIGHT)
          light_source 
          {
            <0, 0, 0>
          #if (RADIOSITY)             
            color rgb <.25, .25, .15>
          #else
            color rgb <.95, .95, .85>
          #end // RADIOSITY
            translate<0,.03,0>
          #if (PHOTONS)
            photons {
              reflection on
              refraction on
            }
          #end
          } 
        #end // WALL_LIGHT
        translate<-.08,0,-.00> 
      }
    }
    mTop()
    object
    {
      Top
      scale .5
      translate<0,-.005,0>
    }
  }
#end // macro EntryLamp

//mEntryLamp()
//object{ EntryLamp rotate <20,-20,0> }
/*
mGlassFlame()
        object
        {
          GlassFlame
          rotate 100*y
          //translate<0,-.08,0>
        }
*/
