//Abduction
//povray 3.5

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "glass.inc"
#include "metals.inc"
#include "figure.inc"

global_settings {
	max_trace_level 150
	radiosity {
		media on
		normal on
		brightness 1.5
	}
}

camera {
	location < 0, 4, -2>
	up <0, 1, 0>
	look_at <-5, 2.5, 4>
}

media {
	scattering {3, 1}
	samples 1, 10
	intervals 20
	density {
		planar
		color_map {
			[1 color rgb <0.1, 0.1, 0.1>]
		}
	}
}

light_source {<-3.70625, 4.25, 9.9> color <1, 2, 7>
	spotlight
	point_at <-5.75, 2, 4.75>
	radius 15
	falloff 20
	tightness 1
}

light_source {<-3.70625, 4.25, 9.9> color <0.01, 0.02, 0.07>*0.25}


//light_source {<0, 5.8, 0> color rgb <0.4, 0.4, 0.4>}

#declare walltext=
texture {
	pigment {White}
	normal {
		granite
		turbulence 0.2 lambda 3
		bump_size 0.075
		scale 0.5
	}
	finish {Dull}
}

#declare carptext=
texture {
	pigment {rgb <0.7, 0.6, 0.4>}
	//pigment {rgb <0.3, 0, 0.05>}
	finish {roughness 0.5 specular 0.4}
	normal {bozo turbulence 0.3 octaves 7 lambda 4 bump_size 3 scale 0.075}
}
//floor
box {<-10.5, -0.5, -10.5>, <10.5, 0, 10.5>
	texture {carptext}
}

//walls & ceiling
difference {
	box {<-10.5, 0, -10.5>, <10.5, 6.5, 10.5>}
	box {<-10, -0.1, -10>, <10, 6, 10>}
	texture {walltext}
}

//baseboards & window sill
union {
	box {<-10, 0, -10>, <10, 0.35, -9.9> texture {T_Wood12 rotate y*90}}
	box {<-10, 0, 9.9>, <10, 0.35, 10> texture {T_Wood12 rotate y*90}}
	box {<9.9, 0, 10>, <10, 0.35, -10> texture {T_Wood12}}
	box {<-9.9, 0, 10>, <-10, 0.35, -10> texture {T_Wood12}}
	texture {T_Wood12}
}

#declare bedguide=
box {<-9.5, 0.5, 2.75>, <-4, 1.25, 6.75> pigment {Blue}}

#declare bed=
union {
	superellipsoid {<0.15, 0.15>
		scale <2.7, 0.4, 2>
		translate <-6.75, 0.95, 4.75>
	}
	superellipsoid {<0.75, 0.25>
		scale <0.5, 0.125, 0.75>
		translate <-8.75, 1.45, 3.6>
	}
	superellipsoid {<0.75, 0.25>
		scale <0.5, 0.125, 0.75>
		translate <-8.75, 1.45, 5.4>
	}
	pigment {White}
	normal {wrinkles turbulence 0.3 bump_size 0.2}
	finish {Dull}
}
 
#declare frame=
union {
	//head posts
	difference {
		union {
			cylinder {<-9.5, 0, 2.75>, <-9.5, 2.25, 2.75>, 0.125}
			sphere {<-9.5, 0, 2.75>, 0.125 scale <1, 0.5, 1> translate <0, 2.25, 0>}
		}
		torus {0.125, 0.025 scale <1, 2, 1> translate <-9.5, 2.05, 2.75>}
	}
	difference {
		union {
			cylinder {<-9.5, 0, 6.75>, <-9.5, 2.25, 6.75>, 0.125}
			sphere {<-9.5, 0, 6.75>, 0.125 scale <1, 0.5, 1> translate <0, 2.25, 0>} 
		}
		torus {0.125, 0.025 scale <1, 2, 1> translate <-9.5, 2.05, 6.75>}
	}
	//foot posts
	difference {
		union {
			cylinder {<-4, 0, 2.75>, <-4, 1.25, 2.75>, 0.115}
			sphere {<-4, 0, 2.75>, 0.115 scale <1, 0.5, 1> translate <0, 1.25, 0>}
		}
		torus {0.125, 0.025 scale <1, 2, 1> translate <-4, 1.05, 2.75>}
	}
	difference {
		union {
			cylinder {<-4, 0, 6.75>, <-4, 1.25, 6.75>, 0.115}
			sphere {<-4, 0, 6.75>, 0.115 scale <1, 0.5, 1> translate <0, 1.25, 0>}
		}
		torus {0.125, 0.025 scale <1, 2, 1> translate <-4, 1.05, 6.75>}
	}
	//side rails
	box {<-9.5, 0.4, 2.7>, <-4, 0.85, 2.75>} 
	box {<-9.5, 0.4, 6.75>, <-4, 0.85, 6.8>}
	//head board
	box {<-9.5, 0.4, 2.75>, <-9.6, 1.9, 6.75>}
	//foot board
	box {<-4.05, 0.4, 2.75>, <-3.95, 1, 6.75>}
	texture {T_Wood5 finish {Shiny}}
}

#declare stand=
union {
	union {
		box {<-0.75, 1.4, -0.75>, <0.75, 1.5, 0.75>}
		box {<-0.7, 1.1, -0.7>, <0.7, 1.45, 0.7>}  
		cylinder {<-0.6, 0, -0.6>, <-0.6, 1.11, -0.6>, 0.075}
		cylinder {<-0.6, 0, 0.6>, <-0.6, 1.11, 0.6>, 0.075}
		cylinder {<0.6, 0, -0.6>, <0.6, 1.11, -0.6>, 0.075}
		cylinder {<0.6, 0, 0.6>, <0.6, 1.11, 0.6>, 0.075}
		texture {T_Wood5 finish {Shiny}}
	}
	union {
		cylinder {<0.69, 1.25, 0>, <0.72, 1.25, 0>, 0.02}
		cylinder {<0.72, 1.25, 0>, <0.73, 1.25, 0>, 0.04}
		texture {T_Brass_3D}
	}
}

#declare lamp=
union {
	cylinder {<0, 0, 0>, <0, 0.01, 0>, 0.06 texture {T_Brass_3D}}
	sphere {<0, 0, 0>, 0.08
		scale <1, 5, 1>
		translate <0, 0.35, 0>
		clipped_by {box {<-1, 0, -1>, <1, 0.5, 1>}}
		pigment {rgb <0.6, 0, 0>} 
		finish {Shiny reflection 0.1}
	}
	//cylinder {<0, 0, 0>, <0, 0.5, 0>, 0.1 pigment {Red} finish {Shiny reflection 0.13}}
	cone {<0, 0.45, 0>, 0.35, <0, 0.75, 0>, 0.15 open
		pigment {White}
		finish {Dull}
		normal {granite scale 0.1 bump_size 0.1}
	}
}

#declare picture=
union {
	box {<-2, -1.5, -0.02>, <2, 1.5, 0>
		pigment {
			image_map {png "saucer2.png"}
			translate <-0.5, -0.5, 0>
			scale <4, 3, 1>
		}
		finish {ambient 0.6}
	}
	union {
		box {<-2.15, -1.65, -0.05>, <-2, 1.65, 0>}
		box {<2.15, -1.65, -0.05>, <2, 1.65, 0>}
		box {<-2, 1.5, -0.05>, <2, 1.65, 0>}
		box {<-2, -1.65, -0.05>, <2, -1.5, 0>}
		texture {T_Wood5 finish {Shiny}}
	}
}

#declare clk=
union {
	union {
		sphere {<-0.25, 0.025, -0.15>, 0.025}
		sphere {<0.25, 0.025, -0.15>, 0.025}
		sphere {<-0.25, 0.025, 0.15>, 0.025}
		sphere {<0.25, 0.025, 0.15>, 0.025}
		cylinder {<-0.25, 0.025, -0.15>, <0.25, 0.025, -0.15>, 0.025}
		cylinder {<-0.25, 0.025, 0.15>, <0.25, 0.025, 0.15>, 0.025}
		cylinder {<-0.25, 0.025, -0.15>, <-0.25, 0.025, 0.15>, 0.025}
		cylinder {<0.25, 0.025, -0.15>, <0.25, 0.025, 0.15>, 0.025}
		sphere {<-0.25, 0.225, -0.15>, 0.025}
		sphere {<0.25, 0.225, -0.15>, 0.025}
		sphere {<-0.25, 0.225, 0.15>, 0.025}
		sphere {<0.25, 0.225, 0.15>, 0.025}
		cylinder {<-0.25, 0.225, -0.15>, <0.25, 0.225, -0.15>, 0.025}
		cylinder {<-0.25, 0.225, 0.15>, <0.25, 0.225, 0.15>, 0.025}
		cylinder {<-0.25, 0.225, -0.15>, <-0.25, 0.225, 0.15>, 0.025}
		cylinder {<0.25, 0.225, -0.15>, <0.25, 0.225, 0.15>, 0.025}
		cylinder {<-0.25, 0.025, -0.15>, <-0.25, 0.225, -0.15>, 0.025}
		cylinder {<-0.25, 0.025, 0.15>, <-0.25, 0.225, 0.15>, 0.025}
		cylinder {<0.25, 0.025, -0.15>, <0.25, 0.225, -0.15>, 0.025}
		cylinder {<0.25, 0.025, 0.15>, <0.25, 0.225, 0.15>, 0.025}
		box {<-0.275, 0.025, -0.15>, <0.275, 0.225, 0.15>}
		box {<-0.25, 0, -0.15>, <0.25, 0.25, 0.15>}
		box {<-0.25, 0.025, 0>, <0.25, 0.225, 0.175>}
		pigment {rgb 0}
		finish {Shiny}
	}
    box {<-0.225, 0.05, -0.151>, <0.225, 0.2, -0.15>
    	texture {
    		material_map {
    			png "clock2.png"
    			texture {pigment {rgb 0} finish {Shiny}}
    			texture {pigment {rgb <2, 0.25, 0.25>} finish {Luminous}}
    		}
    		translate <-0.5, 0.125, 0>
    		scale <0.45, 0.2, 1>
    	}
    }
}

#declare cloth=
height_field {
	png "blanket5.png" smooth hollow
	translate <0, -0.07, 0>
}

#declare blanket=
difference {
	height_field {cloth}
	height_field {cloth scale 1.1 translate <0.025, -0.1, -0.1>}
	rotate <0, -90, 0>
	scale <4.5, 1.485, 3.5>
	translate <0, 0, 0>
	pigment {rgb <0.5, 0, 0>}
	normal {wrinkles 1 scale 0.25}
	//finish {Dull}
}

#declare picture2=
union {
	union {
		box {<-1.15, -0.9, 0>, <1.15, -0.75, 0.05>}
		box {<-1.15, 0.75, 0>, <1.15, 0.9, 0.05>}
		box {<-1.15, -0.9, 0>, <-1, 0.9, 0.05>}
		box {<1, -0.9, 0>, <1.15, 0.9, 0.05>}
		texture {T_Wood5 finish {Shiny}}
	}
	box {<-1, -0.75, 0>, <1, 0.75, 0.02>
		pigment {
			image_map {png "picture.png" once}
			translate <-0.5, -0.5, 0>
			scale <2, 1.5, 1>
		}
		finish {ambient 0.8}
	}
}		

#declare fan=
union {
	cylinder {<0, 6, 0>, <0, 5.95, 0>, 0.15 texture {T_Brass_3D}}
	torus {0.1, 0.05 translate <0, 5.95, 0> texture {T_Brass_3D}}
	cylinder {<0, 6.5, 0>, <0, 5.85, 0>, 0.125 texture {T_Brass_3D}}
	difference {
		superellipsoid {<1, 0.275> rotate <90, 0, 0> scale <0.25, 0.1, 0.25> translate <0, 5.8, 0> texture {T_Brass_3D}}
		cylinder {<0, 5.71, 0>, <0, 5.7, 0>, 0.2 texture {T_Brass_1A}}
	}
	cylinder {<0, 6.5, 0>, <0, 5.6, 0>, 0.075 texture {T_Brass_3D}}
	torus {0.075, 0.015 translate <0, 5.6, 0> texture {T_Brass_3D}}
	sphere {<0, 5.4, 0>, 0.2 pigment {rgb 1} finish {Shiny}}
	cylinder {<-0.15, 5.7, 0>, <-0.375, 5.69, 0>, 0.02 texture {T_Brass_3D}}
	cylinder {<0.15, 5.7, 0>, <0.3755, 5.69, 0>, 0.02 texture {T_Brass_3D}}
	cylinder {<0, 5.7, 0.15>, <0, 5.69, 0.375>, 0.02 texture {T_Brass_3D}}
	cylinder {<0, 5.7, -0.15>, <0, 5.69, -0.375>, 0.02 texture {T_Brass_3D}}
	torus {0.075, 0.02 clipped_by {plane {z, 0 inverse}} translate <0, 5.69, -0.45> texture {T_Brass_3D}}
	torus {0.075, 0.02 clipped_by {plane {z, 0}} translate <0, 5.69, 0.45> texture {T_Brass_3D}}
	torus {0.075, 0.02 clipped_by {plane {x, 0}} translate <0.45, 5.69, 0> texture {T_Brass_3D}}
	torus {0.075, 0.02 clipped_by {plane {x, 0 inverse }} translate <-0.45, 5.69, 0> texture {T_Brass_3D}}
	union {
		cylinder {<0, 5.69, -0.45>, <0, 5.71, -0.45>, 0.12}
		box {<-0.12, 5.69, -0.45>, <0.12, 5.71, -1.45>}
		cylinder {<0, 0, 0>, <0, 0.02, 0>, 0.12 scale <1, 1, 0.35> translate <0, 5.69, -1.45>}
		texture {T_Wood12 finish {Shiny}}
	}
	union {
		cylinder {<0, 5.69, 0.45>, <0, 5.71, 0.45>, 0.12}
		box {<-0.12, 5.69, 0.45>, <0.12, 5.71, 1.45>}
		cylinder {<0, 0, 0>, <0, 0.02, 0>, 0.12 scale <1, 1, 0.35> translate <0, 5.69, 1.45>}
		texture {T_Wood12 finish {Shiny}}
	}
	union {
		cylinder {<0.45, 5.69, 0>, <0.45, 5.71, 0>, 0.12}
		box {<-0.45, 5.69, -0.12>, <-1.45, 5.71, 0.12>}
		cylinder {<0, 0, 0>, <0, 0.02, 0>, 0.12 scale <0.35, 1, 1> translate <-1.45, 5.69, 0>}
		texture {T_Wood12 finish {Shiny} rotate y*90}
	}
	union {
		cylinder {<-0.45, 5.69, 0>, <-0.45, 5.71, 0>, 0.12}
		box {<0.45, 5.69, -0.12>, <1.45, 5.71, 0.12>}
		cylinder {<0, 0, 0>, <0, 0.02, 0>, 0.12 scale <0.35, 1, 1> translate <1.45, 5.69, 0>}
		texture {T_Wood12 finish {Shiny} rotate y*90}
	}
}

#declare glasses=
union {
	torus {0.04, 0.005 rotate x*90 translate <-0.06, 0, 0> texture {T_Gold_2C}}
	torus {0.04, 0.005 rotate x*90 translate <0.06, 0, 0> texture {T_Gold_2C}}
	cylinder {<0, 0, -0.0025>, <0, 0, 0.0025>, 0.04 translate <-0.06, 0, 0> texture {T_Glass3} interior {I_Glass}}
	cylinder {<0, 0, -0.0025>, <0, 0, 0.0025>, 0.04 translate <0.06, 0, 0> texture {T_Glass3} interior {I_Glass}}
	cylinder {<-0.02, 0, 0>, <0.02, 0, 0>, 0.005 texture {T_Gold_2C}}
	cylinder {<-0.1, 0, 0>, <-0.1, 0, 0.175>, 0.005 texture {T_Gold_2C}}
	cylinder {<0.1, 0, 0>, <0.1, 0, 0.175>, 0.005 texture {T_Gold_2C}}
	rotate <13, 0, 0>
	translate <0, 0.045, 0>
	scale 1.3
}

#declare book=
union {
	box {<-0.19, 0.01, -0.29>, <0.19, 0.09, 0.29>
		pigment {White}
		normal {gradient y scale 0.01}
		finish {Dull}
	}
	box {<-0.2, 0, -0.3>, <0.2, 0.01, 0.3>
		pigment {rgb <0, 0, 0.5>}
		finish {Dull ambient 0.5}
	}
	box {<0.2, 0, -0.3>, <0.19, 0.1, 0.3>
		pigment {
			image_map {png "book2.png"}
			rotate y*-90
			translate <-0.5, 0, -0.5>
			scale <0.4, 0.3, 1>
		}
		finish {Dull ambient 0.5}
	}
	box {<-0.2, 0.09, -0.3>, <0.2, 0.1, 0.3>
		pigment {
			image_map {png "book2.png"}
			rotate <90, -90, 0>
			translate <-0.33, -0.5, -0.5>
			scale <0.6, 1, 0.6>
		}
		finish {Shiny ambient 0.5}
	}
}

object {fan rotate y*-12 translate <-5, 0, 5>}
object {bed}
object {frame}
object {blanket translate <-3.8, 0, 1.2>}
object {stand translate <-9, 0, 1.8>}
object {stand translate <-9, 0, 7.7>}
object {lamp scale 1.3 translate <-9.25, 1.5, 1.4>}
object {lamp scale 1.3 translate <-9.25, 1.5, 8.1>}
//object {glasses rotate y*10 translate <-8.6, 1.5, 1.9>}
//object {book rotate y*45 translate <-8.5, 1.5, 1.3>}
object {book rotate y*45 translate <-8.5, 1.5, 1.8>}
object {glasses rotate y*10 translate <-8.45, 1.6, 1.75>}
object {picture translate <-4, 3.5, 10>}
object {picture2 rotate <0, -90, 0> translate <-9.95, 3.85, 3>}	 
object {figure scale 4.85 rotate <0, 90, 0> translate <-6.75, 1.35, 4.75>}
//object {clk rotate <0, -105, 0> translate <-8.75, 1.5, 2.1>}
object {clk scale 1.1 rotate <0, -75, 0> translate <-8.55, 1.5, 7.2>}
