// Persistence of Vision Ray Tracer Scene Description File
// File: basic.pov
// Vers: 3.1g
// Desc: Worlds within Worlds competition
// Date: 2002 01 06
// Auth: Matthias M. Giwer
//

#version 3.1 ;

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"

global_settings {assumed_gamma 2.2
		max_trace_level 20 // 70 is too busy
		max_intersections 64
}
// ----------------------------------------
//#declare place = <1,1,-3.5>; 
#declare place = <1.25,1,-4.5>; // left
//#declare place = <.75,1,-4.5>; // right
//left to right backwards for crosseye
camera{
location place
  direction 1.5*z  right  3/4*x
  look_at   <0.0, 0.0,  0.0>
}
//sky_sphere{  pigment  { gradient y color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }}}

light_source{0*x color <1,1,1> translate <300,100,-900> }
//light_source{0*x color <1,1,1> }

// ----------------------------------------

//plane {y, 0 pigment{ color White}}

#declare merid = difference {
cylinder{-.01*z, .0015*z 1} // .0015
cylinder{-.011*z, .0016*z .975}// .0016
}
#declare merids = union{
#declare i=0;
#while (i<18)
object{merid rotate y*20*i texture{T_Silver_1A}}
#declare i=i+1;
#end
}

#declare lat = union {
torus{cos(-75*2*pi/360),.02 translate y*sin(-75*2*pi/360) texture{T_Silver_1A} }
torus{cos(-60*2*pi/360),.02 translate y*sin(-60*2*pi/360) texture{T_Silver_1A} }
torus{cos(-45*2*pi/360),.02 translate y*sin(-45*2*pi/360) texture{T_Silver_1A} }
torus{cos(-30*2*pi/360),.02 translate y*sin(-30*2*pi/360) texture{T_Silver_1A} }
torus{cos(-15*2*pi/360),.02 translate y*sin(-15*2*pi/360) texture{T_Silver_1A} }
torus{cos(15*2*pi/360),.02 translate y*sin(15*2*pi/360) texture{T_Silver_1A} }
torus{cos(30*2*pi/360),.02 translate y*sin(30*2*pi/360) texture{T_Silver_1A} }
torus{cos(45*2*pi/360),.02 translate y*sin(45*2*pi/360) texture{T_Silver_1A} }
torus{cos(60*2*pi/360),.02 translate y*sin(60*2*pi/360) texture{T_Silver_1A} }
torus{cos(75*2*pi/360),.02 translate y*sin(75*2*pi/360) texture{T_Silver_1A} }
}

#declare lats = object {
object{lat}
clipped_by {sphere{0,.99}}
}

sphere {0, 1000 pigment{image_map{tga "starsa1c.tga" map_type 1}} finish{ambient 2} 
clipped_by{plane{-z, 0}} }

#declare earth = merge{

union{
sphere {0, 1 pigment{ image_map {tga "earth.tga" map_type 1}rotate 210*y} 
finish{ambient .6} no_shadow}
sphere{0,.99999 texture{T_Silver_3B}}
object{merids clipped_by{sphere{0,.999}} }
object{lats}
}
box{<0,0,0>,<1,1,-1> texture {pigment{rgbt<1,1,1,1>}}}
}
object {earth rotate 25*y}

#declare main_gear = union {
difference {
cylinder{-.05*y,.05*y 1}// texture{T_Brass_1A}}
cylinder{-.051*y,.051*y .9}
}
}//union

intersection{ 
object{main_gear texture{T_Gold_1A}}
sphere{0, .999 texture{T_Gold_1A}}
}

#declare imax=72;
#declare i=0;
#while (i<imax)
box{<0,-.05,0>,<.035 ,.05,.035> texture{T_Gold_1A} translate .85*x rotate (360/imax)*i*y}
#declare i=i+1;
#end

#declare drive_gear = union{

#declare holes = union{
cylinder{-.05*y,.05*y .1 translate<-.14,0,0>}
cylinder{-.05*y,.05*y .1 translate<.14,0,0>}
cylinder{-.05*y,.05*y .1 translate<0,0,.14>}
cylinder{-.05*y,.05*y .1 translate<0,0,-.14>}
}

difference {
cylinder{-.045*y,.045*y .3}
holes
}
cylinder {-.3*y, .3*y .05 } //axle
cylinder {-.1*y, .1*y .07 } //axle sleeve

#declare imax=30;
#declare i=0;
#while (i<imax)
box{<0,-.045,0>,<.035 ,.045,.035> translate .3*x rotate (360/imax)*i*y}
#declare i=i+1;
#end
}
object {drive_gear texture{T_Gold_1A} rotate 20*y translate .6*x }
object {drive_gear texture{T_Gold_1A} rotate 20*y translate -.6*x }
object {drive_gear texture{T_Gold_1A} rotate 20*y translate .6*z }
object {drive_gear texture{T_Gold_1A} rotate 20*y translate -.6*z }



#declare axis =intersection{

union {
cylinder {-1*y, 1*y .05 }
cylinder {-.5*y,.5*y .075}
torus{.05, .2 translate 1*y}
torus{.05, .2 translate -1*y}
}

sphere{0,.999}
}
object {axis texture{T_Gold_1A}}

#declare brace = union {
box{<-1,-.06,-.06>,<1,.06,.06> translate .35*y}
box{<-1,-.06,-.06>,<1,.06,.06> translate -.35*y}
}

#declare braces = object {
brace
clipped_by {sphere {0,.99}}
}
object{braces texture{T_Gold_1A}}
object{braces texture{T_Gold_1A} rotate 90*y}

