 #include "colors.inc"

#ifndef(Use_with_FireAndWater)
 camera {location <0,3,-5>
         look_at z*10}

 light_source {<0,1000,10000> White}
#end 

 #declare trand = seed(6598767);

 // *********************************** sky and fog

 

 sky_sphere {pigment{cylindrical color_map{[0    color LightSteelBlue]
                                      [0.3 color LightBlue]
                                      [0.5 color CornflowerBlue]
                                      [0.8 color MediumBlue]}
                    }
            }
           

 #declare i = 0;
 #while (i < 10)
  sphere {0,30000 + i*10
         hollow
         pigment{leopard color_map{[0.01 rgbt<1,1,1,1>]
                                   [0.1 rgbt <1,1,1,0.98>]
                                   [0.4 rgbt <1,1,1,0.94>]
                                   [0.6 rgbt <1,1,1,0.90>]
                                   [0.7 rgbt <1,1,1,0.80>]}
                 turbulence 2.5
                 scale 4000}
         finish{ambient 1.2
                diffuse 0.3
                reflection 0
                specular 0}
         scale <2,0.2,2>}
  #declare i = i + 1;
 #end


 fog {fog_type 1 distance 25000 color MidnightBlue }

 // ********************************** half a sphere for dark water

 difference{
  sphere {0,29990 hollow}
  box{<-30000,0,-30000>,30000 hollow}
  pigment{RichBlue}
  translate y*-100
 }

 // ********************************** declaration of the hf

 #declare surf =
object {
  height_field{ tga "sea_heightfield.tga"
   translate <-0.5,0,-0.5>
   scale <50,0.3,50>
   pigment{RichBlue+<0,0,0,0.8>}
   finish{
    ambient 0.2
    diffuse 0.2
    reflection 0.4
    specular 0.6
    roughness 0.01
   }
  }
 }  

 
 // ***************************** repetition of the hf
 
 #declare side = 0;
 #declare j = 0;
 #while (j < 10)
  #declare i = 0;
  #while (i < 10)
   object{surf translate <-250 + i*50+side,0,0 + j*50>}
   #declare i = i + 1;
  #end
  #declare side = rand(trand)*50 - 25;
  #declare j = j + 1;
 #end
 
 // ********************************* red cylinder
 
 //cylinder{y*-100,y*100,1 pigment{Red} translate <5,0,20>}