//Fire and Water - main file
//by Reuben Pearse
//


//To render the picture use the following settings: +Lisowood_rmp +LBlobMan

// 14/08/2001 - 1024*768 with Isosurface option on Wood 32 minutes
// 18/08/2001 - 1024*768 no Isosurace wood - 58 minutes
// 31/08/2001 - 800*600 no Isosurface 27 minutes



        
//Dragon model by Rune
//Water code based on work done by Marc Schimmler - posted to povray.text.scene-files 13/07/2000

//Ideas
// - Use motion blur for the fall of the dragon
// - Build Lake Town from Isowood macros
// - Use Blobman to create silhouettes of Bard and other archers
// - Need to find some good fire macros
// - Use heightfields to create lake surroundings
// - Need to find some good mountain ranges
// - Need some boat models for people escaping to shore
// - Elongate the dragon using scale - as he is quite fat
// - Use liquid spray to define splashes - perhaps people falling into the water etc.. 

// - Interesting helmets on POVObjects (perhaps a helmet for Bard)    
// - also shields and various swords and pikes


global_settings
{
  assumed_gamma 1.0
}                                                                                       

#declare Use_with_FireAndWater = 1;		//Set up variable to control what happens in the include file isowood_test.pov
                                                                                       
#declare Dragon_On = 1;      			//1 = Include dragron; 0 = don't show Dragon 
#declare Dragon_Flame_On = 1;       //1 = Include flame from Dragons mouth; 0 = don't show flame
#declare Flame_On = 1;       //1 = Other flame
#declare Jetty_On = 1;
#declare Archer_On = 1;
#declare Moon_On=1;	

#declare Boat_On = 0;

camera {  

		  //location <0,400,60>   			//was location <0,10,-20>			//Changed y to 10 from 3
		  //look_at <0, 12, 100>
		  
		  location <0,10,-20>
		  look_at <-5, 12, 10>				//close up on archer
		  
        //look_at <-8, 15, 10>			//was look_at <0, 12, 10>
        //look_at <-8, 10, 10>
        //angle 20
        }	
        
/*        
//Define Dragon settings              
#declare Bodycolor          = <0.8,0.2,0.1>;
#declare Tummycolor         = <0.9,0.8,0.2>;

#declare Mouthopen          = 30; // 0 - 60
#declare Eyeopen            = 8;  // 0 - 10, default: 8

#declare Righthindlegrot    = 25; // 25
#declare Righthindkneerot   = 80; // 80
#declare Righthindheelrot   = 85; // 85
#declare Righthindfootrot   = 0;  // 0
#declare Righthindgrip      = 0;  // 0 - 10
#declare Righthindplanefoot = 1;  // 0 - 1

#declare Lefthindlegrot     = 25; // 25
#declare Lefthindkneerot    = 80; // 80
#declare Lefthindheelrot    = 85; // 85
#declare Lefthindfootrot    = 0;  // 0
#declare Lefthindgrip       = 0;  // 0 - 10
#declare Lefthindplanefoot  = 1;  // 0 - 1

#declare Rightforelegrot    = 70; // 70
#declare Rightforeelbowrot  = 90; // 90
#declare Rightforefootrot   = 0;  // 0
#declare Rightforegrip      = 0;  // 0 - 10
#declare Rightforeplanefoot = 1;  // 0 - 1

#declare Leftforelegrot     = 70; // 70
#declare Leftforeelbowrot   = 90; // 90
#declare Leftforefootrot    = 0;  // 0
#declare Leftforegrip       = 0;  // 0 - 10
#declare Leftforeplanefoot  = 1;  // 0 - 1

#declare Wingrot            = 35; // 0 - 90, 90 = horizontal, 0 = vertical
#declare Wingbend           = 5;  // 0 - 10
#declare Wingfold           = 9;  // 0 - 10

#declare Bodyrot = <0,0,0>;

#declare Body01 = <+02,0,0>;
#declare Body02 = <+02,0,0>;
#declare Body03 = <+02,0,0>;
#declare Body04 = <+02,0,0>;
#declare Body05 = <+02,0,0>;
#declare Body06 = <+02,0,0>;
#declare Body07 = <+02,0,0>;
#declare Body08 = <+02,0,0>;
#declare Body09 = <-10,0,0>;
#declare Body10 = <-16,0,0>;

#declare Neck01 = <-20,0,0>;
#declare Neck02 = <-25,0,0>;
#declare Neck03 = <-20,0,0>;
#declare Neck04 = <-15,0,0>;
#declare Neck05 = <-10,0,0>;
#declare Neck06 = <-05,0,0>;
#declare Neck07 = <+05,0,0>;
#declare Neck08 = <+15,0,0>;
#declare Neck09 = <+25,0,0>;
#declare Neck10 = <+35,0,0>;

#declare Headrot = <+25,0,0>;

#declare Tail01 = <+2,0,0>;
#declare Tail02 = <+2,0,0>;
#declare Tail03 = <+2,0,0>;
#declare Tail04 = <+2,0,0>;
#declare Tail05 = <+2,0,0>;
#declare Tail06 = <+2,0,0>;
#declare Tail07 = <+2,0,0>;
#declare Tail08 = <+2,0,0>;
#declare Tail09 = <+2,0,0>;
#declare Tail10 = <+2,0,0>;
#declare Tail11 = <+2,0,0>;
#declare Tail12 = <+2,0,0>;
#declare Tail13 = <+2,0,0>;
#declare Tail14 = <+2,0,0>;
#declare Tail15 = <+2,0,0>;
#declare Tail16 = <+2,0,0>;
*/

#declare Bodycolor          = <0.8,0.2,0.1>;
#declare Tummycolor         = <0.9,0.8,0.2>;

#declare Mouthopen          = 30; // 0 - 60
#declare Eyeopen            = 8;  // 0 - 10, default: 8

#declare Righthindlegrot    = 0; // 25
#declare Righthindkneerot   = 90; // 80
#declare Righthindheelrot   = 0; // 85
#declare Righthindfootrot   = 0;  // 0
#declare Righthindgrip      = 0;  // 0 - 10
#declare Righthindplanefoot = 1;  // 0 - 1

#declare Lefthindlegrot     = 0; // 25
#declare Lefthindkneerot    = 90; // 80
#declare Lefthindheelrot    = 0; // 85
#declare Lefthindfootrot    = 0;  // 0
#declare Lefthindgrip       = 0;  // 0 - 10
#declare Lefthindplanefoot  = 1;  // 0 - 1

#declare Rightforelegrot    = 0; // 70
#declare Rightforeelbowrot  = -90; // 90
#declare Rightforefootrot   = 0;  // 0
#declare Rightforegrip      = 0;  // 0 - 10
#declare Rightforeplanefoot = 1;  // 0 - 1

#declare Leftforelegrot     = 0; // 70
#declare Leftforeelbowrot   = -90; // 90
#declare Leftforefootrot    = 0;  // 0
#declare Leftforegrip       = 0;  // 0 - 10
#declare Leftforeplanefoot  = 1;  // 0 - 1

#declare Wingrot            = 80; // 0 - 90, 90 = horizontal, 0 = vertical
#declare Wingbend           = 5;  // 0 - 10
#declare Wingfold           = 0;  // 0 - 10

#declare Bodyrot = <0,-40,10>;

#declare Body01 = <+02,0,0>;
#declare Body02 = <+02,0,0>;
#declare Body03 = <+02,0,0>;
#declare Body04 = <+02,0,0>;
#declare Body05 = <+02,0,0>;
#declare Body06 = <+02,0,0>;
#declare Body07 = <+02,0,0>;
#declare Body08 = <+02,0,0>;
#declare Body09 = <-10,0,0>;
#declare Body10 = <-16,0,0>;

/*
#declare Neck01 = <-20,0,0>;
#declare Neck02 = <-25,0,0>;
#declare Neck03 = <-20,0,0>;
#declare Neck04 = <-15,0,0>;
#declare Neck05 = <-10,0,0>;
#declare Neck06 = <-05,0,0>;
#declare Neck07 = <+05,0,0>;
#declare Neck08 = <+15,0,0>;
#declare Neck09 = <+25,0,0>;
#declare Neck10 = <+35,0,0>;
*/
     
#declare rmp_value = 0;     
     
#declare Neck01 = <+10+rmp_value,0,0>;
#declare Neck02 = <+10+rmp_value,0,0>;
#declare Neck03 = <+10+rmp_value,0,0>;
#declare Neck04 = <+05+rmp_value,0,0>;
#declare Neck05 = <-05+rmp_value,0,0>;
#declare Neck06 = <-05+rmp_value,0,0>;
#declare Neck07 = <-15+rmp_value,0,0>;
#declare Neck08 = <-05+rmp_value,0,0>;
#declare Neck09 = <-05+rmp_value,0,0>;
#declare Neck10 = <-05+rmp_value,0,0>;

#declare Headrot = <0,0,0>;

#declare Tail01 = <+2,0,0>;
#declare Tail02 = <+2,0,0>;
#declare Tail03 = <+2,0,0>;
#declare Tail04 = <+2,0,0>;
#declare Tail05 = <+2,0,0>;
#declare Tail06 = <+2,0,0>;
#declare Tail07 = <+2,0,0>;
#declare Tail08 = <+2,0,0>;
#declare Tail09 = <+2,0,0>;
#declare Tail10 = <+2,0,0>;
#declare Tail11 = <+2,0,0>;
#declare Tail12 = <+2,0,0>;
#declare Tail13 = <+2,0,0>;
#declare Tail14 = <+2,0,0>;
#declare Tail15 = <+2,0,0>;
#declare Tail16 = <+2,0,0>;

#include "reddragon.inc"
#include "colors.inc"

#if(Boat_On)
	#include "boat_rmp.pov"

	object{boat
	scale 2
	rotate <0, -130, 0>
	translate<-10,5,20> 
	}
#end	

#if(Dragon_On)
	object {
			 Dragon              
			 scale 0.6
			 rotate <45, 90, 20>
			 //translate <-15, 20, 20>
			 translate <-80, 60, 220>
			 }
#end

#if(Dragon_Flame_On) 
	#include "rmpflame.pov"
   //Flame for dragons mouth
   object {
           Flame1
           scale <4,4,4>
           rotate <0, 110,-45>
           translate <-46, 46, 180>
           }

#end			 

/* -Original dragon camera-
camera {
	location <-150,10,125>
	look_at 0
	angle 35
	translate <0,20,5>
}

*/       

//#include "reddragonworld.inc"       


/* -Original dragon lightsource-
light_source {<-2,+3,+1>*1000000 color 1}
*/                                       

#if(Moon_On)
	#declare moon_shape = 
	disc
	{
	  <0, 0, 0>  // center position
	  z,         // normal vector
	  1.0,       // outer radius
	  //0.2        // optional hole radius
	     pigment {
	      crackle
	      translate <0.3,0,1.1>
	      turbulence 0.3
	      scale 0.04
	      color_map {
	         //[0.0 rgb 0.0]
	         [0.2 rgb 0.5]
	         [0.7 rgb 0.9]
	         [1.0 rgb 1.0]
	      }
	     }
		//finish { reflection 1.0 }     
	}
	
	
	#declare moon =
	light_source
	{
	  0*x // light's position (translated below)
	  color red 1.0  green 1.0  blue 1.0  // light's color
	  //translate <-30, 30, -30>
	  
	  looks_like {moon_shape}
	}
	
	
	#declare moon = union
	{
		object {moon_shape}
	
		  light_source {
		    <0, 0, -2.8>
		    color White
		    spotlight
		    radius 60
		    falloff 19.6
		    tightness 10
		    point_at <0, 0, 0>
		  }
		  
		  light_source {
		    <0, 0, -2.8>
		    color White
		    spotlight
		    radius 60
		    falloff 19.6
		    tightness 10
		    point_at <0, 0, 0>
		  }
		  
		      light_source {
		    <0, 0, -2.8>
		    color White
		    spotlight
		    radius 50
		    falloff 19.6
		    tightness 10
		    point_at <0, 0, 0>
		  }
		    light_source {
		    <0, 0, -2.8>
		    color White
		    spotlight
		    radius 50
		    falloff 19.6
		    tightness 10
		    point_at <0, 0, 0>
		  } 
	}	  
	
	object {
			  moon
			  scale 30
			  translate <0, 500, 1000>		  
			  }
#end			  

light_source {<0,1000,10000> White}





#include "sea.pov"
//background {White}

#include "isowood_test.pov" 				//This is actually in /isowood_rmp folder - use +Lisowood_rmp command switch


#if(Jetty_On) 
object {
        jetty2
        translate <0, 2, 5>
        rotate <0, 20, 0>
       }
       
object {
        jetty2
        translate <0, 2, 5>
        rotate <0, 110, 0>
        translate <-120, 0, 250>
       }       
#end       

/*Original flame*/
/*
#if(Flame_On) 
	#include "rmpflame.pov"
   //Flame for dragons mouth
   object {
           Flame
           //scale <4,4,4>
           rotate <0, 90,-45>
           translate <-10, 20, 20>
           }
#end
*/          


           
#if(Flame_On)
	#include "rmpflame.pov" 
   object {
           Flame2
           //scale <4,4,4>
           //rotate <0, 0,0>
           rotate <-90, 0, 0>
           translate <15, 0, 60>
           scale <1.5, 0.3, 1>
           }
           
   object {
           Flame2
           //scale <4,4,4>
           //rotate <0, 0,0>
           rotate <-90, 0, 0>
           translate <0, 30, 125>
           scale <1.8, 0.2, 1>
           }           
           
   object {
           Flame2
           //scale <4,4,4>
           //rotate <0, 0,0>
           rotate <-90, 0, 0>
           translate <10, 12, 118>
           scale <1.8, 0.45, 1>
           }           
           

#end           

/*
#include "wooden_house.pov"

object {
		  wooden_house
		  translate <-40, 10, 100>
		  rotate <0, 20, 0>
		  scale 0.5
		 } 
*/


#if(Archer_On)
	#include "bmpeople.inc"
	#include "bm_pose.inc"
	#include "hoplite_rmp.cdf"
	
	#declare BM_PoseNo=14;
	
      Blob_Man(Male,10)
      object {BlobMan 
              transform BMO_Abdomen_L
              //rotate <0, 90, 0>              
              rotate <0, 120, 0>              
              translate <-30, 12, 130>

              //scale 0.8
              //scale 2
              }	

#end