// *** snail ***
#declare shape1=
sphere { <0,0,0> 1
 scale <1.15,1,1>
 rotate y*90
}
#declare shape2=
difference{
 sphere { <0,0,0> 1}
 cylinder{<-1.1,0,0>,<1.1,0,0>,.9}
 scale <1.15,1,1>
 rotate y*90 
}
 
#declare ni = 80;
#declare cnt       = 0.0;
#declare inc     = 1.0/ni;
#declare nt     = 360*4;
#declare r_snail=seed(678);
#declare t_snail_shell=
texture{
 T_Stone8
 translate 150
 scale 8
}
#declare m_snail_body=
material{
 texture{
  pigment{Yellow*.5+Gray filter 0.5}
  normal{
   average
   normal_map{
    [0 granite 1]
    [1 crackle 1]
   }
   scale .2
  }
 }
 texture{
  pigment{YellowGreen filter 0.9}
  finish{Glass_Finish ior 1.1}
 }
}

#declare snail =
union { 
 union{
 #while (cnt<=1.0)
  #if (cnt=0)
  object{ shape2
  #else
  object{ shape1
  #end
   scale <(1-cnt)*2,(1-cnt)*1.5,(1-cnt)*2>
   texture{
    t_snail_shell
    scale (1-cnt*.5)
    normal{crackle scale .05}
   }
   translate <(1-cnt)*1.25, cnt*3, 0>
   rotate nt*cnt*y
  } 
  #declare cnt=cnt+inc;
 #end 
  union { 
   sphere {  <0, 4.4, 0>   0.3 scale <1,0.6,1> }
   texture{t_snail_shell
    scale .5
    normal{crackle scale .05}
   }
  }
  scale 1.3
  rotate 90*x
  rotate 180*y  
  rotate 4*z
  translate .5*y
 }
 blob{
  threshold .6
  sphere{0,1.8,1 translate <-2.5,-.5,0>}
  sphere{0,2,1 translate <-2.5,-1,0>}
  sphere{0,1.5,1 translate <-2.5,-1.5,0>}
  sphere{0,2,1 translate <-2.5,-2.5,0>}
  sphere{0,1.5,1 translate <-3.5,-2.5,0>}
  sphere{0,1.5,1 translate <-4,-2.5,0>}
  sphere{0,1.5,1 translate <-4.5,-2,0>}
  sphere{0,1.5,1 translate <-5,-1.5,0>}
  sphere{0,1.3,1 translate <-5.3,-1.1,0>}
  sphere{0,1.3,1 translate <-5.7,-.6,0>}
  sphere{0,1.6,1 translate <-6.2,-.1,0>}
  sphere{0,.3,1 translate <-6.3,.1,-.5>}
  sphere{0,.3,1 translate <-6.3,.1,.5>}
  sphere{0,.3,1 translate <-6.35,.3,-.6>}
  sphere{0,.3,1 translate <-6.35,.3,.6>}
  sphere{0,.3,1 translate <-6.4,.5,-.7>}
  sphere{0,.3,1 translate <-6.4,.5,.7>}
  sphere{0,.3,1 translate <-6.45,.7,-.8>}
  sphere{0,.3,1 translate <-6.45,.7,.8>}
  sphere{0,.3,1 translate <-6.5,.9,-.9>}
  sphere{0,.3,1 translate <-6.5,.9,.9>}
  sphere{0,.3,1 translate <-6.6,1.1,-1>}
  sphere{0,.25,1 translate <-6.6,1.1,1>}
  sphere{0,.25,1 translate <-6.7,1.3,-1.1>}
  sphere{0,.25,1 translate <-6.7,1.3,1>}
  sphere{0,.25,1 translate <-6.8,1.5,-1.15>}
  sphere{0,.25,1 translate <-6.8,1.5,1>}
  sphere{0,.35,1 translate <-6.9,1.7,-1.2>}
  sphere{0,.35,1 translate <-6.9,1.7,1>}

  sphere{0,1.5,1 translate <-2,-2.5,0>}
  sphere{0,1.5,1 translate <-1.5,-2.5,0>}
  sphere{0,1.5,1 translate <-1,-2.5,0>}
  sphere{0,1.5,1 translate <-.5,-2.5,0>}
  sphere{0,1.5,1 translate <0,-2.5,0>}
  sphere{0,1,1 scale <3,1,3> translate <-1,-3,0>}
  sphere{0,1.5,1 translate <.5,-2.5,0>}
  sphere{0,1.5,1 translate <1,-2.5,0>}
  sphere{0,1.5,1 translate <1.5,-2.5,0>}
  sphere{0,1.5,1 translate <2,-2.5,0>}
  sphere{0,1.5,1 translate <2.5,-2.5,0>}
  sphere{0,1.3,1 translate <2.8,-2.5,0>}
  sphere{0,1.1,1 translate <3.2,-2.5,0>}
  sphere{0,.9,1 translate <3.4,-2.5,0>}
  sphere{0,.7,1 translate <3.5,-2.5,0>}
  hollow
  material{m_snail_body}
 }
} 


