// *** light color ***
#declare sun_color=White*.75+Gold*.5+SkyBlue*.25;

// *** sky planes ***
#if (use_sky=2)
 #declare num_planes=1;
#else
 #declare num_planes=16;
#end
#declare sky_color=SkyBlue;
#declare clouds_height=5000;
#declare plane_dist=30;
#declare textu_dist=40;
#declare cnt_planes=1;

union{
#while (cnt_planes<=num_planes)

 #declare p=sky_color*.4+White*.6;

 #declare p1=
 pigment{
  wrinkles
  color_map{
   [0.0 p*(1-(cnt_planes/num_planes))+White*(cnt_planes/num_planes) filter .5+.3*(cnt_planes/num_planes)]
   [1.0 White*.5+p*.5 filter .5+.4*(cnt_planes/num_planes)]
  }
  scale 614
 }
 #declare p2=
 pigment{
  bumps
  color_map{
   [0.0 White*.5+p*.5 filter .5+.4*(cnt_planes/num_planes)]
   [1.0 p*(1-(cnt_planes/num_planes))+White*(cnt_planes/num_planes) filter .5+.3*(cnt_planes/num_planes)]
  }
  scale 614
 }
 plane{
  y,0
  texture{
   pigment{
//    granite octaves 9 lambda 3 turbulence 4 scale 1000000
//    wrinkles lambda 3 turbulence .4 scale 10000
    bumps lambda 3 turbulence 1 scale 10000
    pigment_map{
     [0.0 Clear]
     [0.5 Clear]
     [0.6 p1]
     [1.0 p2]
    }
   }
   finish{
    //ambient sun_color
    Luminous
   }
   translate (clouds_height+textu_dist*cnt_planes)*y
  }
  hollow
  no_shadow
  translate (clouds_height+plane_dist*cnt_planes)*y
 }
 #declare cnt_planes=cnt_planes+1;
#end
translate 10000*z
}

