// *** achmea-like leaf ***
#macro achmea_leaf(lsize,lthick,lwidth)

intersection{
 difference{
  sphere{0,1 scale lsize}
  sphere{0,1 scale lsize-lthick}
 }
 plane{y,0 inverse}
 sphere{0,1 scale <lwidth,lsize*2+.1,lsize*2-.1> translate -lsize*z}
 translate (lsize+lwidth)*z
}

#end

// *** achema flower ***
#macro achmea_flor(rad_flor,t_caliz,t_estambres,t_petal,r_flor)
//sphere{0,4 pigment{Red} translate 4*y}
#local n_caliz=8;
#local n_petal=8;
#local caliz=
sphere{0,.5
 scale <1,2,.1>
 translate 1*y
 texture{t_caliz}
 rotate -45*x
}
#local petal=
sphere{0,.5
 scale <2,6,.1>
 rotate <-1+2*rand(r_flor),-1+2*rand(r_flor),-1+2*rand(r_flor)>
 translate 3*y
 texture{t_petal}
}

union{
 // caliz
 #local i_caliz=0;
 #while (i_caliz<n_caliz)
  object{caliz rotate (360*i_caliz/n_caliz)*y}
  #local i_caliz=i_caliz+1;
 #end
 // petalos
 #local i_petal=0;
 #while (i_petal<n_petal)
  object{petal
   scale 1.5
   rotate (-45-30*rand(r_flor))*x
   rotate (360*i_petal/n_petal)*y
   translate 1*y
  }
  object{petal
   scale 1.25
   rotate (-35-30*rand(r_flor))*x
   rotate -(360*i_petal/n_petal)*y
   rotate (360/n_petal)*.5*y
   translate 2*y
  }
  object{petal
   rotate (-25-30*rand(r_flor))*x
   rotate -(360*i_petal/n_petal)*y
   rotate (360/n_petal)*.5*y
   translate 3*y
  }
  #local i_petal=i_petal+1;
 #end
 sphere{0,1
  scale <1,.5,1>
  texture{t_estambres}
  translate 1.6*y
 }
}
#end

// *** achmea-like plant ***
#macro achmea_plant1(lsize,lthick,lwidth,nleafs,nchilds,t_leaf,rplant)

#local ichilds=0;
#local rp=seed(rplant);
#local lw=lwidth;
#local nl=nleafs;
#local t_est=
texture{
 pigment{Gold}
 normal{granite scale .1}
}
#local t_pet=
texture{
 pigment{Pink+Red*.1 filter 0.5}
 finish{metallic}
}

union{
#while (ichilds<nchilds)
 #local ileafs=0;
 #while (ileafs<nl)
  object{
   achmea_leaf(lsize,lthick,lw)
   scale (1-.5*(ichilds/nchilds))
   scale <1,1,.25+rand(rp)>
   texture{t_leaf}
   rotate -10*(sin(pi*ichilds/nchilds))*x
   rotate (360*(ileafs/nl)-5+10*rand(rp))*y
   translate lw*ichilds*y
  }
  #debug "."
  #local ileafs=ileafs+1;
 #end
 #local nl=nleafs*.5+nleafs*.5*(ichilds/nchilds);
 #local lw=lwidth*.5+lwidth*.5*(ichilds/nchilds);
 #local ichilds=ichilds+1;
#end
 object{
  achmea_flor(3+rand(rp),t_leaf,t_est,t_pet,rplant) rotate 360*rand(rp)*y
  translate (lw*ichilds+2)*y
 }
}

#end

#macro achmea_plant2(lsize,lthick,lwidth,nleafs,nchilds,t_leaf,rplant)

#local ichilds=0;
#local rp=seed(rplant);
#local lw=lwidth;
#local nl=nleafs;

union{
#while (ichilds<nchilds)
 #local ileafs=0;
 #while (ileafs<nl)
  object{
   achmea_leaf(lsize,lthick,lw)
   scale (1-.5*(ichilds/nchilds))
   scale <1,1,.25+rand(rp)>
   texture{t_leaf}
   rotate -10*(sin(pi*ichilds/nchilds))*x
   rotate (360*(ileafs/nl)-5+10*rand(rp))*y
   translate lw*ichilds*y
  }
  #debug "."
  #local ileafs=ileafs+1;
 #end
 #local lw=lwidth*.5+lwidth*.5*(ichilds/nchilds);
 #local ichilds=ichilds+1;
#end
}

#end

#macro hoja1(rleaf)
height_field{
 png "hf_hoja"
 water_level .1
 translate -.5
 rotate <-90,0,180>
 translate -.5*y
 scale <6,8,.2>
}
#end

#macro hoja2(rleaf)
height_field{
 png "hf_hoja2"
 water_level .1
 translate -.5
 rotate <-90,0,180>
 translate -.5*y
 scale <6,8,.5>
}
#end

#macro flor(rad_flor,t_caliz,t_estambres,t_petal,r_flor)
//sphere{0,4 pigment{Red} translate 4*y}
#local n_caliz=8;
#local n_petal=8;
#local caliz=
sphere{0,.5
 scale <1,2,.1>
 translate 1*y
 texture{t_caliz}
 rotate -45*x
}
#local petal=
sphere{0,.5
 scale <2,4,.1>
 rotate <-1+2*rand(r_flor),-1+2*rand(r_flor),-1+2*rand(r_flor)>
 translate 2*y
 texture{t_petal}
}

union{
 // caliz
 #local i_caliz=0;
 #while (i_caliz<n_caliz)
  object{caliz rotate (360*i_caliz/n_caliz)*y}
  #local i_caliz=i_caliz+1;
 #end
 // petalos
 #local i_petal=0;
 #while (i_petal<n_petal)
  object{petal
   rotate (-45-30*rand(r_flor))*x
   rotate (360*i_petal/n_petal)*y
   translate 1*y
  }
  #local i_petal=i_petal+1;
 #end
 sphere{0,1
  scale <1,.5,1>
  texture{t_estambres}
  translate 1.6*y
 }
}
#end

// *** HANGING PLANT ***
#macro hanging_plant(ntall,nnodo,radio,t_leaf,rplant)

 #local rp=seed(rplant);
 #local itall=0;
 #local yr=-65;
 #local t_est=
 texture{
  pigment{Orange}
  normal{granite scale .1}
 }
 #local t_pet=
 texture{
  pigment{White filter 0.3}
  normal{bumps scale 4}
  finish{Phong_Dull}
 }

 union{
 #while (itall<ntall)
  union{
  #local inodo=1;
  #local yant=0;
  #local zant=0;
  #local k=1.1;
  #while (inodo<=(nnodo*.75+nnodo*.25*rand(rp)))
   #local yact=(radio*.8+radio*.2*rand(rp))*sin(k*pi*(inodo/nnodo));
   #local zact=-inodo*.5;
   cylinder{<0,yant,zant>,<0,yact,zact>,.25}
   #if ((inodo>nnodo*.25) & (mod(inodo,2)=0))
    object{hoja1(rand(rp))
     scale (1.2-.4*sin(.5*pi*inodo/nnodo))
     rotate (90*(sin(pi*inodo/nnodo))-10)*x
     rotate yr*y
     translate <0,yact,zact>
    }
    object{
     flor(3+rand(rp),t_leaf,t_est,t_pet,rplant) rotate 360*rand(rp)*y
     scale .7
     rotate (90*(sin(pi*inodo/nnodo)))*x
     rotate -yr*y
     translate <0,yact,zact>
    }
    #if (yr=-65)
     #local yr=65;
    #else
     #local yr=-65;
    #end
   #end
   #local yant=yact;
   #local zant=zact;
   #local inodo=inodo+1;
  #end
   texture{t_leaf}
   rotate (360*(itall/ntall)-10+20*rand(rp))*y
  }
  #local itall=itall+1;
 #end
 }

#end

// *** HANGING PLANT 2 ***
#macro hanging_plant2(ntall,nnodo,radio,t_leaf,rplant)

 #local rp=seed(rplant);
 #local itall=0;
 #local yr=-65;
 #local t_est=
 texture{
  pigment{Orange}
  normal{granite scale .1}
 }
 #local t_pet=
 texture{
  pigment{Violet}
  normal{bumps scale 4}
  finish{Phong_Dull}
 }

 union{
 #while (itall<ntall)
  union{
  #local inodo=1;
  #local yant=0;
  #local zant=0;
  #local k=1;
  #while (inodo<=(nnodo*.75+nnodo*.25*rand(rp)))
   #local yact=radio*sin(k*pi*(inodo/nnodo));
   #local zact=-inodo*.5;
   cylinder{<0,yant,zant>,<0,yact,zact>,.25}
   #if ((inodo>nnodo*.25) & (mod(inodo,2)=0))
    object{hoja2(rand(rp))
     scale (1.2-.4*sin(.5*pi*inodo/nnodo))
     rotate (90*(sin(pi*inodo/nnodo))-20)*x
     rotate (yr)*y
     translate <0,yact,zact>
    }
    #if (inodo<nnodo*.6)
    object{
     flor(3+rand(rp),t_leaf,t_est,t_pet,rplant) rotate 360*rand(rp)*y
     rotate (90*(sin(pi*inodo/nnodo)))*x
     rotate -(yr)*y
     translate <0,yact,zact>
    }
    #end
    #if (yr=-65)
     #local yr=65;
    #else
     #local yr=-65;
    #end
   #end
   #local yant=yact;
   #local zant=zact;
   #local inodo=inodo+1;
  #end
   texture{t_leaf}
   rotate (360*(itall/ntall)-10+20*rand(rp))*y
  }
  #local itall=itall+1;
 #end
 }

#end

// *** HANGING PLANT 3 ***
#macro hanging_plant3(ntall,nnodo,radio,t_leaf,rplant)

 #local rp=seed(rplant);
 #local itall=0;
 #local t_est=
 texture{
  pigment{Gold}
  normal{granite scale .1}
 }
 #local t_pet=
 texture{
  pigment{Red}
  finish{Dull metallic}
 }

 union{
 #while (itall<ntall)
  union{
  #local inodo=1;
  #local yant=0;
  #local zant=0;
  #local k=.2+rand(rp);
  #local nnodo2=(nnodo*.5+nnodo*.5*rand(rp));
  #while (inodo<=nnodo2)
   #local yact=+inodo;
   #local zact=-(sin(k*pi*(inodo/nnodo2)));
   cylinder{<0,yant,zant>,<0,yact,zact>,.25
    texture{t_leaf}
   }
   #if (inodo>nnodo*.4 & (mod(inodo,2)=0) & inodo<nnodo2)
    object{hoja2(rand(rp))
     scale <.5,(1.2-.4*sin(.5*pi*inodo/nnodo2)),1>
     texture{t_leaf}
     rotate (40+10*rand(rp))*x
     rotate (4*360*inodo/nnodo2)*y
     translate <0,yact,zact>
    }
   #end
   #local yant=yact;
   #local zant=zact;
   #local inodo=inodo+1;
  #end
   object{
    flor(3+rand(rp),t_leaf,t_est,t_pet,rplant)
    rotate (-25+10*rand(rp))*y
    translate <0,yact,zact>
   }
   translate -radio*rand(rp)*z
   rotate (360*(itall/ntall)-10+20*rand(rp))*y
  }
  #local itall=itall+1;
 #end
 }

#end

