//====================================== INCLUDES & DIRECTIVES ======================
#version unofficial MegaPov 0.5;
//Warning : particle patch needed (current version, aug 8 2000)

#include "colors.inc"
#include "television.inc"

global_settings {
         max_trace_level 15
         post_process {focal_blur {45, 150, 4, .5}}
 }

//====================================== SCENE ELEMENTS SWITCHING ===================
#declare IsoRocher      =1;
#declare OursinSwitch   =1; //if a "bad matrix problem" appears, turn this off,
                            //make a small complete render, and turn back on.
#declare PoissonSwitch  =1;
#declare GroupePoissons =1;
#declare BocalSwitch    =1;
#declare BocalQuality   =1;
#declare BocalTrans     =1;
#declare AlgueSwitch    =1; 
#declare CoralSwitch    =1;
#declare BrouillaSwitch =1;

//====================================== CAMERAS, LIGHTS & FOG=======================
camera {location <415,10,12> direction z*1 look_at <0,0,11>}  //bonne cam

light_source {<100,300,300>*10 color rgb <0.027,0.243,0.529>+White*1.5}

light_source {<200,50,10> White*.5 shadowless}
light_source {<1400,150,-300> color rgb <0.027,0.243,0.529>+Cyan*.2+White*.3 shadowless}

#if (BrouillaSwitch = 1)
fog {color rgb <0.329,0.620,0.706> distance 800}
fog {color rgb -.3*<1-0.129,1-0.373,1-0.518> distance 2800}
//fog {color rgb -<1-0.329,1-0.620,1-0.706> distance 8800}
#else #end

//====================================== DEFINITIONS DE MACROS ======================
  //macro from John VanSickle, slightly modified to prevent errors due to "trace" malfunction.
  #macro Reorient(Axis1,Axis2)
  #local vX1=vnormalize(Axis1);
  #local vX2=vnormalize(Axis2);
  #local vY=vnormalize(vcross(vX1,vX2));
  #local vZ1=vnormalize(vcross(vX1,vY));
  #local vZ2=vnormalize(vcross(vX2,vY));

  #if (vX2.x = 0 & vY.y = 0 & vZ2.z = 0)
  #debug "damn ! bad matrix \n"
  #else
  matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
  matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
  #end

  #end

//========= Fish School in the back
#include "banc_poissons.inc"
object {Banc_Poissons scale 60 rotate y*10 translate <-1500,50,0>}

//====================================== OBJECTS ====================================
//==================================== DEFINITIONS ==================================
#declare Att=.7;
#declare RocheMap =
   color_map
   {
      [ 0.0     rgbft <0.627075, 0.682597, 0.504869, 0.0, 0.0>*Att ]
      [ 0.5     rgbft <0.912225, 0.954092, 0.858375, 0.0, 0.0>*Att ]
      [ 0.75    rgbft <0.834025, 0.90765, 0.61315, 0.0, 0.0>*Att ]
      [ 0.875   rgbft <0.875, 0.875, 0.875, 0.0, 0.0>*Att ]
      [ 1.0     rgbft <0.785682, 0.827784, 0.693016, 0.0, 0.0>*Att ]
   }

//======= ROCK =========================
#declare Fun1=function {"ridgedmf", <.7, 2, 5, 1, 1.2>}
#declare FunP=function {x*0+y*1+z*0}

#declare Fond_Rocher = isosurface {
  function {FunP + Fun1/2}
  threshold 0
  contained_by { box {<-50,-2,-2>,<2,2,2>} }
  accuracy .01
  method 2
  max_gradient 4 //4
  //eval
  pigment {slope y
  color_map {RocheMap}
  turbulence .5 omega .8
  }
  scale <200,200,200>
  normal {wrinkles 2 scale 5}
  finish {phong .4}
}
//======= FISHBOWL =====================
#if (BocalSwitch = on)
#declare Bocal =  
union {
lathe{
	#if (BocalQuality=0)
	linear_spline
	#else
	cubic_spline
	#end
	18,
	<0.437979,0.997831>,	<0.316107,0.955937>,	<0.388469,0.841682>,
	<0.670299,0.616979>,	<0.670299,0.319915>,	<0.392277,0.118064>,
	<0.091404,0.079979>,	<0.000000,0.083787>,	<0.007617,0.049511>,
	<0.220894,0.049511>,	<0.377043,0.003809>,	<0.521767,0.137107>,
	<0.708384,0.327532>,	<0.716001,0.620788>,	<0.396086,0.872150>,
	<0.437979,0.997831>,	<0.316107,0.955937>,	<0.388469,0.841682>
	scale 120  
	//pigment {Red transmit .5}
}      
object {Teloche translate x*15 scale 2.5 translate y*25 rotate y*60}
}
#else #end

//======= SPIKY PLANT ==================
#declare PigOursin = pigment {color rgb <0.827,0.933,0.655>}

#declare Oursin = mesh {
 #declare ORayon=2;
 #declare OPasParallele=.2;
 #declare OPasMeridien=17;
 #declare OAngleMax=110;

 #declare OMeridien=0;
 #declare OParallele=0;
 #while (OParallele < OAngleMax)
   #declare Po1=vrotate (ORayon*y+<0,0,-.3>,<OParallele,OMeridien,0>);
   #declare Po2=vrotate (ORayon*y+<0,0,+.3>,<OParallele,OMeridien,0>);
   #declare Po3=vrotate ((ORayon*1+rand(r1)*.4)*y+<rand(r1)*.2,rand(r1)*.2,rand(r1)*.2>,<OParallele,OMeridien,0>);
   triangle {Po1,Po2,Po3}
   #declare Po1=vrotate (ORayon*y+<-.3,0,0>,<OParallele,OMeridien,0>);
   #declare Po2=vrotate (ORayon*y+<+.3,0,0>,<OParallele,OMeridien,0>);
   #declare Po3=vrotate ((ORayon*1+rand(r1)*.4)*y+<rand(r1)*.2,rand(r1)*.2,rand(r1)*.2>,<OParallele,OMeridien,0>);
   triangle {Po1,Po2,Po3}
   #declare OMeridien=OMeridien + OPasMeridien;
 #declare OParallele=OParallele + OPasParallele;
 #end

 pigment {PigOursin}
}

//======= CORAL ========================
#if (CoralSwitch = 1)

#declare Pts1 = array [6] {<0,0,0>,<1,3,-2>,<2,5,0>,<1,8,-2>,<0,10,-1>,<1,15,-3>}
#declare NbPoints = dimension_size(Pts1,1);

#init_3d_spline {"Spline1",natural,<0,0,0>,<1,3,-2>,<2,5,0>,<1,8,-2>,<0,10,-1>,<1,15,-3>}

#declare PremGen = union {
#declare Pas=.1;
#declare C=0;
#while (C < 1)
  cylinder {eval_3d_spline ("Spline1",C+Pas),eval_3d_spline ("Spline1",C),.1}  
#declare C=C+Pas;
#end
 }

#declare OldGen=object {PremGen}

 #declare A=0;
 #while (A < 3)

        #declare NewGen=union {
         object {OldGen}
         #declare I=0;
         #while (I < NbPoints-1)
          object {OldGen scale .5 rotate <70-rand(r2)*40,rand(r2)*360,0> translate Pts1[I+1]
           }
         #declare I=I+1;
         #end
         }
        
        #declare OldGen=object {NewGen}
        
 #declare A=A+1;
 #end

#declare Corail = object {OldGen pigment {Firebrick*1.5} finish {phong .6 specular .2} normal {crackle .2 scale .1}}

#else
#end

//======= ALGA =========================
#if (AlgueSwitch=1)
#macro MakeBlade (P1,P2,P3,P4,P5,P6)
 triangle {P1,P2,P5}
 triangle {P1,P4,P5}
 triangle {P2,P3,P5}
 triangle {P3,P5,P6}
#end

#declare A1 = <1,0,.5>;
#declare A2 = <0,0,0>;
#declare A3 = <.3,0,1.2>;

#macro MakeFirstPlante1 (A1,A2,A3)
#local I=0;
#while (I < 5)
 #local AProvis = A2+<rand(r1)-.5,rand(r1)*1+3,rand(r1)-.5>;
 #local A5 = AProvis;
 #local A4 = AProvis+<rand(r1),0,rand(r1)*.1>;
 #local A6 = AProvis+<rand(r1)*.1,0,rand(r1)>;
  MakeBlade (A1,A2,A3,A4,A5,A6) 
 #local A1 = A4;
 #local A2 = A5;
 #local A3 = A6;
#local I=I+1;
#end
 
 #local A5 = A2+<rand(r1)-.5,rand(r1)*1+3,rand(r1)-.5>;
 #local A4 = A5;
 #local A6 = A5;
  MakeBlade (A1,A2,A3,A4,A5,A6)
#end

#declare OldPlante1 = mesh {MakeFirstPlante1 (A1,A2,A3)}

#declare B1 = <1,0,.5>;
#declare B2 = <0,0,0>;
#declare B3 = <.3,0,1.2>;

#declare Boucle = 0;
#while (Boucle < 3)
        #declare NewPlante1 =
        union {
        #declare I=0;
        #declare B2=<0,0,0>;
        #while (I < 5)
         #declare BProvis = B2+<rand(r1)-.5,rand(r1)*1+3,rand(r1)-.5>;
         #declare B5 = BProvis;
         #declare B4 = BProvis+<rand(r1),0,rand(r1)*.1>;
         #declare B6 = BProvis+<rand(r1)*.1,0,rand(r1)>;
          MakeBlade (B1,B2,B3,B4,B5,B6)
          object {OldPlante1 scale .5 rotate <20+rand(r1)*30,60+rand(r1)*40,0> translate B5}   
          object {OldPlante1 scale .5 rotate <30+rand(r1)*20,rand(r1)*360,0> translate B5}   
         #declare B1 = B4;
         #declare B2 = B5;
         #declare B3 = B6;
        #declare I=I+1;
        #end
         
         #declare B5 = B2+<rand(r1)-.5,rand(r1)*1+3,rand(r1)-.5>;
         #declare B4 = B5;
         #declare B6 = B5;
          MakeBlade (B1,B2,B3,B4,B5,B6)
        }    

 #declare OldPlante1 = object {NewPlante1}

#declare Boucle = Boucle+1;
#end

#else #end//fin algueswitch

//======================================  ELEMENTS =====================================
//====================================== PLACEMENTS ====================================
//========== rock placement ==========
#if (IsoRocher = on)
  object {Fond_Rocher}
  object {Fond_Rocher rotate x*60}
#else
  object {plane {y,-100} pigment {checker color White color Gray90 scale 50}}
  object {plane {y,-100} pigment {checker color White color Gray90 scale 50} rotate x*60}

  #declare Boucle=0;
  #while (Boucle < 10)
   cylinder {<0,0,0>,<0,20,0>,3 pigment {Red} translate <-Boucle*50,0,Boucle*10>}
  #declare Boucle=Boucle+1;
  #end
  
#end

//========== fishbowl placement ======
#if (BocalSwitch = on)
#declare v1=<0,-100,150>;
object {Bocal rotate x*-10 rotate z*-5 translate v1
        pigment {rgb <.9,1,.95>   
                #if (BocalTrans=1)
                transmit .95
                #else #end
                 }
        finish {phong .4 phong_size 65 metallic
        #if (BocalQuality=1)
        reflection_type 1 reflection_min .1 reflection_max 1 conserve_energy
        #else #end
        }
        #if (BocalQuality=1)
        interior {ior 1.3}
        #else #end
        }
#else
#end

//========== coral placement =========
#if (CoralSwitch = 1)
object {Corail scale 10 translate <-100,-50,150>}
#else
#end

//========== spiky plants placement ==
#declare r3=seed(0);

#if (OursinSwitch = on)

#declare Oursins1 = union {
 #declare StockNormal = <0,0,0>;
 #declare I=0;
 #while (I < 100)
   #declare FoundPoint = 
   trace (Fond_Rocher,<-400+rand(r3)*600,0,-100+rand(r3)*400>,-y,StockNormal);  

   //this check seems to prevent bad behaviour from "trace" (illogical, but it works (sometimes..)!)
   #debug concat ("intersection = <",str(FoundPoint.x,3,3),",",str(FoundPoint.y,3,3),",",str(FoundPoint.z,3,3),">\n") 
   #debug concat ("normale = <",str(StockNormal.x,3,3),",",str(StockNormal.y,3,3),",",str(StockNormal.z,3,3),">\n") 

   object {Oursin rotate y*360*rand(r1) scale 5+(StockNormal.x*5)
   Reorient (y,StockNormal) 
   translate FoundPoint}
 #declare I=I+1;
 #end
}

#declare Oursins2 = union {
  #declare StockNormal = <0,0,0>;
 #declare I=0;
 #while (I < 100)
   #declare FoundPoint =
   trace (Fond_Rocher,<-400+rand(r3)*600,0,-200+rand(r3)*400>,-y,StockNormal);  
   object {Oursin rotate y*360*rand(r1) scale 5+(StockNormal.x*5) Reorient (y,StockNormal) translate FoundPoint}   
 #declare I=I+1;
 #end
 rotate x*60
 }
 
object {Oursins1}
object {Oursins2}

#else
#end

//========== alga placement ==========
#if (AlgueSwitch=1)
object {NewPlante1 pigment {color rgb <0.310,0.482,0.298>} finish {phong .9} scale 40 rotate <10,90,10> translate <-900,-250,200>}
object {NewPlante1 pigment {color rgb <0.310,0.482,0.298>} finish {phong .9} scale 30 rotate <10,10,10> translate <-800,-300,0>}
object {NewPlante1 pigment {color rgb <0.310,0.482,0.298>} finish {phong .9} scale 10 rotate <-20,-0,-30> translate <-400,-100,-50>}
#else #end

#if (PoissonSwitch = on)
#declare r4 = seed(4);

//========== fishes placement ========
#include "poisson_bon.inc"

object {Poisson_Complet 
         texture {pigment {OrangeRed*2}}
         texture {pigment {Pig02} normal {crackle .5 scale <.2,.5,.2>} finish {phong .8}}
         scale 12 rotate y*180 rotate x*20 translate <0,-50,0>
         }

object {Poisson_Complet 
         texture {pigment {Red*1.5}}
         texture {pigment {Pig02} normal {crackle .5 scale <.2,.5,.2>} finish {phong .8}}
         scale 11 rotate y*190 rotate x*35 translate <-15,-40,10>
         }
object {Poisson_Complet 
         texture {pigment {Orange*2}}
         texture {pigment {Pig02} normal {crackle .5 scale <.2,.5,.2>} finish {phong .8}}
         scale 8 rotate y*175 rotate x*-20 translate <25,-80,30>
         }
         
#declare r5=seed(541);
#declare r6=seed(128);
#declare Bubulles = union {
 #local B=0;
 #while (B < 120)
  sphere {0,1 translate <rand(r6)*5,B+rand(r6)*1,rand(r6)*5>}
 #local B=B+3;
 #end
 pigment {White transmit .95}
 finish  {reflection .5 phong .7}
 }

#if (GroupePoissons=1)
#declare I=0;
#while (I < 10)
 object {Poisson_InComplet
 //sphere {<0,0,0>,1 pigment {White*5}
 texture {pigment {OrangeRed*(1.7+rand(r5)*.6)}}
 texture {pigment {Pig02} normal {crackle .5 scale <.2,.5,.2>} finish {phong .8} translate rand(r5)*100}
   #declare Cf1 = rand(r4);#declare Cf2 = rand(r4);#declare Cf3 = rand(r4);#declare Cf4 = rand(r4);
   #declare Transf1 = 
    transform {scale 12 rotate y*360*Cf1 rotate x*(-30+(Cf2*60)) translate <-250-I*60,0+Cf3*200,-50+Cf4*500>}
 transform {Transf1}
 }
 object {
 //cylinder {<0,0,0>,<0,10,0>,1 pigment {Yellow}}
 #declare CtrSph = vtransform (<0,1,-5>,transform {Transf1});
 //sphere {CtrSph,10 pigment {Yellow}}
 object {Bubulles translate CtrSph}
 }
#declare I=I+1;
#end
#else
#end

#else #end

//=========================== THAT'S ALL FOLKS !! ===============================================