#version unofficial megapov 0.5;

global_settings { hf_gray_16 }


#declare Ridge1 = function {"ridgedmf", <.8, 2, 4, 1, 1.1>}

#declare Cyl1 = function {
	pigment {
		cylindrical
		color_map {
			[0 rgb 0]
			[1 rgb 1]
		}
	}
}


plane { y, 0
	pigment {	
		function { (Cyl1(x,0,z)^.2)*(1-.9*(1-Cyl1(x,0,z)^.50)*(Cyl1(x,0,z)^.2)*min(2,Ridge1(x*5,0,z*5))) }
		color_map {
			[0 rgb 0]
			[1 rgb 1]
		}
		turbulence .2 octaves 3 lambda 5
	}
	finish { ambient 1 diffuse 0 }
	rotate -90*x
}


camera {
	orthographic
	location <0,0,-10>
	right 2.5*x
	up 2.5*y
	look_at <0,0,0>
}

