//=========================================================================
//      INCLUDE FILES, SETTINGS
//=========================================================================
#version unofficial MegaPov 0.5;
#include "colors.inc"
#include "metals.inc"
#include "utils.inc"
#declare r1=seed(3652);


//=========================================================================
//=========================================================================
//      GLOBAL SETTINGS
//=========================================================================
//=========================================================================
global_settings
{
	ini_option "+q9"
	assumed_gamma 1.0
	max_trace_level 70
	adc_bailout 0.15
}

#declare Use_Fog1 = off;
#declare Use_First_Fog = on;
#declare Use_Second_Fog = off;
#declare Use_Cloud_Plane = off;

#declare Place_Mer = on;
#declare Use_Prox = off;
#declare Use_Fresnel = off;
#declare Fake_Texture = 0;
#declare HF_Mer = on;

#declare Place_Rocher = on;
#declare HF_Rocher = on;
#declare Scale_Rocher = <5,5,3.5>;

#declare Place_Phare = on;
#declare Detail_Phare = 5;
#declare Iso_Base = off;

#declare Place_Part1 = on;
#declare Place_Part2 = on;
#declare Place_Part3 = off;
#declare Part_Samples = 1;
#declare Part_Variance = 1/255;
#declare Part_Confidence = 0.95;

#declare Camera_Scene1 = off;
#declare Camera_Scene2 = on;
#declare Camera_Phare = off;
#declare Camera_Cabane = off;
#declare Camera_Haut = off;

#declare Use_Mouette = on;
#declare Use_Mouette2 = on;

#declare Use_Marin = on;

//=========================================================================
//=========================================================================
//      LUMIERE, ENVIRONNEMENT
//=========================================================================
//=========================================================================

//=========================================================================
// sky_sphere
//=========================================================================
sky_sphere {
	pigment {
		gradient y
		turbulence .05
		scale 1.001
		pigment_map {
//			[0 color rgb <217,191,159>/255 ]
//			[0.2 color rgb <201,193,171>/255 ]
			[0 color rgb .7*<217,191,150>/255 ]
			[0.2 bozo turbulence .2 scale .4
				color_map {
					[0.2 color rgb .7*<201,193,150>/255]
					[0.8 color rgb .7*<195,190,185>/255]
				} ]
		}
		rotate x*20
		rotate -30*z
	}
}

//=========================================================================
//           BROUILLARD(S)
//=========================================================================
#if (Use_Fog1)
fog {
	fog_type 1
	distance 30
	turbulence <5,3,10>*50
	octaves 3 lambda 5 omega .5
	turb_depth 10
	color rgbt<.30, .30, .25, .8>
}
#end

#if (Use_First_Fog)
#declare Fog_Plane1 = union {
	triangle {0, x, x+y}
	triangle {0, y, x+y}
	hollow
	pigment {
		planar
		pigment_map {
			[0 gradient y poly_wave .5 color_map { [0 color rgbf .4] [1 color rgbf 1] } ]
			[0.6 gradient y poly_wave .5 turbulence .1 lambda 5 color_map { [0 color rgbf .4] [1 color rgbf 1] } ]
			[1 gradient y poly_wave .5 color_map { [0 color rgbf .4] [1 color rgbf 1] } ]
		}
		scale <.05, 1, .05>
	}
	finish { ambient 0 diffuse .3 }
	translate -.5*x
	scale <2000, 1500, 1>
	translate 1500*z
	no_shadow
}

object { Fog_Plane1 }
object { Fog_Plane1 scale <1,-1,1> }

#end

#if (Use_Second_Fog)
union {
	triangle {0, x, x+y}
	triangle {0, y, x+y}
	hollow
	pigment {
		planar
		pigment_map {
			[0 gradient y poly_wave .5 color_map { [0 color rgbf .5] [1 color rgbf 1] } ]
			[0.6 gradient y poly_wave .5 turbulence .1 color_map { [0 color rgbf .5] [1 color rgbf 1] } ]
			[1 gradient y poly_wave .5 color_map { [0 color rgbf .5] [1 color rgbf 1] } ]
		}
		scale <.1, 1, .1>
	}
	finish { ambient 0 diffuse .3 }
	translate -.5*x
	scale <3500, 2000, 1>
	translate 3500*z
}

#end
//=========================================================================
//              NUAGES
//=========================================================================
#if (Use_Cloud_Plane)

#end


//=========================================================================
//          LUMIERES
//=========================================================================

light_source {<-40,50,20>*1000 rgb <1,1,.98>*.95 groups "Main_light" } 
light_source {<-40,.015,-20>*1000 rgb <1,1,.98>*.5 shadowless groups "Fill_light" media_interaction off }
//light_source {<10,50,10>*1000 rgb <1,.95,.95>*.2 shadowless groups "Back_light" }


//=========================================================================
//          CAMERA
//=========================================================================

#if (Camera_Cabane)
camera {
	location <0,7,-50>
	right x
	up y*4/3
	angle 20
	look_at <-3,8,0>
}
#end

#if (Camera_Haut)
camera {
	location <0,37,-50>
	right x
	up y*4/3
	angle 10
	look_at <1,42,0>
}
#end

#if (Camera_Phare)
camera {
	location <0,7,-70>
	right x
	up y*4/3
	angle 25
	look_at <1,27,0>
}
#end

#if (Camera_Scene1)
camera {
	location <0,8,-70>
	right x
	up y*4/3
	angle 30
	look_at <0,25,0>
	rotate z*0.2
}

//plane { z, -75 pigment { color rgb 0} }

#end

#if (Camera_Scene2)
camera {
	location <0,8,-70>
	right x
	up y*4/3
	angle 27
	look_at <0,24,0>
	rotate z*0.2
}

#end

//=========================================================================
//=========================================================================
//      DEFINITION DES ISOSURFACES
//=========================================================================
//=========================================================================

//H, lacunary, octaves, offset, gain
#declare Fun1=function {"ridgedmf", <.8, 2, 4, 1, 1.1>}
#declare Fun2=function {"ridgedmf", <.9, 1.5, 6, 1, 1.4>}
#declare FunP=function { x*0+y*1+z*0 }
#declare FunC=function { min(1, x^2+z^2 - 1) }
#declare FunS=function { x^2+y^2+z^2 - 1 }


#if (HF_Rocher)

#declare Rocher= merge {
	height_field {
		png "hfroc1.png"
		smooth
		translate -.5*x -.5*z
		scale <7, 1.5, 7>
	}
	cylinder { .01*y, -5*y, 3.5 }
	translate y*4/5
	scale Scale_Rocher
}

#else

#declare Rocher= merge {
	isosurface { 
		function { FunS(x*.25,y*.5,z*.25) + Fun1(x,y,z)/6 }
		threshold 0
		contained_by { box {<-4,0,-4>,<4, 2, 4>} }
		accuracy .01
		method 2
		max_gradient 5.35
	}
	cylinder { 0, -5*y, 4 }
	scale Scale_Rocher
}

#end

#declare Rocher_Dummy = sphere { 
	0,1
	scale <3.5,1.9,3.5>
	scale Scale_Rocher
}


#if (HF_Mer)
#declare SurfEau = merge {

#local hfmer = height_field {
	png "hfmer1.png"
	//smooth
	translate -.5*x -.5*z
	scale <80, 5.5, 100>
}
	#local i=-1;
	#while (i<5)
		#local j=1;
		#while (j<(i+2))
			object {
				hfmer
				translate i*99.99*z +j*79.99*x
			}
			object {
				hfmer
				translate i*99.99*z -j*79.99*x
			}
			#local j=j+1;
		#end
		object {
			hfmer
			translate i*99.99*z
		}
		#local i=i+1;
	#end
	box{ <-200, -200, -200>, <200,0,200> }
	translate 4.0*y
}
#else
#declare SurfEau = merge {
	isosurface { 
		function {FunP(x,y,z) - Fun2(x,y,z)/4}
		threshold 0
		contained_by { box {<-10, 0, -10>,<10, 3, 10>} }
		accuracy .005
		method 2
		eval
		max_gradient 5.0
		max_trace 6
	}
	box{ -10, <10,0,10> }
	scale <15,7,15>
	translate 2.3*y
} 
#end

//=========================================================================
//=========================================================================
//      DEFINITION DE TEXTURES
//=========================================================================
//=========================================================================
#include "my_tex.inc"


//=========================================================================
//      PLACEMENTS
//=========================================================================
#if (Place_Rocher)
object { Rocher texture { T_Pierre } light_group "!Cabane_light" }
#end

#if (Place_Mer)
object { SurfEau material { M_My_Water } no_shadow translate 5*x light_group "Main_light" }
#end

#if (Place_Phare)
#include "phare.inc"
object { Phare rotate -20*y translate <1,10,0> light_group "all"}
#local tmp = <-2, 3, 0>;
#local tmp = vrotate(tmp, <0, -20, 0>);
#local tmp = tmp + <1,10,0>;
light_source {
	tmp, color rgb<1,1,.7>
	fade_distance 2
	fade_power 2
	groups "Cabane_light"
}
#end

//=========================================================================
//      GARDIEN
//=========================================================================

#if (Use_Marin)

#include "marin.inc"

object {
	Marin
	translate -3.3*z
	rotate y*20
	translate 1*x+40.8*y
}

#end


//=========================================================================
//      MOUETTES
//=========================================================================
#if (Use_Mouette)

#include "mouettet.inc"

#local tmp = <0,2.12,-8.86>;
#local tmp = vrotate(tmp, <0, 10, 0>);
#local tmp = tmp*<1,1,7/9>;
#local tmp = vrotate(tmp, <0, -20, 0>);
#local tmp = tmp + <1,10,0>;

object { Mouette
	rotate -y*140
	translate tmp
}

#local tmp = <0,2.10,-3.55>;
#local tmp = vrotate(tmp, <0, 80, 0>);
#local tmp = tmp + <1,40,0>;

object { Mouette
	rotate -y*10
	translate tmp
}

#end


#if (Use_Mouette2)

#include "mouette2t.inc"

object { Mouette2
	rotate (-20 + 40*rand(r1))*x
	rotate y*36521*rand(r1)
	translate -(5+10*rand(r1))*x
	translate (-15+10*rand(r1))*z
	translate (25+20*rand(r1))*y
}

object { Mouette2
	rotate (-20 + 40*rand(r1))*x
	rotate y*36521*rand(r1)
	translate -(5+10*rand(r1))*x
	translate (-15+10*rand(r1))*z
	translate (25+30*rand(r1))*y
}

object { Mouette2
	rotate (-20 + 40*rand(r1))*x
	rotate y*36521*rand(r1)
	translate (5+10*rand(r1))*x
	translate (-15+10*rand(r1))*z
	translate (25+30*rand(r1))*y
}

object { Mouette2
	rotate 25*x
	rotate 20*y
	translate -9*x
	translate -25*z
	translate 11*y
}

#end


#if ((Place_Part1) | (Place_Part2) | (Place_Part3))
#include "ecumes2.inc"
#end




//=========================================================================
//      EAU ET TERRE
//=========================================================================
// Eau
sphere { 0, 300000
	texture {
		cylindrical
		scale 20
		warp { reset_children }
		texture_map {
			[0 T_Water1_To_Water2_2 scale <20,2,10>]
			[0.2 T_Water1]
		}
	}
	interior {
		//ior 1.05
		fade_color rgb<.3,.90,.8>*.8
		fade_power 1001
		fade_distance 10
	}
	translate -y*300000
	light_group "Main_light"
}

//  Sol sous l'eau
sphere { 0, 299800
	pigment { color rgb<.5,.9,.8> }
	normal { wrinkles 1 scale 2 }
	finish {
		ambient 0.5 diffuse 0.5
	}
	translate -300000*y
	light_group "Main_light" 
}

