#include "pcm.mcr"

#version Unofficial MegaPov 0.4;

//========================================================================
// Scene settings
//========================================================================
#declare DrawField=yes;
#declare DrawBirds=yes;
#declare UseFocalBlur=yes;
#declare UseAreaLight=yes;

#declare camera_location = <8,3,-20>*.2;
#declare camera_look_at = <-15,0,-1>;
#declare camera_angle = 35;
#declare effect_location = <8,3,-20>*.2+<-20,1.5,1>*.2;
#declare effect_type = "Star2"
#declare effect_scale = .2;
#declare effect_always_on_top = false;
#include "lens.inc"
camera
{ right 1.85*x
  location camera_location look_at camera_look_at
  angle camera_angle
  #if(UseFocalBlur)
    focal_point -x*10 aperture .015 blur_samples 100 variance 0
  #end
}
light_source
{ <100,200,-100>*1000, 1
  #if(UseAreaLight)
    area_light (x+z)*50000, (-x+z)*50000, 10, 10 adaptive 0
  #end
}
fog { distance 1000 rgb z }
fog
{ fog_type 2
  distance 1000
  rgb <.7,.9,1>
  fog_alt 100
}

//========================================================================
// Ground
//========================================================================
#if(DrawField)
  #declare HFPigment=
    pigment
    { gradient x pigment_map
      { [0 rgb 0]
        [1 granite color_map { [0 rgb .3][1 rgb 1] } scale .5 ]
      }
      rotate z*-10
    }

  #declare Ground =
    texture
    { pigment
      { granite color_map
        { [0 rgb <1,.7,.3>]
          [1 rgb <.8,.6,.2>]
        }
      }
      normal
      { granite .1
      }
      scale .02
    }
  #declare Grass =
    texture
    { pigment
      { granite color_map
        { [0 rgb <.5,1,.2>]
          [1 rgb <.6,.8,.1>]
        }
      }
      normal
      { granite .4
      }
      scale .01
    }

  #declare HF =
    height_field
    { pattern 500, 500
      { hf_gray_16 HFPigment
      }
      smooth

      translate <-.5,0,-.5>
      scale <10,1.2,10>

      texture
      { slope y texture_map
        { [0 Ground]
          [.85 Ground]
          [.95 Grass]
          [1 Grass]
        }
      }
    }
  
  object { HF }

  plane
  { y,.1
    pigment { rgb .2 }
    finish { specular .3 reflection .8 }
    normal { granite .1 scale 5 }
  }
#end

//========================================================================
// Moons
//========================================================================
#declare Moon =
  sphere
  { 0,1
    pigment { rgb 1 }
    normal { bumps .1 turbulence .5 scale .2 }
    finish { diffuse 15000000 ambient 0 }
  }

object { Moon scale 800 translate <8,3,-20>*.2+<-20,1.2,3>*800 }
object { Moon scale 400 translate <8,3,-20>*.2+<-20,2,5>*800 }

//========================================================================
// Plants
//========================================================================
#declare Leaf=
  union
  { bicubic_patch
    { type 1 flatness 0 u_steps 3 v_steps 3
      <0, -.1, 0>, <0, 1, 0>, <0, 2, 0>, <0, 3, 1>,
      <1, -.5, 0>, <1, 0, 0>, <1, 1, 0>, <1, 2.5, 1>,
      <2, -.5, 0>, <2, 0, 0>, <2, 1, 0>, <2, 2, 1>,
      <2, 1, .5>, <2, 1, .5>, <2, 1, .5>, <2, 1, .5>
    }
    bicubic_patch
    { type 1 flatness 0 u_steps 3 v_steps 3
      <0, -.1, 0>, <0, 1, 0>, <0, 2, 0>, <0, 3, 1>,
      <-1, -.5, 0>, <-1, 0, 0>, <-1, 1, 0>, <-1, 2.5, 1>,
      <-2, -.5, 0>, <-2, 0, 0>, <-2, 1, 0>, <-2, 2, 1>,
      <-2, 1, .5>, <-2, 1, .5>, <-2, 1, .5>, <-2, 1, .5>
    }
    pigment { rgb <.7,1,.2> } finish { specular .2 }
    normal
    { gradient y .1 slope_map
      { [0 <1,0>][.1 <0,-1>][.1 <0,0>][.9 <0,0>][.9 <0,1>][1 <1,0>]
      }
      turbulence 1.5
      scale .5
    }
  }

#declare Scale=.5;
object { Leaf scale .07*Scale rotate <120,-30,0>
  translate camera_location*(1-.1*Scale)+camera_look_at*.1*Scale+
  <0,.28,-.5>*Scale }
object { Leaf scale .06*Scale rotate <100,30,0>
  translate camera_location*(1-.1*Scale)+camera_look_at*.1*Scale+
  <0,.28,-.4>*Scale }
object { Leaf scale .04*Scale rotate <130,10,0>
  translate camera_location*(1-.1*Scale)+camera_look_at*.1*Scale+
  <0,.2,-.5>*Scale }
object { Leaf scale .03*Scale rotate <90,-10,0>
  translate camera_location*(1-.1*Scale)+camera_look_at*.1*Scale+
  <0,.2,-.4>*Scale }
object { Leaf scale .06*Scale rotate <150,15,0>
  translate camera_location*(1-.1*Scale)+camera_look_at*.1*Scale+
  <.05,.15,-.45>*Scale }
object { Leaf scale .05*Scale rotate <90,10,0>
  translate camera_location*(1-.1*Scale)+camera_look_at*.1*Scale+
  <0,.1,-.6>*Scale }
object { Leaf scale .04*Scale rotate <150,10,0>
  translate camera_location*(1-.1*Scale)+camera_look_at*.1*Scale+
  <.05,0,-.4>*Scale }

//========================================================================
// Birds
//========================================================================
#if(DrawBirds)
  #declare Bird =
    object
    { read_mesh("bird.pcm")
      pigment { rgb <1,.8,.6> }
      no_reflection
    }
  object
  { Bird
    scale .4
    rotate z*-30
    translate camera_look_at+<-45,2,15>
  }
  object
  { Bird
    scale .4
    rotate y*60+z*30
    translate camera_look_at+<-45,3,20>
  }
#end

//========================================================================
// City
//========================================================================
#declare Building1 =
  union
  { difference
    { cylinder { 0, y*3, 1 }
      torus { 5, 4.75 translate y*2 }
    }
    torus { .25,.1 translate y*2 }
    sphere { y*3, .28 }
    pigment
    { leopard color_map
      { [0 rgb 1][.4 rgb 1][.6 rgb <.7,.8,1>][1 rgb <.7,.8,1>]
      }
      scale .02
      warp { cylindrical orientation y }
      scale <1,7,1>
      rotate y*-90
    }
    finish { specular .5 reflection .1 ambient .4 }
    normal
    { leopard -2 slope_map { [0 <0,0>][.4 <0,0>][.6 <1,1>][.6 <1,0>][1 <1,0>] }
      scale .02
      warp { cylindrical orientation y }
      scale <1,7,1>
      rotate y*-90
    }
  }

#declare Building2 =
  union
  { box
    { <-.7,0,-1><.7,1,1>
      pigment
      { gradient y color_map { [0 rgb <1,.8,.5>][1 rgb <.9,.6,.3>] }
        turbulence .5
        scale <1,.04,1>
      }
      normal
      { gradient y 1 slope_map
        { [0 <0,1>][.1 <1,0>][.9 <1,0>][1 <0,-1>]
        }
        scale .15
      }
      finish { ambient .3 }
    }
    difference
    { box { <-.9,1,-1.2><.9,2,1.2> }
      box { <0,0,-1.21><.7,1.5,1.21> rotate z*40 translate <.9,1,0> }
      box { <0,0,-1.21><-.7,1.5,1.21> rotate -z*40 translate <-.9,1,0> }
      box { <-.9,0,0><.9,1.5,-.5> rotate x*30 translate <0,1,-1.2> }
      box { <-.9,0,0><.9,1.5,.5> rotate -x*30 translate <0,1,1.2> }
      pigment
      { gradient z color_map
        { [0 rgb <1,.9,.7>][.5 rgb <1,.9,.2>][1 rgb <1,.9,.7>]
        }
        turbulence .2
        scale <1,1,.02>
      }
      normal
      { gradient z 1 slope_map
        { [0 <0,1>][.5 <1,0>][1 <0,-1>]
        }
        turbulence .2
        scale <1,1,.02>
      }
      finish { ambient .3 }
    }
  }

#declare Building3 =
  union
  { cone { 0, .5, y*3, .2 }
    sphere { y*3,.4 }
    torus { .4, .1 translate y*3 }
    cone { y*3, .08, y*5, 0 }
    pigment { rgb 1 }
    finish { reflection .2 ambient .4 specular .4 }
  }

#declare Building4 =
  union
  { superellipsoid { <.1, .1> scale <1.5,.5,1.5> translate y*.5 }
    sphere { y*.5, 1 }
    pigment { rgb 1 }
    finish { reflection .2 ambient .4 specular .4 }
  }

#declare Building5 =
  box
  { <-.9,0,-1.2><.9,1,1.2>
    pigment { rgb 1 }
    finish { reflection .2 ambient .4 }
  }

#declare Building6 =
  union
  { box { <-.9,0,-1.2><.9,1.5,1.2> }
    box { <-.7,1.5,-1><.7,1.6,1> }
    pigment { rgb <1,.95,.8> }
    finish { ambient .4 crand .05 }
  }

#if(DrawField)
  object { Building1 scale .08 translate trace(HF, <-2,10,-3>, -y)-y*.01 }
  object { Building1 scale .05 translate trace(HF, <-2.2,10,-3.2>, -y)-y*.01 }
  object
  { Building2 scale .03 rotate y*-30
    translate trace(HF, <-1.7,10,-3>, -y)-y*.005
  }
  object
  { Building2 scale .025 rotate y*60
    translate trace(HF, <-1,10,-3.1>, -y)-y*.005
  }
  object
  { Building2 scale .025
    translate trace(HF, <-2.5,10,-3>, -y)
  }
  object
  { Building2 scale .02
    translate trace(HF, <-2.2,10,-3.3>, -y)
  }
  object
  { Building3 scale .05
    translate trace(HF, <-1.8,10,-3.2>, -y)
  }
  object
  { Building4 scale .04
    translate trace(HF, <-1.2,10,-3.4>, -y)
  }
  object
  { Building5 scale .02 rotate y*-30
    translate trace(HF, <-1.5,10,-3.5>, -y)
  }
  object
  { Building5 scale .02 rotate y*-60
    translate trace(HF, <-1.1,10,-3.3>, -y)
  }
  object
  { Building5 scale .03 rotate y*-90
    translate trace(HF, <-1.7,10,-3.1>, -y)
  }
  object
  { Building5 scale .02 rotate y*-120
    translate trace(HF, <-2.3,10,-3>, -y)
  }
  object
  { Building6 scale .02 rotate y*-10
    translate trace(HF, <-1.8,10,-2.7>, -y)
  }
  object
  { Building6 scale .02 rotate y*-40
    translate trace(HF, <-1.8,10,-2.9>, -y)
  }
  object
  { Building6 scale .02 rotate y*-40
    translate trace(HF, <-1.9,10,-3.1>, -y)
  }
  object
  { Building6 scale .02 rotate y*-70
    translate trace(HF, <-1.9,10,-3.4>, -y)
  }
  object
  { Building6 scale .02 rotate y*-80
    translate trace(HF, <-1.5,10,-3.4>, -y)
  }
  object
  { Building6 scale .025 rotate y*-140
    translate trace(HF, <-1.4,10,-3.5>, -y)
  }
  object
  { Building6 scale .02 rotate y*-190
    translate trace(HF, <-1.45,10,-3.45>, -y)
  }
  object
  { Building6 scale .02 rotate y*-210
    translate trace(HF, <-1.52,10,-3.25>, -y)
  }
  object
  { Building6 scale .02 rotate y*-240
    translate trace(HF, <-1.6,10,-3.2>, -y)
  }
  object
  { Building6 scale .02 rotate y*-270
    translate trace(HF, <-1.65,10,-3.2>, -y)
  }
  object
  { Building6 scale .02 rotate y*-300
    translate trace(HF, <-1.7,10,-3.25>, -y)
  }
  object
  { Building6 scale .015 rotate y*-330
    translate trace(HF, <-1.7,10,-3.32>, -y)
  }
  //cylinder { y*10, y*-10, .003 translate <-1.7,0,-3.32> pigment { rgb z } }

  #declare Seed2=seed(0);
  #macro Tree()
    union
    { cone
      { 0, .2, y*2, .1
        pigment { rgb <1,.7,.4> }
        normal { radial .5 frequency 20 turbulence .2 }
      }
      sphere
      { 0, .6 scale <1.5,2.5-rand(Seed2),1.5> translate y*2.9
        pigment { rgb <.5,1,.2> }
        normal { bumps 1 scale .1 }
        finish { crand .2 }
      }
    }
  #end

  #declare Seed=seed(0);
  #declare Ind=0;
  #while(Ind<30)
    #declare Loc = <-2.2+1.5*rand(Seed), 10, -4+1.5*rand(Seed)>;
    object
    { Tree() scale .03-.02*rand(Seed)
      translate trace(HF, Loc, -y)
    }
    #declare Ind=Ind+1;
  #end

  #declare Ind=0;
  #while(Ind<60)
    #declare Loc = <-3.2+1*rand(Seed), 10, -4.5+1.2*rand(Seed)>;
    object
    { 
      #if(rand(Seed)<.5)
        Building5
      #else
        Building6
      #end
      scale .015+.01*rand(Seed) rotate y*360*rand(Seed)
      translate trace(HF, Loc, -y)-y*.005
    }
    #declare Ind=Ind+1;
  #end
  
  sphere
  { 0,1 hollow
    pigment { rgbt 1 }
    interior
    { media
      { emission .8
        density
        { spherical density_map
          { [0 rgb 0]
            [1 rgb 1]
          }
        }
        method 3
      }
    }
    scale .65
    translate <-1.6,0,-3.3>
  }
#end
