
#declare Mound_Rand = seed(13);

#declare Mound_Object1 = Mound13 (1,50,13,1,.5) 
#declare Mound_Object2 = Mound13 (1,50,26,.75,1) 

#declare Mound_Object =
union {
	object {Mound_Object1}
	object {Mound_Object2 translate <1,0,-.5>}
}

#macro PLACE_ROCKS (Qty,BLDR_SCALE)

#local Point1 = min_extent(Mound_Object); 
#local Point2 = max_extent(Mound_Object); 

#local MinX = Point1.x;
#local MaxX = Point2.x;
#local Xrange = (MaxX - MinX);
 
#local MinY = Point1.y;
#local MaxY = Point2.y; 

#local MinZ = Point1.z;
#local MaxZ = Point2.z; 
#local Zrange = (MaxZ - MinZ); 

#local Count1 = 0;
#while (Count1 < Qty)
	
	#local Newx = ((rand(Mound_Rand) * Xrange) + MinX);
	#local Newz = ((rand(Mound_Rand) * Zrange) + MinZ);
	#local Newy1 = (MaxY + 1);
	#local Newy2 = (MinY - 1);
	
	#local NP1 = <Newx,Newy1,Newz>;
	#local NP2 = <Newx,Newy2,Newz>; 
	
	#declare Rock_Normal = <0,0,0>;
	#local NP3 = trace(Mound_Object,NP1,NP2,Rock_Normal);
	
	#if (VEQUAL (NP3,<0,0,0>))
		#local Flag1 = 1;
	#else
	
		#local Temp_Rand = int(rand(Mound_Rand) * 100); 
		#local Boulder = union {Rock13 (1,20,Temp_Rand)}
		object {Boulder scale BLDR_SCALE AXIS_OBJECT (<0,1,0>,Rock_Normal) translate NP3 texture{MROCK1 scale (.5 * BLDR_SCALE)}} 
				
		#local Count1 = (Count1 + 1);
	#end
#end
#end

#macro PLACE_PLANT (Qty)

#local Point1 = min_extent(Mound_Object); 
#local Point2 = max_extent(Mound_Object); 

#local MinX = Point1.x;
#local MaxX = Point2.x;
#local Xrange = (MaxX - MinX);
 
#local MinY = Point1.y;
#local MaxY = Point2.y; 

#local MinZ = Point1.z;
#local MaxZ = Point2.z; 
#local Zrange = (MaxZ - MinZ); 

#local Count1 = 0;
#while (Count1 < Qty)
	
	#local Newx = ((rand(Mound_Rand) * Xrange) + MinX);
	#local Newz = ((rand(Mound_Rand) * Zrange) + MinZ);
	#local Newy1 = (MaxY + 1);
	#local Newy2 = (MinY - 1);
	
	#local NP1 = <Newx,Newy1,Newz>;
	#local NP2 = <Newx,Newy2,Newz>; 
	
	#local NP3 = trace(Mound_Object,NP1,NP2); 
	#local NP4 = trace(Boulder_Group,NP1,NP2);
	
	#if (VEQUAL (NP3,<0,0,0>))
		#local Flag1 = 1;
	#else 
		#if (VEQUAL (NP4,<0,0,0>))
			INSERT_PLANT (NP3) 
			#local Count1 = (Count1 + 1);
		#end
	#end
#end
#end

#macro MAKE_MOUND (ROCKS,ROCK_SIZE,PLANTS)

	object {Mound_Object texture{MTEXT1}}
	#declare Boulder_Group = union {PLACE_ROCKS (ROCKS,ROCK_SIZE)}
	object {Boulder_Group}
	PLACE_PLANT (PLANTS)
	
#end

// eof