// SIMPLE STONE WORK MACRO
#declare Block_Rand = seed(13);

#declare Max_Side_Cut = 45;  
#declare Min_Side_Cut = 20;

#declare Cut_Range1 = (Max_Side_Cut -  Min_Side_Cut);
#declare Cut_Depth = 100;

#macro STONE_BLOCK (Point1,Point2,Point3,Point4)

#local XP1 = Point1.x;
#local XP2 = Point2.x;
#if (XP1 > XP2)
	#local Length = (XP1 - XP2);
	#local BX = XP1;
	#local SX = XP2;
#else
	#local Length = (XP2 - XP1);  
	#local BX = XP2;
	#local SX = XP1;
#end 

#local YP1 = Point1.y;
#local YP2 = Point2.y;
#if (YP1 > YP2)
	#local Height = (YP1 - YP2); 
	#local BY = YP1;
	#local SY = YP2;
#else
	#local Height = (YP2 - YP1); 
	#local BY = YP2;
	#local SY = YP1;
#end

#local ZP1 = Point1.z;
#local ZP2 = Point2.z;
#if (ZP1 > ZP2)
	#local Width = (ZP1 - ZP2);
	#local BZ = ZP1;
	#local SZ = ZP2;
#else
	#local Width = (ZP2 - ZP1);
	#local BZ = ZP2;
	#local SZ = ZP1;
#end

difference { 
	union {
		box {Point1,Point2} 
		box {Point3,Point4}
	}  
	
	// side trims
	box {<(SX - 1),(Height / 5),0><(BX + 1),(Height / -5),(Width / -5)> rotate <(-1 *((rand(Block_Rand) * Cut_Range1) + Min_Side_Cut)),0,0> translate <0,(SY + (Height / Cut_Depth)),(SZ + (Width / Cut_Depth))>}
    box {<(SX - 1),(Height / 5),0><(BX + 1),(Height / -5),(Width / -5)> rotate <((rand(Block_Rand) * Cut_Range1) + Min_Side_Cut),0,0> translate <0,(BY - (Height / Cut_Depth)),(SZ + (Width / Cut_Depth))>}
    box {<(SX - 1),(Height / 5),0><(BX + 1),(Height / -5),(Width / 5)> rotate <((rand(Block_Rand) * Cut_Range1) + Min_Side_Cut),0,0> translate <0,(SY + (Height / Cut_Depth)),(BZ - (Width / Cut_Depth))>}
    box {<(SX - 1),(Height / 5),0><(BX + 1),(Height / -5),(Width / 5)> rotate <(-1 *((rand(Block_Rand) * Cut_Range1) + Min_Side_Cut)),0,0> translate <0,(BY - (Height / Cut_Depth)),(BZ - (Width / Cut_Depth))>}
   
    box {<0,(SY - 1),(Width / -5)><(Length / 5),(BY + 1),(Width / 5)> rotate <0,((rand(Block_Rand) * Cut_Range1) + Min_Side_Cut),0> translate<(BX - (Length / Cut_Depth)),0,(SZ + (Width / Cut_Depth))>}
    box {<0,(SY - 1),(Width / -5)><(Length / 5),(BY + 1),(Width / 5)> rotate <0,(-1 *((rand(Block_Rand) * Cut_Range1) + Min_Side_Cut)),0> translate<(BX - (Length / Cut_Depth)),0,(BZ - (Width / Cut_Depth))>}
    box {<0,(SY - 1),(Width / -5)><(Length / -5),(BY + 1),(Width / 5)> rotate <0,(-1 *((rand(Block_Rand) * Cut_Range1) + Min_Side_Cut)),0> translate<(SX + (Length / Cut_Depth)),0,(SZ + (Width / Cut_Depth))>}
    box {<0,(SY - 1),(Width / -5)><(Length / -5),(BY + 1),(Width / 5)> rotate <0,((rand(Block_Rand) * Cut_Range1) + Min_Side_Cut),0> translate<(SX + (Length / Cut_Depth)),0,(BZ - (Width / Cut_Depth))>}
    
   	box {<(Length / 5),0,(SZ - 1)><(Length / -5),(Height / 5),(BZ + 1)> rotate <0,0,((rand(Block_Rand) * Cut_Range1) + Min_Side_Cut)> translate <(SX + (Length / Cut_Depth)),(BY - (Height / Cut_Depth)),0>}
	box {<(Length / 5),0,(SZ - 1)><(Length / -5),(Height / 5),(BZ + 1)> rotate <0,0,(-1 *((rand(Block_Rand) * Cut_Range1) + Min_Side_Cut))> translate <(BX - (Length / Cut_Depth)),(BY - (Height / Cut_Depth)),0>}
   	box {<(Length / 5),0,(SZ - 1)><(Length / -5),(Height / -5),(BZ + 1)> rotate <0,0,(-1 *((rand(Block_Rand) * Cut_Range1) + Min_Side_Cut))> translate <(SX + (Length / Cut_Depth)),(SY + (Height / Cut_Depth)),0>}
	box {<(Length / 5),0,(SZ - 1)><(Length / -5),(Height / -5),(BZ + 1)> rotate <0,0,((rand(Block_Rand) * Cut_Range1) + Min_Side_Cut)> translate <(BX - (Length / Cut_Depth)),(SY + (Height / Cut_Depth)),0>}
}

#end               

// eof
