// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1 (megapov unofficial compile)
// Desc: Main scene file for RUINS round of the IRTC
// Date: Feb 2000
// Auth: Nathan G B O'Brien
// Mail: no13@no13.net
// Web : http://www.no13.net

#declare SW_Plants = on; 
#declare SW_Build = on;
#declare SW_Mounds = on;
#declare SW_Mount = on;

#include "colors.inc"

#version 3.1;

#include "colors.inc"

#include "blocks1.inc"
#include "pillar1.inc" 
#include "arch1.inc"
#include "entab1.inc"
#include "setout.inc"
#include "sidewall1.inc" 
#include "building1.inc"
#include "building2.inc" 
#include "13sky.inc"
#include "road.inc" 
#include "13system.inc" 
#include "13rocks.inc"  
#include "moundtex.inc"
#if (SW_Plants = on) #include "pgroup.inc" #end
#include "mound.inc"

camera {
	location <18,4,-15>
	look_at  <10,4,-4>
}

light_source {
0*x color <1.75,1.75,1.65> 
area_light
//<0, 0, 0> <15, 0, 15>
<0,0,0> <50,50,0> 
//4, 4
5,5               
adaptive 0         
jitter 
//translate <500,800,-800> 
translate <50000,80000,-80000>
}

// base buildings
#if (SW_Build = on)

object {Building1}
object {Building2 translate <14,0,0>} 
object {Building2 translate <14,0,0> scale <-1,0,0>}
object {Roadway translate <-20,0,0>}
object {Roadway translate <-20,0,10.1683>}  

#end

// landscaping
#declare Mound_Object1 = Mound13 (1,50,13,5,1)
#declare Mound_Object2 = Mound13 (1,50,13,2.5,.75)

#declare Mound_Object =
union {   
	object {Mound_Object1 translate <1,-1.25,-.5>} 
	object {Mound_Object2 translate <5,-1.5,-1>} 
} 
#if (SW_Plants = on)
	#declare PLNT_QTY1 = 600; // 300 default
#else
	#declare PLNT_QTY1 = 0;
#end

#if (SW_Mounds = on) MAKE_MOUND (21,.65,PLNT_QTY1) #end 

// front mound
#declare Mound_Object =   
difference {
	object {Mound13 (1,50,13,4,4) translate <14,-1.25,5>}
	box {<20,20,0><-20,-20,20> translate <14,-1.25,5>}
}
#if (SW_Mounds = on) MAKE_MOUND (21,.65,PLNT_QTY1) #end    

#declare Mound_Object1 = Mound13 (1,50,13,4,4)
#declare Mound_Object2 = Mound13 (1,50,32,4,2)

#declare Mound_Object =
union {   
	object {Mound_Object1 translate <-12,-1.25,5>} 
	object {Mound_Object2 translate <-9,-1.25,7>} 
} 

#if (SW_Mounds = on) MAKE_MOUND (20,.65,0) #end

#declare Mound_Object = object {Mound13 (1,50,13,4,4) translate <-3,-1.25,6>}
#if (SW_Mounds = on) MAKE_MOUND (5,.65,0)  #end

#declare Mound_Object1 = Mound13 (1,50,13,4,3)
#declare Mound_Object2 = Mound13 (1,50,32,4,1)

#declare Mound_Object =
union {   
	object {Mound_Object1 scale <1,1,2> translate <-20,-1.25,0>} 
	object {Mound_Object2 scale <1,1,2> translate <-16,-1.25,0>} 
} 
#if (SW_Mounds = on) MAKE_MOUND (30,1,PLNT_QTY1) #end

// the tree

#declare N_Bark1 =
normal {
	gradient x 1 
	scale .25
	scallop_wave
	turbulence .5
}  

#declare N_Bark2 =
normal {
	granite 1
	scale <2,5,2>
	scallop_wave
	turbulence .5
}   

#declare txtTree =
texture {
  pigment
  {
    radial
    color_map
    {
      [0.00 color rgb<0.569, 0.482, 0.416>]
      [0.19 color rgb<0.757, 0.631, 0.533>]
      [0.37 color rgb<0.498, 0.400, 0.329>]
      [0.53 color rgb<0.604, 0.490, 0.314>]
      [0.71 color rgb<0.667, 0.537, 0.459>]
      [0.84 color rgb<0.549, 0.416, 0.341>]
      [1.00 color rgb<0.733, 0.659, 0.561>]
    } 
    frequency 5
    turbulence .5
    lambda 6
    octaves 3
    omega .75
  } 
  finish {ambient .3 phong .2} 
  normal {
		average  
		normal_map {
			[1.0 N_Bark1]
			[2.0 N_Bark2]
		}
	}
}

#if (SW_Plants = on)
	#include "gttree1.inc"
	object {TREE1 scale .2 translate <9,-.75,-3> pigment{White}}
#end

#declare Mound_Object = object {Mound13 (1,50,13,2.5,.5) translate <9,-1.25,-3>}
#if (SW_Plants = on)
	#declare PLNT_QTY2 = 200; // 100 real 
#else
	#declare PLNT_QTY2 = 0;
#end
#if (SW_Mounds = on) MAKE_MOUND (5,.5,PLNT_QTY2) #end

#if (SW_Mount = on)

// mountains
#include "mountain.inc"  
object {Mountains rotate <0,-180,0> scale <6,2,5> scale 85 translate <-225,-30,300>}  

object {Mountains rotate <0,-180,0> scale <6,1,5> scale 85 translate <-200,-30,250>}

fog
{
  fog_type   2
  distance   300
  color      rgbf <1,1,1,.25>
  fog_offset 0
  fog_alt    40
  turbulence 1
}

#end

//eof