#declare Warntex = texture{
 pigment{gradient z color_map{[0.5 Black]
                              [0.5 Yellow]}
         translate <0,0,100>
         rotate <0,45,0>
        }
 finish {ambient 0.2
         diffuse 0.3
         specular 0.1
         roughness 0.1
         reflection 0.1}
 normal {granite scale 0.4}
}  

#declare Hooktex = texture{
 granite texture_map{[0.55 Warntex scale 0.2]
                  [0.55 Rusty scale 0.02]}
 scale 5
}

#declare CableTex = texture{
pigment {LightSteelBlue5 }
normal{spiral1 10 0.4 scale <0.3,0.5,0.3>}
finish { ambient 0.1
         diffuse 0.2
         specular 0.5
         roughness 0.01
         metallic}
}

// ------------------------------------------------------------

#declare C_Angle = degrees(atan2(1,4));

#declare Lo_Corn = vrotate(<0.5,0,0>,<0, C_Angle,0>) + <1,0,0>;
#declare Hi_Corn = vrotate(<0.5,0,0>,<0, C_Angle,0>) + <2,0,4>;


#declare hookside = object{
 union{
  prism{ linear_spline
         0,1,9,
	     <1,-0.5>, <Lo_Corn.x,Lo_Corn.z>, <Hi_Corn.x,Hi_Corn.z>,       
         <2,4.5>, <-2,4.5>, <-Hi_Corn.x,Hi_Corn.z>,
         <-Lo_Corn.x,Lo_Corn.y>, <-1,-0.5>, <1,-0.5>
       }
  cylinder {<-1,0,0,>,<-1,1,0>,0.5}
  cylinder {< 1,0,0,>,< 1,1,0>,0.5}
  cylinder {<-2,0,4,>,<-2,1,4>,0.5}
  cylinder {< 2,0,4,>,< 2,1,4>,0.5}
 }
 texture {Hooktex}
}

// ------------------------------------------------------------

#declare Hookbase = object{
 union{
  difference{
   torus{1.5,0.5}
   box {<-2,-1,0>,<0,1,2>}
   box {<-2,-1,0>,<0,1,2> rotate <0,45,0>}
  } 
  sphere {<-1.5,0,0>,0.5}

  difference{
   torus {1.5,0.5}
   box {<0,-1,-2>,<2,1,2> rotate <0,-90,0>}
   box {<0,-1,-2>,<2,1,2> rotate <0,45,0>}
   translate <2.1213,0,2.1213>
  }
  cylinder {<0.6216,0,2.1213>,<0.6216,0,4>,0.5} 
  texture {Rusty translate <44,2,8>}
  translate <-0.6216,0,-4>
  rotate <0,-15,0>
  scale <0.5,0.4,0.5>
 }
}

#declare Hookbody = object{
union{
 object{hookside scale <1,0.2,1> translate -0.5*y}
 object{hookside scale <1,0.2,1> translate  0.5*y}
 cylinder {<1,-0.5,0>,<1,0.5,0>,0.3 texture {Rusty}}
 cylinder {<-1,-0.5,0>,<-1,0.5,0>,0.3 texture {Rusty}}
 cylinder {<2,-0.5,4>,<2,0.5,4>,0.3 texture {Rusty}}
 cylinder {<-2,-0.5,4>,<-2,0.5,4>,0.3 texture {Rusty}}

 difference {
  cylinder{<0,-0.4,0>,<0,0.4,0>,1.2}
  torus {1.2,0.1 translate <0,-0.2,0>}
  torus {1.2,0.1 translate <0,0.2,0>}
  texture{ Rusty translate <3,466,43>}
  translate <0,0,2.5>
 }

 cylinder {<0,-0.5,2.5>,<0,0.5,2.5>,0.5 texture{Rusty}}
 cylinder {<0,-0.5,0>,<0,0.5,0>,0.5 texture{Rusty translate <4,3,6>}}
 }
}

// -----------------------------------------------------------------

#declare Hook = object{
 union{
  object {Hookbody}
  object {Hookbase}
  cylinder {<0,0,0>,<0,0,100>,0.1 
            texture{CableTex rotate <0,0,90>} 
            translate <1.2,0.2,2.5>}
  cylinder {<0,0,0>,<0,0,100>,0.1 
            texture{CableTex rotate <0,0,90>}
            translate <1.2,-0.2,2.5>}
  cylinder {<0,0,0>,<0,0,100>,0.1 
            texture{CableTex rotate <0,0,-90>} 
            translate <-1.2,0.2,2.5>}
  cylinder {<0,0,0>,<0,0,100>,0.1 
            texture{CableTex rotate <0,0,-90>}
            translate <-1.2,-0.2,2.5>}
  difference{
   torus {1.2,0.1}
   box {<-2,-1,0>,<2,1,2>}
   texture {CableTex rotate <0,0,45>}
   translate <0,0.2,2.5>
  }
  difference{
   torus {1.2,0.1}
   box {<-2,-1,0>,<2,1,2>}
   texture {CableTex rotate <0,0,45>}
   translate <0,-0.2,2.5>
  }
 }
}