/*
 * shiny.sl -- Shiny metal surface, using ray tracing.
 *
 * DESCRIPTION:
 *   Makes a smoothly polished metal, using ray tracing to calculate
 *   reflections of the environment.
 * 
 * PARAMETERS:
 *    Ka, Kd, Ks, roughness, specularcolor - The usual meaning
 *    Kr - coefficient for mirror-like reflections of environment
 *    blur - how blurry are the reflections? (0 = perfectly sharp)
 *    samples - set to higher than 1 for oversampling of blur
 *
 * AUTHOR: written by Larry Gritz, 1991
 *
 * HISTORY:
 *      Aug 1991 -- written by lg in C
 *      25 Jan 1994 -- recoded by lg in correct shading language.
 *
 * last modified 25 Jan 1994 by Larry Gritz
 */


#include "rayserver.h"
#include "raytrace.h"



surface
shiny ( float Ka = 1, Kd = 0.5, Ks = 1;
	float Kr = 0.5, roughness = 0.05, blur = 0;
	color specularcolor = 1;
	float samples = 1; )
{
    normal Nf = faceforward (normalize(N), I);
    vector IN = normalize (I);

    /* Calculate the reflection color */
    color ev;
    if (Kr > 0.001) {
	vector Rdir = normalize (reflect (IN, Nf));
	ev = Kr * RayTrace (P, Rdir, blur, 1, samples);
    } else {
	ev = 0;
    }

    /* The rest is like the plastic shader */
    Ci = Cs * (Ka*ambient() + Kd*diffuse(Nf)) +
	 specularcolor * (ev + Ks*specular(Nf,-IN,roughness));
    Oi = Os;  Ci *= Oi;
}
