//POOL.pov         17/10/98

#include "colors.inc"

#background { color rgb < 0.2, 0.2, 0.6 > }

global_settings { max_trace_level 10 } 

camera {                                            // CAMERA  
        location < 1, 0, -10 >   
        look_at < -1, -2, 0 >
        angle 45
        }

light_source { < -300, 200, -500 > 
                 color rgb < 0.1, 0.1, 0.2 > shadowless } // FILL LIGHT

light_source { < 20, 40, -20 > color rgb < 1, 1, 0.8 >    // SUN
               spotlight
               point_at < 0.5, -0.5, -3 >
               tightness 10
               radius 1
               falloff 3
              }
light_source { < 30, 66, -39 > color rgb < 0.7, 0.7, 0.2 >    // SUN
               spotlight
               point_at < -1.25, -0.5, -6.25 >
               tightness 10
               radius 1
               falloff 2
              }

light_source { < 10, 22, -13 > color rgb < 0.6, 0.6, 0.1 >      // SUN
               spotlight
               point_at < 1.8, -0.5, -8.25 >
               tightness 10
               radius 1
               falloff 2
              }


// TREES  ( out of sight }
plane { z, 10
           pigment { 
                    granite 
                    turbulence 0.8
                    color_map {
                              [ 0.0 color rgb < 0.4, 0.5, 0.2 > ]
                              [ 0.2 color rgb < 0.4, 0.5, 0.2 > ] 
                              [ 0.4 color rgb < 0.1, 0.3, 0.2 > ]
                              [ 0.4 color rgb < 0.1, 0.3, 0.2 > ]   
                              [ 0.4 color rgb < 0.6, 0.5, 0.4 > ]
                              [ 0.6 color rgb < 0.6, 0.5, 0.4 > ]
                              [ 0.6 color rgb < 0.4, 0.6, 0.2 > ]
                              [ 0.7 color rgb < 0.4, 0.6, 0.2 > ] 
                              [ 0.7 color rgb < 0.6, 0.6, 1 > ]
                              [ 0.9 color rgb < 0.6, 0.6, 1 > ]   
                              [ 1.0 color rgb < 0.5, 0.3, 0.2 > ]
                              }
                       scale 15
                  }         
             finish { ambient 0.4 }     
       }         


// ROCK WALL
#declare Rock =
             height_field {
                          tga "wrinc2.tga" 
                          translate < -0.5, -0.5, -0.5 >
                          scale < 10, 6, 9 >
                          texture {
                          pigment { 
                                bozo
                                turbulence 0.6
                                color_map {
                                      [ 0.0 color rgb < 0.8, 0.64, 0.4 > ]
                                      [ 0.3 color rgb < 0.85, 0.7, 0.45 > ]
                                      [ 0.5 color rgb < 0.7, 0.8, 0.3 > ]
                                      [ 0.6 color rgb < 0.8, 0.74, 0.4 > ]
                                      [ 1.0 color rgb < 0.8, 0.74, 0.4 > ]
                                          }
                                   scale 4
                                   }
                          normal { bumps 0.75 scale < 0.5, 0.5, 1.5 > } 
                          finish { ambient 0.2 }
                                   }
                          texture {
                          pigment { 
                                gradient x
                                turbulence 0.2
                                color_map {
                                  [ 0.0 color Clear ]
                                  [ 0.4 color Clear ] 
                                  [ 0.4 color rgbt < 0.5, 0.7, 0.5, 0.6 > ]
                                  [ 0.6 color rgbt < 0.7, 0.8, 0.8, 0.6 > ]
                                  [ 0.6 color Clear ] 
                                  [ 1.0 color Clear ] 
                                          }
                                   scale 2
                                   }
                          normal { bumps 0.75 scale < 0.5, 0.5, 1.5 > } 
                          finish { ambient 0.2 
                                   phong 1 
                                   phong_size 80 }
                                   }

                          }
#declare Gloss =
             height_field {
                          tga "wrinc2.tga" 
                          translate < -0.5, -0.5, -0.5 >
                          scale < 10, 6, 9 >
                          texture {
                              pigment { color rgbt < 0.8, 0.85, 1.0, 0.8 > }
                              normal { bumps 0.75 scale < 1.5, 0.05, 005 > }
                              finish { ambient 0.2 
                                       phong 1 
                                       phong_size 80 
                                     }
                                  }  
                           translate 0.001*y       
                          }
#declare Brock =
             height_field {
                          tga "wrinc2.tga" 
                          translate < -0.5, -0.5, -0.5 >
                          scale < 10, 6, 9 >
                          texture {
                          pigment { 
                                bozo
                                turbulence 0.6
                                color_map {
                                      [ 0.0 color rgb < 0.8, 0.64, 0.4 > ]
                                      [ 0.3 color rgb < 0.75, 0.6, 0.45 > ]
                                      [ 0.5 color rgb < 0.7, 0.8, 0.3 > ]
                                      [ 0.6 color rgb < 0.8, 0.74, 0.4 > ]
                                      [ 1.0 color rgb < 0.8, 0.74, 0.4 > ]
                                          }
                                   scale 4
                                   }
                    
                          finish { ambient 0.2 }
                                   }
                          texture {
                          pigment { 
                                gradient x
                                turbulence 0.2
                                color_map {
                                  [ 0.0 color Clear ]
                                  [ 0.4 color Clear ] 
                                  [ 0.4 color rgbt < 0.5, 0.7, 0.5, 0.6 > ]
                                  [ 0.6 color rgbt < 0.5, 0.8, 0.8, 0.6 > ]
                                  [ 0.6 color Clear ] 
                                  [ 1.0 color Clear ] 
                                          }
                                   scale 2
                                   }
                          normal { bumps 0.9 scale 0.015 } 
                          finish { ambient 0.2 }    
                                   }

                          }

object { Rock rotate < -70, 45, -60 > translate < -0.5, 1, -1 > }
object { Gloss rotate < -70, 45, -60 > translate < -0.5, 1, -1.1 > }  
object { Brock rotate < -70, -60, 0 > translate < 0.5, -2, -2 > }   
object { Brock rotate < -70, 60, 0 > translate < 2.2, 0, -2.6 > }  

// SMALL FERN
#declare Fall =
              torus { 2, 0.015  rotate 90*z
                     clipped_by {
                             box { < -1, 0, 0 >,< 1, 2.1, -2.1 > }
                                }
                            pigment { color rgb < 0.2, 0.7, 0.2 > }
                            finish { ambient 0.2 } 
                    }
                                 
#declare Fleaf =
                union {
                      disc { < 0, 0, 0 >,< 0, 1, 0 >,0.1
                              scale < 1, 1, 1.5 >
                              translate -0.4*z  
                            }
                      cone { < 0, 0, 0 >,0.01,< 0, 0, -0.5 >,0.0 }
                            rotate -30*y
                            pigment { color rgb < 0.32, 0.7, 0.2 > }
                            finish { ambient 0.25 }
                       }
#declare Gleaf =
                union {
                      disc { < 0, 0, 0 >,< 0, 1, 0 >,0.1
                              scale < 1, 1, 1.5 >
                              translate -0.4*z  
                            }
                      cone { < 0, 0, 0 >,0.01,< 0, 0, -0.5 >,0.0 }
                            rotate 30*y
                            pigment { color rgb < 0.2, 0.65, 0.3 > }
                            finish { ambient 0.25 }
                       }

#declare Duo =
             union {
                   object { Fleaf }
                   object { Gleaf }  
                   }
#declare Fron =
             union {
                    object { Fall }
                    object { Duo translate 2*y }
                    object { Duo scale 0.95  translate 2*y rotate -9*x } 
                    object { Duo scale 0.9  translate 2*y rotate -18*x }
                    object { Duo scale 0.85  translate 2*y rotate -27*x } 
                    object { Duo scale 0.8  translate 2*y rotate -36*x }
                    object { Duo scale 0.75  translate 2*y rotate -45*x } 
                    object { Duo scale 0.7  translate 2*y rotate -54*x }
                    object { Duo scale 0.65  translate 2*y rotate -63*x } 
                    object { Duo scale 0.6  translate 2*y rotate -72*x }
                    object { Duo scale 0.55  translate 2*y rotate -81*x } 
                    object { Duo scale 0.5  translate 2*y rotate -90*x }   
                    translate -2*y
                   }
#declare Afern =
           union {
object { Fron rotate -30*y }
object { Fron scale < 1.5, 1.25, 0.8 > rotate 15*y }  
object { Fron scale < 1.5, 0.8, 0.7 > rotate < -15, -15, 0 > } 
object { Fron scale < 1.25, 0.7, 1.2 > rotate < 15, -60, 0 > }       
object { Fron scale < 1.25, 1, 1.5 > rotate < 10, -40, 0 > }       
                 }             
                 
object { Afern scale 0.35 rotate -15*y translate < -0.65, 0.2, -1.6 > }                 
object { Afern scale < 0.4, 0.45, 0.25 > rotate 30*y 
                          translate < -1.2, 1, -1.65 > }  
object { Afern scale < 0.2, 0.3, 0.1 > 
                          translate < -1.6, 0, -5 > }  
object { Fron scale 0.35 rotate 30*y translate < 2, 1.1, -1.1 > }
object { Fron scale 0.35 rotate 10*y translate < 2.05, 1, -1.2 > }  

// WATER EFFECTS

#declare Spls =
           torus { 1, 0.2   
                  rotate 90*z    
                  pigment { color rgbt < 0.8, 0.9, 1, 0.92 > }
                  finish { ambient 0.2 
                           metallic
                           phong 1 
                           phong_size 80 }
                     scale 0.2
                 }
#declare Bubbles =
                  sphere { < 0, 0, 0 >,0.04   
                  pigment { color rgbt < 0.8, 0.9, 1, 0.8 > }
                  finish { ambient 0.2 
                           metallic
                           phong 1 
                           phong_size 80 }
                   }

object { Bubbles translate < -0.5, -1, -5 > }                  
object { Bubbles translate < -1.5, -1, -6 > }     
object { Bubbles translate < 1.2, -1, -7 > }                  
object { Bubbles translate < 1, -1, -8 > }     

// WATER PLANTS
#declare Bit =
              sphere { < 0, 0.4, 0 >,0.4
                      clipped_by {
                                 box { < -0.5, 0.01, -0.5 >,< 0.5, -1, 0.5 > }
                                 }
                      pigment { color rgb < 0.1, 0.6, 0.1 > }
                      finish { ambient 0.25 }
                      
                      translate 0.005*y
                     }
#declare Abits =
          union {
object { Bit scale 0.5 translate < -1.5, -1, -5.8 > }
object { Bit scale 0.5 translate < -1.6, -1, -5.75 > }   
object { Bit scale 0.5 translate < -1.45, -1, -5.7 > }   
object { Bit scale 0.5 translate < -1.34, -1, -5.7 > }   
object { Bit scale 0.5 translate < -1.48, -1, -5.45 > }
object { Bit scale 0.5 translate < -1.65, -1, -5.5 > }   
object { Bit scale 0.5 translate < -1.34, -1, -5.85 > }   
object { Bit scale 0.5 translate < -1.4, -1, -5.6 > }   

object { Bit scale 0.5 translate < -1.55, -1, -5.55 > }
object { Bit scale 0.5 translate < -1.65, -1, -5.63 > }   
object { Bit scale 0.5 translate < -1.3, -1, -5.55 > }   
object { Bit scale 0.5 translate < -1.25, -1, -5.65 > }   
object { Bit scale 0.5 translate < -1.25, -1, -5.75 > }
object { Bit scale 0.5 translate < -1.7, -1, -5.6 > }   
object { Bit scale 0.5 translate < -1.8, -1, -5.5 > }   
object { Bit scale 0.5 translate < -1.2, -1, -5.46 > }   
          }
object { Abits translate 0.6*x }
object { Abits translate < 2.75, 0, -2 > }

#declare Ripple =  
           torus { 2, 0.1   
                  pigment { color rgbt < 0.8, 0.9, 1, 0.92 > }
                  finish { ambient 0.2 
                           metallic
                           phong 1 
                           phong_size 80 }
                     scale 0.2
                 }

#declare Bub =
           sphere { < 0, 0, 0 >,0.7
                     scale < 0.1, 1, 0.1 >
                  pigment { color rgbt < 0.8, 0.9, 1, 0.8 > }
                  finish { ambient 0.2 
                           phong 1 
                           phong_size 80 }
                   }

object { Bub rotate 30*x translate < 0.2, -0.75, -1.7 > }
object { Bub rotate 30*x scale 0.75 translate < 0.6, -0.75, -1.85 > } 
object { Spls scale < 3, 6, 2 > rotate 20*y translate < 0.25, -1, -1.5 > }
object { Spls scale < 3, 6, 2 > rotate 20*y translate < 0, -0.76, -1.25 > } 
object { Spls scale < 2, 6, 2 > rotate 25*y translate < 0.2, -1, -1.5 > }
object { Spls scale < 2, 6, 2 > rotate -25*y translate < -0.15, -1.75, -1.75 > } 
object { Spls scale < 4, 5.6, 2 > rotate -10*y translate < 0.1, -1, -1.5 > }
object { Spls scale < 4, 4, 2 > rotate 30*y translate < 0.5, -1, -1.5 > } 
object { Ripple translate < 0.2, -1, -1.8 > }
 
// SAND
#declare Base =
             height_field {
                          tga "wrinc2.tga" 
                          translate < -0.5, -0.5, -0.5 >
                          scale < 60, 25, 50 >
                          texture {
                          pigment { 
                                bozo
                                turbulence 0.6
                                color_map {
                                      [ 0.0 color rgb < 0.8, 0.64, 0.4 > ]
                                      [ 0.3 color rgb < 0.85, 0.7, 0.45 > ]
                                      [ 0.5 color rgb < 0.7, 0.8, 0.3 > ]
                                      [ 0.6 color rgb < 0.8, 0.74, 0.4 > ]
                                      [ 1.0 color rgb < 0.8, 0.74, 0.4 > ]
                                          }
                                   scale 1.5
                                   }
                          normal { bumps 0.5 scale 0.0005 } 
                          finish { ambient 0.2 }
                                   }
                     }
object { Base scale < 2, 1, 2 > translate < -0.75, 0.1, -23.7 > }
#declare Stone =
               sphere { < 0, 0, 0 >,0.25
                        scale < 1, 0.25, 0.8 >
                        pigment { color rgb < 0.4, 0.6, 0.1 > }
                        normal { bumps 0.5 scale 0.0005 } 
                        finish { ambient 0.2 }
                      }
#declare Pebbl =
               sphere { < 0, 0, 0 >,0.1
                        scale < 1, 0.25, 0.8 >
                        pigment { color rgb < 0.7, 0.5, 0.3 > }
                        normal { bumps 0.5 scale 0.005 } 
                        finish { ambient 0.2 }
                      }

object { Stone translate < 0, -1.075, -5.8 > }
object { Stone scale < 1, 1, 0.6 > rotate 15*z
                  translate < 1.1, -1.35, -5.5 > }   
object { Stone translate < 1.1, -1.35, -6.5 > }  
object { Stone scale < 0.6, 1, 1.2 > rotate < -15, 20, 0 >
                 translate < 0.65, -1.4, -7.2 > }  
                 
object { Pebbl translate < -0.25, -1.05, -6 > }
object { Pebbl translate < 0.5, -1.15, -5.6 > }   
object { Pebbl scale < 1, 1, 0.6 > rotate -15*z
                  translate < 1, -1.3, -5.9 > }   
object { Pebbl rotate -25*x translate < 0.4, -1.25, -6.85 > }  
object { Pebbl scale < 0.6, 1, 1.2 > rotate < -25, 20, 0 >
                 translate < 0.15, -1.2, -7.25 > }  

object { Pebbl rotate -42*z translate < -0.05, -1.1, -7.6 > }
object { Pebbl translate < 0.5, -1.35, -7.56 > }   
object { Pebbl scale < 1, 1, 0.56 > rotate -15*z
                  translate < 0.03, -1.11, -7.4 > }   
                  
object { Pebbl rotate < -25, 0, -20 > translate < 0.4, -1.35, -7.15 > }  
object { Pebbl scale < 0.6, 1, 1.2 > rotate < -15, 20, 0 >
                 translate < 0.15, -1.12, -7.05 > }  

// FLOATING LEAF
#declare Harf =
          union {   
             torus { 0.1, 0.015   scale  < 1.4142, 0.5, 1 >
                     rotate < 90, 45, 0 > 
                     translate 0.1*z
                     pigment { color rgb < 0.7, 0.6, 0.1 > }
                     finish { ambient 0.2 }
                    }
             cylinder { < 0, 0, -1 >,< 0, 0, 1 >,0.1  }
                       clipped_by {
                                  box { < -1, 0, -0.8 >,< 1, 0.15, 0.8 > }
                                  }   
                       pigment { color rgb < 0.8, 0.7, 0.2 > }
                       finish { ambient 0.25 }
                       }
#declare Arf =
          union {   
             torus { 0.1, 0.015   scale  < 1.4142, 0.5, 1 >
                     rotate < 90, 45, 0 > 
                     translate -0.1*z
                     pigment { color rgb < 0.7, 0.6, 0.1 > }
                     finish { ambient 0.2 }
                    }
             cylinder { < 0, 0, -1 >,< 0, 0, 1 >,0.1  }
                       clipped_by {
                                  box { < -1, 0, -0.8 >,< 1, -0.15, 0.8 > }
                                  }   
                       pigment { color rgb < 0.8, 0.7, 0.2 > }
                       finish { ambient 0.25 }
                       }

#declare Both =
              union {
                    object { Harf translate -0.1*x }
                    object { Arf translate 0.1*x }
                    }
#declare Float =
   
                object { Both
                       clipped_by {
                                cylinder { < 0, -1, 0 >,< 0, 1, 0 >,0.284
                                            scale < 1, 1, 0.25 >
                                            rotate  45*y
                                          }
                                  }  
                          rotate 10*z
                       }
#declare Wfall =
          object { Float rotate -45*y scale < 1, 0.25, 1 > translate 0.025*y }


object { Wfall scale 0.5
          rotate -60*y translate < -0.25, -1, -7.25 > }
object { Wfall scale 0.5 
          rotate 40*y translate < 0, -1, -7.9 > } 
object { Wfall scale 0.4
          rotate 60*y translate < -0.35, -1, -8 > }
object { Wfall scale 0.3 
          rotate 80*y translate < -0.3, -1, -8.1 > } 



// GRASS
#declare Elem =
              torus { 3, 0.25  rotate 90*x 
                      clipped_by {
                               box { < -3, 4, -1 >,< 0, 0, 1 > }
                                 }
                     pigment { color rgb < 0.6, 0.8, 0.2 > }
                     finish { ambient 0.2 }
                     }
#declare Blade =
                object { Elem
                         clipped_by {
                                   cylinder { < 0, 0, -1 >,< 0, 0, 1 >,2.75
                                              translate -0.25*x
                                            }
                                     }
                         translate 3*x
                         scale < 1, 2, 0.3 >  
                         rotate 10*z
                       }
               
#declare Number_of_Cycles = 2
#declare Count_per_Cycle = 30
#declare Coefficient = 0.5
#declare Starting_Angle = 0
#declare Angle = 360 / Count_per_Cycle
#declare Count = Number_of_Cycles * Count_per_Cycle -1

#declare SD1 = seed(1)

#declare Grass =
       union {
         sphere { < 0, 0, 0 >,0.1
                   pigment { color Red }
                }
         #while ( Count >= 0 )
                object { Blade 
                       scale < 1, 1.5*rand(SD1), 1 >
                       translate 0.4*rand(SD1)*x
                       rotate <  Starting_Angle * Coefficient, 0,  
                                 Starting_Angle * Coefficient  > 
                       }
         #declare Starting_Angle =  Starting_Angle + Angle
         #declare Count = Count - 1

         #end      
                }
object { Grass scale 0.06 rotate -30*y translate < -0.5, -0.95, -7.65 > }
object { Grass scale < 0.03, 0.075, 0.03 >  rotate 120*y
                      translate < -1.7, 0.2, -5 > }   
object { Grass scale < 0.02, 0.1, 0.02 >  rotate -90*y
                      translate < -2, -0.05, -5.1 > }   
                      



// WATER SURFACE
plane { y, -1
       pigment { color rgbt < 0.4, 0.5, 0.6, 0.45 > }
       normal { ripples 0.6 scale 0.25 turbulence 0.25 translate -2.5*z }
       finish { ambient 0.15
                reflection 0.3
                phong 1 }
      }

// MOSS  
#declare Moss =
               sphere { < 0, 0, 0 >,0.25
                        scale < 1, 0.25, 0.8 >
                        pigment { color rgb < 0.54, 0.5, 0.1 > }
                        normal { bumps 1 scale 0.005 } 
                        finish { ambient 0.2 }
                      }

object { Moss scale < 2, 1, 1 > rotate -30*x translate < -2.2, -0.08, -5 > }

// BIG FERN
#declare Afine =
             disc { < 0, 0, 0 >,< 0, 1, 0 >,0.17
                    scale < 0.23, 1, 1.5 >
                    pigment { color rgb < 0.4, 0.7, 0.5 > }
                    finish { ambient 0.3 }
                  }
#declare Bfine =
             disc { < 0, 0, 0 >,< 0, 1, 0 >,0.17
                    scale < 0.33, 1, 1.5 >
                    pigment { color rgb < 0.5, 0.7, 0.5 > }
                    finish { ambient 0.3 }
                  }
#declare Apair =
             union {
                    object { Afine translate -0.25*z 
                            rotate 60*y
                           }
                    object { Afine translate -0.25*z
                            rotate -60*y
                           }
                  }
#declare Bpair =
             union {
                    object { Afine translate -0.25*z 
                            rotate 60*y
                           }
                    object { Bfine translate -0.25*z
                            rotate -60*y
                           }
                  }
#declare Prong =
             union {
                   torus { 2.35, 0.01
                           rotate 90*z
                           clipped_by {
                              box { < -0.1, 0, 0.5 >,< 0.1, 3, -3 > }
                                      }
                    pigment { color rgb < 0.6, 0.6, 0.35 > }
                    finish { ambient 0.3 }
                  }
                  object { Apair translate 2.35*y }
                  object { Apair translate 2.35*y rotate -4*x }
                  object { Apair translate 2.35*y rotate -8*x }  
                  object { Apair translate 2.35*y rotate -12*x }  
                  object { Apair translate 2.35*y rotate -16*x }  
                  object { Apair translate 2.35*y rotate -20*x }  
                  object { Apair translate 2.35*y rotate -24*x }
                  object { Apair translate 2.35*y rotate -28*x }  
                  object { Apair translate 2.35*y rotate -32*x }  
                  object { Bpair translate 2.35*y rotate -36*x }  
                  object { Apair translate 2.35*y rotate -40*x }  
                  object { Apair translate 2.35*y rotate -44*x }
                  object { Apair translate 2.35*y rotate -48*x }  
                  object { Apair translate 2.35*y rotate -52*x }  
                  object { Bpair translate 2.35*y rotate -56*x }  
                  object { Apair translate 2.35*y rotate -60*x }
                  object { Apair translate 2.35*y rotate -64*x }  
                  object { Apair scale 0.95 translate 2.35*y rotate -68*x }  
                  object { Apair scale 0.825 translate 2.35*y rotate -72*x }  
                  object { Apair scale 0.7 translate 2.35*y rotate -76*x }   
                  object { Apair scale 0.575 translate 2.35*y rotate -80*x }  
                  object { Bpair scale 0.45 translate 2.35*y rotate -83*x }  
                  object { Apair scale 0.325 translate 2.35*y rotate -86*x }   
                  object { Apair scale 0.2 translate 2.35*y rotate -90*x }  
                    translate < 0, -2.35, -0.25 >
                    scale < 1.2, 0.5, 0.8 >
               }   
          

#declare Biprong =
               union {
                     object { Prong rotate 60*y translate -0.3*z }
                     object { Prong rotate -60*y translate 0.3*z } 
                     }
#declare Brakn =                  
          union {
                   torus { 10, 0.03
                           rotate 90*z
                           clipped_by {
                              box { < -0.1, 0, 0.25 >,< 0.1, 14, -14 > }
                                      }
                    pigment { color rgb < 0.6, 0.6, 0.35 > }
                    finish { ambient 0.3 }
                  }
                  object { Biprong translate 10*y }
                  object { Biprong translate 10*y rotate -5*x }
                  object { Biprong translate 10*y rotate -10*x }  
                  object { Biprong translate 10*y rotate -15*x }
                  object { Biprong translate 10*y rotate -20*x }  
                  object { Biprong translate 10*y rotate -25*x }
                  object { Biprong translate 10*y rotate -30*x }  
                 
                  object { Biprong scale 0.98 translate 10*y  rotate -35*x }  
                  object { Biprong scale 0.95translate 10*y  rotate -40*x }
                  object { Biprong scale 0.9 translate 10*y  rotate -45*x }  
                  object { Biprong scale 0.88 translate 10*y  rotate -50*x }
                  object { Biprong scale 0.82 translate 10*y  rotate -55*x }  
                  object { Biprong scale 0.78 translate 10*y  rotate -60*x }  
                  object { Biprong scale 0.72 translate 10*y  rotate -65*x }
                  object { Biprong scale 0.65 translate 10*y  rotate -70*x }    
                  object { Biprong scale 0.6 translate 10*y  rotate -74*x }
                  object { Biprong scale 0.5 translate 10*y  rotate -78*x }    
                  
                  object { Biprong scale 0.4 translate 10*y  rotate -82*x }  
                  object { Biprong scale 0.3 translate 10*y  rotate -86*x }  
                  object { Biprong scale 0.2 translate 10*y  rotate -88*x }
                  object { Biprong scale 0.1 translate 10*y  rotate -90*x }     
                    translate -10*y
                 } 

object { Brakn   scale < 0.15, 0.03, 0.08 > rotate < 20, 150, 0 > 
                 translate < 1.75, -0.6, -8.25 > }                  

object { Brakn   scale < 0.15, 0.03, 0.08 > rotate 90*y 
                 translate < 1.95, -0.4, -8.25 > }                  

object { Brakn   scale < 0.2, 0.04, 0.1 > rotate 130*y 
                 translate < 1.9, -0.6, -8.1 > }                  
                 
object { Brakn   scale < 0.2, 0.04, 0.1 > rotate 70*y 
                 translate < 2, -0.5, -8.4 > }                  
                 

//FROG  
#declare Amph =
              texture {
                       pigment {
                                granite
                                turbulence 0.5
                                color_map {
                                     [ 0.0 color rgb < 0.3, 0.6, 0.1 > ]
                                     [ 0.2 color rgb < 0.3, 0.6, 0.1 > ]
                                     [ 0.2 color rgb < 0.6, 0.4, 0.2 > ]
                                     [ 0.4 color rgb < 0.6, 0.4, 0.2 > ]  
                                     [ 0.4 color rgb < 0.4, 0.8, 0.3 > ]  
                                     [ 0.6 color rgb < 0.1, 0.3, 0.1 > ]  
                                     [ 0.8 color rgb < 0.1, 0.3, 0.1 > ] 
                                     [ 0.8 color rgb < 0.9, 0.9, 0.3 > ]  
                                     [ 1.0 color rgb < 0.9, 0.9, 0.3 > ]  
                                          }
                                     scale < 0.2, 0.2, 1 >
                                }
                        finish { ambient 0.2 }
                        }
#declare Fingr =
             torus { 0.1, 0.01
                      rotate 90*z
                      clipped_by {
                                 box { < -0.1, 0, 0 >,< 0.1, 0.11, 0.11 > }
                                 }
                      translate  -0.1*y
                      texture { Amph }
                    }
#declare Claw =
            union {
                   object { Fingr rotate 10*y }
                   object { Fingr rotate -10*y }
                   object { Fingr rotate 25*y } 
                   object { Fingr rotate -25*y } 
                   }
#declare Toe =
               cone { < 0, 0, 0 >,0.015,< 0, 0, -0.3 >,0.008 
                 texture { Amph }     
                    } 
#declare Foot =
        union {
              triangle { < 0, 0, -0.16 >,< -0.14, 0, -0.4 >,< 0.14, 0, -0.4 >
                         texture { Amph }  
                       }
              object { Toe rotate 25*y translate -0.15*z }    
              object { Toe rotate 13*y translate  -0.15*z }
              object { Toe rotate -25*y translate -0.15*z  }
              object { Toe rotate -13*y translate -0.15*z  } 
              }
#declare Frog =   
          union {
              sphere { < 0, 0, 0 >,0.2             // HEAD     
                       scale < 0.75, 0.4, 1 >
                       rotate 20*x
                       translate < 0, -0.035, 0.4 >
                      }  
              sphere { < 0, 0, 0 >,0.06                    // R EYE
                         clipped_by {
                                 box { < 0, 0.1, 0.1 >,< -0.1, -0.1, -0.1 > }
                                    }
                         translate < 0.08, -0.01, 0.45 >
                     }
              sphere { < 0, 0, 0 >,0.056                    // R EYE  
                         pigment { color Black }
                         finish { phong 1 }
                         translate < 0.08, -0.01, 0.45 >
                     }
              sphere { < 0, 0, 0 >,0.06                    // L EYE
                         clipped_by {
                                 box { < 0, 0.1, 0.1 >,< 0.1, -0.1, -0.1 > }
                                    }  
                         translate < -0.08, -0.01, 0.45 >
                     }
              sphere { < 0, 0, 0 >,0.056                    // L EYE  
                         pigment { color Black }
                         finish { phong 1 }
                         translate < -0.08, -0.01, 0.45 >
                     }

              cone { < 0, -0.05, 0.4 >,0.18,< 0, 0, 0 >,0.32    // NECK     
                       scale < 0.75, 0.4, 1 >
                      }
              sphere { < 0, 0, 0 >,0.35             // BODY     
                       scale < 0.75, 0.475, 1 >
                     }
              sphere { < 0, 0, 0 >,0.25              // L THIGH
                       scale < 0.4, 0.4, 1 >
                       rotate 30*y
                       translate < -0.13, -0.05, -0.38 >
                     }
              sphere { < 0, 0, 0 >,0.25              // R THIGH
                       scale < 0.4, 0.4, 1 >
                       rotate -30*y
                       translate < 0.13, -0.05, -0.38 >
                     }
              sphere { < 0, 0, 0 >,0.125              // L U ARM
                       scale < 1, 0.4, 0.4 >
                       rotate 40*z
                       translate < -0.2, -0.1, 0.2 >
                     }
              sphere { < 0, 0, 0 >,0.125              // R U ARM
                       scale < 1, 0.4, 0.4 >
                       rotate -40*z
                       translate < 0.2, -0.1, 0.2 >
                     }
              sphere { < 0, 0, 0 >,0.125              // L L ARM
                       scale < 1, 0.3, 0.3 >
                       rotate 65*z
                       translate < -0.35, -0.25, 0.2 >
                     }
              sphere { < 0, 0, 0 >,0.125              // R L ARM
                       scale < 1, 0.3, 0.3 >
                       rotate -65*z
                       translate < 0.35, -0.25, 0.2 >
                     }
              object { Claw rotate 45*x                     // R HAND
                       translate < 0.4, -0.35, 0.2 > }
              object { Claw rotate 45*x                     // L HAND
                       translate < -0.4, -0.35, 0.2 > }


              sphere { < 0, 0, 0 >,0.2              // L CALF
                       scale < 0.3, 0.3, 1 >
                       rotate -5*y
                       translate < -0.25, -0.05, -0.7 >
                     }
              sphere { < 0, 0, 0 >,0.2              // R CALF
                       scale < 0.3, 0.3, 1 >
                       rotate 5*y
                       translate < 0.25, -0.05, -0.7 >
                     }
              sphere { < 0, 0, 0 >,0.2              // L FOOT
                       scale < 0.2, 0.2, 1 >
                       rotate < -25, 30, 0 >
                       translate < -0.3, -0.1, -1 >
                     }
              sphere { < 0, 0, 0 >,0.2              // R FOOT
                       scale < 0.2, 0.2, 1 >
                       rotate < -25, -30, 0 >
                       translate < 0.3, -0.1, -1 >
                     }
              object { Foot  rotate < -25, -30, 0 >        
                            translate < 0.3, -0.1, -1 >     // R FOOT
                     }
              object { Foot  rotate < -25, 30, 0 >
                          translate < -0.3, -0.1, -1 >      // L FOOT
                       }
                      texture { Amph }
                     }

object { Frog scale 0.18 rotate < -30, 120, 0 >
              translate < 0.65, -1.028, -6.85 > }



                 
                 


                  


