
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "atmos.inc"    // Include the Atmosphere2 declaration


// XXXX   XXXX   XX   XXX       XXXXX  X  X  XXXXX   XXX   XX
//  X  X  X     X  X  X  X        X    X  X    X    X      XX
//  XXX   XX    XXXX  X  X        X    XXXX    X     XX    XX
//  X  X  X     X  X  X  X        X    X  X    X       X
//  X  X  XXXX  X  X  XXX         X    X  X  XXXXX  XXX    XX

// Read this!
// Due to the extreme complexity of the atmosphere effect used in this scene,
// It is necessary to indicate whether you want high quality or faster
// rendering.
// If you have a very fast computer or a LOT of time, choose 1 below.
// This will turn the jittering off and increase the sampling by a factor of
// 20. Otherwise, choose 0. For no atmosphere, choose any other number.

#declare computer = 1
//               -here-                    






//--Texture declarations--

#declare blackstone=texture{pigment{marble color_map{[0 rgb 0.2][1 rgb 0.4]} turbulence 0.5 omega 1}}
#declare Black_Marble=pigment{marble color_map{[0 rgb 0.2][1 rgb 0.5]} turbulence 0.4 omega 1 scale 0.05}
#declare Blood=pigment{rgb<0.5,0.2,0.1>}
#declare bloodstone=texture{pigment{marble pigment_map{[0.7 Black_Marble][1 Blood]} turbulence 0.8 omega 1 scale 50}finish{diffuse 0.7}}
#declare floortex=texture{pigment{rgb<0.2,0.3,0.4>} finish{diffuse 0.7 specular 0.3 reflection 0.4}
                                                    normal{bumps 0.2 turbulence 1 scale 0.25}}
#declare grass=texture{pigment{rgb<0.1,0.3,0.02>} normal{bumps 0.5 scale 0.01} finish{ambient 0.1}}


//--Torch on arches--

#declare torch=
union{
//--Handle with wall holder
cylinder
{
  <0,-0.2,0>,  <0,1,0>,  0.25
  texture{pigment{rgb<0.4,0.3,0>}}
}

cylinder
{
  <0,1,0>,  <0,1.2,0>,  0.5
  texture{pigment{rgb<0.4,0.3,0>}}
}
cylinder
{
  <0,0.5,0>,  <0,0.5,0.5>,  0.2
  texture{pigment{rgb 0.3} finish{diffuse 0.5}}
}
//--Flame (halo)
sphere { <0,0.9,0>, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    color_map {
      [ 0 color rgbt <1, 0, 0, 1> ]
      [ 1 color rgbt <1, 1, 0, -1> ]
    }
    scale 0.5
    samples 10
    turbulence 0.5

  }
  hollow
  scale<0.7,4,0.7>
  translate<0,1.2,0>
}
}



//--Arches used in while-statement--

#declare arch=
union{
union{

box
{
  <-1,  0, -0.3>  // one corner position <X1 Y1 Z1>
  <-0.8,2,  0.3>  // other corner position <X2 Y2 Z2>
}

box
{
  <1,   0, -0.3>  // one corner position <X1 Y1 Z1>
  <0.8, 2,  0.3>  // other corner position <X2 Y2 Z2>
}

difference{

box
{
  <-1,  2, -0.3>  // one corner position <X1 Y1 Z1>
  <1,  3,   0.3>  // other corner position <X2 Y2 Z2>
}

cylinder
{
  <0,2,1>,  <0,2,-1>,  0.8
}
}
texture{blackstone}
}
object{torch scale 0.2 translate<0.9,1,-0.4>}
}


//--Camera selection:--
//   1 Over Colloseum, looking in
//   2 In Colloseum looking at fire
//   3 Direct view of a torch
//   4 Over Colloseum looking to the side
//   5 Camera used in Competition - like 1 but further away

#declare cam=5




#if (cam=1)
camera
{
  location  <3.0 , 12.0 , -20.0>
  look_at   <-0.7 , -1.0 , 5.0>
}
#end

#if (cam=2)
camera
{
  location  <1.0 , 4.0 , -9.0>
  look_at   <0.0 , 3.0 , 0.0>
}
#end

#if (cam=3)
camera
{
  location  <1.0 , 7.0 , 9.0>
  look_at   <-1.0 , 7.0 , 11.0>
}
#end

#if (cam=4)
camera
{
  location  <10.0 , 10.0 , -20.0>
  look_at   <13.0 , 1.0 , 5.0>
}
#end

#if (cam=5)
camera
{
  location  <4.0 , 14 , -27.5>
  look_at   <-0.7 , -1.0 , 5.0>
}
#end


//--I noticed that halos don't emit very much light, so I added a ...
//--Light in fire - To make the blaze emit more than normal.

light_source
{
  0*x // light's position (translated below)
  color red 0.8  green 0.5  blue 0.0  // light's color
  translate <0, 2.3, 0>
  atmospheric_attenuation on
}



//--This is the floor--
//--First the steps--
#declare ct=1
#while (ct<6)
cylinder
{
  <0,-1,0>,  <0,-1+ct/5,0>, 12-ct/5
  texture{floortex}
}
#declare ct=ct+1
#end


//--The grassy plain--
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1 // distance from the origin in the direction of the surface normal
  texture{grass}
}






//--Here's the offering table--
difference{
intersection{
cylinder
{
  <0,0,0>,  <0,1,0>,  5
}
cone
{
  <0,0,0>,  5,
  <0,2,0>, 4
}
}
union{
 cylinder
 {
   <0,-1,0>,  <0,4,0>,  0.5
 }
 cone
 {
   <0,0.5,0>,  0,
   <0,2,0>, 3
 }
}

texture{pigment{Black_Marble}}
}


//--The fire in the table--
  sphere { <0,0.9,0>, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 0.4 color rgbt <1, 1, 0, -1> ]
        [ 1 color rgbt <1, 1, 0, -1> ]

      }
      scale 0.4
      samples 10
      turbulence 0.7
    }
    hollow
    scale<2,10,2>
  }


//--while-placings of the arches--
//first level
#declare scl = 1.6
#declare rd = 10
#declare ct=0
#while (ct < 20)
 #declare pct = ct/20
 object{arch scale scl    rotate<0,pct*360,0>  translate<sin(2*pi*pct)*rd, 0, cos(2*pi*pct)*rd>}
 #declare ct = ct + 1
#end

//second level
#declare rd = 10
#declare ct=0.5
#while (ct < 20)
 #declare pct = ct/20
 object{arch scale scl    rotate<0,pct*360,0>  translate<sin(2*pi*pct)*rd, 3*scl, cos(2*pi*pct)*rd>}
 #declare ct = ct + 1
#end




//--Moonlight--
light_source
{
  0*x // light's position (translated below)
  color red 0.1  green 0.1  blue 0.2  // light's color
  translate <70, 70, 000>
}



//--Here comes the atmosphere (uh oh...)
#if (computer=0)
 atmosphere{Atmosphere2 scattering 0.025 distance 100}
#end

#if (computer=1)
 atmosphere{Atmosphere2 scattering 0.045 samples 80 distance 100 jitter 0}
#end


//--Trees: 1=on, anything else=off
#declare trees = 1
#if (trees=1)


//--Declare random placements of trees
#declare r1=seed(012)
#declare r2=seed(166)
#declare r3=seed(256)
#declare r4=seed(334)

#declare ct=0
#while(ct<4000) /* Yes, 4000 trees. That's why it takes so long to parse. */
#declare xx = rand(r1)
 #declare factor=rand(r4)
 #declare treegreen=texture{pigment{rgb<0.1, 0.7*(factor*0.5+0.2), 0.5>} normal{bumps 1 scale 0.01}}
 #declare tree=union{
 cone
 {
   <0,7,0>,  0.0,
   <0,0.5,0>, 2.0
   texture{treegreen}
 }
 cylinder
 {
   <0,1,0>,  <0,0,0>,  0.3
   texture{pigment{rgb<0.5,0.4,0>}}
 }
 }
 object{tree scale rand(r2)+0.25 translate<sin(xx*2*pi)*30*(rand(r3)*8+1), -1, cos(xx*2*pi)*30*(rand(r3)*8+1)>}

#declare ct=ct+1
#end

#end

//--This sphere is here to stop the renderer from rendering the atmophere
//--indefinetely. It only calculates it inside the hollow sphere.
//--This cut the rendering time in half.
sphere
{
 <0,0,0>
 100
 hollow
}

//--Wow! You made it all the way to the end. Thanks for showing interest in
//--my file, and I hope you have fun or even learn something from it.
