/* Small, simple wooden table with candle. You want to know what tragedy 
   is? I designed this to appear in the windows of the tower stacks with
   windows. Although the light from the candles does make a contribution
   to the final pic, the viewing angle is such that not one of the tables
   could be seen through the windows! I could have just used a 
   disembodied light source and gotten away with it! *sigh* live and learn
*/


#declare Flametex2 =
   texture  // Flametex2
   {
      pigment
      {
         color rgb <1.0, 1.0, 1.0>
      }
      finish
      {
         ambient 1.0
         diffuse 1.0
      }
   }

#declare WhiteCandle =
   texture  // WhiteCandle
   {
      pigment
      {
         color rgb <0.958333, 0.958333, 0.958333>
      }
      finish
      {
         ambient 0.1
         phong 0.25
         phong_size 30.0
      }
   }


#declare Mildwood =
   texture  // Mildwood
   {
      pigment
      {
         wood
         color_map
         {
            [ 0.0     rgbft <0.6, 0.3, 0.18, 0.0, 0.0> ]
            [ 0.1     rgbft <0.6, 0.3, 0.18, 0.0, 0.0> ]
            [ 0.9     rgbft <0.528821, 0.26441, 0.158646, 0.0, 0.0> ]
            [ 1.0     rgbft <0.75318, 0.37659, 0.225954, 0.0, 0.0> ]
         }
         turbulence 0.04
         octaves 3
         scale  <0.2, 0.2, 1.0>
         rotate    <-89.0, -5.0, 0.0>
      }
   }

#declare Spun_Brass =
   texture  // Spun_Brass
   {
      pigment
      {
         color rgb <0.7, 0.56, 0.37>
      }
      normal
      {
         waves , 0.35
         scale  0.01
      }
      finish
      {
         ambient 0.35
         diffuse 1.0
         brilliance 15.0
         phong 0.41
         phong_size 5.0
      }
   }

#declare Candleholder = lathe {
  quadratic_spline
  5  // control points
  <-0.923077, 0.039886>,
  <0.048433, 0.012821>,
  <1.80057, 0.001425>,
  <0.767717, 0.56664>,
  <0.401709, 2.054131>
  rotate <90,0,90>
  texture {
    Spun_Brass
  }
  scale <0.3, 0.3, 0.5>
  translate  10.3*z
}
#declare Flame = lathe {
  quadratic_spline
  4  // control points
  <-0.438746, 0.766382>,
  <0.076923, 0.012821>,
  <0.803419, 0.47151>,
  <0.031339, 1.911681>
  rotate <90,0,90>
  texture {
    Flametex2
  }
  no_shadow
  scale <0.075, 0.075, 0.25>
  translate  12.7*z
}

#declare Candletable =
union {
	box { // Crosspiece1
    	<-1, -1, -1>, <1, 1, 1>
	    texture { Mildwood }
    scale <6.0, 0.4, 0.1>
    rotate 45.0*z
  }
  box { // Crosspiece2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Mildwood
    }
    scale <6.0, 0.4, 0.1>
    rotate -45.0*z
  }
  cylinder { // Tableleg
    <0,0,1>, <0,0,0>, 1
    texture {
      Mildwood
    }
    scale <0.475, 0.475, 10.0>
  }
  superellipsoid { // Tabletop
    <1.0, 0.1>
    texture {
      Mildwood
    }
    scale <5.0, 5.0, 0.3>
    translate  10.0*z
  }
  object { Candleholder }
  cylinder { // Candle
    <0,0,1>, <0,0,0>, 1
    texture {
      WhiteCandle
    }
    scale <0.1, 0.1, 1.5>
    translate  11.2*z
  }
  object { Flame }
  light_source {   // Light001
  <0.004, 0.000, 12.897>
  color rgb <0.400, 0.400, 0.400>
}

/*RHC -> LHC conversion*/ rotate -90*x  scale <1,1,-1>
translate <0,-30.5,0>
}




