// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  El record de velocidad.
//--
// This file contains:
//  The speed record.

// ** IMPORTANT ** Wrong use can cause errors, I decline ALL responsability.
// INCLUDE FLAGS
//  ## No flags used ##
// For multiple "include"s of this file use multiple flags, think about this
//  condition as arguments required by functions.


global_settings {
    assumed_gamma 2.4
    max_trace_level 16
}

#include "colors.inc"
#include "metals.inc"
background { Blue }

camera {
    right 16/9*x
    up y
    location <0, 1.8, -80>
    look_at <0, 0, 0>
    angle 45
}

light_source {
    <10, 1000, -1000> rgb <1, 1, .9>
}


// Speed limit signal
#declare HalfSignal1 =
    union {
        box { <-.4*450/500, 0, 0>, <.4*450/500, -.8, .03> }
        union {
            cylinder { <-.3-.025, .05, -.025>, <-.3-.025, -1, -.025>, .025 }
            cylinder { <.3+.025, .05, -.025>, <.3+.025, -1, -.025>, .025 }
            texture {
                T_Chrome_3A
                normal {
                    bumps .2
                    scale <1, 20, 1>*.01
                }
            }
        }
        union {
            cylinder {
                <-.3-.025-.01-.025, 0, -.025>,
                <-.3-.025+.025+.01+.05, 0, -.025>, .02
            }
            cylinder {
                <-.3-.025-.01-.025, 0, -.025>,
                <-.3-.025+.025+.01+.05, 0, -.025>, .02
                scale <-1, 1, 1>
            }
            texture {
                T_Chrome_3D
            }
        }
        texture {
            pigment { White }
            finish {
                specular .1
                roughness .001
                ambient .1
                diffuse .8
            }
            normal {
                bumps .05
                scale .01
            }
        }
        translate .025 * z
        rotate -15 * x
    }

#declare HalfSignal2 =
    union {
        box {
            <-.4*450/500, 0, 0>, <.4*450/500, -.8, -.03>
            texture {
                pigment {
                    image_map {
                        tga "limit.tga"
                        interpolate 2
                        once
                    }
                    scale <.8*450/500, .8, 1>
                    translate <-.4*450/500, -.8, 0>
                }
                finish {
                    specular .1
                    roughness .001
                    ambient .1
                    diffuse .8
                }
                normal {
                    bumps .05
                    scale .01
                }
            }
        }
        union {
            cylinder { <-.3+.025, .05, .025>, <-.3+.025, -1, .025>, .025 }
            cylinder { <.3-.025, .05, .025>, <.3-.025, -1, .025>, .025 }
            texture {
                T_Chrome_3A
                normal {
                    bumps .2
                    scale <1, 20, 1>*.01
                }
            }
        }
        texture {
            pigment { White }
            finish {
                specular .1
                roughness .001
                ambient .1
                diffuse .8
            }
            normal {
                bumps .05
                scale .01
            }
        }
        translate -.025 * z
        rotate 15 * x
    }

#declare Signal =
    union {
        object { HalfSignal1 }
        object { HalfSignal2 }
        torus {
            .7, .01
            texture {
                pigment { Gray50 }
                normal {
                    radial .2
                    frequency 64
                    ramp_wave
                }
            }
            rotate 90 * z
            translate .3 * x
            clipped_by {
                intersection {
                    plane { -z, .025 rotate 15 * x }
                    plane { z, .025 rotate -15 * x }
                    plane { y, 0 }
                }
            }
        }
        translate cos (radians (15)) * 1 * y
    }

object {
    Signal
    scale 2
    rotate 45 * y
    translate <2, 0, -71>
}


#declare CarTrans =
    transform {
        rotate 50 * y
        translate <-15, 0, -7.5>
        translate <7.5, 0, -22.5>
    }


// From a Dominique's file (modified) <d.jacquel@ed.ac.uk>
#declare T_Alu =
    texture {
        pigment { rgb <.714, .714, .776> }
        normal {
            bumps .1
            turbulence 1
            scale <30, 1, 30>
        }
        finish {
            reflection .05
            ambient .2
            brilliance 6
            specular .6
            roughness .1
        }
        scale .01
    }

#include "car.inc"
#declare Car =
    union {
        object { CarLayer1 }
        object { CarLayer2 }
        object { CarLayer3 }
        object { CarLayer4 }
        object {
            CarLayer1
            clipped_by {
                plane { z, -9 }
            }
            texture { T_Alu }
            translate -.01 * z
            no_shadow
        }
        object {
            CarLayer2
            clipped_by {
                plane { z, -4.75 }
            }
            texture { T_Alu }
            translate -.01 * z
            no_shadow
        }
        object {
            CarLayer2
            clipped_by { box { <3, 0, -4.75>, <5, 3.5, 5.25> } }
            texture {
                pigment {
                    image_map {
                        gif "logos.gif"
                        transmit 6, 1
                        once
                        interpolate 2
                    }
                    rotate -90 * y
                    scale <1, 3.5, 10>
                    translate <0, 0, -4.75>
                }
            }
            translate .01 * x
            no_shadow
        }
        object {
            CarLayer1
            clipped_by { box { <-2, 0, -9>, <2, 3.5, -5> } }
            texture {
                pigment {
                    image_map {
                        gif "logonose.gif"
                        transmit 8, 1
                        interpolate 2
                        once
                    }
                    rotate -90 * y
                    scale <1, 3.5, 4>
                    translate <0, -.4, -9>
                }
            }
            translate .01 * x
            no_shadow
        }
        union { // Jet blast
            cylinder {
                <2.75, 1.75, 7>, <2.75, 1.75, 17>, 1.25
                open hollow
            }
            sphere {
                0, 1.25
                scale <1, 1, 4>
                translate <2.75, 1.75, 17>
                hollow
                clipped_by { plane { -z, -17 } }
            }
            texture {
                pigment { Clear }
                normal {
                    bumps .5
                    scale .4
                }
                finish {
                    refraction on
                    ior 1.05
                }
            }
        }
        texture {
            pigment { Gray10 }
            finish {
                reflection .1
                brilliance 2
                specular 1
                roughness .05
            }
            normal {
                waves .0125
                frequency 2
                scale .005
                turbulence .1
            }
        }
    }

object {
    Car
    transform CarTrans
}


// Mountains
#declare M_Mountain =
    texture_map {
        [ 0 pigment { BakersChoc } ]
        [ .35 pigment { VeryDarkBrown } ]
        [ .6 pigment { DarkBrown } ]
        [ 1 pigment { BakersChoc } ]
    }

#declare T_Mountain =
    texture {
        granite
//        gradient y
//        frequency 10
        turbulence .1
        scale 10
        texture_map { M_Mountain }
    }
#include "mountain.inc"


// Ground
plane {
    y, -.1
    texture {
        T_Mountain
    }
}

disc {
    0, y, 80
    texture {
        onion
        frequency 1/80
        turbulence .01
        texture_map {
            [ 0
                pigment {
                    granite
                    pigment_map {
                        [ .3 Wheat ]
                        [ .6 NewTan ]
                        [ .8 MediumGoldenrod ]
                    }
                    turbulence .1
                    scale .5
                }
                normal {
                    bump_map {
                        gif "cracks.gif"
                        bump_size 2
                    }
                    rotate 90 * x
                    scale 10
/*                    crackle 1
                    slope_map {
                        [ .025 <0, -3> ]
                        [ .03 <0, -1> ]
                        [ .035 <.5, 3> ]
                        [ .04 <1, 0> ]
                        [ .045 <.9, -1> ]
                        [ .01 <.9, 0> ]
                    }
                    turbulence .1
                    scale 1*/
                }
                finish {
                    specular .5
                    ambient .3
                    diffuse .7
                }
            ]
            [ .95 pigment { Clear } ]
        }
    }
    translate <0, 0, -70>
}


// Skies
#include "skies.inc"
plane {
    y, 1000
    texture { T_Cloud3 scale 1000 }
    translate -40*z
    hollow
}

sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.00    rgb <0.847, 0.749, 0.847> ] // horizon
            [0.10*.5 SkyBlue ]                   // horizon
            [0.20*.5 P_Cloud4 scale .25 ]
        }
    }
}

fog {
    fog_type 2
    distance 2000
    fog_offset -.5
    fog_alt 60
    color SkyBlue transmit .5
    turbulence 1
    turb_depth .5
}


// Logo
height_field {
    gif "by-gsr.gif"
    water_level .001
    texture {
        pigment {
            bozo // gradient z+x
            color_map {
                [ 0 color rgb <.25, 1, 1> ]
                [ 1 color rgb <.1, .1, 1> ]
            }
            sine_wave
            scale .25
        }
        finish {
            ambient .2
            diffuse .4
        }
    }
    texture {
        pigment {
            crackle
            color_map {
                [ .05 Black ]
                [ .05 Clear ]
            }
            scale .2
            translate <.5, 0, .5> // To fix big black spots
        }
        finish {
            ambient .1
            diffuse .5
        }
    }
    translate <-.5, 0, -.5>
    rotate -90 * x
    scale <1, .5, 1> * .8
    translate <-2, .4, -74>
}


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
