// Persistence of Vision Ray Tracer Include File
// File: tracry.inc
// Vers: 3
// Date: 02/28/98
// Auth: Bob Franke
//

#version 3

#include "colors.inc"
#include "textures.inc"


#declare graniteMult=0.9
#declare granite1 =
texture {
  pigment{
    granite
    turbulence 0.6
    color_map
     {[0.000, 0.154   color rgb <0.800, 0.651, 0.557>*graniteMult
                      color rgb <0.996, 0.835, 0.737>*graniteMult]
      [0.154, 0.308   color rgb <0.996, 0.835, 0.737>*graniteMult
                      color rgb <0.800, 0.651, 0.557>*graniteMult]
      [0.308, 0.444   color rgb <0.800, 0.651, 0.557>*graniteMult
                      color rgb <0.694, 0.624, 0.604>*graniteMult]
      [0.444, 0.615   color rgb <0.694, 0.624, 0.604>*graniteMult
                      color rgb <0.800, 0.651, 0.557>*graniteMult]
      [0.615, 0.812   color rgb <0.800, 0.651, 0.557>*graniteMult
                      color rgb <0.725, 0.655, 0.651>*graniteMult]
      [0.812, 1.001   color rgb <0.725, 0.655, 0.651>*graniteMult
                      color rgb <0.800, 0.651, 0.557>*graniteMult]
     }
  }
 finish { crand 0.2 }
}

#declare cly_1=
object{
  difference{
    cylinder{<-6.769,77,-3>,<-6.769,77,-1>,6.769}
    cylinder{<-6.769,77,-10>,<-6.769,77,10>,5.769}
  }
  clipped_by{plane{y,77 inverse}}
  texture{granite1 scale .1}
}

#declare cly_2=
object{
  difference{
    cylinder{<-9.9035,76,-3>,<-9.9035,76,-1>,3.6345}
    cylinder{<-9.9035,76,-10>,<-9.9035,76,10>,2.6345}
  }
  clipped_by{plane{y,76 inverse}}
  texture{granite1 scale .1}
}

#declare cly_3=
object{
  difference{
    cylinder{<-6.769,80.75,-3>,<-6.769,80.75,-1>,2.05}
    cylinder{<-6.769,80.75,-10>,<-6.769,80.75,10>,0.4}
    cylinder{<-6.769,81.75,-10>,<-6.769,81.75,10>,1}
    cylinder{<-6.769-.7,80.10,-10>,<-6.769-.7,80.10,10>,.9}
    cylinder{<-6.769+.7,80.10,-10>,<-6.769+.7,80.10,10>,.9}
  }
  texture{granite1 scale .1}
}


#declare smallTracery=
union{
  box{<-13.538,65.5-7,-3>,<-12.538,77,-1> texture{granite1 scale .1}}
  box{<-1.0,65.5-7,-3>,<0,77,-1> texture{granite1 scale .1}}
  box{<-7.269,65.5-7,-3>,<-6.269,77,-1> texture{granite1 scale .1}}
  cly_1
  cly_2
  object{cly_2 translate<(3.6345*2-1),0,0>}
  cly_3
}
