// Persistence of Vision Ray Tracer Scene Description File
// File: outsect.inc
// Vers: 3
// Desc: Basic Scene Example
// Date: 02-28-98
// Auth: Bob Franke
//



#include "colors.inc"
#include "stones.inc"
#include "tracry.inc"
/*
global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera
{
  location  <0.01, 32, -75>
  direction 1*z
  right     4/3*x
  look_at   <0.0, 32,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-40,150, -100>
}
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <40,150, -100>
}


plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}


// ----------------------------------------
*/



#declare mainColumn=
merge{
  cylinder{<-1,0,1>,<-1,65,1>, 1}
  cylinder{<-1,0,-1>,<-1,65,-1>, 1}

  cylinder{<1,0,1>, <1,65,1>, 1}
  cylinder{<1,0,-1>, <1,65,-1>, 1}

  cylinder{<0,0,-1.5>,<0,65,-1.5>, 1}
  cylinder{<0,0,1.5>,<0,65,1.5>, 1}

  box{<-2,0,2>,<0,65,-2>}
  box{<2,0,2>,<0,65,-2>}
  texture{T_Grnt11 scale .1 finish { crand 0.2 }}
}


#declare topWall =
union{
  merge{
    difference{
      box{<-13.538,36+83-77,3>,<0,142-77,-3>}
      cylinder{<11.836,36+80-77,4>,<11.836,36+80-77,-4>,25}
    }

    difference{
      box{<0,36+83-77,3>,<13.538,142-77,-3> }
      cylinder{<-11.836,36+80-77,4>,<-11.836,36+80-77,-4>,25}
    }

    texture{T_Grnt11 scale .1 finish { crand 0.2 }}
  }
 //==============
  object{
    difference{
      cylinder{<11.836,36+80-77,4>,<11.836,36+80-77,-4>,26.5}
      cylinder{<11.836,36+80-77,10>,<11.836,36+80-77,-10>,25}
    }
    clipped_by{plane{y,36+80-77 inverse }}
    clipped_by{plane{x,0 }}
    clipped_by{plane{x,-13.538 inverse }}
    texture{T_Grnt11 scale .1 finish { crand 0.2 }}
  }

  object{
    difference{
      cylinder{<-11.836,36+80-77,4>,<-11.836,36+80-77,-4>,26.5}
      cylinder{<-11.836,36+80-77,10>,<-11.836,36+80-77,-10>,25}
    }
    clipped_by{plane{y,36+80-77 inverse }}
    clipped_by{plane{x,0 inverse }}
    clipped_by{plane{x,13.538 }}
    texture{T_Grnt11 scale .1 finish { crand 0.2 }}
  }
//=====================

  object{
    difference{
      cylinder{<11.836,36+80-77,3>,<11.836,36+80-77,-3>,25}
      cylinder{<11.836,36+80-77,10>,<11.836,36+80-77,-10>,24}
    }
    clipped_by{plane{y,36+80-77 inverse }}
    clipped_by{plane{x,0 }}
    texture{T_Grnt11 scale .1 finish { crand 0.2 }}
  }

  object{
    difference{
      cylinder{<-11.836,36+80-77,3>,<-11.836,36+80-77,-3>,25}
      cylinder{<-11.836,36+80-77,10>,<-11.836,36+80-77,-10>,24}
    }
    clipped_by{plane{y,36+80-77 inverse }}
    clipped_by{plane{x,0 inverse }}
    texture{T_Grnt11 scale .1 finish { crand 0.2 }}
  }
//=====================
  object{
    difference{
      cylinder{<11.836,36+80-77,2>,<11.836,36+80-77,-2>,24}
      cylinder{<11.836,36+80-77,10>,<11.836,36+80-77,-10>,23}
    }
    clipped_by{plane{y,36+80-77 inverse }}
    clipped_by{plane{x,0 }}
    texture{T_Grnt11 scale .1 finish { crand 0.2 }}
  }

  object{
    difference{
      cylinder{<-11.836,36+80-77,2>,<-11.836,36+80-77,-2>,24}
      cylinder{<-11.836,36+80-77,10>,<-11.836,36+80-77,-10>,23}
    }
    clipped_by{plane{y,36+80-77 inverse }}
    clipped_by{plane{x,0 inverse }}
    texture{T_Grnt11 scale .1 finish { crand 0.2 }}
  }
//=====================


box{<-13.538,0,3>,<13.538,16.5,-3> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}
box{<-13.538,117-77,-2>,<-12.538,112-77,0> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}
box{<13.538,117-77,-2>,<12.538,112-77,0> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}
box{<-12.538,117-77,-2>,<-11.538,115-77,0> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}
box{<12.538,117-77,-2>,<11.538,115-77,0> texture{T_Grnt11 scale .1 finish { crand 0.2 }}}


object{ smallTracery translate<0,34.5-77,1>}
object{ smallTracery translate<13.538,34.5-77,1>}


#declare cly_10=
difference{
  cylinder{<0,00,-2>,<0,00,2>,8.2}
  cylinder{<0,00,-10>,<0,00,10>,7.7}
  texture{T_Grnt11 scale .1 finish { crand 0.2 }}
}
#declare cly_11=
difference{
  cylinder{<0,00,-2>,<0,00,2>,8.2}
  cylinder{<0,00,-10>,<0,00,10>,7.7}
  texture{T_Grnt11 scale .1 finish { crand 0.2 }}
}

#declare smallRose=
object{
  difference{
    object{
      union{
        object{cly_10}
        #declare zz=0
        #while (zz < 360)
          object{ cly_11 translate<-8.2,0,0> rotate<0,0,zz>}
          #declare zz=zz+30
        #end
       cylinder{<0,0,-2>,<0,00,2>,3 texture{T_Grnt11 scale .1 finish { crand 0.2 }}}

      }
      clipped_by{cylinder{<0,0,-10>,<0,00,10>,8.2 }}
    }
    cylinder{<0,0,-10>,<0,00,10>,2.25}
  }
}
object{smallRose translate<0,124.9-77,0>}

}

//===========================================

#declare outsideWallSection=
union{
  object{ mainColumn scale<2,1,2> translate <17.538,0,0>}
  topWall
}

//outsideWallSection
