
// Persistence of Vision Ray Tracer Scene Description File
// File: backwall.inc
// Vers: 3
// Date: 02/28/98
// Auth: Bob Franke
//


#include "colors.inc"
#include "stones.inc"
#include "in_sect.inc"

/*
global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera //current
{
  location  <-15,15,-13>
  direction 2*z
  right     3/4*x
  look_at   <0,60,200>
}



sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-40,100, -100>
}
// ----------------------------------------

//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

plane
{
  y, - 1.5/12
  texture{
    pigment { color rgb <1, 1, 0.9>}
    finish {reflection 0.2}
  }
}


*/






#declare backWall_1=
union{
  difference{
    box{<-75,0,267+35>,<75,160,271+35> texture{T_Grnt11 scale .1 finish { crand 0.1 }}}
    cylinder{<0,125,225>,<0,125,350>,25}
  }
  difference{
    cylinder{<0,125,265+35>,<0,125,271+35>,26.5}
    cylinder{<0,125,-220>,<0,125,350>,25}
    texture{T_Grnt11 scale .1 finish { crand 0.1 }}
  }
}

//===============================================
#declare halfCurl2=
union{
  object{
    difference{
      cylinder{<0,00,0.125>,<0,00,-0.33>,2}
      cylinder{<0,00,-1>,<0,00,1>,1.25}
    }
    clipped_by{plane{x,0}}
  }

  object{
    difference{
      cylinder{<0,-.5,0.125>,<0,-.5,-0.33>,1.5}
      cylinder{<0,-.5,-1>,<0,-.5,1>,0.75}
    }
    clipped_by{plane{x,0 inverse}}
  }
  box{<0,1.25,-0.33>,<2,2,0.125>}
  texture{
    T_Gold_5A
    finish { crand 0.1 }
  }
}

#declare oneCurl2=
union{
  object{halfCurl translate<-2,0,0>}
  object{halfCurl rotate<180,180,0> translate<2,0,0>}
  scale<.5,.5,1>
}


//===============================================
#declare cap_2 =
merge{
  box{<-38,63,225>,<38,65.5,221.5> texture{T_Grnt11 scale .1 finish { crand 0.1 } }}
  #declare xx= -38
  #while (xx < 38)
    object{oneCurl2 translate<xx,64.15,221.375>}
    #declare xx=xx+4.37
  #end
}
//===============================================

#declare cap_22 =
merge{
  box{<-38,63,223.5>,<38,65.5,230> texture{T_Grnt11 scale .1 finish { crand 0.1 } }}
  #declare xx= -38
  #while (xx < 38)
    object{oneCurl2 translate<xx,64.15,223.375>}
    #declare xx=xx+4.37
  #end
}

//===============================================


#declare graniteMult=0.9
#declare granite1 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgb <0.800, 0.651, 0.557>*graniteMult
                    color rgb <0.996, 0.835, 0.737>*graniteMult]
    [0.154, 0.308   color rgb <0.996, 0.835, 0.737>*graniteMult
                    color rgb <0.800, 0.651, 0.557>*graniteMult]
    [0.308, 0.444   color rgb <0.800, 0.651, 0.557>*graniteMult
                    color rgb <0.694, 0.624, 0.604>*graniteMult]
    [0.444, 0.615   color rgb <0.694, 0.624, 0.604>*graniteMult
                    color rgb <0.800, 0.651, 0.557>*graniteMult]
    [0.615, 0.812   color rgb <0.800, 0.651, 0.557>*graniteMult
                    color rgb <0.725, 0.655, 0.651>*graniteMult]
    [0.812, 1.001   color rgb <0.725, 0.655, 0.651>*graniteMult
                    color rgb <0.800, 0.651, 0.557>*graniteMult]
   }
 }
 }

#declare graniteMult2=0.8
#declare granite2 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgb <0.800, 0.651, 0.557>*graniteMult2
                    color rgb <0.996, 0.835, 0.737>*graniteMult2]
    [0.154, 0.308   color rgb <0.996, 0.835, 0.737>*graniteMult2
                    color rgb <0.800, 0.651, 0.557>*graniteMult2]
    [0.308, 0.444   color rgb <0.800, 0.651, 0.557>*graniteMult2
                    color rgb <0.694, 0.624, 0.604>*graniteMult2]
    [0.444, 0.615   color rgb <0.694, 0.624, 0.604>*graniteMult2
                    color rgb <0.800, 0.651, 0.557>*graniteMult2]
    [0.615, 0.812   color rgb <0.800, 0.651, 0.557>*graniteMult2
                    color rgb <0.725, 0.655, 0.651>*graniteMult2]
    [0.812, 1.001   color rgb <0.725, 0.655, 0.651>*graniteMult2
                    color rgb <0.800, 0.651, 0.557>*graniteMult2]
   }
 }
 }

//===================================================

#declare cly_1=
object{
  difference{
    cylinder{<-6.769,77,-3>,<-6.769,77,-1>,6.769}
    cylinder{<-6.769,77,-10>,<-6.769,77,10>,5.769}
  }
  clipped_by{plane{y,77 inverse}}
  texture{granite1 }
}

#declare cly_2=
object{
  difference{
    cylinder{<-9.9035,76,-3>,<-9.9035,76,-1>,3.6345}
    cylinder{<-9.9035,76,-10>,<-9.9035,76,10>,2.6345}
  }
  clipped_by{plane{y,76 inverse}}
  texture{granite1 }
}

#declare cly_3=
object{
  difference{
    cylinder{<-6.769,80.75,-3>,<-6.769,80.75,-1>,2.05}
    cylinder{<-6.769,80.75,-10>,<-6.769,80.75,10>,0.4}
    cylinder{<-6.769,81.75,-10>,<-6.769,81.75,10>,1}
    cylinder{<-6.769-.7,80.10,-10>,<-6.769-.7,80.10,10>,.9}
    cylinder{<-6.769+.7,80.10,-10>,<-6.769+.7,80.10,10>,.9}
  }
  texture{granite1 }
}



#declare backTracery=
union{
  box{<-13.538,65.5-7,-3>,<-12.538,77,-1> texture{granite1 }}
  box{<-1.0,65.5-7,-3>,<0,77,-1> texture{granite1 }}
  box{<-7.269,65.5-7,-3>,<-6.269,77,-1> texture{granite1 }}
  cly_1
  cly_2
  object{cly_2 translate<(3.6345*2-1),0,0>}
  cly_3
}












//==================<<< start mainwindow >>>======================
#declare cly_1=
difference{
  cylinder{<0,00,-2>,<0,00,2>,25}
  cylinder{<0,00,-10>,<0,00,10>,24}
  texture{T_Grnt11 scale .1 finish { crand 0.1 } }
}
#declare cly_2=
difference{
  cylinder{<0,00,-2>,<0,00,2>,25}
  cylinder{<0,00,-10>,<0,00,10>,24.5}
  texture{T_Grnt11 scale .1 finish { crand 0.1 }}
}

#declare cly_21=
difference{
  cylinder{<0,00,-2>,<0,00,2>,18.5}
  cylinder{<0,00,-10>,<0,00,10>,17.5}
 texture{T_Grnt11 scale .1 finish { crand 0.1 }}
}
#declare cly_22=
difference{
  cylinder{<0,00,-2>,<0,00,2>,18.5}
  cylinder{<0,00,-10>,<0,00,10>,18}
  texture{T_Grnt11 scale .1 finish { crand 0.1 }}
}

#declare cly_31=
difference{
  cylinder{<0,00,-2>,<0,00,2>,9.5}
  cylinder{<0,00,-10>,<0,00,10>,8.5}
  texture{T_Grnt11 scale .1 finish { crand 0.1 }}
}
#declare cly_32=
difference{
  cylinder{<0,00,-2>,<0,00,2>,9.5}
  cylinder{<0,00,-10>,<0,00,10>,9}
  texture{T_Grnt11 scale .1 finish { crand 0.1 }}
}


#declare whiteGlass=
difference{
  cylinder{<0,00,-.125/12>,<0,00,.125/12>,25}
  cylinder{<0,00,-1>,<0,00,2>,25 translate<-25,0,0> rotate<0,0,15*13>}
  cylinder{<0,00,-1>,<0,00,2>,25 translate<-25,0,0> rotate<0,0,15*22>}
  clipped_by{cylinder{<0,0,-3>,<0,00,2>,18.5 inverse}}
  clipped_by{plane{y,0 inverse}}
  pigment{color rgbf <1*1.55, 1*1.55, 1*1.55, 0.99>}

}

#declare blueGlass=
object{
  cylinder{<0,00,-.1/12>,<0,00,.1/12>,25 translate<-25,0,0> rotate<0,0,15*22>}
  clipped_by{cylinder{<0,00,-1>,<0,00,2>,25 translate<-25,0,0> rotate<0,0,15*14>}}
  clipped_by{cylinder{<0,0,-3>,<0,00,2>,18.5 inverse}}
  clipped_by{plane{y,0 inverse}}
  pigment{color rgbf <0, 0, 1*1.55, 0.99>}
}


#declare whiteGlass2=
object{
  cylinder{<0,00,-.1/12>,<0,00,.1/12>,18.5 translate<-18.5,0,0> rotate<0,0,15*22>}
    clipped_by{cylinder{<0,00,-1>,<0,00,2>,18.5 translate<-18.5,0,0> rotate<0,0,15*14>}}
  clipped_by{cylinder{<0,0,-3>,<0,00,2>,9.5 inverse}}
  clipped_by{plane{y,0 inverse}}
  pigment{color rgbf <1*1.55, 1*1.55, 1*1.55, 0.99>}
}

#declare whiteGlass3=
object{
  cylinder{<0,00,-.1/12>,<0,00,.1/12>,9.5 translate<-9.5,0,0> rotate<0,0,15*23>}
  clipped_by{cylinder{<0,00,-1>,<0,00,2>,9.5 translate<-9.5,0,0> rotate<0,0,15*15>}}
  pigment{color rgbf <1*1.55, 1*1.55, 1*1.55, 0.99>}
}

#declare redGlass1=
difference{
  cylinder{<0,00,-.125/12>,<0,00,.125/12>,18.5}
  cylinder{<0,00,-1>,<0,00,2>,18.5 translate<-18.5,0,0> rotate<0,0,30*6>}
  cylinder{<0,00,-1>,<0,00,2>,18.5 translate<-18.5,0,0> rotate<0,0,30*11>}
  clipped_by{cylinder{<0,0,-3>,<0,00,2>,9.5 inverse}}
  clipped_by{plane{y,0 inverse}}
  pigment{color rgbf <1*1.55, 0, 0, 0.99>}
}

#declare blueGlass2=
difference{
  cylinder{<0,00,-.125/12>,<0,00,.125/12>,18.5}
  cylinder{<0,00,-1>,<0,00,2>,18.5 translate<-18.5,0,0> rotate<0,0,30*7>}
  cylinder{<0,00,-1>,<0,00,2>,18.5 translate<-18.5,0,0> rotate<0,0,30*12>}
  clipped_by{cylinder{<0,0,-3>,<0,00,2>,9.5 inverse}}
  clipped_by{plane{y,0 inverse}}
  pigment{color rgbf <0, 0, 1*1.55, 0.99>}
}

#declare blueGlass3=
difference{
  cylinder{<0,00,-.125/12>,<0,00,.125/12>,9.5}
  cylinder{<0,00,-1>,<0,00,2>,9.5 translate<-9.5,0,0> rotate<0,0,60*4>}
  cylinder{<0,00,-1>,<0,00,2>,9.5 translate<-9.5,0,0> rotate<0,0,60*7>}
  clipped_by{plane{y,0 inverse}}
  pigment{color rgbf <0, 0, 1*1.55, 0.99>}
}

#declare redGlass2=
difference{
  cylinder{<0,00,-.125/12>,<0,00,.125/12>,9.5}
  cylinder{<0,00,-1>,<0,00,2>,9.5 translate<-9.5,0,0> rotate<0,0,60*3>}
  cylinder{<0,00,-1>,<0,00,2>,9.5 translate<-9.5,0,0> rotate<0,0,60*6>}
  clipped_by{plane{y,0 inverse}}
  pigment{color rgbf <1*1.55, 0, 0, 0.99>}
}



#declare mainWindow=
union{
object{
  union{
    object{cly_1}
    #declare zz=0
    #while (zz < 360)
      object{whiteGlass rotate<0,0,zz>}
      object{blueGlass rotate<0,0,zz>}
      object{ cly_2 translate<-25,0,0> rotate<0,0,zz>}
      #declare zz=zz+15
    #end
  }
  clipped_by{cylinder{<0,0,-3>,<0,00,2>,25}}
  clipped_by{cylinder{<0,0,-3>,<0,00,2>,18.5 inverse}}
}

object{
  union{
    object{cly_21}
    #declare zz=0
    #while (zz < 360)
      object{ cly_22 translate<-18.5,0,0> rotate<0,0,zz>}
      #declare zz=zz+30
    #end
  }
  clipped_by{cylinder{<0,0,-3>,<0,00,2>,18.5}}
  clipped_by{cylinder{<0,0,-3>,<0,00,2>,9.5 inverse}}
}

object{
  union{
    object{cly_31}
    #declare zz=0
    #while (zz < 360)
      object{ cly_32 translate<-9.5,0,0> rotate<0,0,zz>}
      object{redGlass1 rotate<0,0,zz>}
      #declare zz=zz+60
    #end
  }
  clipped_by{cylinder{<0,0,-3>,<0,00,2>,9.5}}
}

#declare zz=0
#while (zz < 360)
  object{redGlass1 rotate<0,0,zz>}
  object{blueGlass2 rotate<0,0,zz>}
  object{whiteGlass3 translate<-1,0,0> rotate<0,0,zz>}
  #declare zz=zz+60
#end



#declare zz=0
#while (zz < 360)
  object{whiteGlass2 rotate<0,0,zz>}
  #declare zz=zz+30
#end

#declare zz=0
#while (zz < 360)
  object{redGlass2 rotate<0,0,zz>}
  object{blueGlass3 rotate<0,0,zz>}
  object{whiteGlass3 rotate<0,0,zz>}
  #declare zz=zz+120
#end
cylinder{<0,00,-2>,<0,00,2>,1.25   texture{T_Grnt11 scale .1 finish { crand 0.1 }}}
}
//==================<<< end mainwindow >>>======================


#declare rearArch=
union{

  difference{
    box{<-30,63,-3>,<0,0,3>}
    cylinder{<50,0,-10>,<50,0,10> 75}
    torus{76.5,.75 rotate<90,0,0> translate<50,0,-3>}
    torus{78,.75 rotate<90,0,0> translate<50,0,-3>}
    torus{79.5,.75 rotate<90,0,0> translate<50,0,-3>}
  }
  difference{
    box{<30,63,-3>,<0,0,3>}
    cylinder{<-50,0,-10>,<-50,0,10> 75}
    torus{76.5,.75 rotate<90,0,0> translate<-50,0,-3>}
    torus{78,.75 rotate<90,0,0> translate<-50,0,-3>}
    torus{79.5,.75 rotate<90,0,0> translate<-50,0,-3>}
  }

  box{<30,63,-3>,<-30,65.5,3> texture{T_Grnt11 scale .1 finish { crand 0.1 }}}

  difference{
    box{<30,65.5,-3>,<0,130,3>}
    cylinder{<-50,130,-10>,<-50,130,10> 75}
    torus{76.5,.75 rotate<90,0,0> translate<-50,130,-3>}
    torus{78,.75 rotate<90,0,0> translate<-50,130,-3>}
    torus{79.5,.75 rotate<90,0,0> translate<-50,130,-3>}
  }

  difference{
    box{<-30,65.5,-3>,<0,130,3>}
    cylinder{<50,130,-10>,<50,130,10> 75}
    torus{76.5,.75 rotate<90,0,0> translate<50,130,-3>}
    torus{78,.75 rotate<90,0,0> translate<50,130,-3>}
    torus{79.5,.75 rotate<90,0,0> translate<50,130,-3>}
  }


  difference{
    cylinder{<0,130,-2.9>,<0,130,3> 30}
    cylinder{<0,130,-10>,<0,130,10> 25}
    torus{28.75,.65 rotate<90,0,0> translate<0,130,-2.9>}
    torus{27, 0.65 rotate<90,0,0> translate<0,130,-2.9>}
    torus{26.25, 0.65 rotate<90,0,0> translate<0,130,-2.9>}
    clipped_by{plane{y,130 inverse}}
    texture{T_Grnt11 scale .1 finish { crand 0.1 }}
 }
    texture{T_Grnt11 scale .1 finish { crand 0.1 }}

}


#declare onePlank=
difference{
  box{<0,0,0>,<2.0,25,8>}
  box{<-1,-1,-1>,<1,25,1>
   rotate<0,45,0>
   translate<-.65,0,-.65>
  }

  box{<-1,-1,-1>,<1,25,1>
   rotate<0,-45,0>
   translate<2.65,0,-.65>
  }
}

#declare oneDoor=
union{
  object{onePlank pigment{DMFLightOak rotate<89,0,0> }}
  object{onePlank translate<2,0,0> pigment{DMFLightOak rotate<-89,0,0>}}
  object{onePlank translate<4,0,0> pigment{DMFLightOak rotate<-89,3,1>} }
  object{onePlank translate<6,0,0> pigment{DMFLightOak rotate<89,-3,1>}}
  object{onePlank translate<8,0,0> pigment{DMFLightOak rotate<89,3,-1>}}
  object{onePlank translate<10,0,0> pigment{DMFLightOak rotate<89,-3,-1>}}
}

object{oneDoor translate<1,0,301> }
object{oneDoor translate<-13,0,301> }

box{<13,0,300>,<17,25,302> texture{granite2 }}
box{<-17,0,300>,<-13,25,302> texture{granite2 }}
box{<-17,25,300>,<17,29,302> texture{granite2 }}



#declare TheBackWall=
union{
  object{backWall_1}
  object{cap_2  }
  object{rearArch translate<0,0,35.076*6+17.538>}
  object{ mainWindow translate<0,125,269+35>}
  object{oneDoor translate<1,0,302> }
  object{oneDoor translate<-13,0,302> }

  box{<13,0,300>,<17,25,302> texture{granite2 }}
  box{<-17,0,300>,<-13,25,302> texture{granite2 }}
  box{<-17,25,300>,<17,29,302> texture{granite2 }}
}

//TheBackWall




