#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define UL_CORNER()  (i>0)?(sin(pages[i-1]*M_PI/180.0)*2.83609026816):(sin(pages[i]*M_PI/180.0)*2.83609026816)
#define UR_CORNER()  sin(pages[i+1]*M_PI/180.0)*2.83609026816
#define LL_CORNER()  sin(pages[i]*M_PI/180.0)*12.13609026816
#define LR_CORNER()  sin(pages[i+1]*M_PI/180.0)*12.13609026816
#define LL_CORNERy() cos(pages[i]*M_PI/180.0)*12.13609026816 - 3.06505309687
#define LR_CORNERy() cos(pages[i+1]*M_PI/180.0)*12.13609026816 - 3.06505309687

int main (void) {
  float pages[1000], end, sep;
  int   i, nump;

  end = -20;
  nump = 0;
  srandom (time(NULL));
  while (end < 20) {
    sep = random()*1.0/RAND_MAX;
    sep *= 0.5*(20 - fabs(end))*sep;
    if (sep < 0.01) sep = 0.01;
    pages[nump++] = end;
    end += sep;
    if (end < 20) {
      sep = random()*1.0/RAND_MAX;
      sep *= 10*sep*sep;
      if (sep < 0.001) sep = 0.001;
      pages[nump++] = end;
      end += sep;
    }
    else pages[nump++] = 20;
  }
  if (pages[nump-1] < 20) pages[nump-1] = 20;
  for (i = 0; i < nump - 1; i += 2) {
    printf ("  union {\n");
    printf ("    intersection {\n");
    printf ("      box { <%f,-1,-5.7>, <%f,0,5.7> }\n", UL_CORNER(), UR_CORNER());
    printf ("      cylinder { <0,1.62,-6>, <0,1.62,6>, 2 }\n");
    printf ("    }\n");
    printf ("    polygon {\n      5,\n      <%f,0>, <%f,0>,\n      <%f,%f>, <%f,%f>,\n      <%f,0>\n",
            UL_CORNER(), UR_CORNER(), LR_CORNER(), LR_CORNERy(),
            LL_CORNER(), LL_CORNERy(), UL_CORNER());
    printf ("      translate 5.7*z\n    }\n");
    printf ("    polygon {\n      5,\n      <%f,0>, <%f,0>,\n      <%f,%f>, <%f,%f>,\n      <%f,0>\n",
            UL_CORNER(), UR_CORNER(), LR_CORNER(), LR_CORNERy(),
            LL_CORNER(), LL_CORNERy(), UL_CORNER());
    printf ("      translate -5.7*z\n    }\n");
    printf ("    pigment {\n");
    printf ("      marble color_map {\n");
    printf ("        [0 color rgb<1,1,1>]\n        [0.4 color rgb<1,1,1>]\n        [1 color rgb<0.7,0.7,0.7>]\n");
    printf ("      }\n");
    printf ("      scale 0.1 rotate %f*z\n", -(pages[i]+pages[i+1])/2.0);
    printf ("    }\n");
    printf ("    finish { ambient 0.24 diffuse 0.76 }\n");
    printf ("  }\n");
    printf ("  union {\n");
    printf ("    triangle {\n      <%f,0,-5.7>, <%f,0,5.7>, <%f,%f,5.7>\n    }\n",
            UL_CORNER(), UL_CORNER(), LL_CORNER(), LL_CORNERy());
    printf ("    triangle {\n      <%f,0,-5.7>, <%f,%f,5.7>, <%f,%f,-5.7>\n    }\n",
            UL_CORNER(), LL_CORNER(), LL_CORNERy(), LL_CORNER(), LL_CORNERy());
    printf ("    triangle {\n      <%f,0,-5.7>, <%f,0,5.7>, <%f,%f,5.7>\n    }\n",
            UR_CORNER(), UR_CORNER(), LR_CORNER(), LR_CORNERy());
    printf ("    triangle {\n      <%f,0,-5.7>, <%f,%f,5.7>, <%f,%f,-5.7>\n    }\n",
            UR_CORNER(), LR_CORNER(), LR_CORNERy(), LR_CORNER(), LR_CORNERy());
    printf ("    pigment { rgb<1,1,1> }\n");
    printf ("    finish { ambient 0.24 diffuse 0.76 }\n");
    printf ("  }\n");
  }
  return 0;
}
