//  Stained Glass Window
//  By
//  SR/A.E.Brickett
//
//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 4 lights, 18 textures and 158 primitives.
//
//  This file and all include files was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//  These Files Then edited by Me for extra effects and specifics.

//  Date : 02/08/1997    (08.02.1997)
//

global_settings {max_trace_level 5}


camera {  //  Camera StdCam
  location  <-0.565, 18.162, 10.161>
  direction <0.0,     0.0,  1.3866>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-0.512, -8.487, 6.145>
}

// *******  L I G H T S *******
light_source {   // Light4
  <-3.789, -15.027, 8.438>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light3
  <-0.818, -16.221, 12.585>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light2
  <2.965, -14.927, 10.742>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light1
  <-0.827, -13.840, 2.668>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//

#include "glassw.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******



// Include contains 'GlassP22'
#include "glassw.in1"

object {
  GlassP22_Raw
  texture {
    WallMarble
  }
  scale <1.975, 1.875, 2.4>
  rotate <-90.0, 29.0, 180.0>
  translate  <-3.445, -7.904, 11.251001>
}


// Include contains 'GlassP21'
#include "glassw.in2"

object {
  GlassP21_Raw
  texture {
    WallMarble
  }
  scale <1.975, 1.875, 2.4>
  rotate <-90.0, 29.0, 180.0>
  translate  <-2.211, -7.904, 13.310001>
}


// Include contains 'GlassP20'
#include "glassw.in3"

object {
  GlassP20_Raw
  texture {
    WallMarble
  }
  scale <1.975, 1.875, 2.4>
  rotate <90.0, 2.0, 0.0>
  translate  <-4.051, -7.904, 18.303001>
}


// Include contains 'GlassP19'
#include "glassw.in4"

object {
  GlassP19_Raw
  texture {
    WallMarble
  }
  scale <1.95, 1.875, 2.475>
  rotate <90.0, -6.0, 0.0>
  translate  <2.824, -7.93, 15.874001>
}


// Include contains 'GlassP18'
#include "glassw.in5"

object {
  GlassP18_Raw
  texture {
    WallMarble
  }
  scale <1.95, 1.875, 2.475>
  rotate <90.0, -6.0, 0.0>
  translate  <1.507, -7.93, 17.822001>
}


// Include contains 'GlassP17'
#include "glassw.in6"

object {
  GlassP17_Raw
  texture {
    WallMarble
  }
  scale <1.975, 1.875, 2.4>
  rotate <90.0, 17.0, 0.0>
  translate  <1.017, -7.904, 18.446001>
}


// Include contains 'GlassP16'
#include "glassw.in7"

object {
  GlassP16_Raw
  texture {
    RoofGlass
  }
  scale <9.2, 3.475, 30.625>
  rotate <90.0, 0.0, 0.0>
  translate  <-3.509, 18.929001, 18.262001>
}


box { // Mortar56
  <-1, -1, -1>, <1, 1, 1>
  texture {
    RoofGlass
  }
  scale <20.925001, 9.6, 1.625>
  rotate <90.0, 0.0, 90.0>
  translate  <-17.897001, -2.618, 6.694>
}


box { // Mortar55
  <-1, -1, -1>, <1, 1, 1>
  texture {
    RoofGlass
  }
  scale <20.725, 9.6, 1.2>
  rotate <90.0, 0.0, 90.0>
  translate  <16.338001, -2.396, 6.694>
}


box { // Mortar54
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <-15.439001, -8.56, 0.156>
}


box { // Mortar53
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <14.622001, -10.069, 0.156>
}


//
// Include file contains 'CB1'
//
#include "glassw.in8"
#declare CB1 = object {
  CB1_Raw
  scale <1.625, 1.4, 1.0>
  translate  <0.27, -0.803, 1.286>
}
union { // Column1
  torus { // CP14
    1.5, 0.5  rotate -x*90
    rotate -15.0*y
    translate  <-0.269, -0.768, 14.006001>
  }
  torus { // CP15
    1.5, 0.5  rotate -x*90
    texture {
      DiamondGlass
    }
    rotate -15.0*y
    translate  <-0.145, -0.807, 13.146001>
  }
  torus { // CP16
    1.5, 0.5  rotate -x*90
    texture {
      FlintGlass
    }
    rotate -15.0*y
    translate  <-0.111, -0.783, 12.212001>
  }
  torus { // CP17
    1.5, 0.5  rotate -x*90
    texture {
      CrownGlass
    }
    rotate -15.0*y
    translate  <-0.029, -0.776, 11.272001>
  }
  torus { // CP18
    1.5, 0.5  rotate -x*90
    texture {
      WaterGlass
    }
    rotate -15.0*y
    translate  <-0.012, -0.815, 10.341>
  }
  torus { // CP19
    1.5, 0.5  rotate -x*90
    rotate -15.0*y
    translate  <0.103, -0.783, 9.403>
  }
  torus { // CP20
    1.5, 0.5  rotate -x*90
    texture {
      DiamondGlass
    }
    rotate -15.0*y
    translate  <0.129, -0.791, 8.417>
  }
  torus { // CP21
    1.5, 0.5  rotate -x*90
    texture {
      FlintGlass
    }
    rotate -15.0*y
    translate  <0.211, -0.783, 7.478>
  }
  torus { // CP22
    1.5, 0.5  rotate -x*90
    texture {
      CrownGlass
    }
    rotate -15.0*y
    translate  <0.211, -0.783, 6.517>
  }
  torus { // CP23
    1.5, 0.5  rotate -x*90
    texture {
      WaterGlass
    }
    rotate -15.0*y
    translate  <0.319, -0.783, 5.663>
  }
  torus { // CP24
    1.5, 0.5  rotate -x*90
    rotate -15.0*y
    translate  <0.319, -0.783, 4.702>
  }
  torus { // CP25
    1.5, 0.5  rotate -x*90
    texture {
      DiamondGlass
    }
    rotate -15.0*y
    translate  <0.319, -0.783, 3.848>
  }
  torus { // CP26
    1.5, 0.5  rotate -x*90
    texture {
      CrownGlass
    }
    rotate -15.0*y
    translate  <0.319, -0.783, 2.994>
  }
  torus { // CP27
    1.5, 0.5  rotate -x*90
    texture {
      WaterGlass
    }
    rotate -15.0*y
    translate  <0.427, -0.783, 2.033>
  }
  object { CB1 }
  texture {
    MaxGlass
  }
  rotate -158.0*z
  translate  <-6.784, -1.466, 0.898>
}


//
// Include file contains 'CB'
//
#include "glassw.in9"
#declare CB = object {
  CB_Raw
  scale <1.625, 1.4, 1.0>
  translate  <0.363, -0.783, 1.338>
}
union { // Column
  torus { // CP13
    1.5, 0.5  rotate -x*90
    rotate -15.0*y
    translate  <-0.159, -0.783, 14.219001>
  }
  torus { // CP12
    1.5, 0.5  rotate -x*90
    texture {
      DiamondGlass
    }
    rotate -15.0*y
    translate  <-0.158, -0.783, 13.243001>
  }
  torus { // CP11
    1.5, 0.5  rotate -x*90
    texture {
      FlintGlass
    }
    rotate -15.0*y
    translate  <-0.081, -0.783, 12.283001>
  }
  torus { // CP10
    1.5, 0.5  rotate -x*90
    texture {
      CrownGlass
    }
    rotate -15.0*y
    translate  <-0.004, -0.783, 11.335001>
  }
  torus { // CP9
    1.5, 0.5  rotate -x*90
    texture {
      WaterGlass
    }
    rotate -15.0*y
    translate  <0.041, -0.783, 10.36>
  }
  torus { // CP8
    1.5, 0.5  rotate -x*90
    rotate -15.0*y
    translate  <0.133, -0.783, 9.415>
  }
  torus { // CP7
    1.5, 0.5  rotate -x*90
    texture {
      DiamondGlass
    }
    rotate -15.0*y
    translate  <0.165, -0.783, 8.424>
  }
  torus { // CP6
    1.5, 0.5  rotate -x*90
    texture {
      FlintGlass
    }
    rotate -15.0*y
    translate  <0.211, -0.783, 7.478>
  }
  torus { // CP5
    1.5, 0.5  rotate -x*90
    texture {
      CrownGlass
    }
    rotate -15.0*y
    translate  <0.211, -0.783, 6.517>
  }
  torus { // CP4
    1.5, 0.5  rotate -x*90
    texture {
      WaterGlass
    }
    rotate -15.0*y
    translate  <0.319, -0.783, 5.663>
  }
  torus { // CP3
    1.5, 0.5  rotate -x*90
    rotate -15.0*y
    translate  <0.319, -0.783, 4.702>
  }
  torus { // CP2
    1.5, 0.5  rotate -x*90
    texture {
      DiamondGlass
    }
    rotate -15.0*y
    translate  <0.319, -0.783, 3.848>
  }
  torus { // CP1
    1.5, 0.5  rotate -x*90
    texture {
      CrownGlass
    }
    rotate -15.0*y
    translate  <0.319, -0.783, 2.994>
  }
  torus { // CP
    1.5, 0.5  rotate -x*90
    texture {
      WaterGlass
    }
    rotate -15.0*y
    translate  <0.427, -0.783, 2.033>
  }
  object { CB }
  texture {
    MaxGlass
  }
  translate  <6.3, 0.026, 0.895>
}


box { // Mortar52
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.35, 1.05>
  rotate 90.0*z
  translate  <7.285, -9.191, 14.813001>
}


box { // Mortar51
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.35, 1.05>
  rotate 90.0*z
  translate  <8.549, -9.191, 12.501001>
}


box { // Mortar50
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.35, 1.05>
  rotate 90.0*z
  translate  <-8.608, -9.191, 14.948001>
}


box { // Mortar49
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.35, 1.05>
  rotate 90.0*z
  translate  <-16.690001, -9.191, 12.357001>
}


box { // Mortar48
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.35, 1.05>
  rotate 90.0*z
  translate  <-9.831, -9.191, 12.521001>
}


box { // Mortar47
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 1.05, 0.725>
  rotate <-57.0, 0.0, 90.0>
  translate  <-3.948, -9.191, 14.219001>
}


box { // Mortar46
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 1.05, 0.725>
  rotate <-53.0, 0.0, 90.0>
  translate  <-5.209, -9.191, 12.374001>
}


box { // Mortar45
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 1.05, 0.725>
  rotate <52.0, 0.0, 90.0>
  translate  <2.567, -9.191, 14.358001>
}


box { // Mortar44
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 1.05, 0.725>
  rotate <52.0, 0.0, 90.0>
  translate  <3.89, -9.191, 12.502001>
}


box { // Mortar43
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.7, 1.025>
  rotate 90.0*z
  translate  <12.216001, -9.191, 10.117>
}


box { // Mortar42
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 1.925, 1.1>
  rotate 90.0*z
  translate  <6.349, -9.191, 10.213>
}


box { // Mortar41
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.7, 1.025>
  rotate 90.0*z
  translate  <15.655001, -9.191, 7.912>
}


box { // Mortar40
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.7, 1.025>
  rotate 90.0*z
  translate  <8.118, -9.191, 7.913>
}


box { // Mortar39
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.7, 1.025>
  rotate 90.0*z
  translate  <12.236001, -9.191, 5.66>
}


box { // Mortar38
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 1.95, 1.05>
  rotate 90.0*z
  translate  <6.402, -9.191, 5.631>
}


box { // Mortar37
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.35, 1.05>
  rotate 90.0*z
  translate  <14.625001, -9.191, 3.369>
}


box { // Mortar36
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.35, 1.05>
  rotate 90.0*z
  translate  <7.803, -9.191, 3.37>
}


box { // Mortar35
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.35, 1.05>
  rotate 90.0*z
  translate  <-15.950001, -9.191, 10.141>
}


box { // Mortar34
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.35, 1.05>
  rotate 90.0*z
  translate  <-9.103, -9.191, 10.238>
}


box { // Mortar33
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.35, 1.05>
  rotate 90.0*z
  translate  <-13.104001, -9.191, 7.889>
}


box { // Mortar32
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 1.975, 1.075>
  rotate 90.0*z
  translate  <-7.615, -9.191, 7.908>
}


box { // Mortar31
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.75, 1.075>
  rotate 90.0*z
  translate  <-17.130001, -9.191, 5.56>
}


box { // Mortar30
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.75, 1.075>
  rotate 90.0*z
  translate  <-9.448, -9.191, 5.561>
}


box { // Mortar29
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 3.75, 1.075>
  rotate 90.0*z
  translate  <-14.411001, -9.191, 3.259>
}


box { // Mortar28
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallMarble
  }
  scale <1.275, 2.4, 1.125>
  rotate 90.0*z
  translate  <-8.155, -9.191, 3.211>
}


box { // Mortar27
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  rotate 90.0*z
  translate  <-10.502, -9.191, 0.911>
}


box { // Mortar26
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  rotate 90.0*z
  translate  <9.444, -9.191, 1.164>
}


box { // Mortar25
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  rotate 90.0*z
  translate  <-0.528, -9.191, 1.038>
}


box { // Mortar24
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MortatrT
  }
  scale <7.55, 6.8, 1.0>
  rotate <90.0, -59.0, 0.0>
  translate  <-8.326, -9.022, 18.638001>
}


box { // Mortar23
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MortatrT
  }
  scale <7.55, 6.8, 1.0>
  rotate <90.0, -34.0, 0.0>
  translate  <9.042, -9.022, 16.943001>
}


box { // Mortar22
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MortatrT
  }
  scale <7.55, 6.8, 1.0>
  rotate 90.0*x
  translate  <11.921001, -9.022, 6.694>
}


box { // Mortar21
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MortatrT
  }
  scale <7.55, 6.8, 1.0>
  rotate 90.0*x
  translate  <-13.007001, -9.022, 6.883>
}


box { // Mortar20
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <11.941001, 2.84, 0.156>
}


box { // Mortar19
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <11.942001, -7.202, 0.156>
}


box { // Mortar18
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <9.239, 4.74, 0.156>
}


box { // Mortar17
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <9.239, -5.398, 0.156>
}


box { // Mortar16
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <6.425, 1.404, 0.156>
}


box { // Mortar15
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <6.425, -8.673, 0.156>
}


box { // Mortar14
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <3.781, 4.498, 0.156>
}


box { // Mortar13
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <3.745, -5.506, 0.156>
}


box { // Mortar12
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <1.064, 1.288, 0.156>
}


box { // Mortar11
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <1.065, -8.767, 0.156>
}


box { // Mortar10
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <-1.691, 5.41, 0.156>
}


box { // Mortar9
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <-1.675, -4.594, 0.156>
}


box { // Mortar8
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <-4.394, 3.399, 0.156>
}


box { // Mortar7
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <-4.393, -6.717, 0.156>
}


box { // Mortar6
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <-7.15, 4.583, 0.156>
}


box { // Mortar5
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <-7.149, -5.465, 0.156>
}


box { // Mortar4
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <-9.935, -0.214, 0.156>
}


box { // Mortar3
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <-9.934, -10.262, 0.156>
}


box { // Mortar2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <-12.700001, 3.655, 0.156>
}


box { // Mortar1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    FloorMarble
  }
  scale <1.275, 4.925, 1.0>
  translate  <-12.699001, -6.467, 0.156>
}


box { // Floor1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BackMarble
  }
  scale <22.575001, 17.450001, 0.775>
  rotate -90.0*x
  translate  <0.0, -18.773001, 6.725>
}


// Include contains 'GlassP15'
#include "glassw.i10"

object {
  GlassP15_Raw
  texture {
    BeachGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <2.002, -8.614, 3.256>
}


// Include contains 'GlassP14'
#include "glassw.i11"

object {
  GlassP14_Raw
  texture {
    BeachGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <-3.897, -8.614, 3.475>
}


// Include contains 'GlassP13'
#include "glassw.i12"

object {
  GlassP13_Raw
  texture {
    YellowGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <-1.791, -8.614, 16.581001>
}


// Include contains 'GlassP12'
#include "glassw.i13"

object {
  GlassP12_Raw
  texture {
    RedGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <-3.543, -8.614, 14.619001>
}


// Include contains 'GlassP11'
#include "glassw.i14"

object {
  GlassP11_Raw
  texture {
    RedGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <0.177, -8.614, 14.761001>
}


// Include contains 'GlassP10'
#include "glassw.i15"

object {
  GlassP10_Raw
  texture {
    PurpleGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <1.999, -8.614, 12.722001>
}


// Include contains 'GlassP9'
#include "glassw.i16"

object {
  GlassP9_Raw
  texture {
    PurpleGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <-5.502, -8.614, 12.358001>
}


// Include contains 'GlassP8'
#include "glassw.i17"

object {
  GlassP8_Raw
  texture {
    YellowGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <-4.994, -8.614, 9.808>
}


// Include contains 'GlassP7'
#include "glassw.i18"

object {
  GlassP7_Raw
  texture {
    YellowGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <1.562, -8.614, 9.809>
}


// Include contains 'GlassP6'
#include "glassw.i19"

object {
  GlassP6_Raw
  texture {
    GreenGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <2.364, -8.614, 10.538001>
}


// Include contains 'GlassP5'
#include "glassw.i20"

object {
  GlassP5_Raw
  texture {
    GreenGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <-5.209, -8.614, 10.467>
}


// Include contains 'GlassP4'
#include "glassw.i21"

object {
  GlassP4_Raw
  texture {
    PurpleGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <-3.679, -8.614, 3.985>
}


// Include contains 'GlassP3'
#include "glassw.i22"

object {
  GlassP3_Raw
  texture {
    PurpleGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <2.294, -8.614, 4.058>
}


// Include contains 'GlassP2'
#include "glassw.i23"

object {
  GlassP2_Raw
  texture {
    BlueGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 180.0>
  translate  <2.564, -9.111, 5.951>
}


// Include contains 'GlassP1'
#include "glassw.i24"

object {
  GlassP1_Raw
  texture {
    BlueGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <-3.678, -8.614, 5.588>
}


box { // GlassPC2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WhiteGlass
  }
  scale <0.9, 0.175, 0.975>
  translate  <-0.627, -8.853, 12.350001>
}


box { // GlassPC1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WhiteGlass
  }
  scale <0.975, 0.175, 2.7>
  rotate <0.0, -90.0, 0.0>
  translate  <-0.658, -8.853, 10.385>
}


box { // GlassPC
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WhiteGlass
  }
  scale <0.875, 0.175, 2.275>
  translate  <-0.54, -8.853, 7.028>
}


// Include contains 'GlassP'
#include "glassw.i25"

object {
  GlassP_Raw
  texture {
    GreenGlass
  }
  scale <1.95, 1.875, 0.4>
  rotate <90.0, 0.0, 0.0>
  translate  <-0.473, -8.614, 4.132>
}






union { // Window
  box { // LeadP5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.75, 0.275, 0.225>
    rotate <-180.0, 0.0, 180.0>
    translate  <-0.574, -8.843, 15.374001>
  }
  box { // LeadP4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <3.0, 0.275, 0.075>
    rotate <0.0, -59.0, 0.0>
    translate  <-3.771, -8.879, 12.755001>
  }
  box { // LeadP3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <3.0, 0.275, 0.075>
    rotate <180.0, -57.0, -180.0>
    translate  <2.62, -8.879, 12.834001>
  }
  box { // LeadP2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <4.225, 0.275, 0.125>
    rotate <0.0, -90.0, 0.0>
    translate  <4.24, -8.879, 6.215>
  }
  box { // LeadP1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <4.225, 0.275, 0.125>
    rotate <0.0, -90.0, 0.0>
    translate  <-5.349, -8.878, 6.215>
  }
  box { // LeadP
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <4.925, 0.3, 0.125>
    translate  <-0.514, -8.863, 1.995>
  }
  box { // LeadP6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.375, 0.275, 0.1>
    rotate <0.0, -63.0, 0.0>
    translate  <1.544, -8.879, 3.082>
  }
  box { // LeadP7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.375, 0.275, 0.1>
    rotate <180.0, -56.0, -180.0>
    translate  <-1.953, -8.879, 3.009>
  }
  box { // LeadP8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.425, 0.275, 0.1>
    rotate <0.0, -62.0, 0.0>
    translate  <-2.1, -8.879, 5.266>
  }
  box { // LeadP9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.4, 0.275, 0.1>
    rotate <180.0, -50.0, -180.0>
    translate  <1.277, -8.879, 5.337>
  }
  box { // LeadP10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <2.3, 0.275, 0.1>
    rotate <0.0, -90.0, 0.0>
    translate  <-1.421, -8.879, 6.973>
  }
  box { // LeadP11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <2.3, 0.275, 0.1>
    rotate <0.0, -90.0, 0.0>
    translate  <0.374, -8.879, 6.939>
  }
  box { // LeadP12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <3.025, 0.275, 0.15>
    rotate <180.0, 0.0, -180.0>
    translate  <-0.576, -8.879, 9.413>
  }
  box { // LeadP13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <2.975, 0.275, 0.15>
    rotate <180.0, 0.0, -180.0>
    translate  <-0.614, -8.879, 11.452001>
  }
  box { // LeadP14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <0.975, 0.275, 0.15>
    rotate <0.0, -90.0, 0.0>
    translate  <-3.42, -8.879, 10.502>
  }
  box { // LeadP15
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <0.975, 0.275, 0.15>
    rotate <0.0, -90.0, 0.0>
    translate  <2.26, -8.879, 10.429>
  }
  box { // LeadP16
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <0.975, 0.275, 0.15>
    rotate <0.0, -90.0, 0.0>
    translate  <0.365, -8.879, 12.540001>
  }
  box { // LeadP17
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <0.975, 0.275, 0.15>
    rotate <0.0, -90.0, 0.0>
    translate  <-1.529, -8.879, 12.540001>
  }
  box { // LeadP18
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <0.975, 0.275, 0.15>
    rotate <0.0, 0.0, 0.0>
    translate  <-0.584, -8.879, 13.340001>
  }
  box { // LeadP19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.0, 0.275, 0.15>
    rotate <0.0, 0.0, 0.0>
    translate  <-0.517, -8.879, 4.71>
  }
  box { // LeadP20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.575, 0.275, 0.1>
    rotate <180.0, -47.0, -180.0>
    translate  <3.072, -8.879, 3.154>
  }
  box { // LeadP21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.575, 0.275, 0.1>
    rotate <180.0, 38.0, -180.0>
    translate  <-3.994, -8.879, 3.007>
  }
  box { // LeadP22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <2.525, 0.275, 0.1>
    rotate <-180.0, 43.0, -180.0>
    translate  <-3.415, -8.879, 7.594>
  }
  box { // LeadP23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <2.525, 0.275, 0.1>
    rotate <0.0, 40.0, 0.0>
    translate  <2.336, -8.879, 7.737>
  }
  box { // LeadP24
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.1, 0.275, 0.125>
    rotate <0.0, 24.0, 0.0>
    translate  <-4.292, -8.879, 9.848>
  }
  box { // LeadP25
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.15, 0.275, 0.075>
    rotate <0.0, -43.0, 0.0>
    translate  <-4.365, -8.879, 8.609>
  }
  box { // LeadP26
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.15, 0.275, 0.075>
    rotate <0.0, -27.0, 0.0>
    translate  <3.209, -8.879, 9.846>
  }
  box { // LeadP27
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.15, 0.275, 0.075>
    rotate <0.0, 35.0, 0.0>
    translate  <3.208, -8.879, 8.68>
  }
  box { // LeadP28
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.0, 0.275, 0.125>
    rotate <0.0, -90.0, 0.0>
    translate  <2.26, -8.879, 12.394001>
  }
  box { // LeadP29
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <0.975, 0.275, 0.15>
    rotate <0.0, -90.0, 0.0>
    translate  <-3.423, -8.879, 12.463001>
  }
  box { // LeadP30
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.125, 0.275, 0.15>
    rotate <-180.0, -70.0, 180.0>
    translate  <-1.829, -8.879, 14.223001>
  }
  box { // LeadP31
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.125, 0.275, 0.15>
    rotate <0.0, -66.0, 0.0>
    translate  <0.7, -8.879, 14.269001>
  }
  box { // LeadP32
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <2.525, 0.275, 0.15>
    rotate <0.0, -39.0, 0.0>
    translate  <-3.484, -8.879, 5.629>
  }
  box { // LeadP33
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <2.375, 0.275, 0.15>
    rotate <0.0, 37.0, 0.0>
    translate  <2.341, -8.879, 5.993>
  }
  box { // LeadP34
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.075, 0.225, 0.1>
    rotate <180.0, 0.0, -90.0>
    translate  <3.225, -9.135, 1.97>
  }
  box { // LeadP35
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.075, 0.225, 0.1>
    rotate <180.0, 0.0, -90.0>
    translate  <-0.645, -9.136, 1.97>
  }
  box { // LeadP36
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.075, 0.225, 0.1>
    rotate <180.0, 0.0, -90.0>
    translate  <-3.965, -9.136, 2.035>
  }
  box { // LeadP37
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.075, 0.225, 0.1>
    rotate <90.0, 0.0, -90.0>
    translate  <-5.151, -9.136, 10.289>
  }
  box { // LeadP38
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.075, 0.225, 0.1>
    rotate <90.0, 0.0, -90.0>
    translate  <4.086, -9.136, 10.313>
  }
  box { // LeadP39
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeadT
    }
    scale <1.075, 0.225, 0.1>
    rotate <-180.0, 0.000001, -90.0>
    translate  <-0.602, -9.136, 15.183001>
  }
}


box { // Mortar
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MortatrT
  }
  scale <16.325001, 17.450001, 1.0>
  translate  <-0.305, 0.038, 0.0>
}




