

#declare barrel_length = 8

//the glass barrel
#declare syringe = union {

merge { //merge the glass barrel and the endpiece

  difference { //the outer and inner barrel cylinders
  
    //outer cylinder
    cylinder { <0, 0, 0>, <0, barrel_length, 0>, .4 
               
               //texture { //this texture is only for quick renders
               //  pigment { White }
               //} 


              texture { 
               pigment {
                image_map {
                   gif "syringe.gif"
                   map_type 2
                   once
                   filter 0, 1.0
                 }
                 quick_color Red
               }                         
               
               rotate <0, -180, 0>
               scale <1,8,1>
               
           } //end first texture

           //texture  put glass texture here
           texture { T_Glass3 }
           
           translate <0, -4, 0>
           rotate <0, 0, 90>

    } // end cylinder



    
    
    cylinder { < -barrel_length/2 - 0.1, 0, 0>, <barrel_length/2 + 0.1, 0, 0>, 0.125 
    			texture { T_Glass3 }
    		 }
    

  //texture { //second and last texture on this object
  //  pigment { color rgb<1.0, 1.0, 1.0> }
  //} //end of second texture
  
  } //end difference of inner and outer barrel






  difference { //the endpiece
    cylinder { <-0.15, 0, 0>, <0.15, 0, 0>, 0.67 }
    box { <-0.2, 0.5, -0.67>, <0.2, 0.8, 0.67> }
    box { <-0.2, -0.5, -0.67>, <0.2, -0.8, 0.67> }
    cylinder { <-0.16, 0, 0>, <0.16, 0, 0>, 0.125 }

    texture {
      T_Glass3
      pigment { quick_color Blue}
    }

    translate <barrel_length/2 + 0.149, 0, 0>

  } //end endpiece

} //end merge of glass barrel and the endpiece




//the metal cap

union { //union of cutaway cap, short barrel, and screw cap

  difference { //take notch from cutaway cap

    difference { //remove inside of cutaway cap
      cylinder { <-0.3, 0, 0>, <0.3, 0, 0>, 0.45 }
      cylinder { <-0.31, 0, 0>, <0.31, 0, 0>, 0.40 }
    } //end: remove inside of cap

    box { <-0.2, 0, -0.25>, <0.31, 0.5, 0.25> }

    texture {

      pigment { color rgb <0.90, 0.89, 0.81> }
      pigment { quick_color Blue }
      finish {
        ambient 0.15
        brilliance 5
        diffuse 0.6
        metallic
        specular 0.80
        roughness 1/1000
        reflection 0.65
      }
    }

  } //end difference: cutaway cap



  //cap of cutaway cap
  cylinder { <-0.31, 0, 0>, <-0.250, 0, 0>, 0.43
    texture {
      T_Silver_2D
      pigment {quick_color Blue}
    }
  }



  //barrel coming from cutaway cap
  cylinder { <-0.45, 0, 0>, <-0.251, 0, 0>, 0.25
    texture {

      pigment { color rgb <0.90, 0.89, 0.81> }
      pigment { quick_color Blue }
      finish {
        ambient 0.15
        brilliance 5
        diffuse 0.6
        metallic
        specular 0.80
        roughness 1/1000
        reflection 0.65
      }
    }

  }



  //spinney metal cap
  
  union{
    cylinder { <0, 0, 0>, <0, 0.46, 0>, 0.4 
    
    texture {


      pigment { color rgb <0.75, 0.82, 0.71> }
      pigment { quick_color Blue }
      finish {
        ambient 0.15
        brilliance 5
        diffuse 0.6
        metallic
        specular 0.80
        roughness 1/1000
        reflection 0.85
      }
      
      normal {
			bump_map
			{ 
  			  gif "syringe_knurl.gif" 
			  map_type 2 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
  			  interpolate 4 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  			  use_color
 			  bump_size 1 // 0...3
			} 
	  		scale <0.8, .23, 1>
	  }
	  
    }
    }
    
    
    
    cylinder { 
      <0, 0.459, 0>, <0, 0.48, 0>, 0.4 
      pigment { color rgb <0.85, 0.92, 0.81> }
    }
    
    translate <0, -.23, 0>    //put the center at <0, 0, 0>
    rotate <0, 0, 90>       
    translate <-0.62, 0, 0>
    
  }//end union of spinney cap



  //needle
  cylinder { <-0.81, 0, 0>, <-5.8, 0, 0>, 0.025
    texture {

      pigment { color rgb <0.90, 0.89, 0.81> }
      pigment { quick_color Blue }
      finish {
        ambient 0.15
        brilliance 5
        diffuse 0.6
        metallic
        specular 0.80
        roughness 1/1000
        reflection 0.65
      }
    }

  }





  //translate this union into the right spot
  translate <-barrel_length/2 + 0.3, 0, 0>



} //end union


} // end syringe







