// Persistence Of Vision Raytracer version 3.0 file.

#include "colors.inc"
#include "textures.inc"
#include "stoneold.inc"
#include "clock.inc"
#include "sundial.inc"
#include "hrglass.inc"

camera {
	location <17, 4, 0>
	direction <-1, 0,  0>
	look_at <0, 1.5, 0>
}

light_source {<77320000, 38660000, 38660000> color red 2 blue 2 green 2
	area_light <356200, 0, -711000>, <0, 711000, 0>, 2, 2
	adaptive 1
	jitter
}

background {Gray25}

plane { -z, 0 hollow texture {Luminous
        pigment {
                image_map {tga "earth.tga"
                        map_type 0
                        interpolate 2
                        once
                }
        translate <-.5, -.65, 0>
        scale <26560, 19920, 1>
        }
}
finish {ambient 1.125}
rotate <0, 90, 8.365886124>
translate <-20000, 0, 0>
}


#declare column = union {
	cylinder {<0, 0, 0>, <0, .5, 0>, .625}
	difference {
		cylinder {<0, .5, 0>, <0, .75, 0>, .5625}
		torus {.5625, .0625 translate .75*y}
		bounded_by {cylinder {<0, .5, 0>, <0, .75, 0>, .5625}}
	}
	torus {.5625, .0625 translate .5*y}
	cylinder {<0, .75, 0>, <0, 8, 0>, .5}
texture {Stone14 finish {reflection .1}}
}

#declare arch = intersection {
	difference {
		cylinder {<.25, 0, 0>, <-.25, 0, 0>, 4.75}
		union {
			cylinder {<.5, 0, 0>, <-.5, 0, 0>, 4.25}
			plane {y, 0}
		}
	}
	torus {4.5, .3 rotate 90*z}
	bounded_by {box {<-.25, 0, -4.75>, <.25, 4.75, 4.75>}}
texture {Stone11 scale .5 finish {reflection .1}}
}

object { //floor
	union{
		difference {
			box {<-14, -.5, -83>, <14, 0, 16>}
			union {
				box {<-21, -2, -101>, <-5, 1, -3>}
				box {<-21, -2, 7>, <-5, 1, 21>}
				box {<5, -2, -101>, <21, 1, -3>}
				box {<5, -2, 7>, <21, 1, 21>}
			}
			texture{
	    			tiles {texture {Stone8 finish {reflection .15}}
       					tile2 texture {Stone14 finish {reflection .15}}
       				}
    			}
		}
		object {column scale .5 translate <4.5, 0, 6.5>}
		object {column scale .5 translate <4.5, 0, 15.5>}
		object {column scale .5 translate <4.5, 0, -2.5>}
		object {column scale .5 translate <4.5, 0, -11.5>}
		object {column scale .5 translate <4.5, 0, -20.5>}
		object {column scale .5 translate <4.5, 0, -29.5>}
		object {column scale .5 translate <4.5, 0, -38.5>}
		object {column scale .5 translate <4.5, 0, -47.5>}
		object {column scale .5 translate <4.5, 0, -56.5>}
		object {column scale .5 translate <4.5, 0, -64.5>}
		object {column scale .5 translate <4.5, 0, -73.5>}
		object {column scale .5 translate <4.5, 0, -82.5>}
		object {column scale .5 translate <-4.5, 0, 6.5>}
		object {column scale .5 translate <-4.5, 0, 15.5>}
		object {column scale .5 translate <-4.5, 0, -2.5>}
		object {column scale .5 translate <-4.5, 0, -11.5>}
		object {column scale .5 translate <-4.5, 0, -20.5>}
		object {column scale .5 translate <-4.5, 0, -29.5>}
		object {column scale .5 translate <-4.5, 0, -38.5>}
		object {column scale .5 translate <-4.5, 0, -47.5>}
		object {column scale .5 translate <-4.5, 0, -56.5>}
		object {column scale .5 translate <-4.5, 0, -65.5>}
		object {column scale .5 translate <-4.5, 0, -74.5>}
		object {column scale .5 translate <-4.5, 0, -83.5>}
		object {column scale .5 translate <13.5, 0, -2.5>}
		object {column scale .5 translate <13.5, 0, 6.5>}
		object {column scale .5 translate <-13.5, 0, -2.5>}
		object {column scale .5 translate <-13.5, 0, 6.5>}
		object {arch translate <4.5, 4, 2>}
		object {arch translate <-4.5, 4, 2>}
		object {arch translate <13.5, 4, 2>}
		object {arch translate <-13.5, 4, 2>}
		object {arch rotate 90*y translate <0, 4, 15.5>}
		object {arch rotate 90*y translate <0, 4, 6.5>}
		object {arch rotate 90*y translate <0, 4, -2.5>}
		object {arch rotate 90*y translate <0, 4, -11.5>}
		object {arch rotate 90*y translate <0, 4, -20.5>}
		object {arch rotate 90*y translate <0, 4, -29.5>}
		object {arch rotate 90*y translate <0, 4, -38.5>}
		object {arch rotate 90*y translate <0, 4, -47.5>}
		object {arch rotate 90*y translate <0, 4, -56.5>}
		object {arch rotate 90*y translate <0, 4, -65.5>}
		object {arch rotate 90*y translate <0, 4, -74.5>}
		object {arch rotate 90*y translate <0, 4, -83.5>}
	}
rotate 45*y
translate 1*z
}

object {CLOCK rotate -60*y translate <0, 0, 2> rotate 45*y translate 1.25*z}

object {sundial translate <9, -.25, 2> rotate 45*y translate 1*z}

object {hourglass scale <.5 .625, .5> translate <-9, 0, 2> rotate 45*y translate 1*z}


