//******************************** HEADER *************************************

#include "colors.inc"
#include "color2.inc"
#include "textures.inc"
#include "marble.inc"
#include "altar.inc"
#include "stars.inc"
#include "clock.inc"
#include "hourglas.inc"

//****************** CAMERA **********************

camera {
    location <0, 7, -30>
   direction <0, 0, 1.25>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <0, 10, 0>
}

//****************** LIGHTS *********************

light_source { <0,50,55> color White shadowless }

light_source { <0,25,10> color White
                spotlight
                point_at <0,25,25>
                radius 90
                falloff 110
                tightness 7
}

light_source { <0,20,-20> color White
                spotlight
                point_at <0,5,0>
                radius 120
                falloff 160
                tightness 15
}

//****************** ACTION **********************

//LeftMoon
sphere { <-20,25,25> 3 pigment {color White} finish {ambient 0.1 } no_shadow}

//CenterMoon
sphere { <0,25,25> 3 pigment {color White} no_shadow}

//RightMoon
sphere { <20,25,25> 3 pigment {color White} finish {ambient 0.1 } no_shadow}

// NEBULAR OBJECTS
sphere { 0, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1.75
    color_map {
      [ 0 color rgbt <1, 0, 0, 1> ]
      [ 0.5 color rgbt <1, 0, 1, 0> ]
      [ 1 color rgbt <0, 0, 1, -1> ]
    }
    samples 20
    scale 0.5
  }
  hollow
  no_shadow
  scale <35,35,20>
  translate <-30,35,75>
}

sphere { 0, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1.75
    color_map {
      [ 0 color rgbt <0, 1, 0, 1> ]
      [ 1 color rgbt <0, 0, 1, -1> ]
    }
    samples 20
    scale 0.75
  }
  hollow
  no_shadow
  rotate <0,180,0>
  scale <35,35,20>
  translate <-40,35,65>
}

sphere { 0, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 2
    color_map {
      [ 0 color rgbt <0, 0, 0, 1> ]
      [ 1 color rgbt <1, 0, 0, -1> ]
    }
    samples 20
    scale 0.85
  }
  hollow
  no_shadow
  rotate <0,180,0>
  scale <15,15,10>
  translate <45,20,65>
}

//Altar Piece
union {
sphere {<0,6,0> 3.5 texture {Glass3}}
object {ClockFace scale 0.75 translate <0,5.85,2>}
translate <0,0,2>
}

//STARS
object {Star1 scale 0.5 translate <-33,70,200> pigment { color Steel_Blue_Light}}

object {Star1 scale 0.4 translate <-127,67,220> pigment { color Azure}}

object {Star1 scale 0.5 translate <-56,76,200> pigment { color Mars_Orange}}

object {Star2 translate <55,20,100> pigment { color Violet_Red_Pale}}

object {Star2 translate <30,20,150> pigment { color Azure}}

object {Star2 translate <40,80,150> pigment { color White}}

object {Star2 translate <60,30,100> pigment { color Firebrick}}

object {Star3 translate <20,20,150> pigment { color White}}

object {Star3 translate <30,75,150> pigment { color White}}

object {Star3 translate <45,30,150> pigment { color White}}

object {Star3 translate <40,55,150> pigment { color Violet_Red_Pale}}

object {Star3 translate <-10,40,160> pigment { color Cornsilk}}

object {HourGlass rotate <0,25,0> scale 10 translate <-3,180,500>}
