#version 3.5 ;

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"
#include "metals.inc"
#include "woods.inc"

global_settings
{
  assumed_gamma 1.6// 1.8
}

// ----------------------------------------

#declare pi2=2*pi/360;
#declare tclock=clock-1000;

#declare place = <0,0,-3>;
//#declare place = <0,0,-30>;

/*
light_source { place + <-2,2,0> color <1,1,1>*.2 }
light_source { place + <2,2,0> color <1,1,1>*.2 }
light_source{place color<1,1,1>*.6 shadowless}
*/

light_source{place color<1,1,1>*.2}
//light_source{<-1000,1000,-1000> color<1,1,1>*.6} // a*
light_source{<1000,100,-10> color<1,1,1>*.8} // b*

camera {location place//-4 
right 16/9*x
look_at <0,0,0>
sky <0,1,0>
up <0,1,0> // -1 flips left to right
//angle 20
}

//background{SkyBlue}

sky_sphere{S_Cloud3 rotate 180*x}

#declare tex1= texture{T_Silver_1A 
finish {ambient .6} 
normal {dents -1 scale .1}
}

#declare tex2= texture{T_Silver_5D 
finish {ambient .6} 
normal {dents -1 scale .1}
}

#declare ufo = union{
cone {<0,0,0>, 1, <0,.25,0>, .9 texture {tex1}}
torus {.9, .013 texture{tex1}}
cone {<0,.25,0>, .9, <0,.45,0>, 0 texture {tex1}}

sphere {<0,.45,0> .4 scale <1,.7,1> texture {tex1}} 

cylinder {<0,.45,0>,<0,.65,0> .1 texture {tex1}}

#declare i=0;
#declare imax=12;
#while (i<imax)
cylinder{<0,.45,-.01>,<0,.45,.01> .4 scale <1,.72,1> 
rotate y*i*360/imax texture {tex2}}
#declare i=i+1;
#end

torus {1, .013 texture{tex1}}

cone {<0,0,0>, 1, <0,-.15,0>, 0 texture {tex1}}

#declare i=0;
#declare imax=12;
#while (i<imax)
cylinder {<-1,0,0>,<0,-.15,0> .0125 texture {tex2} rotate y*i*360/imax }
#declare i=i+1;
#end
cylinder {<0,-.1,0>,<0,-.175,0> .2 texture{tex1}}

//cylinder {<0,0,0>, <0,1000,0> .0065 pigment{Black}}

}//ufo

#declare fleet = union{
object{ufo rotate 0*y  rotate 7*tclock*y translate <0,0,0>}

object{ufo rotate 45*y  rotate 7*tclock*y translate <1.5,0,3>}

object{ufo rotate 90*y  rotate 7*tclock*y translate <-1.5,0,3>}

object{ufo rotate 135*y  rotate 7*tclock*y translate <3,0,6> }

object{ufo rotate 180*y  rotate 7*tclock*y translate <-3,0,6> }

object{ufo rotate 225*y  rotate 7*tclock*y translate <4.5,0,9> }

object{ufo rotate 270*y  rotate 7*tclock*y translate <0,0,9> } // center

object{ufo rotate 100*y  rotate 7*tclock*y translate <-4.5,0,9> }

object{ufo rotate 145*y  rotate 7*tclock*y translate <6,0,12> }

object{ufo rotate 200*y  rotate 7*tclock*y translate <-6,0,12> }
}//fleet

#declare screen = object{
mesh{
triangle {<-1,-1,0>,<-1,1,0>,<1,1,0>}
triangle {<-1,-1,0>,<1,1,0>,<1,-1,0>}
texture {pigment {image_map{tga "/home/matt/povray/images/tampa-fore.tga" 
once map_type 0}}}
finish {ambient .8 }
translate<-.5,-.5,0>
}//mesh

}//screen

object{screen scale <16,9,1>*.335 translate .05*y translate .015*x  }

#declare screen1 = object{
mesh{
triangle {<-1,-1,0>,<-1,1,0>,<1,1,0>}
triangle {<-1,-1,0>,<1,1,0>,<1,-1,0>}
texture {pigment {image_map{tga "/home/matt/povray/images/tampa-back.tga" 
once map_type 0}}}
finish {ambient .8}
translate<-.5,-.5,0>
}//mesh

}//screen

object{screen1 scale <16,9,1>*.335 translate 2*z scale 3 } //3


object { fleet rotate -35*y scale (.1+.9*tclock/210)  
translate <-4 +8*tclock/210 ,1,.9- 9*tclock/210 >}

//object { fleet scale (.1+.9*tclock/100)  translate <0,1,.9- 9*tclock/100 >}
//object { fleet scale .1 translate <0,1,.9 - .1*tclock >}
//3.5 -> -5 //7.5

box{-1,1 pigment{rgbt<1,1,1,1>} scale <30,3,.1> 
translate <-20,-3.11,0> rotate 1*z
//3.25
normal{ bumps 1 scale .05 scale<20,1,1>  translate -y*tclock*.01 
translate x*tclock*.005}
interior{ior 1.15}
}
