
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "metals.inc"           
#include "SolarTransit.inc"

#include "myskies.inc" 


#declare CameraX = 50;
#declare CameraY = 20;
#declare CameraZ = 0;
#declare CameraRot = 0;

#declare PoleTop = 10;


camera {
  location <CameraX, CameraY, CameraZ>  

  right x*1880/800
  
  rotate <0,CameraRot,0>
  
  look_at <0, PoleTop-5, 0>
}


// This is the cloudy sky code
#declare New_Sky = sky_sphere {My_Cloud}
sky_sphere {New_Sky rotate <0,ElapsedMinutesOfDay/1440*360,0>}                     // style borrowed from arches.pov .... basically just the S_Cloud2 texture
// End of the cloudy sky code  

#declare Label1X = -8.5;
#declare Label2X = -8.5;
#declare Label1Y = 0;
#declare Label1Z = 0;
#declare Label2Y = Label1Y -1;


#declare LabelSX = CameraX/8;
#declare LabelSY = CameraX/6;
#declare LabelSZ =0.3;

#declare LabelSystem = union {        
        
        text { ttf "crystal.ttf", concat("SolarTransit.inc - ", "a utility"), 2, 0
        translate <Label1X,Label1Y,Label1Z>
        pigment { color <1 - .85*HowMuchDayLight, 1 - .85*HowMuchDayLight,1 - .85*HowMuchDayLight,0,1+4*clock*(clock-1)> }
        finish {
        ambient 0.9
        diffuse 0.6
        phong 0.3
        phong_size 100
        }
        scale <LabelSX, LabelSY, LabelSZ>
        rotate <0, -90, 0>
        no_shadow
        }


        text { ttf "crystal.ttf", concat("By Edward Leibnitz: ", "copyright 2003"), 2, 0
        translate <Label2X,Label2Y,Label1Z>
        pigment { color <1 - .85*HowMuchDayLight, 1 - .85*HowMuchDayLight,1 - .85*HowMuchDayLight,0,1+4*clock*(clock-1)> }
        finish {  
        ambient 0.9
        diffuse 0.6
        phong 0.3
        phong_size 100
        }
        scale <LabelSX, LabelSY, LabelSZ>
        rotate <0, -90, 0>
        no_shadow
        }


}



#declare Ground = plane { y, 0

   pigment {
      color Gray80
   }   
   finish {
      ambient 0.3
      diffuse 0.8
   }

}

#declare Pole = cylinder {
  <0,0,0>,  <0,10,0>,  0.5
  
material {
  texture {
    pigment { color rgbt <0.5, 0.5, 0.7, 0.5> }
    finish { diffuse 0.2 specular 0.6 }
  }
  interior {
    ior 1.5
  }
}
  texture { Silver1 }   
}



#declare clockdot = 

sphere {<18,0,0>,0.25 
   color <0,0,0>
   finish {
      ambient 0.3
      diffuse 0.8
   }
}

#declare clockface = union {

object {clockdot rotate<0,360 * 0/12,0>}
object {clockdot rotate<0,360 * 1/12,0>}
object {clockdot rotate<0,360 * 2/12,0>}
object {clockdot rotate<0,360 * 3/12,0>}
object {clockdot rotate<0,360 * 4/12,0>}
object {clockdot rotate<0,360 * 5/12,0>}
object {clockdot rotate<0,360 * 6/12,0>}
object {clockdot rotate<0,360 * 7/12,0>}
object {clockdot rotate<0,360 * 8/12,0>}
object {clockdot rotate<0,360 * 9/12,0>}
object {clockdot rotate<0,360 * 10/12,0>}
object {clockdot rotate<0,360 * 11/12,0>}

text { ttf "crystal.ttf", concat("N"), 2, 0
        translate <0,0,0>
        pigment { color <1 - .85*HowMuchDayLight, 1 - .85*HowMuchDayLight,1 - .85*HowMuchDayLight> }
        finish {
        ambient 0.9
        diffuse 0.6
        phong 0.3
        phong_size 100
        }
        scale <10,10, 1>
        rotate <0, -90,90>

        translate <27,0.5,-1.6>
        no_shadow
        }


text { ttf "crystal.ttf", concat("E"), 2, 0
        pigment { color <1 - .85*HowMuchDayLight, 1 - .85*HowMuchDayLight,1 - .85*HowMuchDayLight> }
        finish {
        ambient 0.9
        diffuse 0.6
        phong 0.3
        phong_size 100
        }
        scale <10,10, 1>
        rotate <0, -90,90>

        translate <2.5,0.5,-22>
        rotate <0,180,0>

        translate <-1,0,-43>

        no_shadow
        }


text { ttf "crystal.ttf", concat("S"), 2, 0
        translate <0,0,0>
        pigment { color <1 - .85*HowMuchDayLight, 1 - .85*HowMuchDayLight,1 - .85*HowMuchDayLight> }
        finish {
        ambient 0.9
        diffuse 0.6
        phong 0.3
        phong_size 100
        }
        scale <10,10, 1>
        rotate <0, -90,90>

        translate <-21,0.5,-1.25>

        rotate <0,180,0>

        translate <-48,0,0.5>
        no_shadow
        }


text { ttf "crystal.ttf", concat("W"), 2, 0
        pigment { color <1 - .85*HowMuchDayLight, 1 - .85*HowMuchDayLight,1 - .85*HowMuchDayLight> }
        finish {
        ambient 0.9
        diffuse 0.6
        phong 0.3
        phong_size 100
        }
        scale <10,10, 1>
        rotate <0, -90,90>

        translate <3,0.5,-24>
        rotate <0,180,0>
        no_shadow

        }



}




object {LabelSystem   rotate <0,CameraRot,0> translate <0,PoleTop + 10 ,0>}
Ground
Pole
TheSun

object {clockface scale <CameraX/60,CameraX/60,CameraX/60>}
