/* you may have to increase your max_trace_level if you have
some semi-tranparent objects behind the explosion, like the Galaxy Objects
from Chris Colefax's Galaxy Include File */
global_settings { max_trace_level 40 }


/* Globals parametres for explose.inc */

/* Exp_Nb_Blobs_1, Exp_Nb_Blobs_2 define the numbers of elements used
for the explosion. Don't set them lower than 3. The higher they are, 
the slower it renders.
Default are 4 and 3.
A good start: */
#declare Exp_Nb_Blobs_1 = 5;
#declare Exp_Nb_Blobs_2 = 4;

/* Seed for randomness */
#declare Exp_Seed = 36520;

/* Exp_Test: replace the medias with a red pigment if on */
#declare Exp_Test=off;

/* Parameters for the medias:
Exp_Method: the method for the media
	1: official POV method
	2: Superpatch method (???)
	3: other method (other patch)
Method 2, 3 are available in MegaPov
Exp_Roughness: the higher, the lower quality, the faster render (intervals = 12 - Roughness)
Exp_Min_Samples, Exp_Max_Samples. Leave at 1 if you use method 2 or 3 (MegaPov only) */
#declare Exp_Method = 2;
#declare Exp_Roughness = 7;
#declare Exp_Max_Samples = 1;
#declare Exp_Min_Samples = 1;
#include "explose.inc"



camera {
	location <0,3,-10>
	right x*4/3
	up y
	angle 40
	look_at <0,0,0>
}


Explosion(
	<0,0,0>,	// position of the explosion
	1.5,		// radius of the explosion
	0.2,		// clock value for start of explosion
	0.8,		// clock value for end of explosion
	40,			// emission value for "fire"
	5,			// emission value for "smoke" 
	15,			// absorption value for "fire"
	6,			// number of "streaks"
	on			// enable shockwava
)

