// Persistence of Vision Ray Tracer Scene Description File
// File: wheel.pov
// Vers: 3.5
// Desc: Start-scene of "topspeed - no risk"
// Date: Nov 2002
// Auth: Dirk Dittmann
//
// COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//

#version 3.5;

#declare camera_type = 3;

#declare Test       = off;
#declare ExpTest    = off;

#declare show_fog   = on;
#declare show_rock  = on;
#declare show_sky   = on;
#declare show_road  = on;
#declare show_car   = on;
#declare show_palms = on;
#declare show_stone = on;
#declare make_stone = off;
#declare stone_file = "FlyStones.inc"
#declare show_emisson = on;

#declare show_Profil = on;
#declare show_Cockpit= off;
#declare show_Driver = off;

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "golds.inc"
#include "skies.inc"
#include "functions.inc"
#include "ts-textures.inc"

#default {finish {ambient 0.15}}

global_settings {
  max_trace_level 120
    assumed_gamma 2.4
}

// ----------------------------------------

#switch (camera_type)
#case (3)
    #declare camera_location        = <-12.3, 1.2 , 4.5>; 
    #declare camera_direction       = <0, 0, 2.6>;
    #declare camera_sky             = <0, 1, 0>;
    #declare camera_right           = <image_width/image_height,0,0>;
    #declare camera_look_at         = <-6.0, 0.6,  3>;
    #break
#end

camera {
    location        camera_location 
    direction       camera_direction
    sky             camera_sky  
    right           camera_right  
    look_at         camera_look_at
}

// ----------------------------------------

#if (show_fog)
    fog {
        fog_type 2
        distance  8000
        color rgbt < 0.835, 0.835, 0.835,  0 >
        fog_alt  30
        fog_offset 50
    }
#end

#if (show_sky)
    #include "ts-sky.inc"
#else
    background { rgb <0.6,0.7,1.0> }
#end

// ----------------------------------------

light_source {
        < -0.6, 0.54, 0.83>*150000
        SunCol2*1.5
}
light_source {
        camera_location
        SunCol2*0.50
        shadowless
}

// ----------------------------------------

#include "ts-params.inc"

#declare DriveSplineClock = 6*clock;
#declare SpeedSplineClock = 6*clock;

#declare SpeedSpline =
spline {
   cubic_spline
   -1, < -1, 0,  0>,
   00, < 0,  0,  0>,
   01, < 1,  0,  0.25>,
   02, < 2,  0,  0.75>,
   03, < 3,  0,  1.5>,
   04, < 4,  0,  2.0>,
   05, < 5,  0,  2.25>,
   06, < 6,  0,  2.5>,
   07, < 7,  0,  2.75>
}

#declare DriveSpline =
spline {
   cubic_spline
   -1, <0, 0, -0.3>,
   00, < 0, 0, 0>,
   01, < 0.05, 0, 0.25>,
   02, < 0.1, 0, 0.25>,
   03, <0.2, 0, -0.15>,
   04, <0.4, 0, 0>,
   05, <1.2, 0, 0>,
   06, <2.4, 0, 0>,
   07, <4.8, 0, 0>,
}

#local Point1= DriveSpline(DriveSplineClock);
#local Point2= SpeedSpline(SpeedSplineClock);
#declare AlphaCobra = degrees(asin(Point1.z/Achs_Abstand));
#declare xCobra = sqrt((Achs_Abstand*Achs_Abstand)-(Point1.z*Point1.z)) + Point1.x - Achs_Abstand ;

#switch(clock)
#range (0,0.1)
    #declare lclock = 1;
#break
#range (0.1,0.5)
    #declare lclock = (clock-0.1)*(1/0.4);
    #declare lclock = 1-(sin((lclock - .5) * pi) / 2 + .5);
#break
#range (0.5,1)
    #declare lclock = 0;
#end

#declare Vorderrad_Rotation =  xCobra/(Vorderrad_Durchmesser*pi)*360;
#declare Hinterrad_Rotation =  2*Point2.z*360;

#declare Lenk_Bewegung      =   -lclock*10;

// ----------------------------------------

#if (show_car)
    #include "cobra_raeder.inc"
    #include "cobra_body.inc"

    #declare Raeder =
    union {
    //    object {Vorderrad          rotate -z*Vorderrad_Rotation rotate y*Lenk_Bewegung translate <0,Vorderrad_Durchmesser/2,-Rad_Abstand_vorne/2>}
        object {Vorderrad rotate y*180 rotate -z*Vorderrad_Rotation rotate y*Lenk_Bewegung translate <0,Vorderrad_Durchmesser/2, Rad_Abstand_vorne/2>}    
    //    object {Hinterrad          rotate -z*Hinterrad_Rotation translate <-Achs_Abstand,Hinterrad_Durchmesser/2,-Rad_Abstand_hinten/2>}
        object {Hinterrad rotate y*180 rotate -z*Hinterrad_Rotation translate <-Achs_Abstand,Hinterrad_Durchmesser/2, Rad_Abstand_hinten/2>}
    }   

    #declare Cobra =
    union{
        object {Raeder}
        object {cobraBody_T0}
        rotate y*AlphaCobra
        translate x*xCobra
        translate y*-.1
    }
    object {Cobra}
#end

// ----------------------------------------

#if(show_rock) 
  #declare filename = "Rocks.tga"
  object {
      height_field {
          tga filename
          texture {TerrainTex2}
      }  
      translate <-0.5,0,-0.5>
      scale  <HF_Length, HF_High,HF_Length>
      translate -y*Water_Level
      translate <4.5*HF_Length,0*HF_High,-0.2*HF_Length>
  } 
#end

// ----------------------------------------

#declare R1 = 0.015;
#if((make_stone)|(show_stone))
    #declare Anzahl = 1200;
    #declare Seed = seed(12378);
    #include "make_stones.inc"
#end

// ----------------------------------------

#if(show_palms)
    #include "palms.inc"
    #declare Seed = seed(486);                     
    #declare cnt=0;
    #while (cnt<50)  
        #declare PalmScale = 1.5+(rand(Seed)-0.5);
        #declare PalmPosY = 0;
        #declare PalmPosX = 30*cnt+1500; 
        #while (abs(PalmPosY)<10)
            #declare PalmPosY = (rand(Seed)-0.5)*80;  
        #end
        #declare PalmPos = <PalmPosX,0,PalmPosY>;
        palmtree(PalmScale,PalmPos)
    #declare cnt=cnt+1;
    #end
#end  


// ----------------------------------------
#if (show_road)
    #local sclockT = 80;
    #local sclock = clock*sclockT;
    #declare Cnt = 0;
    #declare PlaneCut = 
    union {
        #while(Cnt<sclock)
            #local Pos = DriveSpline(6*Cnt/sclockT);
            #declare AlphaC = asin(Pos.z/Achs_Abstand);
            #local PosX = Pos.x  - Achs_Abstand+(Rad_Abstand_hinten/2)*sin(AlphaC);
            #local PosZ = Pos.z  + (Rad_Abstand_hinten/2)*cos(AlphaC);
            sphere {
                0,Hinterrad_Durchmesser/2
                scale <1,1,1.5>
                translate <PosX,(0.5*Hinterrad_Durchmesser-0.03),PosZ>
            }
            #declare Cnt = Cnt+1;
        #end
    }
    
    plane { y, 0 texture {Teer0} translate y*-0.0001}

    difference {
            plane { y, 0 }
            object { PlaneCut  pigment {Clear}}  
            texture {Teer2 scale 400}
    }

#end

// ----------------------------------------

//Exp_Test

#declare Roughness  = 9;
#declare MinSamples = 1;
#declare MaxSamples = 5;
#declare Seed = seed(4925);

#declare Emiss = 0.4;
#declare Absorb = 0.2;
#declare BozoDens  = rgb 0.8;

#if(show_emisson)
    #declare TranEmiss1 = <-5.05,-0.17+Vorderrad_Durchmesser/2,3.1>;
    #declare TranEmiss1 = vrotate(TranEmiss1,<0,AlphaCobra,0,>);
    #declare TranEmiss1 = TranEmiss1+<xCobra,-0.1,0>;
    #declare TranEmiss2 = TranEmiss1+<-3.2, 0.3, 2.4>;
    #declare ScaleEmiss1 = 0.3;
    #declare ScaleEmiss2 = 0.7;
    #declare ClockEmiss   = mod((40*clock),1);
    #declare ClockEmiss1  = mod((ClockEmiss+0.0),1);
    #declare ClockEmiss2  = mod((ClockEmiss+0.125),1);
    #declare ClockEmiss3  = mod((ClockEmiss+0.25),1);
    #declare ClockEmiss4  = mod((ClockEmiss+0.375),1);
    #declare ClockEmiss5  = mod((ClockEmiss+0.5),1);
    #declare ClockEmiss6  = mod((ClockEmiss+0.625),1);
    #declare ClockEmiss7  = mod((ClockEmiss+0.75),1);
    #declare ClockEmiss8  = mod((ClockEmiss+0.825),1);
        
  #declare Enission = 
    interior {
      media {
        emission Emiss
        method 1
        intervals (12-Roughness)
        samples MinSamples, MaxSamples
        confidence .9
        variance 1/255
        density {
          spherical
          cubic_wave
          color_map {
            [ 0   rgb <0, 0, 0>     ]
            [ 0.3 rgb <0.3, 0.3, 0.3> ]
            [ 0.7 rgb <0.7, 0.7, 0.7>   ]
            [ 1   rgb <0.9, 0.9, 0.9> ]
          }
          scale <.3, .7, .7>
        }
      }
      media {
        emission Emiss
        absorption Absorb
        method 1
        intervals (12-Roughness)
        samples MinSamples, MaxSamples
        confidence .9
        variance 1/255
        density {
          spherical
          cubic_wave
          density_map {
            [ 0.0 rgb 0    ]
            [ 0.2 BozoDens ]
            [ 1.0 BozoDens ]
          }
        }
        scale <1.3,.8,.8>
      }
  }


    sphere {
        0,1.0
        pigment { color rgbt<1,1,1,1> }
        interior { Enission }
        hollow
        rotate rand(Seed)*29676*z
        rotate rand(Seed)*84425*z
        scale ScaleEmiss1+(ScaleEmiss2-ScaleEmiss1)*pow(ClockEmiss1,2)
        translate (TranEmiss1+(TranEmiss2-TranEmiss1)*ClockEmiss1)
    }
    sphere {
        0,1.0
        pigment { color rgbt<1,1,1,1> }
        interior { Enission }
        hollow
        rotate rand(Seed)*29676*z
        rotate rand(Seed)*84425*z
        scale ScaleEmiss1+(ScaleEmiss2-ScaleEmiss1)*pow(ClockEmiss2,2)
        translate (TranEmiss1+(TranEmiss2-TranEmiss1)*ClockEmiss2)
    }
    sphere {
        0,1.0
        pigment { color rgbt<1,1,1,1> }
        interior { Enission }
        hollow
        rotate rand(Seed)*29676*z
        rotate rand(Seed)*84425*z
        scale ScaleEmiss1+(ScaleEmiss2-ScaleEmiss1)*pow(ClockEmiss3,2)
        translate (TranEmiss1+(TranEmiss2-TranEmiss1)*ClockEmiss3)
    }    
    sphere {
        0,1.0
        pigment { color rgbt<1,1,1,1> }
        interior { Enission }
        hollow
        rotate rand(Seed)*29676*z
        rotate rand(Seed)*84425*z
        scale ScaleEmiss1+(ScaleEmiss2-ScaleEmiss1)*pow(ClockEmiss4,2)
        translate (TranEmiss1+(TranEmiss2-TranEmiss1)*ClockEmiss4)
    }  
    sphere {
        0,1.0
        pigment { color rgbt<1,1,1,1> }
        interior { Enission }
        hollow
        rotate rand(Seed)*29676*z
        rotate rand(Seed)*84425*z
        scale ScaleEmiss1+(ScaleEmiss2-ScaleEmiss1)*pow(ClockEmiss5,2)
        translate (TranEmiss1+(TranEmiss2-TranEmiss1)*ClockEmiss5)
    }
    sphere {
        0,1.0
        pigment { color rgbt<1,1,1,1> }
        interior { Enission }
        hollow
        rotate rand(Seed)*29676*z
        rotate rand(Seed)*84425*z
        scale ScaleEmiss1+(ScaleEmiss2-ScaleEmiss1)*pow(ClockEmiss6,2)
        translate (TranEmiss1+(TranEmiss2-TranEmiss1)*ClockEmiss6)
    }
    sphere {
        0,1.0
        pigment { color rgbt<1,1,1,1> }
        interior { Enission }
        hollow
        rotate rand(Seed)*29676*z
        rotate rand(Seed)*84425*z
        scale ScaleEmiss1+(ScaleEmiss2-ScaleEmiss1)*pow(ClockEmiss7,2)
        translate (TranEmiss1+(TranEmiss2-TranEmiss1)*ClockEmiss7)
    }        
    sphere {
        0,1.0
        pigment { color rgbt<1,1,1,1> }
        interior { Enission }
        hollow
        rotate rand(Seed)*29676*z
        rotate rand(Seed)*84425*z
        scale ScaleEmiss1+(ScaleEmiss2-ScaleEmiss1)*pow(ClockEmiss8,2)
        translate (TranEmiss1+(TranEmiss2-TranEmiss1)*ClockEmiss8)
    } 
#end