#declare PalmColor1 = <0.86,0.56,0.44>;
#declare PalmColor2 = <0.4,0.3,0>;

#declare FrondColor1= <0.65,1,0.3>*0.3;
#declare FrondColor2= <0.65,1,0.3>*0.2;

#declare FrondTex =
texture{
  pigment {
    gradient z 
    turbulence <0.3,0.3,0.3>    
    color_map {
      [0.0 rgb FrondColor1]
      [0.2 rgb FrondColor1]          
      [0.2 rgb FrondColor2]
      [0.3 rgb FrondColor2]
      [0.3 rgb FrondColor1]
      [0.5 rgb FrondColor1]
      [0.5 rgbt<1,1,1,1>]
      [1   rgbt<1,1,1,1>]
    }
  }
}   
                    
#declare TrunkTex =
texture{
  pigment {
    gradient y 
    turbulence 0.3    
    color_map {
        [0.0 rgb PalmColor1]
        [0.5 rgb PalmColor1]
        [0.5 rgb PalmColor2]
        [1   rgb PalmColor2]
    }
  }
}

#declare FrondScale=3.2;      

#declare PalmFrond=
difference{  
    union{ 
        sphere {
            <0,1,0>, 1  
            scale <.5,FrondScale,1.5> 
            clipped_by { plane { -y, -0.5 } }
        }
        torus{.95,.05 rotate z*90 translate <0,1,0> scale <.5,FrondScale,1.5> pigment {rgb FrondColor1}}
    }
    box{<-15,-15,-15><15,15,0> pigment{Clear}}
    cylinder{<-1,1,0><1,1,0> 1 scale <1,FrondScale,.7> pigment{Clear}}
}

#macro palmtree(PalmScale,PalmPosition)
  union {
    torus { 
        30, 0.35
        clipped_by { box { <-15,-5, 0>, <0,5,50> } }
        rotate z*90  
        translate -z*30
        texture{TrunkTex scale 0.3}
        rotate y*360*rand(Seed)
    }
    sphere {0, 0.35 texture{TrunkTex scale 0.3}}
    #declare Cnt=0;
    #while (Cnt<18)
        object { 
            PalmFrond         
            rotate -x*(rand(Seed)*120+30) 
            texture{
                FrondTex 
                rotate x*(rand(Seed)*6) 
                scale 0.25
            } 
            rotate y*rand(Seed)*360 scale (rand(Seed)*.4+.6)
        } 
        #declare Cnt=Cnt+1;
    #end 
    scale PalmScale 
    translate y*15*PalmScale
    translate PalmPosition
  }
#end