// OBJECT EXPLODER: SAMPLE FILE 3
// ******************************
// This scene illustrates how adjusting the particle object of an
// explosion via the "particle_object" variable affects the Object
// Exploder output.

// CAMERA AND LIGHTS
   camera {location <5, 10, -15> look_at <0, 0, 0> angle 50}
   light_source {<-10, 0, -50> rgb 1}
   light_source {<20, 40, 10> rgb 1}

// EXPLOSION PARAMETERS
   #declare explode_object = sphere {<0, 0, 0>, 1
      pigment {bozo color_map {[0 rgb <0, 0, 1>] [1 rgb <1, 0, 1>]}}
      finish {phong .3 phong_size 35}}

   #declare particle_texture = texture {
      pigment {bozo color_map {[0 rgb <.2, .2, .5>] [1 rgb <.5, .2, .5>]}}
      finish {phong .2 phong_size 25}}

   #declare explode_clock = .1;
   #declare object_hollow = false;

// DEFAULT PARTICLE OBJECT: box {<-.5, -.5, -.5>, <.5, .5, .5>}
   object {#include "Explode.inc" translate <-5, 0, 0>}

// PARTICLE OBJECT EXAMPLE 2: sphere
   #declare particle_object = sphere {<0, 0, 0>, .5}
   object {#include "Explode.inc"}

// PARTICLE OBJECT EXAMPLE 3: cone
   #declare particle_object = cone {<0, -.75, 0>, .75, <0, .5, 0>, 0}
   object {#include "Explode.inc" translate <5, 0, 0>}
