// OBJECT EXPLODER: SAMPLE FILE 2
// ******************************
// This scene illustrates how adjusting the particle resolution of an
// explosion via the "particle_res" variable affects the Object Exploder
// output.

// CAMERA AND LIGHTS
   camera {location <5, 10, -15> look_at <0, 0, 0> angle 50}
   light_source {<-10, 0, -50> rgb 1}
   light_source {<20, 40, 10> rgb 1}

// EXPLOSION PARAMETERS
   #declare explode_object = sphere {<0, 0, 0>, 1
      pigment {bozo color_map {[0 rgb <0, .5, 0>] [1 rgb <1, 1, 0>]}}
      finish {phong .3 phong_size 35}}

   #declare particle_texture = texture {
      pigment {bozo color_map {[0 rgb <.2, .4, .2>] [1 rgb <.5, .5, .2>]}}
      finish {phong .2 phong_size 25}}

   #declare explode_clock = .1;
   #declare object_hollow = false;

// DEFAULT PARTICLE RESOLUTION <3, 3, 3>
   object {#include "Explode.inc" translate <-5, 0, 0>}

// PARTICLE RESOLUTION EXAMPLE 2
   #declare particle_res = <6, 1, 6>;
   object {#include "Explode.inc"}

// PARTICLE RESOLUTION EXAMPLE 3
   #declare particle_res = <2, 12, 2>;
   object {#include "Explode.inc" translate <5, 0, 0>}
