#include "devmath.inc"
#include "ship4.pov"
#include "ship2.pov"
union{
#include "terrain.pov"
scale <-1,1,1>
}

#declare Clock=clock;
#declare LeftThrust=0;
#declare RightThrust=0;
#declare GoodShipRot=<0,0,0>;

#switch(Clock)
	#range(0,0.5)
		#declare LeftThrust=1;
		#declare GoodShipRot=x*Smooth((Clock-0)/0.5)*405;
	#break
	#range(0.5,1)
		#declare RightThrust=1;
		#declare GoodShipRot=x*(405-Smooth((Clock-0.5)/0.5)*45);
	#break	                                             
#end
	
#declare GoodShipHeading=0;//It is probably unnecessary to break 
																 //this into two variables, 
																 //but I don't know any matrix math,
																 //so this is simpler.
#declare GoodShipPos=<10000,0,3000>+x*Clock*60000;
								
camera{
	location <0,0,5000>
	sky z
	look_at <1000,0,5000>
}

object{
	ship2(1,0,LeftThrust,RightThrust)
	//rotate z*180
	rotate GoodShipRot
	rotate GoodShipHeading
	translate GoodShipPos
}