#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"
#include "ConversionUnits.inc"



//
// ********  MATERIALS  *******
//

#include "warriorTextures.inc"
// #declare ScalingFactor = 1/20 * 1.6;
#declare ScalingFactor = 1.8/(2.0665+26.72);
//#debug concat( "Scaling facor = ", str( ScalingFactor, 4, 4), "\n")


//
// ********  OBJECTS  *******
//

#declare Eye = 
    union { // Eye
      sphere { // Sphere015
        <0,0,0>,1
        material {
          CorneaColor
        }
        scale <0.094698, 0.025134, 0.089347>
        translate  <2.972814, -0.412033, 0.091453>
      }
      sphere { // Sphere016
        <0,0,0>,1
        material {
          IrisColor
        }
        scale <0.157399, 0.055729, 0.157399>
        translate  <2.972814, -0.353171, 0.090988>
      }
      sphere { // Sphere017
        <0,0,0>,1
        material {
          EyeballColor
        }
        scale 0.38831
        translate  <2.960581, 0.0, 0.110104>
      }
    }  
    
#declare Torso =
    union { // Torso
      sphere { // CodPiece
        <0,0,0>,1
        material {
          BumpMetal
        }
        scale <-1.628465, -2.478854, -2.91127>
        rotate -180.0*z
        translate  <-0.01425, 0.0, -10.868242>
      }
      cylinder { // Cylndr016
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <3.834514, 2.228245, 0.725753>
        translate  <-0.18476, 0.0, -11.110879>
      }
      cylinder { // Cylndr015
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <4.019388, 2.228245, 0.679534>
        translate  <-0.18476, 0.0, -10.610879>
      }
      cylinder { // Cylndr014
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <4.065606, 2.228245, 0.679534>
        translate  <-0.18476, 0.0, -10.110879>
      }
      cylinder { // Cylndr013
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <4.204261, 2.228245, 0.679534>
        translate  <-0.18476, 0.0, -9.610879>
      }
      cylinder { // Cylndr012
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <4.204261, 2.275816, 0.91739>
        translate  <-0.09238, 0.0, -6.777644>
      }
      cylinder { // Cylndr011
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <4.204261, 2.323388, 0.822248>
        translate  <-0.09238, 0.0, -7.955096>
      }
      cylinder { // Cylndr010
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <4.204261, 2.275816, 0.70332>
        translate  <-0.09238, 0.0, -8.547476>
      }
      cylinder { // Cylndr009
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <4.204261, 2.228245, 0.679534>
        translate  <-0.18476, 0.0, -9.110879>
      }
      cylinder { // Cylndr008
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <4.111881, 1.82389, 0.648741>
        translate  <-0.18476, -0.023786, -4.90133>
      }
      cylinder { // Cylndr007
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <4.204261, 2.180674, 0.822248>
        translate  <-0.18476, -0.023786, -6.091113>
      }
      cylinder { // Cylndr006
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <3.957915, 1.60982, 0.767669>
        translate  <-0.18476, 0.0, -4.450408>
      }
      cylinder { // Cylndr005
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <4.204261, 2.275816, 0.70332>
        translate  <-0.09238, 0.023786, -7.31172>
      }
      cylinder { // Cylndr004
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <4.173468, 1.966604, 0.672527>
        translate  <-0.18476, 0.0, -5.450408>
      }
      sphere { // Sphere003
        <0,0,0>,1
        material {
          BumpMetal
        }
        scale <3.925361, 2.284154, 4.6865>
        translate  <-0.030793, -0.023786, -7.299082>
      }
      cylinder { // Cylndr003
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <1.355934, 1.261642, 9.463774>
        rotate <180.0, 89.955017, 180.0>
        translate  <-4.772957, 0.0, -3.910745>
      }
    }

#ifndef (Man_LeftEyeAngle)
  #declare Man_LeftEyeAngle = 0;
#end
#ifndef (Man_RightEyeAngle)
  #declare Man_RightEyeAngle = 0;
#end
  
  
// ===========================================================
//
//               Warrior
//
// ===========================================================
#macro Warrior(
    LeftShoulderAngle1,   // Rotate around the shoulder along the direction of the arm
    LeftShoulderAngle2,   // Rotate around the sholder parallel around the line between the shoulders
    LeftElbowAngle,       // Uplift elbow. Normal range 0 -> 160
    LeftHipAngle,         // Angle of leg from hip. Normal range -10->100
    LeftKneeAngle,        // Angle of lower leg via knee. Normal range 0->95
    LeftAnkleAngle        // Angle of foot wrt ankle. Normal range 0-90
    RightShoulderAngle1,  // Rotate around the shoulder along the direction of the arm
    RightShoulderAngle2,  // Rotate around the sholder parallel around the line between the shoulders
    RightElbowAngle,      // Uplift elbow. Normal range 0 -> 160
    RightHipAngle,        // Angle of leg from hip. Normal range -10->100
    RightKneeAngle,       // Angle of lower leg via knee. Normal range 0->95
    RightAnkleAngle       // Angle of foot wrt ankle. Normal range 0-90
    )
  union {
    sphere { // Sphere018
      <0,0,0>,1
      texture {
        SkinTexture
      }
      scale 0.363842
      translate  <0.048935, -1.380578, -0.931087>
    }
    
    
    cylinder { // Cylndr030
      <0,0,1>, <0,0,0>, 1 
      texture {
        SkinTexture
      }
      scale <0.302673, 0.149179, 1.016073>
      rotate -21.906935*x
      translate  <0.036701, -1.605323, -0.950417>
    }
    
    object {
      Eye
      rotate Man_RightEyeAngle
      translate  <-2.361124, -1.123726, 0.055818>
    }
    object {
      Eye
      rotate Man_LeftEyeAngle
      translate  <-3.486634, -1.123726, 0.055818>
    }
    
    
    difference { // HeadTop
      sphere { // TopHeadSphere
        <0,0,0>,1
        texture {
          SkinTexture
        }
        scale 1.617718
      }
      sphere { // RightEyeSocket
        <0,0,0>,1
        scale <0.626228, 0.61389, 0.274473>
        translate  <-0.489352, -1.126485, 0.166435>
      }
      sphere { // LeftEyeSocket
        <0,0,0>,1
        scale <0.626228, 0.61389, 0.274473>
        translate  <0.550521, -1.126485, 0.154201>
      }
      texture {
        SkinTexture
      }
    }
    
    
    cylinder { // Neck
      <0,0,1>, <0,0,0>, 1 
      texture {
        SkinTexture
      }
      scale <0.888003, 0.81533, 2.050767>
      translate  <0.0, 0.166203, -3.252405>
    }
    
    object { Torso }    
    union {
      union {
        union {
          superellipsoid { // RightFoot
            <0.2, 0.2>
            material {
              BumpMetal
            }
            scale <1.204078, 1.839299, 0.530881>
            translate  <-2.267408, -1.362827, -26.20056+25.723351>
          }
          sphere { // RightAnkle
            <0,0,0>,1
            material {
              BumpMetal
            }
            scale <1.156373, 1.0, 0.851717>
            translate  <-2.267408, 0.0, 0.0>
          }
          rotate RightAnkleAngle*x
          translate (-25.723351+18.842941)*z
        }  
        cone { // RightLowerLeg
          <0,0,0>, 0.8, <0,0,1>, 1.0
          material {
            BumpMetal
          }
          scale <1.455861, 1.333935, 6.629426>
          translate  <-2.267408, 0.0, -25.645164+18.842941>
        }
        
        
        sphere { // RIghtKneeJoint
          <0,0,0>,1
          material {
            BumpMetal
          }
          scale <1.625492, 1.420576, 1.078187>
          translate  <-2.267408, 0.0, 0.0>
        }
        rotate RightKneeAngle*x
        translate (-18.842941+12.155419)*z
      }
      cone { // RightThigh
        <0,0,0>, 0.9, <0,0,1>, 1.0
        material {
          BumpMetal
        }
        scale <1.673197, 1.524755, 6.785799>
        translate  <-2.267408, 0.0, -18.686568+12.155419>
      }
      
      
      sphere { // RightHipJoint
        <0,0,0>,1
        material {
          BumpMetal
        }
        scale <1.785712, 1.420576, 1.556157>
        translate  <-2.264698, 0.0, 0.0>
      }
      rotate RightHipAngle*-x
      translate (-12.155419)*z
    }    
    
    union {    
      union {
        sphere { // RightHand
          <0,0,0>,1
          material {
            BumpMetal
          }
          translate  <-5.252148, 0.0, -13.957764+9.065352>
        }
        #ifdef (RightHandTool)
          object { RightHandTool translate  <-5.252148, 0.0, -13.957764+9.065352> }
        #end    
        cone { // RightForeArm
          <0,0,0>, 0.9, <0,0,1>, 1.0
          material {
            BumpMetal
          }
          scale <0.761475, 1.09541, 4.327719>
          translate  <-5.176452, 0.0, -13.634406+9.065352>
        }
        
        sphere { // RightElbowJoint
          <0,0,0>,1
          material {
            BumpMetal
          }
          scale <0.952295, 1.238525, 1.0>
          translate  <-5.108254, 0.0, 0.0>
        }
        rotate RightElbowAngle * -x
        translate -9.065352*z
        translate -<-4.80375, 0.0, -3.941538> 
      }  
      cylinder { // RightArm
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <0.998441, 1.204416, -4.766763>
        translate  <-5.108254, 0.0, -4.17294> - <-4.80375, 0.0, -3.941538>
      }
      #ifdef (RightArmTool)
        object { RightArmTool translate <-5.108254, 0.0, -4.17294> - <-4.80375, 0.0, -3.941538> } 
      #end
      sphere { // RightShoulder
        <0,0,0>,1
        material {
          BumpMetal
        }
        scale 1.369519
        translate  <0.0, 0.0, 0.0>
      }
      rotate RightShoulderAngle2 * x
      rotate RightShoulderAngle1 * -z
      translate <-4.80375, 0.0, -3.941538>
    }    
    
    
    #declare RotSweep001 = lathe {
      cubic_spline
      13  // control points
      <-0.015453, 1.913907>,
      <0.017082, 1.913539>,
      <0.718411, 1.709104>,
      <1.558061, 0.610821>,
      <1.779287, -1.049088>,
      <1.885795, -2.293202>,
      <2.09345, -2.366091>,
      <1.961631, -2.190117>,
      <1.828869, -0.824038>,
      <1.576771, 0.707296>,
      <0.791792, 1.733891>,
      <0.0164, 1.98177>,
      <0.006623, 1.986019>
      rotate <90,0,90>
      material {
        BumpMetal
      }
    }
    difference { // Helmet
      object { RotSweep001 }
      box { // Cube001
        <-1, -1, -1>, <1, 1, 1>
        scale <0.788122, 1.0, 1.070626>
        translate  <0.0, -1.705917, -1.641207>
      }
      cylinder { // Cylndr002
        <0,0,1>, <0,0,0>, 1 
        scale <0.265489, 0.336116, 0.998525>
        rotate <89.899055, 0.000042, 0.023815>
        translate  <0.536758, -0.951424, 0.108537>
      }
      box { // Cube003
        <-1, -1, -1>, <1, 1, 1>
        scale <0.265489, 1.0, 0.929374>
        translate  <0.522633, -1.688778, -0.822185>
      }
      box { // Cube002
        <-1, -1, -1>, <1, 1, 1>
        scale <0.265489, 1.0, 0.929374>
        translate  <-0.522633, -1.688778, -0.836311>
      }
      cylinder { // Cylndr001
        <0,0,1>, <0,0,0>, 1 
        scale <0.265489, 0.336116, 0.998525>
        rotate <89.899055, 0.000042, 0.023815>
        translate  <-0.522633, -0.951424, 0.094412>
      }
      material {
        BumpMetal
      }
      translate  <0.02825, 0.0, 0.084751>
    }
    
    
    union {    
      union {    
        sphere { // LeftHand
          <0,0,0>,1
          material {
            BumpMetal
          }
          translate  <5.108254, 0.0, -13.81387+8.926697>
        }
        #ifdef (LeftHandTool)
          object { LeftHandTool translate  <5.108254, 0.0, -13.81387+8.926697> }
        #end    
        
        
        cone { // LeftForeArm
          <0,0,0>, 0.9, <0,0,1>, 1.0
          material {
            BumpMetal
          }
          scale <0.761475, 1.09541, 4.327719>
          translate  <5.084016, 0.0, -13.680624+8.926697>
        }
           
        #ifdef (LeftArmTool)
          object { LeftArmTool translate <5.084016, 0.0, -13.680624+8.926697> } 
        #end
      
        sphere { // LeftElbowJoint
          <0,0,0>,1
          material {
            BumpMetal
          }
          scale <0.952295, 1.238525, 1.0>
          translate  <5.059777, 0.0, 0.0>
        }
        rotate LeftElbowAngle * -x
        translate -8.926697*z
        translate <-4.61899, 0, 3.910745>
      }    
      
      cylinder { // LeftArm
        <0,0,1>, <0,0,0>, 1 
        material {
          BumpMetal
        }
        scale <0.998441, 1.204416, -4.766763>
        translate  <4.921123-4.61899, 0.0, -4.080503+3.910745>
      }
      sphere { // LeftShoulder
        <0,0,0>,1
        material {
          BumpMetal
        }
        scale 1.369519
        translate  <0.0, 0.0, 0.0>
      }
      rotate LeftShoulderAngle2 * x
      rotate LeftShoulderAngle1 * z
      translate -3.910745*z
      translate 4.61899*x  
    }      
      
    union {    
      sphere { // LeftHipJoint
        <0,0,0>,1
        material {
          BumpMetal
        }
        scale <1.785712, 1.420576, 1.556157>
        translate  <2.21848, 0.0, 0.0>
      }
      
      
      cone { // LeftThigh
        <0,0,0>, 0.9, <0,0,1>, 1.0
        material {
          BumpMetal
        }
        scale <1.673197, 1.524755, 6.785799>
        translate  <2.267408, 0.0, -18.921127+12.109201>
      }
      
      union {
        sphere { // LeftKneeJoint
          <0,0,0>,1
          material {
            BumpMetal
          }
          scale <1.625492, 1.420576, 1.078187>
          translate  <2.267408, 0.0, 0.0>
        }
        
        
        cone { // LeftLowerLeg
          <0,0,0>, 0.8, <0,0,1>, 1.0
          material {
            BumpMetal
          }
          scale <1.455861, 1.333935, 6.629426>
          translate  <2.345594, 0.0, -25.645164+18.921127>
        }
        
    
        union {    
          sphere { // LeftAnkle
            <0,0,0>,1
            material {
              BumpMetal
            }
            scale <1.156373, 1.0, 0.851717>
            translate  <2.345594, 0.0, 0.0>
          }
          
          superellipsoid { // LeftFoot
            <0.2, 0.2>
            material {
              BumpMetal
            }
            scale <1.204078, 1.839299, 0.530881>
            translate  <2.345594, -1.362827, -26.332544+25.723351>
          }
          rotate LeftAnkleAngle*x
          translate (-25.723351+18.921127)*z
        }
        rotate LeftKneeAngle*x 
        translate <0, 0, -18.921127+12.109201>    
      }
      rotate LeftHipAngle*-x 
      translate <0, 0, -12.109201>    
    }
    
            
    sphere { // Sphere002
      <0,0,0>,1
      texture {
        SkinTexture
      }
      scale 1.469983
      translate  <0.0, 0.240071, -0.886414>
    }
    
    
    sphere { // Sphere012
      <0,0,0>,1
      texture {
        SkinTexture
      }
      scale 0.860573
      translate  <0.0, -0.775612, -1.348088>
    }
    translate 26.72*z
    rotate -90*x
    rotate 180*y
    scale ScalingFactor
  }
#end

  
// ===========================================================
//
//               Sword
//
// ===========================================================
#declare SwordBlade = intersection {
  sphere { // Sphere006
    <0,0,0>,1
    material {
      Chrome_Metal
    }
    scale <1.0, 1.0, 14.994692>
    translate  <-14.880432, -0.184145, -13.197526>
  }
  sphere { // Sphere009
    <0,0,0>,1
    material {
      Chrome_Metal
    }
    scale <1.0, 1.0, 14.994692>
    translate  <-13.973146, -0.230181, -13.906118>
  }
  sphere { // Sphere011
    <0,0,0>,1
    material {
      Chrome_Metal
    }
    scale <1.0, 1.0, 14.994692>
    translate  <-14.005743, -0.782617, -13.197526>
  }
  sphere { // Sphere010
    <0,0,0>,1
    material {
      Chrome_Metal
    }
    scale <1.0, 1.0, 14.994692>
    translate  <-14.926468, -0.782617, -13.197526>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    material {
      Chrome_Metal
    }
    scale <3.455027, 1.874689, 10.920288>
    translate  <-15.146154, 0.0, -3.454386>
  }
  translate  <3.058815, 0.022254, 0.14287>
}

#declare Sword = 
  union { // Sword
    object { SwordBlade }
    cylinder { // Cylndr032
      <0,0,1>, <0,0,0>, 1 
      material {
        Chrome_Metal
      }
      scale <0.250106, 0.401528, 3.226422>
      rotate <0.0, 89.979759, 0.0>
      translate  <-13.054325, 0.0, -14.40428>
    }
    sphere { // Sphere007
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.508175
      translate  <-9.548965, 0.0, -14.388023>
    }
    torus { // Torus009
      1.5, 0.5  rotate -x*90
      material {
        PommelTexture
      }
      scale 0.20309
      translate  <-11.535023, 0.0, -15.836218>
    }
    cylinder { // Cylndr031
      <0,0,1>, <0,0,0>, 1 
      material {
        Chrome_Metal
      }
      scale <0.846633, 0.422333, 0.398484>
      rotate <89.073219, 0.74675, -0.407333>
      translate  <-11.502113, 0.276218, -17.312735>
    }
    torus { // Torus010
      1.5, 0.5  rotate -x*90
      material {
        PommelTexture
      }
      scale 0.20309
      translate  <-11.527829, 0.0, -15.496182>
    }
    torus { // Torus011
      1.5, 0.5  rotate -x*90
      material {
        PommelTexture
      }
      scale 0.20309
      translate  <-11.525637, 0.0, -15.667962>
    }
    torus { // Torus012
      1.5, 0.5  rotate -x*90
      material {
        PommelTexture
      }
      scale 0.20309
      translate  <-11.527829, 0.0, -15.325487>
    }
    torus { // Torus013
      1.5, 0.5  rotate -x*90
      material {
        PommelTexture
      }
      scale 0.20309
      translate  <-11.535023, 0.0, -15.160039>
    }
    torus { // Torus014
      1.5, 0.5  rotate -x*90
      material {
        PommelTexture
      }
      scale 0.20309
      translate  <-11.520636, 0.0, -14.987398>
    }
    torus { // Torus015
      1.5, 0.5  rotate -x*90
      material {
        PommelTexture
      }
      scale 0.20309
      translate  <-11.520636, 0.0, -14.807563>
    }
    torus { // Torus016
      1.5, 0.5  rotate -x*90
      material {
        PommelTexture
      }
      scale 0.20309
      translate  <-11.535023, 0.0, -16.016052>
    }
    torus { // Torus017
      1.5, 0.5  rotate -x*90
      material {
        PommelTexture
      }
      scale 0.20309
      translate  <-11.535023, 0.0, -16.1815>
    }
    torus { // Torus018
      1.5, 0.5  rotate -x*90
      material {
        PommelTexture
      }
      scale 0.20309
      translate  <-11.547522, 0.0, -16.366953>
    }
    torus { // Torus019
      1.5, 0.5  rotate -x*90
      material {
        PommelTexture
      }
      scale 0.20309
      translate  <-11.53856, 0.0, -16.528269>
    }
    torus { // Torus020
      1.5, 0.5  rotate -x*90
      material {
        PommelTexture
      }
      scale 0.20309
      translate  <-11.53856, 0.0, -16.698547>
    }
    torus { // Torus021
      1.5, 0.5  rotate -x*90
      material {
        PommelTexture
      }
      scale 0.20309
      translate  <-11.53856, 0.0, -16.859863>
    }
    sphere { // Sphere008
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.508175
      translate  <-13.405911, 0.0, -14.362137>
    }
    translate  <11.378248, 0.0, 16.128272>
    rotate -90*x
  }

#declare SwordObject =
    object {
      Sword
      scale ScalingFactor
    }  

// ===========================================================
//
//               Banner
//
// ===========================================================
#declare BannerFlag = difference {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      BannerTexture
    }
    scale <7.462017, 0.074614, 6.910365>
    rotate 180.0*x
    translate  <33.536638, -0.372326, 11.738515>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale 0.539972
    rotate 90.640739*x
    translate  <26.92378, 0.0, 17.791738>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale 0.539972
    rotate 90.640739*x
    translate  <40.108704, 0.0, 17.744649>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale 0.539972
    rotate 90.640739*x
    translate  <30.785079, 0.0, 17.933005>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale 0.539972
    rotate 90.640739*x
    translate  <35.870693, 0.0, 17.933005>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale 0.539972
    rotate 90.640739*x
    translate  <26.876691, 0.0, 5.501505>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale 0.539972
    rotate 90.640739*x
    translate  <30.879257, 0.0, 5.595683>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale 0.539972
    rotate 90.640739*x
    translate  <30.879257, 0.0, 5.595683>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale 0.539972
    rotate 90.640739*x
    translate  <35.823604, 0.0, 5.689861>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale 0.539972
    rotate 90.640739*x
    translate  <40.061615, 0.0, 5.595683>
  }
  material {
    BannerTexture
  }
}

#declare Banner = 
  union { // Banner
    object { BannerFlag }
    torus { // Torus002
      1.5, 0.2  rotate -x*90
      material {
        Sandalwood
      }
      scale 0.3851
      rotate <180.0, 88.7276, 180.0>
      translate  <30.784119, -0.18957, 18.608205>
    }
    torus { // Torus003
      1.5, 0.2  rotate -x*90
      material {
        Sandalwood
      }
      scale 0.3851
      rotate <180.0, 88.7276, 180.0>
      translate  <35.87111, -0.18957, 18.608205>
    }
    torus { // Torus004
      1.5, 0.2  rotate -x*90
      material {
        Sandalwood
      }
      scale 0.3851
      rotate <180.0, 88.7276, 180.0>
      translate  <40.137618, -0.18957, 18.498807>
    }
    torus { // Torus005
      1.5, 0.2  rotate -x*90
      material {
        Sandalwood
      }
      scale 0.3851
      rotate <180.0, 88.7276, 180.0>
      translate  <26.900503, -0.18957, 4.660004>
    }
    torus { // Torus006
      1.5, 0.2  rotate -x*90
      material {
        Sandalwood
      }
      scale 0.3851
      rotate <180.0, 88.7276, 180.0>
      translate  <30.893517, -0.18957, 4.714703>
    }
    torus { // Torus007
      1.5, 0.2  rotate -x*90
      material {
        Sandalwood
      }
      scale 0.3851
      rotate <180.0, 88.7276, 180.0>
      translate  <35.816411, -0.18957, 4.660004>
    }
    torus { // Torus008
      1.5, 0.2  rotate -x*90
      material {
        Sandalwood
      }
      scale 0.3851
      rotate <180.0, 88.7276, 180.0>
      translate  <40.137618, -0.18957, 4.824101>
    }
    cylinder { // Cylndr019
      <0,0,1>, <0,0,0>, 1 
      material {
        Sandalwood
      }
      scale <-0.306002, -0.282514, -15.206079>
      rotate <-180.0, 90.0, 0.0>
      translate  <25.965123, 0.0, 19.157725>
    }
    cylinder { // Cylndr020
      <0,0,1>, <0,0,0>, 1 
      material {
        Sandalwood
      }
      scale <-0.306002, -0.282514, -15.206079>
      rotate <-180.0, 90.0, 0.0>
      translate  <25.811851, 0.0, 4.19486>
    }
    torus { // Torus001
      1.5, 0.2  rotate -x*90
      material {
        Sandalwood
      }
      scale 0.3851
      rotate <180.0, 88.7276, 180.0>
      translate  <26.845804, -0.18957, 18.608205>
    }
    cylinder { // Cylndr018
      <0,0,1>, <0,0,0>, 1 
      material {
        Sandalwood
      }
      scale <-0.239301, -0.282514, -48.038269>
      rotate -180.0*x
      translate  <33.679399, 0.0, -27.470348>
    }
    translate  <-23.718038, 0.0, 27.564207>
    rotate -90*x
    rotate 180*y
  }
  
#declare BannerObject = 
    object {
      Banner
      scale ScalingFactor
    }  
      


// ===========================================================
//
//               Shield
//
// ===========================================================
#declare ShieldBack = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  13  // control points
  <-1.096062, 0.326276>,
  <-0.977925, -0.959603>,
  <-0.087564, -2.118469>,
  <0.094923, -2.089036>,
  <1.006425, -0.997435>,
  <1.117734, 0.396615>,
  <1.113169, 0.957017>,
  <0.949778, 1.019652>,
  <-0.94247, 1.015882>,
  <-1.095659, 0.941133>,
  <-1.096062, 0.326276>,
  <-0.977925, -0.959603>,
  <-0.087564, -2.118469>
  rotate -x*90
  material {
    Chrome_Metal
  }
  scale <4.616251, 4.785161, 0.731328>
  rotate 90.0*x
  translate  <23.122091, 0.0, -9.75292>
}
#declare ShieldFront = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  13  // control points
  <-1.096062, 0.326276>,
  <-0.977925, -0.959603>,
  <-0.087564, -2.118469>,
  <0.094923, -2.089036>,
  <1.006425, -0.997435>,
  <1.117734, 0.396615>,
  <1.113169, 0.957017>,
  <0.949778, 1.019652>,
  <-0.94247, 1.015882>,
  <-1.095659, 0.941133>,
  <-1.096062, 0.326276>,
  <-0.977925, -0.959603>,
  <-0.087564, -2.118469>
  rotate -x*90
  material {
    ShieldTexture
  }
  scale <4.087675, 4.237244, 0.647589>
  rotate 90.0*x
  translate  <23.243507, -0.132694, -9.75292>
}

#declare Shield = 
  union { // Shield
    sphere { // StudSphere
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <19.10562, -0.770962, -5.142297>
    }
    object { ShieldBack }
    object { ShieldFront }
    sphere { // StudSphere1
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <24.01087, -0.770962, -5.142297>
    }
    sphere { // StudSphere2
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <21.953829, -0.770962, -5.142297>
    }
    sphere { // StudSphere3
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <20.964868, -0.770962, -5.102738>
    }
    sphere { // StudSphere4
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <25.155219, -0.770962, -5.142297>
    }
    sphere { // StudSphere5
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <19.975906, -0.770962, -5.142297>
    }
    sphere { // StudSphere6
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <26.025505, -0.770962, -5.142297>
    }
    sphere { // StudSphere7
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <23.021908, -0.770962, -5.142297>
    }
    sphere { // StudSphere8
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <26.974909, -0.770962, -5.142297>
    }
    sphere { // StudSphere9
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <27.853733, -0.770962, -5.142297>
    }
    sphere { // StudSphere10
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <18.354009, -0.734249, -5.142297>
    }
    sphere { // StudSphere11
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <28.051525, -0.770962, -5.893908>
    }
    sphere { // StudSphere12
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <28.091084, -0.770962, -7.001545>
    }
    sphere { // StudSphere13
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <28.051525, -0.770962, -7.990506>
    }
    sphere { // StudSphere14
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <28.051525, -0.770962, -8.93991>
    }
    sphere { // StudSphere15
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <28.051525, -0.770962, -10.087105>
    }
    sphere { // StudSphere16
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <28.011967, -0.770962, -11.115625>
    }
    sphere { // StudSphere17
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <27.972408, -0.770962, -11.946353>
    }
    sphere { // StudSphere18
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <27.893291, -0.770962, -12.935315>
    }
    sphere { // StudSphere19
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <27.616382, -0.770962, -14.003393>
    }
    sphere { // StudSphere20
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <27.102122, -0.770962, -14.992355>
    }
    sphere { // StudSphere21
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <26.469186, -0.770962, -15.981317>
    }
    sphere { // StudSphere22
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <25.559342, -0.770962, -17.009837>
    }
    sphere { // StudSphere23
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <24.728614, -0.770962, -17.95924>
    }
    sphere { // StudSphere24
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <23.897886, -0.770962, -18.789968>
    }
    sphere { // StudSphere25
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <23.146275, -0.770962, -19.660254>
    }
    sphere { // StudSphere26
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <18.354009, -0.734249, -5.973025>
    }
    sphere { // StudSphere27
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <18.354009, -0.734249, -6.922428>
    }
    sphere { // StudSphere28
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <18.393567, -0.734249, -7.950948>
    }
    sphere { // StudSphere29
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <18.433126, -0.734249, -9.019026>
    }
    sphere { // StudSphere30
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <18.433126, -0.734249, -9.96843>
    }
    sphere { // StudSphere31
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <18.433126, -0.734249, -11.076067>
    }
    sphere { // StudSphere32
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <18.472684, -0.734249, -11.946353>
    }
    sphere { // StudSphere33
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <18.670477, -0.734249, -13.014432>
    }
    sphere { // StudSphere34
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <18.907827, -0.734249, -13.924276>
    }
    sphere { // StudSphere35
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <19.422087, -0.734249, -14.913238>
    }
    sphere { // StudSphere36
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <20.015464, -0.734249, -15.941758>
    }
    sphere { // StudSphere37
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <20.767075, -0.734249, -16.891161>
    }
    sphere { // StudSphere38
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <21.439569, -0.734249, -17.840565>
    }
    sphere { // StudSphere39
      <0,0,0>,1
      material {
        Chrome_Metal
      }
      scale 0.129714
      translate  <22.270297, -0.734249, -18.829526>
    }
    translate  <7.051309, 0.0, 20.512898>
    translate -11*z
    translate -30*x
    rotate -90*x
    rotate 180*y
  }
  
#declare ShieldObject = 
    object {
      Shield
      scale ScalingFactor
    }  

// ===========================================================
//
//               Pike
//
// ===========================================================
#declare CSG001 = difference {
  sphere { // Sphere004
    <0,0,0>,1
    material {
      Chrome_Metal
    }
    scale <2.855287, 0.761475, 1.078187>
    translate  <13.747562, 0.0, -15.637295>
  }
  sphere { // Sphere005
    <0,0,0>,1
    material {
      Chrome_Metal
    }
    scale <2.954662, 1.0, 1.625492>
    translate  <13.76082, 0.0, -16.41916>
  }
}
#declare TaperSweep001 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-0.005027, -1.414205>,
  <0.569903, -0.00744>,
  <0.005027, 1.414205>,
  <-0.470057, -0.003016>,
  <-0.005027, -1.414205>
  rotate <90,0,90>
  material {
    Chrome_Metal
  }
  scale <0.420396, 1.0, 6.165663>
  rotate <180.0, 0.509232, 180.0>
  translate  <13.604447, 0.0, -8.678699>
}

#declare Pike = 
  union { // Pike
    object { CSG001 }
    object { TaperSweep001 }
    cylinder { // Cylndr017
      <0,0,1>, <0,0,0>, 1 
      material {
        Sandalwood
      }
      scale <0.485615, 0.379835, 28.834177>
      translate  <13.697921, 0.0, -43.614181>
    }
    translate  <6.341878, 0.0, 43.689434>
    translate -20*x
    rotate -90*x
    rotate 180*y
  }
  
  
#declare PikeObject = 
    object {
      Pike
      scale ScalingFactor
    }

#macro __clearVars()
  #ifdef (LeftArmTool)
    #undef LeftArmTool
  #end            
  #ifdef (RightArmTool)
    #undef RightArmTool
  #end
  #ifdef (LeftHandTool)  
    #undef LeftHandTool
  #end  
  #ifdef (RightHandTool)  
    #undef RightHandTool
  #end  
#end

#macro BannerWarrior(
    LeftHipAngle,         // Angle of leg from hip. Normal range -10->100
    LeftKneeAngle,        // Angle of lower leg via knee. Normal range 0->95
    LeftAnkleAngle        // Angle of foot wrt ankle. Normal range 0-90
    RightHipAngle,        // Angle of leg from hip. Normal range -10->100
    RightKneeAngle,       // Angle of lower leg via knee. Normal range 0->95
    RightAnkleAngle       // Angle of foot wrt ankle. Normal range 0-90
    )
    
  __clearVars()  
  #declare RightHandTool = object { Banner translate <10,-15,0> rotate 180*x rotate 225*y }
  object { Warrior ( 
            -35, -45, 10, LeftHipAngle,LeftKneeAngle,LeftAnkleAngle,
            -40, -45, 50, RightHipAngle, RightKneeAngle, RightAnkleAngle )
  }          
#end 
  
  
#macro SwordWarrior(
    LeftShoulderAngle1,   // Rotate around the shoulder along the direction of the arm
    LeftShoulderAngle2,   // Rotate around the sholder parallel around the line between the shoulders
    LeftElbowAngle,       // Uplift elbow. Normal range 0 -> 160
    LeftHipAngle,         // Angle of leg from hip. Normal range -10->100
    LeftKneeAngle,        // Angle of lower leg via knee. Normal range 0->95
    LeftAnkleAngle        // Angle of foot wrt ankle. Normal range 0-90
    RightShoulderAngle1,  // Rotate around the shoulder along the direction of the arm
    RightShoulderAngle2,  // Rotate around the sholder parallel around the line between the shoulders
    RightElbowAngle,      // Uplift elbow. Normal range 0 -> 160
    RightHipAngle,        // Angle of leg from hip. Normal range -10->100
    RightKneeAngle,       // Angle of lower leg via knee. Normal range 0->95
    RightAnkleAngle       // Angle of foot wrt ankle. Normal range 0-90
    )
    
  __clearVars()  
  #declare RightHandTool = object { Sword rotate 180*x rotate 90*y }
  #declare LeftArmTool = object { Shield translate <0, 0, -1> rotate 180*x rotate 90*y }
  object { Warrior ( 
            LeftShoulderAngle1, LeftShoulderAngle2, LeftElbowAngle, LeftHipAngle,LeftKneeAngle,LeftAnkleAngle,
            RightShoulderAngle1,RightShoulderAngle2, RightElbowAngle, RightHipAngle, RightKneeAngle, RightAnkleAngle )
  }          
#end 

#macro PikeWarrior(
    LeftShoulderAngle1,   // Rotate around the shoulder along the direction of the arm
    LeftShoulderAngle2,   // Rotate around the sholder parallel around the line between the shoulders
    LeftElbowAngle,       // Uplift elbow. Normal range 0 -> 160
    LeftHipAngle,         // Angle of leg from hip. Normal range -10->100
    LeftKneeAngle,        // Angle of lower leg via knee. Normal range 0->95
    LeftAnkleAngle        // Angle of foot wrt ankle. Normal range 0-90
    RightShoulderAngle1,  // Rotate around the shoulder along the direction of the arm
    RightShoulderAngle2,  // Rotate around the sholder parallel around the line between the shoulders
    RightElbowAngle,      // Uplift elbow. Normal range 0 -> 160
    RightHipAngle,        // Angle of leg from hip. Normal range -10->100
    RightKneeAngle,       // Angle of lower leg via knee. Normal range 0->95
    RightAnkleAngle       // Angle of foot wrt ankle. Normal range 0-90
    )

  __clearVars()  
  #declare RightHandTool = object { Pike translate -15*y rotate 180*x rotate 90*y }
  object { Warrior ( 
            LeftShoulderAngle1, LeftShoulderAngle2, LeftElbowAngle, LeftHipAngle,LeftKneeAngle,LeftAnkleAngle,
            RightShoulderAngle1,RightShoulderAngle2, RightElbowAngle, RightHipAngle, RightKneeAngle, RightAnkleAngle )
  }          
#end 


#declare CatapultLength = 10*m;
#declare CatapultWidth = 4*m;
#declare Wheel = difference { cylinder { 0, -20*cm*z, 80*cm } cylinder { 1*z, -20*z, 20*cm } texture { T_Wood14 } }
#declare CatapultStone = sphere { 0, 2*m texture { pigment { color rgb <0.8, 0.7, 0.75> } normal { dents scale 0.4 } } }

#macro Catapult(pWheelRotation, pFiringAngle, pLoaded)
  union {
    #declare uprightLocation = CatapultLength/2 * 0.75;
    object { Wheel rotate pWheelRotation * z translate <-CatapultLength / 2 * 0.75, 80*cm, -CatapultWidth/2> }
    object { Wheel rotate pWheelRotation * z translate < CatapultLength / 2 * 0.75, 80*cm, -CatapultWidth/2> }
    object { Wheel rotate pWheelRotation * z translate <-CatapultLength / 2 * 0.75, 80*cm,  CatapultWidth/2+30*cm> }
    object { Wheel rotate pWheelRotation * z translate < CatapultLength / 2 * 0.75, 80*cm,  CatapultWidth/2+30*cm> }
    
    // axles
    cylinder { <-CatapultLength/2 * 0.75, 80*cm, -CatapultWidth/2 - 20*cm> <-CatapultLength/2 * 0.75, 80*cm, CatapultWidth/2 + 20*cm> 20*cm texture { T_Wood15 } }
    cylinder { < CatapultLength/2 * 0.75, 80*cm, -CatapultWidth/2 - 20*cm> < CatapultLength/2 * 0.75, 80*cm, CatapultWidth/2 + 20*cm> 20*cm texture { T_Wood1 } }

    // Firing Platform
    box { <-CatapultLength/2, 100*cm, -CatapultWidth/2> <CatapultLength/2, 110*cm, CatapultWidth/2> texture { T_Wood7 } }
    
    // Firing upright -- in line with the front wheels
    box { <uprightLocation - 15*cm, 100*cm, -CatapultWidth/2> <uprightLocation + 35*cm, 5.5*m, -CatapultWidth/2 + 30*cm> texture { T_Wood7 } }
    box { <uprightLocation - 15*cm, 100*cm, CatapultWidth/2> <uprightLocation + 35*cm, 5.5*m, CatapultWidth/2 - 30*cm> texture { T_Wood7 } }
    
    // Front cross pieces
    box { <uprightLocation - 10*cm, 100*cm, -CatapultWidth/2-1*mm> <uprightLocation + 30*cm, 2*m, CatapultWidth/2 - 1*mm> texture { T_Wood6 } }
    
    // Firing axis
    cylinder { <uprightLocation, 3*m, -CatapultWidth/2-1*mm> <uprightLocation, 3*m, CatapultWidth/2 - 1*mm> 20*cm texture { T_Wood6 } }
    
    // Upright structure support
    #declare supportOffset = 2*m;
    box {
      <-15*cm, 80*cm, -CatapultWidth/2>
      <15*cm, 100*m, -CatapultWidth/2 + 30*cm>
      texture { T_Wood7 }
      rotate -30*z
      translate (uprightLocation - supportOffset) * x
      clipped_by { box { <-100*m, 100*cm, -100*m> <uprightLocation - 15*cm, 100*m, 100*m> } }
    }
    box {
      <-15*cm, 80*cm, CatapultWidth/2>
      <15*cm, 100*m, CatapultWidth/2 - 30*cm>
      texture { T_Wood7 }
      rotate -30*z
      translate (uprightLocation - supportOffset) * x
      clipped_by { box { <-100*m, 100*cm, -100*m> <uprightLocation - 15*cm, 100*m, 100*m> } }
    }
    box { <uprightLocation - 15.1*cm, 270*cm, -CatapultWidth/2-1*mm> <uprightLocation + 35.1*cm, 400*cm, -CatapultWidth/2 + 30.1*cm> texture { T_Chrome_1A } }
    box { <uprightLocation - 15.1*cm, 270*cm, CatapultWidth/2+1*mm> <uprightLocation + 35.1*cm, 400*cm, CatapultWidth/2 - 30.1*cm> texture { T_Chrome_1A } }
     
    #declare FiringBowl = 
        union {
          difference {
            sphere { 0, 1.9*m }
            sphere { 0, 1.8*m }
            plane { -y, 0 }
            scale <1, 0.4, 1>
          }
          cylinder { <1.0*m, -35*cm, 0> <CatapultLength - 1.9*m, -35*cm, 0> 30*cm clipped_by { sphere {0, 1.81*m inverse } } }
          texture { T_Wood17 }
          translate (-CatapultLength/2 - 2.5*m) * x
        }
        
    union {
      object { FiringBowl }
      #if (pLoaded)
        object { CatapultStone translate <(-CatapultLength/2 - 2.5*m), 2*m - 1.8*0.4, 0>}
      #else  
        // Eliminate warnings
        sphere { 0, 0.000001 pigment { color rgbt 1 } }
      #end  
      rotate pFiringAngle * -z
      translate <uprightLocation, 3.4*m, 0>
    }            
    // Firing mechanism
    /*
    sphere_sweep {
      catmull_rom_spline
      6,
      <CatapultLength/2-30*cm, 0, 0>, 20*cm   // Non-visible point
      <CatapultLength/2-30*cm, 110*cm, 0>, 20*cm
      #if (pFiringAngle <= 45)
        <0, 210*cm, 0>, 20*cm
      #else
      #end */
      
  }
#end
      