#include "ConversionUnits.inc"
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

camera {
  location <0.0, -0.0, -0.25>
  //location <-0.2, 0, 0>
  //location <0, 0.3, -0.4>
  look_at <0, 0.0, 0>
}

light_source {
  <0, 1, -1>   
  White
}  


// Draw the left hand
#declare hand = 0;

#declare Finger1Angle1 = 10+40 * clock;
#declare Finger1Angle2 = 10+40*clock;
#declare Finger1Angle3 = 10+40*clock;
#declare Finger2Angle1 = 15+40*clock;
#declare Finger2Angle2 = 15+40*clock;
#declare Finger2Angle3 = 15+40*clock;
#declare Finger3Angle1 = 20+40*clock;
#declare Finger3Angle2 = 20+40*clock;
#declare Finger3Angle3 = 20+40*clock;
#declare Finger4Angle1 = 30+40*clock;
#declare Finger4Angle2 = 30+40*clock;
#declare Finger4Angle3 = 30+40*clock;
#declare ThumbAngle1 = 30;
#declare ThumbAngle2 = 30;
#declare ThumbAngle3 = 30+40*clock;
#declare WristAngle = 15-40*clock;
#declare SkinTexture =
    texture {
      pigment {
        //color rgb <0.5, 0.25, 0.125>
        color rgb <0.8, 0.5, 0.25>
      } 
      finish { ambient 0.5 }
      normal {
        bumps 0.1
        scale 0.1
      }
    }
#declare NailTexture = 
    texture {
      pigment {
        //color rgb <0.5, 0.25, 0.125>
        color rgb <0.9, 0.6, 0.35>
      } 
      finish { ambient 0.5 phong .1 }
      //normal { }
    }

#ifndef (vClock)
  #declare vClock = clock;
#end  

#ifndef (ActualFPS)
  #declare ActualFPS=25;
#end
  
#macro LocalClock( pStart, pEnd )
  (((clock*ActualFPS)-pStart) / (pEnd-pStart))
#end

#declare ring = difference { cylinder { <0, 0, 0> <0, 0.5*cm, 0> 10*mm } cylinder {<0, -0.1, 0> <0, 1, 0> 9*mm } translate 2*mm*y texture { Gold_Texture } }

#declare Finger3Ring = ring;


object {#include "hand.inc" rotate -90*y translate -15*cm*x}      

#undef Finger3Ring
#declare hand = 1;

object {#include "hand.inc" rotate 90*y translate 15*cm*x}      

#declare bigRing = 
    union {
      // The band
      difference {
        cylinder {
          <0, 0, 0>
          <0, 0.8*cm, 0>
          10*mm
        }
        cylinder {
          <0, -0.1, 0>
          <0, 1*cm, 0>
          9*mm
        }
        texture {Silver_Metal}
      }
      
      // The silver platter
      cylinder {
        <0, 0.4*cm, 10*mm>
        <0, 0.4*cm, 10.1*mm>
        2*cm
        texture { Silver_Metal }
      }
      
      // NOw the bright blue (light emitting jewel)
      intersection {
        sphere {
          <0, 0.4*cm, 10.1*mm>
          1.8*cm
        }
        box{ <-1000, -1000, 10.1*mm> <1000, 1000, 1000> } 
        material { texture { pigment { color rgb <0.2, 0.3, 1.0> } finish { ambient 0.6 } } }
      }    
    }
