#include "colors.inc"
#include "textures.inc"
#include "MiscObjects.inc"
#include "ConversionUnits.inc"
#include "woods.inc"
//#include "Glass.inc"


#ifndef (vClock)
  #declare vClock = clock;
#end

// Draw the bookcase with the reagents
#declare bookcaseTexture =
    texture {
      pigment {
        wood
        color_map {
          [0.0 rgb <0.888, 0.6, 0.3>]
          [0.1 rgb <0.888, 0.6, 0.3>]
          [0.9 rgb <0.60, 0.4, 0.2>]
          [1.0 rgb <0.60, 0.4, 0.2>]
        }
        turbulence 0.04
        octaves 3
        ramp_wave
        scale <0.05, 0.05, 1.0>
      }
    }

#declare subSceneLoc = <0*m, 50*0.85*m + 1.2*m, 75*m>;
                
object {
  CreateBookcase(2*m, 2*m, 20*cm, 48*cm, 0, texture { bookcaseTexture scale 0.1 rotate <12, -3, 96>}, false)
  translate subSceneLoc
}

object {
  DisturbedJar
  translate <22*cm, 50*cm, -8*cm>
  translate subSceneLoc
}  

object {
  OnyxJar
  translate <-11*cm, 50*cm, -13*cm>
  translate subSceneLoc
}  

object {
  OxTongueJar
  translate <-22*cm, 50*cm, -13*cm>
  translate subSceneLoc
}  

object {
  EyeOfNewtJar
  rotate From(0*x, 0.7) To(15*x, 0.85)
  translate From( <0, 50*cm, -8*cm>, 0.7) To(<0, 60*cm, -20*cm>, 0.85)
  translate subSceneLoc
}  

object {
  DragonsBloodJar
  translate <-18*cm, 50*cm, -6*cm>
  translate subSceneLoc
}  

// Draw the left hand
#declare hand = 0;

#declare Finger1Angle1 = 0;
#declare Finger1Angle2 = 0;
#declare Finger1Angle3 = 0;
#declare Finger2Angle1 = 0;
#declare Finger2Angle2 = 0;
#declare Finger2Angle3 = 0;
#declare Finger3Angle1 = 0;
#declare Finger3Angle2 = 0;
#declare Finger3Angle3 = 0;
#declare Finger4Angle1 = 0;
#declare Finger4Angle2 = 0;
#declare Finger4Angle3 = 0;
#declare ThumbAngle1 = 0;
#declare ThumbAngle2 = 0;
#declare ThumbAngle3 = 0;
#declare WristAngle = 0;
#declare ThumbJoint2TransverseAngle = 0;

#if (vClock <= 0.5)
  #declare sTime = 0;
  #declare eTime = 0.5;
  #declare Finger1Angle1 = 5;
  #declare Finger1Angle2 = 5;
  #declare Finger1Angle3 = 5;
  #declare Finger2Angle1 = 70;
  #declare Finger2Angle2 = 70;
  #declare Finger2Angle3 = 70;
  #declare Finger3Angle1 = 70;
  #declare Finger3Angle2 = 70;
  #declare Finger3Angle3 = 70;
  #declare Finger4Angle1 = 70;
  #declare Finger4Angle2 = 70;
  #declare Finger4Angle3 = 70;
  #declare ThumbAngle1 = 80;
  #declare ThumbAngle2 = 60;
  #declare ThumbAngle3 = 80;
  #declare WristAngle = 0;
  object {
    #include "hand.inc"
    rotate 90*x
    rotate 180*z
    translate 25*cm*z 
    #if (vClock < 0.45)
      rotate (-20+(vClock/0.45)*50)*y
    #else
      rotate (30 - (vClock-0.45)/(0.5-0.45) * 20) *y
    #end  
    translate <-10*cm, 0, -25*cm>
    
    // Now move the arm relative to the scene
    translate <0,60*cm, -25*cm>
    translate subSceneLoc
  }  
#else
  #if (vClock <= 0.6)
    #declare sTime = 0.5;
    #declare eTime = 0.6;
    Interpolate( Finger1Angle1, 5, sTime, 10, eTime);    
    Interpolate( Finger1Angle2, 5, sTime, 10, eTime);    
    Interpolate( Finger1Angle3, 5, sTime, 10, eTime);    
    Interpolate( Finger2Angle1, 70, sTime, 10, eTime);    
    Interpolate( Finger2Angle2, 70, sTime, 10, eTime);    
    Interpolate( Finger2Angle3, 70, sTime, 10, eTime);    
    Interpolate( Finger3Angle1, 70, sTime, 10, eTime);    
    Interpolate( Finger3Angle2, 70, sTime, 10, eTime);    
    Interpolate( Finger3Angle3, 70, sTime, 10, eTime);    
    Interpolate( Finger4Angle1, 70, sTime, 5, eTime);    
    Interpolate( Finger4Angle2, 70, sTime, 5, eTime);    
    Interpolate( Finger4Angle3, 70, sTime, 5, eTime);    
    Interpolate( ThumbAngle1, 80, sTime, 60, eTime);    
    Interpolate( ThumbAngle2, 60, sTime, 10, eTime); 
    Interpolate( ThumbJoint2TransverseAngle, 0, sTime 30, eTime);
    Interpolate( ThumbAngle3, 80, sTime, 10, eTime);    
    Interpolate( WristAngle, 0, sTime, 5, eTime);    
    object {
      #include "hand.inc"
      rotate 90*x
      rotate From( 180*z, sTime) To (250*z, eTime)
      translate 25*cm*z 
      rotate From( 10*y, sTime) To (-2*y, eTime)
      translate <-10*cm, 0, -25*cm>
      translate From(<0, 0, 0>, sTime) To(<0, 0, 10*cm>, eTime)
      
      // Now move the arm relative to the scene
      translate <0,60*cm, -25*cm>
      translate subSceneLoc
    }  
  #else
    #if (vClock <= 0.7)
      #declare sTime = 0.6;
      #declare eTime = 0.7;
      Interpolate( Finger1Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger1Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger1Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle1, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle2, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle3, 5, sTime, 5, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 30, sTime 30, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 5, sTime, 20, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From( 250*z, sTime) To (270*z, eTime)
        translate 25*cm*z 
        rotate From( -2*y, sTime) To (1*y, eTime)
        translate <-10*cm, 0, -25*cm>
        translate From(<0, 0, 10*cm>, sTime) To(<-2*cm, 0, 17*cm>, eTime)
        
        // Now move the arm relative to the scene
        translate <0,60*cm, -25*cm>
        translate subSceneLoc
      }  
      
    #else
      #declare sTime = 0.7;
      #declare eTime = 0.85;
      Interpolate( Finger1Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger1Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger1Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle1, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle2, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle3, 5, sTime, 5, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 30, sTime 30, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 20, sTime, -5, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From( 270*z, sTime) To (285*z, eTime)
        translate 25*cm*z 
        rotate From( 1*y, sTime) To (45*y, eTime)
        translate <-10*cm, 0, -25*cm>
        translate From(<-2*cm, 0, 17*cm>, sTime) To(<-12*cm, 10*cm, 17*cm>, eTime)
        
        // Now move the arm relative to the scene
        translate <0,60*cm, -25*cm>
        translate subSceneLoc
      }  
      
    #end  
    
  #end  
#end

camera {
  location (From(<0, 70*cm, -50*cm>, 0.5) To( <0, 70*cm, -40*cm>, 0.6)) + subSceneLoc
  look_at <0, 60*cm, 0> + subSceneLoc
  //location <0, 95*cm, -20*cm>
  //look_at <0, 65*cm, -20*cm>
}

light_source {
  <1*m, 3*m, -2*m> + subSceneLoc
  color White
}  