#macro FireStone( pClock )
  #declare intensity = 0.6+sin(pClock * 30) * 0.4;
  //#declare spherePower = 1;
  #ifdef (spherePower)
    #declare aScale = 3*cm + 10*cm*spherePower;
  #else
    #declare spherePower = 0;    
    #declare aScale = 3*cm;
  #end  
  union { 
    light_source {
      <0, 0, 0>
      //<1, 0, 0>
      <intensity, 0, 0>
      fade_power 2
      fade_distance 0.1*m + 50*m*spherePower
      looks_like { 
        sphere {  0, 1*cm scale <1, 1, 1> texture { pigment { color rgb <1, 0, 0> } finish { ambient 1 } } } 
      }
    } 
    sphere {
      0, 1 
      hollow
      material {
        texture {
          pigment {
            color rgbt <1.0, 1.0, 1.0, 1.0>
          }
        }
        interior {
          media {
            emission (1/aScale * (0.5+intensity/2)) * (1+spherePower)
            density {
              spiral2 1
              color_map {
                [0.0 color rgb <1.0, 0.0, 0.0>]
                [0.4+0.3*spherePower color rgb <0.4, 0.0, 0.0>]
                [0.7+0.3*spherePower color rgb <0.0, 0.0, 0.0>]
                [1.0 color rgb <0.0, 0.0, 0.0>]
              }
              turbulence 0.6 + 0.5 * sin( pClock * 30) + spherePower
            }
          }
        }  
      }
      rotate 90*x
      scale aScale
    } 
    rotate <pClock * 1000, pClock * 713, pClock * 103>
  }      
#end


#declare MagicStone = sphere { 0, 3*cm scale <1.5, 1, 1> texture { T_Wood31 rotate <2, 1.7, 4>} }

#declare bowlLocation =   <0, height1+1*m, 67.3*m>;
#declare aBowl = object { MixingBowl translate bowlLocation }
object { EyeOfNewtJar rotate 136*y translate <-38*cm, height1+1*m, 67.2*m > } 

#declare NewtEyes = 
  union {
    object { EyeOfNewt rotate 90*x translate trace( aBowl, bowlLocation + 1*m*y, -y ) }
    object { EyeOfNewt rotate 90*x translate trace( aBowl, bowlLocation + <2*cm, 1*m, 0.3*cm>, -y ) }
    object { EyeOfNewt rotate 90*x translate trace( aBowl, bowlLocation + <-0.3*cm, 1*m, 0.8*cm>, -y ) }
    object { EyeOfNewt rotate 90*x translate trace( aBowl, bowlLocation + <2.1*cm, 1*m, -1*cm>, -y ) }
  }  
    

#declare Finger1Angle1 = 0;
#declare Finger1Angle2 = 0;
#declare Finger1Angle3 = 0;
#declare Finger2Angle1 = 0;
#declare Finger2Angle2 = 0;
#declare Finger2Angle3 = 0;
#declare Finger3Angle1 = 0;
#declare Finger3Angle2 = 0;
#declare Finger3Angle3 = 0;
#declare Finger4Angle1 = 0;
#declare Finger4Angle2 = 0;
#declare Finger4Angle3 = 0;
#declare ThumbAngle1 = 0;
#declare ThumbAngle2 = 0;
#declare ThumbAngle3 = 0;
#declare WristAngle = 0;
#declare ThumbJoint2TransverseAngle = 0;


#macro DrawSpell()
  #declare vClock = mixingClock;
  #declare timeForSegment = 10;
  #declare frameRate = 25;
  #declare segmentTimes = array[25] {
    1.0,  // 1  - Moving the left hand into position
    0.5,  // 2  - Grasp the dragon's blood jar
    2.0,  // 3  - Lifting the jar
    1.0,  // 4  - Positioning the jar, including tilting   
    3.0,  // 5  - Pouring the blood
    0.5,  // 6  - Finish tilting the jar
    1.0,  // 7  - Replace the jar, reach for the rock
    0.2,  // 8  - Drop the jar, grab the rock
    1.5,  // 9  - Lift the rock, remove the left hand
    0.2,  // 10 - Open the fingers
    0.5,  // 11 - Eject the stone, withdraw the hand
    0.1,  // 12 - Flash fire
    1.5,  // 13 - Recovery, notice stone.
    1.2,  // 14 - Move hands to the bowl
    0.3,  // 15 - Bend the thumbs
    0.7,  // 16 - Lift the bowl
    1.0,  // 17 - follow the rising stone
    0.5,  // 18 - Pause
    0.7,  // 19 - Move the hands in ready to continue the spell
    3.0,  // 20 - Cast the powerup spell
    0.0,  // 21 - Fire the spell
    0.0,  // 22 -
    0.0,  // 23 -
    0.0,  // 24 -
    0.0}

  clockToSegmentTime( vClock, segmentTimes )

  #switch (segment)
    #case (16)
    #else
      object { aBowl }
  #end        

  #switch (segment)
    #case (1)
      // MOve the hand into position  
      Interpolate( Finger1Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger1Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger1Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle1, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle2, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle3, 5, sTime, 5, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 30, sTime 30, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 5, sTime, 20, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From( 250*z, sTime) To (270*z, eTime)
        translate 25*cm*z 
        rotate From( -202*y, sTime) To (-202*y, eTime)
        translate From( <-5*cm, 0, 25*cm>, sTime) To (<-10*cm, 0, -5*cm>, eTime)
        
        // Now move the arm relative to the scene
        translate <43*cm, height1+1.15*m, 67.6*m>
      }  
      object { MagicStone translate <-40*cm, height1+1*m + 3*cm, 67.33*m> }
      object { DragonsBloodJar rotate 243*y translate <38*cm, height1+1*m, 67.3*m > } 
      object { NewtEyes }  
      #break
      
    #case (2)
      // Grasp the jar
      Interpolate( Finger1Angle1, 10, sTime, 20, eTime);    
      Interpolate( Finger1Angle2, 10, sTime, 20, eTime);    
      Interpolate( Finger1Angle3, 10, sTime, 40, eTime);    
      Interpolate( Finger2Angle1, 10, sTime, 20, eTime);    
      Interpolate( Finger2Angle2, 10, sTime, 20, eTime);    
      Interpolate( Finger2Angle3, 10, sTime, 40, eTime);    
      Interpolate( Finger3Angle1, 10, sTime, 20, eTime);    
      Interpolate( Finger3Angle2, 10, sTime, 20, eTime);    
      Interpolate( Finger3Angle3, 10, sTime, 40, eTime);    
      Interpolate( Finger4Angle1, 5, sTime, 10, eTime);    
      Interpolate( Finger4Angle2, 5, sTime, 10, eTime);    
      Interpolate( Finger4Angle3, 5, sTime, 10, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 30, sTime 30, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 20, sTime, 20, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From( 270*z, sTime) To (270*z, eTime)
        translate 25*cm*z 
        rotate From( -202*y, sTime) To (-202*y, eTime)
        translate <-10*cm, 0, -5*cm>
        
        // Now move the arm relative to the scene
        translate <43*cm, height1+1.15*m, 67.6*m>
      }  
      object { MagicStone translate <-40*cm, height1+1*m + 3*cm, 67.33*m> }
      object { DragonsBloodJar rotate 243*y translate <38*cm, height1+1*m, 67.3*m > } 
      object { NewtEyes }  
      #break
      
    #case (3)  
      // Lift the jar
      Interpolate( Finger1Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger2Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger3Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger4Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle3, 10, sTime, 10, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 30, sTime 30, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 20, sTime, 20, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From( 270*z, sTime) To (245*z, eTime)
        translate 25*cm*z 
        rotate From( -202*y, sTime) To (-202*y, eTime)
        translate From( <-10*cm, 0, -5*cm>, sTime) To (<-20*cm, 10*cm, -5*cm>, eTime)
        
        // Now move the arm relative to the scene
        translate <43*cm, height1+1.15*m, 67.6*m>
      }  
      object { MagicStone translate <-40*cm, height1+1*m + 3*cm, 67.33*m> }
      object {
        DragonsBloodJar
        rotate 243*y
        rotate From( 0, sTime ) To (25*z, eTime)
        translate From (<38*cm, height1+1*m, 67.3*m >, sTime) To (<30*cm, height1+1.1*m, 67.3*m>, eTime )
      }
      object { NewtEyes }  
      #break
      
    #case (4)  
      Interpolate( Finger1Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger2Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger3Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger4Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle3, 10, sTime, 10, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 30, sTime 30, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 20, sTime, 15, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From( 245*z, sTime) To (205*z, eTime)
        translate 25*cm*z 
        rotate From( -202*y, sTime) To (-202*y, eTime)
        translate From( <-20*cm, 10*cm, -5*cm>, sTime) To (<-20*cm, 10*cm, -5*cm>, eTime)
        
        // Now move the arm relative to the scene
        translate <43*cm, height1+1.15*m, 67.6*m>
      }  
      object { MagicStone translate <-40*cm, height1+1*m + 3*cm, 67.33*m> }
      object {
        DragonsBloodJar
        rotate 243*y
        rotate 25*z
        translate -15*cm*y
        rotate From( 0*z, sTime ) To (40*z, eTime)
        translate 15*cm*y
        translate <30*cm, height1+1.1*m, 67.3*m>
      }
      object { NewtEyes }  
      #break
  
    #case (5)  
      Interpolate( Finger1Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger2Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger3Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger4Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle3, 10, sTime, 10, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 30, sTime 30, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 15, sTime, 15, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate 205*z
        translate 25*cm*z 
        rotate -202*y
        translate <-20*cm, 10*cm, -5*cm>
        
        // Now move the arm relative to the scene
        translate <43*cm, height1+1.15*m, 67.6*m>
      }  
      object { MagicStone translate <-40*cm, height1+1*m + 3*cm, 67.33*m> }
      object {
        DragonsBloodJar
        rotate 243*y
        rotate From( 25*z, sTime ) To (25*z, eTime)
        translate -15*cm*y
        rotate From( 40*z, sTime ) To (40*z, eTime)
        translate 15*cm*y
        translate <30*cm, height1+1.1*m, 67.3*m>
      }
      // Draw the pouring blood
      #declare pouringLoc = <16*cm, height1+1.22*m, 67.3*m>;
      #declare hitLoc = trace( aBowl, pouringLoc, -y );
      // FInd the time when the bowl will be intersected (s = ut + 0.5at*t)
      #declare timeToBowl = sqrt(2*vlength( hitLoc - pouringLoc) / 9.8);   
      #declare increment = 0.001;
      #declare started = false;
            
      blob {      
        threshold 0.1
        #declare now = sTime;
        #while (now < vClock)
          #declare timeDiff = now - sTime;
          #declare timeDiffInSecs = timeDiff * timeForSegment;
          #if (timeDiffInSecs > timeToBowl)
            // Move linearly towards the centre of the bowl, then drop vertically
            #declare timeDiffInSecs = timeDiffInSecs - timeToBowl;
            #declare timeToCentre = 0.4; // seconds
            #if (timeDiffInSecs < timeToCentre)
              #declare nonDroppedLoc = hitLoc-1*mm*y + (<bowlLocation.x-hitLoc.x, 0, bowlLocation.z-hitLoc.z>*timeDiffInSecs / timeToCentre);
              #declare droppedLoc = trace( aBowl, nonDroppedLoc, -y);
              sphere { 0, 5*mm, 2 translate droppedLoc }
            #else
              #declare started = true;
              #declare startedTime = now;
              // We can break the loop now
              #declare now = vClock;  
            #end  
          #else
            sphere { 0, 5*mm, 2 translate pouringLoc - (0.5 * 9.8 * timeDiffInSecs * timeDiffInSecs) * y }
          #end  
          #declare now = now + increment;
        #end
        texture { pigment { color rgb <0.5, 0.1, 0.2> } }
      }  
  
      // Draw the dragon's blood liquid level
      #if (started)
        #declare bloodHeight = 0;
        Interpolate( bloodHeight, 0, startedTime, 1, eTime);
        #declare bloodHeight = sqrt(bloodHeight) * 0.4*cm;
        intersection {
          plane { y, 2*cm translate bloodHeight*y }
          sphere { 0, 11*cm scale <2, 1, 2> translate 12*cm*y}
          texture { pigment { color rgb <0.7, 0.1, 0.2> } }
          normal {bumps 2 scale 1*cm turbulence From (0, sTime) To (0.6, eTime)}
          translate bowlLocation
        }
      #end
      object { NewtEyes }  
      #break
  
    #case (6)
      Interpolate( Finger1Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger2Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger3Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger4Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle3, 10, sTime, 10, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 30, sTime 30, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 15, sTime, 20, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From( 205*z, sTime) To (245*z, eTime)
        translate 25*cm*z 
        rotate From( -202*y, sTime) To (-202*y, eTime)
        translate From( <-20*cm, 10*cm, -5*cm>, sTime) To (<-20*cm, 10*cm, -5*cm>, eTime)
        
        // Now move the arm relative to the scene
        translate <43*cm, height1+1.15*m, 67.6*m>
      }  
      object { MagicStone translate <-40*cm, height1+1*m + 3*cm, 67.33*m> }
      object {
        DragonsBloodJar
        rotate 243*y
        rotate 25*z
        translate -15*cm*y
        rotate From( 40*z, sTime ) To (0*z, eTime)
        translate 15*cm*y
        translate <30*cm, height1+1.1*m, 67.3*m>
      }
      #declare bloodHeight = 0.4 *cm;
      intersection {
        plane { y, 2*cm translate bloodHeight*y }
        sphere { 0, 11*cm scale <2, 1, 2> translate 12*cm*y}
        texture { pigment { color rgb <0.7, 0.1, 0.2> } } normal {bumps 2 scale 1*cm turbulence 0.6 }
        translate bowlLocation
      }
      object { NewtEyes }  
    #break
  
    #case (7)  
      // Replace the jar
      Interpolate( Finger1Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger2Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger3Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger4Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle3, 10, sTime, 10, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 30, sTime 30, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 20, sTime, 20, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From( 245*z, sTime) To (270*z, eTime)
        translate 25*cm*z 
        rotate From( -202*y, sTime) To (-202*y, eTime)
        translate From( <-20*cm, 10*cm, -5*cm>, sTime) To (<-10*cm, 0, -5*cm>, eTime)
        
        // Now move the arm relative to the scene
        translate <43*cm, height1+1.15*m, 67.6*m>
      }  
  
      #declare hand = 1;
      Interpolate( Finger1Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger2Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger3Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger4Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle3, 10, sTime, 10, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 30, sTime 30, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 5, sTime, 5, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From(90*z, sTime) To (180*z, eTime )
        translate 25*cm*z
        rotate From( -170*y, sTime) To( -155*y, eTime )
        translate From( <-5*cm, 10*cm, 30*cm>, sTime) To (<-8*cm, -7*cm, -6*cm>, eTime)
        
        // Now move the arm relative to the scene
        translate <-20*cm, height1+1.15*m, 67.6*m>
      }  
  
      object { MagicStone translate <-40*cm, height1+1*m + 3*cm, 67.33*m> }
      
      object {
        DragonsBloodJar
        rotate 243*y
        rotate From( 25*z, sTime ) To (0*z, eTime)
        translate From (<30*cm, height1+1.1*m, 67.3*m >, sTime) To (<38*cm, height1+1*m, 67.3*m>, eTime )
      }
      #declare bloodHeight = sqrt( 0.80 - 0.56 ) * 1 *cm;
      intersection {
        plane { y, 2*cm translate bloodHeight*y }
        sphere { 0, 11*cm scale <2, 1, 2> translate 12*cm*y}
        texture { pigment { color rgb <0.7, 0.1, 0.2> } } normal {bumps 2 scale 1*cm turbulence 0.6 }
        translate bowlLocation
      }
      object { NewtEyes }  
      #break
  
    #case (8)  
      // Drop the jar, grab the rock.
      Interpolate( Finger1Angle1, 20, sTime, 10, eTime);    
      Interpolate( Finger1Angle2, 20, sTime, 10, eTime);    
      Interpolate( Finger1Angle3, 40, sTime, 10, eTime);    
      Interpolate( Finger2Angle1, 20, sTime, 10, eTime);    
      Interpolate( Finger2Angle2, 20, sTime, 10, eTime);    
      Interpolate( Finger2Angle3, 40, sTime, 10, eTime);    
      Interpolate( Finger3Angle1, 20, sTime, 10, eTime);    
      Interpolate( Finger3Angle2, 20, sTime, 10, eTime);    
      Interpolate( Finger3Angle3, 40, sTime, 10, eTime);    
      Interpolate( Finger4Angle1, 10, sTime, 5, eTime);    
      Interpolate( Finger4Angle2, 10, sTime, 5, eTime);    
      Interpolate( Finger4Angle3, 10, sTime, 5, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 0, sTime 0, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 20, sTime, 20, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From( 270*z, sTime) To (270*z, eTime)
        translate 25*cm*z 
        rotate From( -202*y, sTime) To (-202*y, eTime)
        translate <-10*cm, 0, -5*cm>
        
        // Now move the arm relative to the scene
        translate <43*cm, height1+1.15*m, 67.6*m>
      }  
  
      #declare hand = 1;
      Interpolate( Finger1Angle1, 20, sTime, 40, eTime);    
      Interpolate( Finger1Angle2, 20, sTime, 40, eTime);    
      Interpolate( Finger1Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger2Angle1, 20, sTime, 40, eTime);    
      Interpolate( Finger2Angle2, 20, sTime, 40, eTime);    
      Interpolate( Finger2Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger3Angle1, 20, sTime, 40, eTime);    
      Interpolate( Finger3Angle2, 20, sTime, 40, eTime);    
      Interpolate( Finger3Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger4Angle1, 10, sTime, 30, eTime);    
      Interpolate( Finger4Angle2, 10, sTime, 30, eTime);    
      Interpolate( Finger4Angle3, 10, sTime, 30, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 30, sTime 30, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 5, sTime, 5, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate 180*z
        translate 25*cm*z
        rotate -155*y
        translate <-8*cm, -7*cm, -6*cm>
        
        // Now move the arm relative to the scene
        translate <-20*cm, height1+1.15*m, 67.6*m>
      }  
  
      object { MagicStone translate <-40*cm, height1+1*m + 3*cm, 67.33*m> }
      object {
        DragonsBloodJar
        rotate 243*y
        translate <38*cm, height1+1*m, 67.3*m>
      }
      #declare bloodHeight = sqrt( 0.24 ) * 1 *cm;
      intersection {
        plane { y, 2*cm translate bloodHeight*y }
        sphere { 0, 11*cm scale <2, 1, 2> translate 12*cm*y}
        texture { pigment { color rgb <0.7, 0.1, 0.2> } } normal {bumps 2 scale 1*cm turbulence 0.6}
        translate bowlLocation
      }
      object { NewtEyes }  
      #break
  
    #case (9)  
      // Lift the rock, remove the left hand
      Interpolate( Finger1Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger1Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger1Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle1, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle2, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle3, 5, sTime, 5, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 0, sTime 0, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 20, sTime, 20, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From( 270*z, sTime) To (250*z, eTime)
        translate 25*cm*z 
        rotate From( -202*y, sTime) To (-202*y, eTime)
        //translate <-10*cm, 0, 25*cm>
        translate From (<-10*cm, 0, -5*cm>, sTime) To ( <-5*cm, 0, 25*cm>, eTime)
        
        // Now move the arm relative to the scene
        translate <43*cm, height1+1.15*m, 67.6*m>
      }  
  
      #declare hand = 1;
      Interpolate( Finger1Angle1, 40, sTime, 40, eTime);    
      Interpolate( Finger1Angle2, 40, sTime, 40, eTime);    
      Interpolate( Finger1Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger2Angle1, 40, sTime, 40, eTime);    
      Interpolate( Finger2Angle2, 40, sTime, 40, eTime);    
      Interpolate( Finger2Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger3Angle1, 40, sTime, 40, eTime);    
      Interpolate( Finger3Angle2, 40, sTime, 40, eTime);    
      Interpolate( Finger3Angle3, 40, sTime, 40, eTime);    
      Interpolate( Finger4Angle1, 30, sTime, 30, eTime);    
      Interpolate( Finger4Angle2, 30, sTime, 30, eTime);    
      Interpolate( Finger4Angle3, 30, sTime, 30, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 0, sTime 0, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 5, sTime, 5, eTime);    
      union {
        object {
          #include "hand.inc"
          rotate 90*x
        }
        object {
          MagicStone
          translate <-1*cm, 4*cm, -2*cm>
        }      
        rotate From(180*z, sTime) To (90*z, eTime )
        translate 25*cm*z
        rotate From( -155*y, sTime) To( -195*y, eTime )
        rotate From( 0*x, sTime ) To (35*x, eTime)
        translate <-8*cm, -7*cm, -6*cm>
        
        // Now move the arm relative to the scene
        translate <-20*cm, height1+1.15*m, 67.6*m>
      }
      object { DragonsBloodJar rotate 243*y translate <38*cm, height1+1*m, 67.3*m> }
      
      #declare bloodHeight = sqrt( 0.24 ) * 1 *cm;
      intersection {
        plane { y, 2*cm translate bloodHeight*y }
        sphere { 0, 11*cm scale <2, 1, 2> translate 12*cm*y}
        texture { pigment { color rgb <0.7, 0.1, 0.2> } } normal {bumps 2 scale 1*cm turbulence 0.6 }
        translate bowlLocation
      }
      object { NewtEyes }  
      #break
  
  
    #case (10)  
      // Open the fingers
      #declare hand = 1;
      Interpolate( Finger1Angle1, 40, sTime, 20, eTime);    
      Interpolate( Finger1Angle2, 40, sTime, 20, eTime);    
      Interpolate( Finger1Angle3, 40, sTime, 20, eTime);    
      Interpolate( Finger2Angle1, 40, sTime, 20, eTime);    
      Interpolate( Finger2Angle2, 40, sTime, 20, eTime);    
      Interpolate( Finger2Angle3, 40, sTime, 20, eTime);    
      Interpolate( Finger3Angle1, 40, sTime, 20, eTime);    
      Interpolate( Finger3Angle2, 40, sTime, 20, eTime);    
      Interpolate( Finger3Angle3, 40, sTime, 20, eTime);    
      Interpolate( Finger4Angle1, 30, sTime, 10, eTime);    
      Interpolate( Finger4Angle2, 30, sTime, 10, eTime);    
      Interpolate( Finger4Angle3, 30, sTime, 10, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 10, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 0, sTime 0, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 5, sTime, 5, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From(90*z, sTime) To (90*z, eTime )
        translate 25*cm*z
        rotate From( -195*y, sTime) To( -195*y, eTime )
        rotate From( 35*x, sTime ) To (35*x, eTime)
        translate <-8*cm, -7*cm, -6*cm>
        
        // Now move the arm relative to the scene
        translate <-20*cm, height1+1.15*m, 67.6*m>
      }
      object { DragonsBloodJar rotate 243*y translate <38*cm, height1+1*m, 67.3*m> }
      object {
        MagicStone
        rotate -90*z
        rotate 28*x
        translate From ( <21*cm, 13*cm, 1*cm>, sTime)
        translate <-40*cm, height1+1*m + 3*cm, 67.33*m>
      }
      #declare bloodHeight = sqrt( 0.24 ) * 1 *cm;
      intersection {
        plane { y, 2*cm translate bloodHeight*y }
        sphere { 0, 11*cm scale <2, 1, 2> translate 12*cm*y}
        texture { pigment { color rgb <0.7, 0.1, 0.2> } } normal {bumps 2 scale 1*cm turbulence 0.6 }
        translate bowlLocation
      }
      object { NewtEyes }  
      #break
  
    #case (11)  
      // Eject the stone
      #declare hand = 1;
      Interpolate( Finger1Angle1, 10, sTime, 20, eTime);    
      Interpolate( Finger1Angle2, 10, sTime, 20, eTime);    
      Interpolate( Finger1Angle3, 10, sTime, 20, eTime);    
      Interpolate( Finger2Angle1, 10, sTime, 20, eTime);    
      Interpolate( Finger2Angle2, 10, sTime, 20, eTime);    
      Interpolate( Finger2Angle3, 10, sTime, 20, eTime);    
      Interpolate( Finger3Angle1, 10, sTime, 20, eTime);    
      Interpolate( Finger3Angle2, 10, sTime, 20, eTime);    
      Interpolate( Finger3Angle3, 10, sTime, 20, eTime);    
      Interpolate( Finger4Angle1, 5, sTime, 10, eTime);    
      Interpolate( Finger4Angle2, 5, sTime, 10, eTime);    
      Interpolate( Finger4Angle3, 5, sTime, 10, eTime);    
      Interpolate( ThumbAngle1, 10, sTime, 10, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 0, sTime 0, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 5, sTime, 5, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From(90*z, sTime) To (90*z, eTime )
        translate 25*cm*z
        rotate From( -195*y, sTime) To( -175*y, eTime )
        rotate From( 35*x, sTime ) To (15*x, eTime)
        translate <-8*cm, -7*cm, -6*cm>
        
        // Now move the arm relative to the scene
        translate <-20*cm, height1+1.15*m, 67.6*m>
      }
      object { DragonsBloodJar rotate 243*y translate <38*cm, height1+1*m, 67.3*m> }
      object {
        MagicStone
        rotate From( -90*z, sTime ) To (90*z, eTime)
        rotate From( 28*x, sTime ) To (-128*x, eTime)
        translate From ( <21*cm, 13*cm, 1*cm>, sTime) To (<40*cm, 2*cm, -3*cm>, eTime)
        translate <-40*cm, height1+1*m + 3*cm, 67.33*m>
      }
      #declare bloodHeight = sqrt( 0.24 ) * 1 *cm;
      intersection {
        plane { y, 2*cm translate bloodHeight*y }
        sphere { 0, 11*cm scale <2, 1, 2> translate 12*cm*y}
        texture { pigment { color rgb <0.7, 0.1, 0.2> } } normal {bumps 2 scale 1*cm turbulence 0.6 }
        translate bowlLocation
      }
      object { NewtEyes }  
      #break
  
    #case (12)  
      // Flash fire
      #declare hand = 1;
      Interpolate( Finger1Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle3, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle3, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle3, 20, sTime, 20, eTime);    
      Interpolate( Finger4Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle3, 10, sTime, 10, eTime);    
      Interpolate( ThumbAngle1, 10, sTime, 10, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 0, sTime 0, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 5, sTime, 5, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From(90*z, sTime) To (90*z, eTime )
        translate 25*cm*z
        rotate From( -175*y, sTime) To( -175*y, eTime )
        rotate From( 15*x, sTime ) To (15*x, eTime)
        translate <-8*cm, -7*cm, -6*cm>
        
        // Now move the arm relative to the scene
        translate <-20*cm, height1+1.15*m, 67.6*m>
      }
      object { DragonsBloodJar rotate 243*y translate <38*cm, height1+1*m, 67.3*m> }
      light_source {
        bowlLocation+3*cm*y
        White*8
      }
      
      light_source {
        bowlLocation + 20*cm*y
        White*4
      }  
      light_source {
        bowlLocation + 40*cm*y
        White*2
      }  
      light_source {
        bowlLocation + 60*cm*y
        White
      }        
      #break
  
    #case (13)  
      // Recovery, notice stone
      #declare hand = 1;
      Interpolate( Finger1Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger1Angle3, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger2Angle3, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle1, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle2, 20, sTime, 20, eTime);    
      Interpolate( Finger3Angle3, 20, sTime, 20, eTime);    
      Interpolate( Finger4Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle3, 10, sTime, 10, eTime);    
      Interpolate( ThumbAngle1, 10, sTime, 10, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 0, sTime 0, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 5, sTime, 5, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From(90*z, sTime) To (90*z, eTime )
        translate 25*cm*z
        rotate From( -175*y, sTime) To( -175*y, eTime )
        rotate From( 15*x, sTime ) To (15*x, eTime)
        translate <-8*cm, -7*cm, -6*cm>
        
        // Now move the arm relative to the scene
        translate <-20*cm, height1+1.15*m, 67.6*m>
      }
      object { FireStone(vClock) translate bowlLocation + 5*cm*y }
      object { DragonsBloodJar rotate 243*y translate <38*cm, height1+1*m, 67.3*m > } 
      #break
  
    #case (14)
      // Move hands to the bowl  
      Interpolate( Finger1Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger1Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger1Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle1, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle2, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle3, 5, sTime, 5, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 0, sTime 0, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 0, sTime, 0, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From( 270*z, sTime) To (270*z, eTime)
        translate 25*cm*z 
        rotate From( -202*y, sTime) To (-185*y, eTime)
        rotate From( 0*x, sTime ) To (-10*x, eTime)
        //translate <-10*cm, 0, 25*cm>
        translate From ( <-5*cm, 0, 25*cm>, sTime) To (<-20*cm, -0*cm, -5*cm>, eTime) 
        
        // Now move the arm relative to the scene
        translate <43*cm, height1+1.15*m, 67.6*m>
      }  
      
      #declare hand = 1;
      Interpolate( Finger1Angle1, 20, sTime, 5, eTime);    
      Interpolate( Finger1Angle2, 20, sTime, 5, eTime);    
      Interpolate( Finger1Angle3, 20, sTime, 5, eTime);    
      Interpolate( Finger2Angle1, 20, sTime, 5, eTime);    
      Interpolate( Finger2Angle2, 20, sTime, 5, eTime);    
      Interpolate( Finger2Angle3, 20, sTime, 5, eTime);    
      Interpolate( Finger3Angle1, 20, sTime, 5, eTime);    
      Interpolate( Finger3Angle2, 20, sTime, 5, eTime);    
      Interpolate( Finger3Angle3, 20, sTime, 5, eTime);    
      Interpolate( Finger4Angle1, 10, sTime, 5, eTime);    
      Interpolate( Finger4Angle2, 10, sTime, 5, eTime);    
      Interpolate( Finger4Angle3, 10, sTime, 5, eTime);    
      Interpolate( ThumbAngle1, 10, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 0, sTime, -9, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 10, eTime);    
      Interpolate( WristAngle, 5, sTime, -10, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From(90*z, sTime) To (90*z, eTime )
        translate 25*cm*z
        rotate From( -175*y, sTime) To( -189*y, eTime )
        rotate From( 15*x, sTime ) To (-9*x, eTime)
        translate From( <-8*cm, -7*cm, -6*cm>, sTime) To( <-7*cm, -0*cm, -4*cm>, eTime)
        
        // Now move the arm relative to the scene
        translate <-20*cm, height1+1.15*m, 67.6*m>
      }
      object { FireStone(vClock) translate bowlLocation + 5*cm*y }
      object { DragonsBloodJar rotate 243*y translate <38*cm, height1+1*m, 67.3*m > } 
      #break
  
    #case (15)
      // Bend the thumbs  
      Interpolate( Finger1Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger1Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger1Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle1, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle2, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle3, 5, sTime, 5, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 0, sTime 0, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 50, eTime);    
      Interpolate( WristAngle, 0, sTime, 0, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From( 270*z, sTime) To (270*z, eTime)
        translate 25*cm*z 
        rotate From( -185*y, sTime) To (-185*y, eTime)
        rotate From( 0*x, sTime ) To (-10*x, eTime)
        //translate <-10*cm, 0, 25*cm>
        translate From ( <-20*cm, 0, -5*cm>, sTime) To (<-20*cm, -0*cm, -5*cm>, eTime) 
        
        // Now move the arm relative to the scene
        translate <43*cm, height1+1.15*m, 67.6*m>
      }  
      
      #declare hand = 1;
      Interpolate( Finger1Angle1, 5, sTime, 5, eTime);    
      Interpolate( Finger1Angle2, 5, sTime, 5, eTime);    
      Interpolate( Finger1Angle3, 5, sTime, 5, eTime);    
      Interpolate( Finger2Angle1, 5, sTime, 5, eTime);    
      Interpolate( Finger2Angle2, 5, sTime, 5, eTime);    
      Interpolate( Finger2Angle3, 5, sTime, 5, eTime);    
      Interpolate( Finger3Angle1, 5, sTime, 5, eTime);    
      Interpolate( Finger3Angle2, 5, sTime, 5, eTime);    
      Interpolate( Finger3Angle3, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle1, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle2, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle3, 5, sTime, 5, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, -9, sTime, -9, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 50, eTime);    
      Interpolate( WristAngle, -10, sTime, -10, eTime);    
      object {
        #include "hand.inc"
        rotate 90*x
        rotate From(90*z, sTime) To (90*z, eTime )
        translate 25*cm*z
        rotate From( -189*y, sTime) To( -189*y, eTime )
        rotate From( -9*x, sTime ) To (-9*x, eTime)
        translate From( <-7*cm, -0*cm, -4*cm>, sTime) To( <-7*cm, -0*cm, -4*cm>, eTime)
        
        // Now move the arm relative to the scene
        translate <-20*cm, height1+1.15*m, 67.6*m>
      }
      object { FireStone(vClock) translate bowlLocation + 5*cm*y }
      object { DragonsBloodJar rotate 243*y translate <38*cm, height1+1*m, 67.3*m > } 
      #break
  
    #case (16)
      // Lift the bowl  
      union {
        Interpolate( Finger1Angle1, 10, sTime, 10, eTime);    
        Interpolate( Finger1Angle2, 10, sTime, 10, eTime);    
        Interpolate( Finger1Angle3, 10, sTime, 10, eTime);    
        Interpolate( Finger2Angle1, 10, sTime, 10, eTime);    
        Interpolate( Finger2Angle2, 10, sTime, 10, eTime);    
        Interpolate( Finger2Angle3, 10, sTime, 10, eTime);    
        Interpolate( Finger3Angle1, 10, sTime, 10, eTime);    
        Interpolate( Finger3Angle2, 10, sTime, 10, eTime);    
        Interpolate( Finger3Angle3, 10, sTime, 10, eTime);    
        Interpolate( Finger4Angle1, 5, sTime, 5, eTime);    
        Interpolate( Finger4Angle2, 5, sTime, 5, eTime);    
        Interpolate( Finger4Angle3, 5, sTime, 5, eTime);    
        Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
        Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
        Interpolate( ThumbJoint2TransverseAngle, 0, sTime 0, eTime);
        Interpolate( ThumbAngle3, 50, sTime, 50, eTime);    
        Interpolate( WristAngle, 0, sTime, 0, eTime);    
        object {
          #include "hand.inc"
          rotate 90*x
          rotate From( 270*z, sTime) To (270*z, eTime)
          translate 25*cm*z 
          rotate From( -185*y, sTime) To (-185*y, eTime)
          rotate From( -10*x, sTime ) To (-10*x, eTime)
          //translate <-10*cm, 0, 25*cm>
          translate From ( <-20*cm, 0, -5*cm>, sTime) To (<-20*cm, 0*cm, -5*cm>, eTime) 
          
          // Now move the arm relative to the scene
          translate <43*cm, height1+1.15*m, 67.6*m>
        }  
        
        #declare hand = 1;
        Interpolate( Finger1Angle1, 5, sTime, 5, eTime);    
        Interpolate( Finger1Angle2, 5, sTime, 5, eTime);    
        Interpolate( Finger1Angle3, 5, sTime, 5, eTime);    
        Interpolate( Finger2Angle1, 5, sTime, 5, eTime);    
        Interpolate( Finger2Angle2, 5, sTime, 5, eTime);    
        Interpolate( Finger2Angle3, 5, sTime, 5, eTime);    
        Interpolate( Finger3Angle1, 5, sTime, 5, eTime);    
        Interpolate( Finger3Angle2, 5, sTime, 5, eTime);    
        Interpolate( Finger3Angle3, 5, sTime, 5, eTime);    
        Interpolate( Finger4Angle1, 5, sTime, 5, eTime);    
        Interpolate( Finger4Angle2, 5, sTime, 5, eTime);    
        Interpolate( Finger4Angle3, 5, sTime, 5, eTime);    
        Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
        Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
        Interpolate( ThumbJoint2TransverseAngle, -9, sTime, -9, eTime);
        Interpolate( ThumbAngle3, 50, sTime, 50, eTime);    
        Interpolate( WristAngle, -10, sTime, -10, eTime);    
        object {
          #include "hand.inc"
          rotate 90*x
          rotate From(90*z, sTime) To (90*z, eTime )
          translate 25*cm*z
          rotate From( -189*y, sTime) To( -189*y, eTime )
          rotate From( -9*x, sTime ) To (-9*x, eTime)
          translate From( <-7*cm, -0*cm, -4*cm>, sTime) To( <-7*cm, 0*cm, -4*cm>, eTime)
          
          // Now move the arm relative to the scene
          translate <-20*cm, height1+1.15*m, 67.6*m>
        }
        object { aBowl }
        object { FireStone(vClock) translate bowlLocation + 5*cm*y }
        translate <0, -height1-1.15*m, -67.6>
        rotate From( 0*x, sTime) To (20*x, eTime)
        translate <0, height1+1.16, 67.6>
      }  
      object { DragonsBloodJar rotate 243*y translate <38*cm, height1+1*m, 67.3*m > } 
      #break
  
    #case (17)
      // follow the rising stone  
      union {
        Interpolate( Finger1Angle1, 10, sTime, 10, eTime);    
        Interpolate( Finger1Angle2, 10, sTime, 10, eTime);    
        Interpolate( Finger1Angle3, 10, sTime, 10, eTime);    
        Interpolate( Finger2Angle1, 10, sTime, 10, eTime);    
        Interpolate( Finger2Angle2, 10, sTime, 10, eTime);    
        Interpolate( Finger2Angle3, 10, sTime, 10, eTime);    
        Interpolate( Finger3Angle1, 10, sTime, 10, eTime);    
        Interpolate( Finger3Angle2, 10, sTime, 10, eTime);    
        Interpolate( Finger3Angle3, 10, sTime, 10, eTime);    
        Interpolate( Finger4Angle1, 5, sTime, 5, eTime);    
        Interpolate( Finger4Angle2, 5, sTime, 5, eTime);    
        Interpolate( Finger4Angle3, 5, sTime, 5, eTime);    
        Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
        Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
        Interpolate( ThumbJoint2TransverseAngle, 0, sTime 0, eTime);
        Interpolate( ThumbAngle3, 10, sTime, 50, eTime);    
        Interpolate( WristAngle, 0, sTime, 0, eTime);    
        object {
          #include "hand.inc"
          rotate 90*x
          rotate From( 270*z, sTime) To (270*z, eTime)
          translate 25*cm*z 
          rotate From( -185*y, sTime) To (-185*y, eTime)
          rotate From( 0*x, sTime ) To (-10*x, eTime)
          //translate <-10*cm, 0, 25*cm>
          translate From ( <-20*cm, 0, -5*cm>, sTime) To (<-20*cm, 0*cm, -5*cm>, eTime) 
          
          // Now move the arm relative to the scene
          translate <43*cm, height1+1.15*m, 67.6*m>
        }  
        
        #declare hand = 1;
        Interpolate( Finger1Angle1, 5, sTime, 5, eTime);    
        Interpolate( Finger1Angle2, 5, sTime, 5, eTime);    
        Interpolate( Finger1Angle3, 5, sTime, 5, eTime);    
        Interpolate( Finger2Angle1, 5, sTime, 5, eTime);    
        Interpolate( Finger2Angle2, 5, sTime, 5, eTime);    
        Interpolate( Finger2Angle3, 5, sTime, 5, eTime);    
        Interpolate( Finger3Angle1, 5, sTime, 5, eTime);    
        Interpolate( Finger3Angle2, 5, sTime, 5, eTime);    
        Interpolate( Finger3Angle3, 5, sTime, 5, eTime);    
        Interpolate( Finger4Angle1, 5, sTime, 5, eTime);    
        Interpolate( Finger4Angle2, 5, sTime, 5, eTime);    
        Interpolate( Finger4Angle3, 5, sTime, 5, eTime);    
        Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
        Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
        Interpolate( ThumbJoint2TransverseAngle, -9, sTime, -9, eTime);
        Interpolate( ThumbAngle3, 10, sTime, 50, eTime);    
        Interpolate( WristAngle, -10, sTime, -10, eTime);    
        object {
          #include "hand.inc"
          rotate 90*x
          rotate From(90*z, sTime) To (90*z, eTime )
          translate 25*cm*z
          rotate From( -189*y, sTime) To( -189*y, eTime )
          rotate From( -9*x, sTime ) To (-9*x, eTime)
          translate From( <-7*cm, -0*cm, -4*cm>, sTime) To( <-7*cm, 0*cm, -4*cm>, eTime)
          
          // Now move the arm relative to the scene
          translate <-20*cm, height1+1.15*m, 67.6*m>
        }
        object { aBowl }
        translate <0, -height1-1.15*m, -67.6>
        rotate From( 20*x, sTime ) To (0*x, eTime)
        translate <0, height1+1.16, 67.6>
      }  
      object { DragonsBloodJar rotate 243*y translate <38*cm, height1+1*m, 67.3*m > } 
      object {
        FireStone(vClock)
        translate bowlLocation + 5*cm*y
        translate <0, -height1-1.15*m, -67.6>
        rotate 20*x
        translate <0, height1+1.16, 67.6>
        translate From( 0, sTime) To (50*cm*y, eTime)
      }
      #break
  
    #case (18)
      // Pause
      object { aBowl }
      object { DragonsBloodJar rotate 243*y translate <38*cm, height1+1*m, 67.3*m > } 
      object { FireStone(vClock) translate <0.0, 44.1686, 67.2839> }
      #break
  
    #case (19)
      // Move hands into position  
      Interpolate( Finger1Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger1Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger1Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger2Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle1, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle2, 10, sTime, 10, eTime);    
      Interpolate( Finger3Angle3, 10, sTime, 10, eTime);    
      Interpolate( Finger4Angle1, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle2, 5, sTime, 5, eTime);    
      Interpolate( Finger4Angle3, 5, sTime, 5, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, 0, sTime 0, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 50, eTime);    
      Interpolate( WristAngle, 0, sTime, -15, eTime);    
      object {
        #include "hand.inc"
        rotate 90*y
        translate 25*cm*y 
        rotate From( -90*x, sTime) To (-55*x, eTime)
        rotate 25*y
        translate From( <-15*cm, 30*cm, 0*cm>, sTime ) To (<-15*cm, 30*cm, -25*cm>, eTime)
        
        // Now move the arm relative to the scene
        translate <43*cm, height1+1.15*m, 67.6*m>
      }  
      
      #declare hand = 1;
      Interpolate( Finger1Angle1, 5, sTime, 10, eTime);    
      Interpolate( Finger1Angle2, 5, sTime, 10, eTime);    
      Interpolate( Finger1Angle3, 5, sTime, 10, eTime);    
      Interpolate( Finger2Angle1, 5, sTime, 10, eTime);    
      Interpolate( Finger2Angle2, 5, sTime, 10, eTime);    
      Interpolate( Finger2Angle3, 5, sTime, 10, eTime);    
      Interpolate( Finger3Angle1, 5, sTime, 10, eTime);    
      Interpolate( Finger3Angle2, 5, sTime, 10, eTime);    
      Interpolate( Finger3Angle3, 5, sTime, 10, eTime);    
      Interpolate( Finger4Angle1, 5, sTime, 10, eTime);    
      Interpolate( Finger4Angle2, 5, sTime, 10, eTime);    
      Interpolate( Finger4Angle3, 5, sTime, 10, eTime);    
      Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
      Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
      Interpolate( ThumbJoint2TransverseAngle, -9, sTime, -9, eTime);
      Interpolate( ThumbAngle3, 10, sTime, 50, eTime);    
      Interpolate( WristAngle, -10, sTime, -10, eTime);    
      object {
        #include "hand.inc"
        rotate -90*y
        translate 25*cm*y 
        rotate From( -90*x, sTime) To (-55*x, eTime)
        rotate -25*y
        translate From( <-5*cm, 30*cm, 0*cm>, sTime) To (<-5*cm, 30*cm, -25*cm>, eTime)
        
        // Now move the arm relative to the scene
        translate <-20*cm, height1+1.15*m, 67.6*m>
      }
      object { FireStone(vClock) translate <0.0, 44.1686, 67.2839> }
      #break
  
    #case (20)
      // Cast the powerup spell 
      #declare fRand = seed(231);
      #declare t1 = sTime + (eTime-sTime) * 1/5;
      #declare t2 = sTime + (eTime-sTime) * 2/5;
      #declare t3 = sTime + (eTime-sTime) * 3/5;
      #declare t4 = sTime + (eTime-sTime) * 4/5;
      #declare a1 = 90*rand(fRand);
      #declare a2 = 90*rand(fRand);
      #declare a3 = 90*rand(fRand);
      #declare a4 = 90*rand(fRand);
      Declare_From( Finger1Angle1, 10, sTime ) Declare_To (Finger1Angle1, a1, t1) Declare_To( Finger1Angle1, a2, t2) Declare_To( Finger1Angle1, a3, t3) Declare_To( Finger1Angle1, a4, t4) Declare_To( Finger1Angle1, 0, eTime )
      Declare_From( Finger1Angle2, 10, sTime ) Declare_To (Finger1Angle2, a1, t1) Declare_To( Finger1Angle2, a2, t2) Declare_To( Finger1Angle2, a3, t3) Declare_To( Finger1Angle2, a4, t4) Declare_To( Finger1Angle2, 0, eTime )
      Declare_From( Finger1Angle3, 10, sTime ) Declare_To (Finger1Angle3, a1, t1) Declare_To( Finger1Angle3, a2, t2) Declare_To( Finger1Angle3, a3, t3) Declare_To( Finger1Angle3, a4, t4) Declare_To( Finger1Angle3, 0, eTime )
      #declare a1 = 90*rand(fRand);
      #declare a2 = 90*rand(fRand);
      #declare a3 = 90*rand(fRand);
      #declare a4 = 90*rand(fRand);
      Declare_From( Finger1Angle1, 10, sTime ) Declare_To (Finger2Angle1, a1, t1) Declare_To( Finger2Angle1, a2, t2) Declare_To( Finger2Angle1, a3, t3) Declare_To( Finger2Angle1, a4, t4) Declare_To( Finger2Angle1, 0, eTime )
      Declare_From( Finger2Angle2, 10, sTime ) Declare_To (Finger2Angle2, a1, t1) Declare_To( Finger2Angle2, a2, t2) Declare_To( Finger2Angle2, a3, t3) Declare_To( Finger2Angle2, a4, t4) Declare_To( Finger2Angle2, 0, eTime )
      Declare_From( Finger2Angle3, 10, sTime ) Declare_To (Finger2Angle3, a1, t1) Declare_To( Finger2Angle3, a2, t2) Declare_To( Finger2Angle3, a3, t3) Declare_To( Finger2Angle3, a4, t4) Declare_To( Finger2Angle3, 0, eTime )
      #declare a1 = 90*rand(fRand);
      #declare a2 = 90*rand(fRand);
      #declare a3 = 90*rand(fRand);
      #declare a4 = 90*rand(fRand);
      Declare_From( Finger3Angle1, 10, sTime ) Declare_To (Finger3Angle1, a1, t1) Declare_To( Finger3Angle1, a2, t2) Declare_To( Finger3Angle1, a3, t3) Declare_To( Finger3Angle1, a4, t4) Declare_To( Finger3Angle1, 0, eTime )
      Declare_From( Finger3Angle2, 10, sTime ) Declare_To (Finger3Angle2, a1, t1) Declare_To( Finger3Angle2, a2, t2) Declare_To( Finger3Angle2, a3, t3) Declare_To( Finger3Angle2, a4, t4) Declare_To( Finger3Angle2, 0, eTime )
      Declare_From( Finger3Angle3, 10, sTime ) Declare_To (Finger3Angle3, a1, t1) Declare_To( Finger3Angle3, a2, t2) Declare_To( Finger3Angle3, a3, t3) Declare_To( Finger3Angle3, a4, t4) Declare_To( Finger3Angle3, 0, eTime )
      #declare a1 = 90*rand(fRand);
      #declare a2 = 90*rand(fRand);
      #declare a3 = 90*rand(fRand);
      #declare a4 = 90*rand(fRand);
      Declare_From( Finger4Angle1, 10, sTime ) Declare_To (Finger4Angle1, a1, t1) Declare_To( Finger4Angle1, a2, t2) Declare_To( Finger4Angle1, a3, t3) Declare_To( Finger4Angle1, a4, t4) Declare_To( Finger4Angle1, 0, eTime )
      Declare_From( Finger4Angle2, 10, sTime ) Declare_To (Finger4Angle2, a1, t1) Declare_To( Finger4Angle2, a2, t2) Declare_To( Finger4Angle2, a3, t3) Declare_To( Finger4Angle2, a4, t4) Declare_To( Finger4Angle2, 0, eTime )
      Declare_From( Finger4Angle3, 10, sTime ) Declare_To (Finger4Angle3, a1, t1) Declare_To( Finger4Angle3, a2, t2) Declare_To( Finger4Angle3, a3, t3) Declare_To( Finger4Angle3, a4, t4) Declare_To( Finger4Angle3, 0, eTime )
      #declare a1 = 60*rand(fRand);
      #declare a2 = 60*rand(fRand);
      #declare a3 = 60*rand(fRand);
      #declare a4 = 60*rand(fRand);
      Declare_From( ThumbAngle1, 60, sTime ) Declare_To (ThumbAngle1, a1, t1) Declare_To( ThumbAngle1, a2, t2) Declare_To( ThumbAngle1, a3, t3) Declare_To( ThumbAngle1, a4, t4) Declare_To( ThumbAngle1, 30, eTime )
      Declare_From( ThumbAngle2, 10, sTime ) Declare_To (ThumbAngle2, a1, t1) Declare_To( ThumbAngle2, a2, t2) Declare_To( ThumbAngle2, a3, t3) Declare_To( ThumbAngle2, a4, t4) Declare_To( ThumbAngle2, 0, eTime )
      Declare_From( ThumbAngle3, 10, sTime ) Declare_To (ThumbAngle3, a1, t1) Declare_To( ThumbAngle3, a2, t2) Declare_To( ThumbAngle3, a3, t3) Declare_To( ThumbAngle3, a4, t4) Declare_To( ThumbAngle3, 0, eTime )
      Interpolate( ThumbJoint2TransverseAngle, 0, sTime 0, eTime);
      Declare_From( WristAngle, -15, sTime ) Declare_To( WristAngle, -30, sTime + (eTime-sTime)*4/5 ) Declare_To( WristAngle, 0, eTime )    
      object {
        #include "hand.inc"
        rotate 90*y
        translate 25*cm*y 
        rotate From( -55*x, sTime) To (-55*x, eTime)
        rotate 25*y
        translate <-15*cm, 30*cm, -25*cm>
        
        // Now move the arm relative to the scene
        translate <43*cm, height1+1.15*m, 67.6*m>
      }  
      
      #declare hand = 1;
      #declare a1 = 90*rand(fRand);
      #declare a2 = 90*rand(fRand);
      #declare a3 = 90*rand(fRand);
      #declare a4 = 90*rand(fRand);
      Declare_From( Finger1Angle1, 10, sTime ) Declare_To (Finger1Angle1, a1, t1) Declare_To( Finger1Angle1, a2, t2) Declare_To( Finger1Angle1, a3, t3) Declare_To( Finger1Angle1, a4, t4) Declare_To( Finger1Angle1, 0, eTime )
      Declare_From( Finger1Angle2, 10, sTime ) Declare_To (Finger1Angle2, a1, t1) Declare_To( Finger1Angle2, a2, t2) Declare_To( Finger1Angle2, a3, t3) Declare_To( Finger1Angle2, a4, t4) Declare_To( Finger1Angle2, 0, eTime )
      Declare_From( Finger1Angle3, 10, sTime ) Declare_To (Finger1Angle3, a1, t1) Declare_To( Finger1Angle3, a2, t2) Declare_To( Finger1Angle3, a3, t3) Declare_To( Finger1Angle3, a4, t4) Declare_To( Finger1Angle3, 0, eTime )
      #declare a1 = 90*rand(fRand);
      #declare a2 = 90*rand(fRand);
      #declare a3 = 90*rand(fRand);
      #declare a4 = 90*rand(fRand);
      Declare_From( Finger1Angle1, 10, sTime ) Declare_To (Finger2Angle1, a1, t1) Declare_To( Finger2Angle1, a2, t2) Declare_To( Finger2Angle1, a3, t3) Declare_To( Finger2Angle1, a4, t4) Declare_To( Finger2Angle1, 0, eTime )
      Declare_From( Finger2Angle2, 10, sTime ) Declare_To (Finger2Angle2, a1, t1) Declare_To( Finger2Angle2, a2, t2) Declare_To( Finger2Angle2, a3, t3) Declare_To( Finger2Angle2, a4, t4) Declare_To( Finger2Angle2, 0, eTime )
      Declare_From( Finger2Angle3, 10, sTime ) Declare_To (Finger2Angle3, a1, t1) Declare_To( Finger2Angle3, a2, t2) Declare_To( Finger2Angle3, a3, t3) Declare_To( Finger2Angle3, a4, t4) Declare_To( Finger2Angle3, 0, eTime )
      #declare a1 = 90*rand(fRand);
      #declare a2 = 90*rand(fRand);
      #declare a3 = 90*rand(fRand);
      #declare a4 = 90*rand(fRand);
      Declare_From( Finger3Angle1, 10, sTime ) Declare_To (Finger3Angle1, a1, t1) Declare_To( Finger3Angle1, a2, t2) Declare_To( Finger3Angle1, a3, t3) Declare_To( Finger3Angle1, a4, t4) Declare_To( Finger3Angle1, 0, eTime )
      Declare_From( Finger3Angle2, 10, sTime ) Declare_To (Finger3Angle2, a1, t1) Declare_To( Finger3Angle2, a2, t2) Declare_To( Finger3Angle2, a3, t3) Declare_To( Finger3Angle2, a4, t4) Declare_To( Finger3Angle2, 0, eTime )
      Declare_From( Finger3Angle3, 10, sTime ) Declare_To (Finger3Angle3, a1, t1) Declare_To( Finger3Angle3, a2, t2) Declare_To( Finger3Angle3, a3, t3) Declare_To( Finger3Angle3, a4, t4) Declare_To( Finger3Angle3, 0, eTime )
      #declare a1 = 90*rand(fRand);
      #declare a2 = 90*rand(fRand);
      #declare a3 = 90*rand(fRand);
      #declare a4 = 90*rand(fRand);
      Declare_From( Finger4Angle1, 10, sTime ) Declare_To (Finger4Angle1, a1, t1) Declare_To( Finger4Angle1, a2, t2) Declare_To( Finger4Angle1, a3, t3) Declare_To( Finger4Angle1, a4, t4) Declare_To( Finger4Angle1, 0, eTime )
      Declare_From( Finger4Angle2, 10, sTime ) Declare_To (Finger4Angle2, a1, t1) Declare_To( Finger4Angle2, a2, t2) Declare_To( Finger4Angle2, a3, t3) Declare_To( Finger4Angle2, a4, t4) Declare_To( Finger4Angle2, 0, eTime )
      Declare_From( Finger4Angle3, 10, sTime ) Declare_To (Finger4Angle3, a1, t1) Declare_To( Finger4Angle3, a2, t2) Declare_To( Finger4Angle3, a3, t3) Declare_To( Finger4Angle3, a4, t4) Declare_To( Finger4Angle3, 0, eTime )
      #declare a1 = 60*rand(fRand);
      #declare a2 = 60*rand(fRand);
      #declare a3 = 60*rand(fRand);
      #declare a4 = 60*rand(fRand);
      Declare_From( ThumbAngle1, 60, sTime ) Declare_To (ThumbAngle1, a1, t1) Declare_To( ThumbAngle1, a2, t2) Declare_To( ThumbAngle1, a3, t3) Declare_To( ThumbAngle1, a4, t4) Declare_To( ThumbAngle1, 30, eTime )
      Declare_From( ThumbAngle2, 10, sTime ) Declare_To (ThumbAngle2, a1, t1) Declare_To( ThumbAngle2, a2, t2) Declare_To( ThumbAngle2, a3, t3) Declare_To( ThumbAngle2, a4, t4) Declare_To( ThumbAngle2, 0, eTime )
      Declare_From( ThumbAngle3, 50, sTime ) Declare_To (ThumbAngle3, a1, t1) Declare_To( ThumbAngle3, a2, t2) Declare_To( ThumbAngle3, a3, t3) Declare_To( ThumbAngle3, a4, t4) Declare_To( ThumbAngle3, 0, eTime )
      Declare_From( WristAngle, -10, sTime ) Declare_To( WristAngle, -30, sTime + (eTime-sTime)*4/5 ) Declare_To( WristAngle, 0, eTime )    
      Interpolate( ThumbJoint2TransverseAngle, -9, sTime, -9, eTime);
      object {
        #include "hand.inc"
        rotate -90*y
        translate 25*cm*y 
        rotate From( -55*x, sTime) To (-55*x, eTime)
        rotate -25*y
        translate <-5*cm, 30*cm, -25*cm>
        
        // Now move the arm relative to the scene
        translate <-20*cm, height1+1.15*m, 67.6*m>
      }
      #declare spherePower = 0;
      Interpolate( spherePower, 0, sTime, 1, eTime );
      object { FireStone(vClock) translate <0.0, 44.1686, 67.2839> }
      #break
  
    #case (21)
      // Fire the sphere  
      // Moved to macro below
      #break
  
  #end    


  camera {
    #switch (segment)
      #case (17)
        location From (<0, (height1+1.8)*m, 67.7>, sTime) To (<0, (height1+1.8)*m, 67.6*m>, eTime)
        look_at From( <0, 0, 30>, sTime) To( <0, 0, -75>, eTime)
        #break
        
  //      #case (21)
  //        location From (<0, (height1+1.8)*m, 67.6>, sTime) To (<0, 20*m, -74*m>, eTime)
  //        look_at From( <0, 0, -75>, sTime) To( <0, 20*m, -76>, eTime)
  //        #break
        
      #range (18,99)  
        location <0, (height1+1.8)*m, 67.6*m>
        look_at <0, 0, -75>
        #break
      
      #range (0, 16)
        location From(<0, (height1+1.8)*m, 68*m>, 0) To (<0, (height1+1.8)*m, 67.7>, 0.2)
        look_at From( <0, 0, -75>, 0) To( <0, 0, 30>, 0.2)
        #break
    #end    
  }

#end

#macro FireBullet()
  // This is called from the main forces.pov to allow synchronisation of the explosion
  Interpolate( Finger1Angle1, 10, sTime, 10, eTime);    
  Interpolate( Finger1Angle2, 10, sTime, 10, eTime);    
  Interpolate( Finger1Angle3, 10, sTime, 10, eTime);    
  Interpolate( Finger2Angle1, 10, sTime, 10, eTime);    
  Interpolate( Finger2Angle2, 10, sTime, 10, eTime);    
  Interpolate( Finger2Angle3, 10, sTime, 10, eTime);    
  Interpolate( Finger3Angle1, 10, sTime, 10, eTime);    
  Interpolate( Finger3Angle2, 10, sTime, 10, eTime);    
  Interpolate( Finger3Angle3, 10, sTime, 10, eTime);    
  Interpolate( Finger4Angle1, 5, sTime, 5, eTime);    
  Interpolate( Finger4Angle2, 5, sTime, 5, eTime);    
  Interpolate( Finger4Angle3, 5, sTime, 5, eTime);    
  Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
  Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
  Interpolate( ThumbJoint2TransverseAngle, 0, sTime 0, eTime);
  Interpolate( ThumbAngle3, 10, sTime, 50, eTime);    
  Interpolate( WristAngle, -15, sTime, -15, eTime);    
  object {
    #include "hand.inc"
    rotate 90*y
    translate 25*cm*y 
    rotate From( -55*x, sTime) To (-90*x, eTime)
    rotate 25*y
    translate From(<-15*cm, 30*cm, -25*cm>, sTime) To (<-15*cm, 30*cm, 0*cm>, eTime )
    
    // Now move the arm relative to the scene
    translate <43*cm, height1+1.15*m, 67.6*m>
  }  
  
  #declare hand = 1;
  Interpolate( Finger1Angle1, 5, sTime, 5, eTime);    
  Interpolate( Finger1Angle2, 5, sTime, 5, eTime);    
  Interpolate( Finger1Angle3, 5, sTime, 5, eTime);    
  Interpolate( Finger2Angle1, 5, sTime, 5, eTime);    
  Interpolate( Finger2Angle2, 5, sTime, 5, eTime);    
  Interpolate( Finger2Angle3, 5, sTime, 5, eTime);    
  Interpolate( Finger3Angle1, 5, sTime, 5, eTime);    
  Interpolate( Finger3Angle2, 5, sTime, 5, eTime);    
  Interpolate( Finger3Angle3, 5, sTime, 5, eTime);    
  Interpolate( Finger4Angle1, 5, sTime, 5, eTime);    
  Interpolate( Finger4Angle2, 5, sTime, 5, eTime);    
  Interpolate( Finger4Angle3, 5, sTime, 5, eTime);    
  Interpolate( ThumbAngle1, 60, sTime, 60, eTime);    
  Interpolate( ThumbAngle2, 10, sTime, 10, eTime); 
  Interpolate( ThumbJoint2TransverseAngle, -9, sTime, -9, eTime);
  Interpolate( ThumbAngle3, 50, sTime, 50, eTime);    
  Interpolate( WristAngle, -10, sTime, -10, eTime);    
  object {
    #include "hand.inc"
    rotate -90*y
    translate 25*cm*y 
    rotate From( -55*x, sTime) To (-90*x, eTime)
    rotate -25*y
    translate From( <-5*cm, 30*cm, -25*cm>, sTime) To (<-5*cm, 30*cm, 0*cm>, eTime)
    
    // Now move the arm relative to the scene
    translate <-20*cm, height1+1.15*m, 67.6*m>
  }
  #declare spherePower = 1;
  object { FireStone(vClock) translate From( <0.0, 44.1686, 67.2839>, sTime) To (collisionLocation, eTime) }
#end

