// Persistence of Vision Ray Tracer Scene Description File
// File: nena.pov
// Vers: 3.1g
// Desc: houses / street / general stage
// Date: Jan 09 2002
// Auth: Gustavo Reyes
//

global_settings { assumed_gamma 1 }
default { finish { phong .5 phong_size 100 ambient .5 diffuse .6 }
        pigment { color Red } }

#declare escaque = superellipsoid { <0.1, 0.1> }
#declare front = union {
        object { escaque }
        object { escaque translate -2.1*x }
        object { escaque translate  2.1*x }

        object { escaque translate 2.1*y }
        object { escaque translate <-2.1, 2.1, 0> }
        object { escaque translate < 2.1, 2.1, 0> }

        object { escaque translate 4.2*y }
        object { escaque translate <-2.1, 4.2, 0> }
        object { escaque translate < 2.1, 4.2, 0> }
        scale <1, 1, .2>
        }

#declare rights_side = union {
        object { escaque }
        object { escaque translate -2.1*x }
        object { escaque translate  2.1*x }

        object { escaque translate 2.1*y } 
        object { escaque translate <-2.1, 2.1, 0> }
        object { escaque translate < 2.1, 2.1, 0> }

        object { escaque translate 4.2*y }
        object { escaque translate <-2.1, 4.2, 0> }
        object { escaque translate < 2.1, 4.2, 0> }
        scale <1, 1, .2>
        }

#declare upper_side = union {
        object { escaque }
        object { escaque translate -2.1*x }
        object { escaque translate  2.1*x }

        object { escaque translate 2.1*y }
        object { escaque translate <-2.1, 2.1, 0> }
        object { escaque translate < 2.1, 2.1, 0> }

        object { escaque translate 4.2*y }
        object { escaque translate <-2.1, 4.2, 0> }
        object { escaque translate < 2.1, 4.2, 0> }
        scale <1, 1, .2>
        }

#declare rubik = union {        
        object { front pigment { colour Red } }
        
        object { rights_side scale .4*x
        matrix
        < 1.0, 1.0, 0.0,
          0.0, 1.0, 0.0,
          0.0, 0.0, 1.0,
          0.0, 0.3, 0.0>
          translate <4.5, .95, 0.0> pigment { colour Green }
         }
        
        object { upper_side scale .4*y
        matrix
        < 1.0, 0.0, 0.0,
          1.0, 1.0, 0.0,
          0.0, 0.0, 1.0,
          0.0, 0.3, 0.0>
          translate <0.5, 5.4, 0.0> pigment { colour Blue }
         }
         }

#declare cubo = union {
        object { rubik }
        prism { linear_sweep linear_spline -0.5, 0.5, 6,
                <-3.20, -1.15>, <-3.20,  5.30>, <-0.55,  7.87>,
                < 5.85,  7.87>, < 5.85,  1.40>, < 3.30, -1.15>
                rotate -90*x translate .4*z pigment { colour Black } }
        rotate 90*x translate <4, 0, -4>  }

#declare bigcasainn = polygon { 8,
        <31.2, .5>, <33.5, .5>, <32.7, 5>, <33.5, 14.5>,
        <19.8, 21>, <19.7, 14>, <.5, 14>, <.5, .5>  }

#declare bigcasaout = polygon { 19,
        <0, 0>,  <0, 14.5>, <19.2, 14.2>, <19.2, 22>, <34, 14.8>, <33.2, 5>, <33.8, 0>,
        <31.2, 0>, <31.2, .5>, <33.5, .5>, <32.7, 5>, <33.5, 14.5>, <19.8, 21>, <19.7, 14>,
        <.5, 14>, <.5, .5>, <26.5, .5>, <26.5, 0>, <0, 0> }

#declare smallhomeout = polygon { 15,
        <0, 0>, <0, 14>, <13, 21.5>, <26, 14>, <26, 0>, <16.8, 0>,  <16.8, .5>, <25.5, .5>,
        <25.5, 13.3>, <13, 20.8>, <.5, 13.2>, <.5, .5>, <12.5, .5>, <12.5, 0>, <0, 0> }

#declare smallhomeinn = polygon { 6,
        <.5, .5>, <25.5, .5>, <25.5, 13.3>,
        <13, 20.8>, <.5, 13.2>, <.5, .5> }

#declare door = polygon { 9,
        <0,0>, <-1.4, 11>, <5, 11.2>, <5, 0>, <4.6, 0>,
        <4.6, 10.1>, <-1, 10.5>, <.5, 0>, <0, 0> }

#declare doorinn = polygon { 5, <4.6, 0>, <4.6, 10.1>, <-1, 10.5>, <.5, 0>, <4.6, 0> }

#declare bigwin = union {
        polygon { 5, <0, 0>, <.6, 6>, <15.4, 6.2>, <14.7, 0>, <0, 0>
                translate .1*z pigment { color SemiSweetChoc } }
        polygon { 5, <.4, .4>, <.6, 2.4>, <3.2, 2.4>, <2.7, .3>, <.4, .4> }
        polygon { 5, <.55, 2.8>, <.9, 5.7>, <3.75, 5.8>,  <3.3, 2.7>, <.55, 2.8> }
        polygon { 5, <3.7, .4>, <3.8, 2.4>, <6.4, 2.4>, <5.9, .3>, <3.7, .4> }
        polygon { 5, <3.8, 2.8>, <4.2, 5.7>, <7, 5.8>, <6.5, 2.7>, <3.8, 2.8> }
        polygon { 5, <6.8, .4>, <6.9, 2.4>, <9.6, 2.4>, <9.3, .3>, <6.8, .4> }
        polygon { 5, <6.8, 2.8>, <7.3, 5.7>, <10.2, 5.8>, <9.7, 2.7>, <6.8, 2.8> }
        polygon { 5, <9.9, .4>, <10.3, 2.4>, <12.7, 2.4>, <12.3, .3>, <9.9, .4> }
        polygon { 5, <10.1, 2.8>, <10.5, 5.7>, <13.4, 5.8>, <12.8, 2.7>, <10.1, 2.8> }
        polygon { 5, <12.7, .4>, <13.3, 2.4>, <14.6, 2.4>, <14.4, .3>, <12.7, .4> }
        polygon { 5, <13.2, 2.8>, <13.7, 5.7>, <15, 5.8>, <14.7, 2.7>, <13.2, 2.8> }
        }

#declare bigwin2 = union {
        polygon { 5, <0, 0>, <.6, 6>, <15.4, 6.2>, <14.7, 0>, <0, 0>
                translate -.1*z pigment { color SemiSweetChoc } }
        polygon { 5, <.4, .4>, <.6, 2.4>, <3.2, 2.4>, <2.7, .3>, <.4, .4> }
        polygon { 5, <.55, 2.8>, <.9, 5.7>, <3.75, 5.8>,  <3.3, 2.7>, <.55, 2.8> }
        polygon { 5, <3.7, .4>, <3.8, 2.4>, <6.4, 2.4>, <5.9, .3>, <3.7, .4> }
        polygon { 5, <3.8, 2.8>, <4.2, 5.7>, <7, 5.8>, <6.5, 2.7>, <3.8, 2.8> }
        polygon { 5, <6.8, .4>, <6.9, 2.4>, <9.6, 2.4>, <9.3, .3>, <6.8, .4> }
        polygon { 5, <6.8, 2.8>, <7.3, 5.7>, <10.2, 5.8>, <9.7, 2.7>, <6.8, 2.8> }
        polygon { 5, <9.9, .4>, <10.3, 2.4>, <12.7, 2.4>, <12.3, .3>, <9.9, .4> }
        polygon { 5, <10.1, 2.8>, <10.5, 5.7>, <13.4, 5.8>, <12.8, 2.7>, <10.1, 2.8> }
        polygon { 5, <12.7, .4>, <13.3, 2.4>, <14.6, 2.4>, <14.4, .3>, <12.7, .4> }
        polygon { 5, <13.2, 2.8>, <13.7, 5.7>, <15, 5.8>, <14.7, 2.7>, <13.2, 2.8> }
        rotate 180*y  translate -.1*z }

#declare smallwin = union {
        polygon { 5, <0, 0>, <-.6, 6.3>, <5.8, 6.3>, <5.8, .1>, <0, 0>
                translate .1*z pigment { color BakersChoc } }
        polygon { 5, <.3, .3>, <.2, 2.6>, <2.9, 2.7>, <3.3, .4>, <.3, .3> }
        polygon { 5, <.3, 3>, <-.3, 5.8>, <2.8, 6>, <3, 3>, <.3, 3> }
        polygon { 5, <3.7, .5>, <3.3, 2.8>, <5.4, 3>, <5.3, .7>, <3.7, .5> }
        polygon { 5, <3.3, 3.1>, <3.1, 5.8>, <5.5, 6.2>, <5.45, 3.3>, <3.3, 3.1> }
        }

#declare bighouse = union {
        object { bigcasainn pigment { color NeonBlue } } 
        object { bigcasaout pigment { color Gray20 } translate .1*z }
        object { bigwin translate <4, 4.2, -.1> pigment {color Wheat} }
        object { door translate <26.4, 0, -.1> pigment {color Gray30 } }
        object { doorinn translate <26.4, 0, -.1> pigment {color Wheat} } }

#declare smallhouse = union {
        object { smallhomeinn } 
        object { smallhomeout pigment { color Gray20 } translate .1*z }
        object { smallwin translate <4, 4.2, -.2> pigment {color Orange } }
        object { door translate <13.4, 0, -.1> pigment {color Gray30 } }
        object { doorinn translate <13.4, 0, -.1> pigment {color Yellow } } }

#declare bighouse2 = union {
        object { bigcasainn rotate 180*y } 
        object { bigcasaout rotate 180*y pigment { color Gray20 } translate .1*z }
        object { bigwin2 translate <-2, 4.2, -.1> pigment {color Wheat} }
        object { door translate <-26.4, 0, -.1> pigment {color Gray30 } }
        object { doorinn translate <-26.4, 0, -.21> pigment {color Yellow } }
        translate 34*x }

#declare bighouse3 = union {
        object { bigcasainn rotate 180*y } 
        object { bigcasaout rotate 180*y pigment { color Gray20 } translate .1*z }
        object { bigwin2 translate <-2, 4.2, -.1> pigment {color Wheat} }
        object { door translate <-26.4, 0, -.1> pigment {color Gray30 } }
        object { doorinn 
                #declare clock_type = "Triangle"
                #declare clock_repeat = 1;
                #include "clockmod.inc"
                rotate -75*y*mclock
                translate <-26.4, 0, -.21>
                pigment {color Yellow } } 
        object { doorinn translate <-26.4, 0, -.18> pigment {color Black } }
        translate 34*x }

#declare neighboor = union { //this is the join of houses -- to move them all
        object { bighouse2 pigment { color Navy } }
        object { bighouse translate 88*x }
        object { smallhouse translate 36*x pigment { color LimeGreen } }
        object { smallhouse rotate 90*y translate <88, 0, 26> pigment { color Orange } }
        object { bighouse3 rotate -90*y translate <62, 0, -.5> pigment { color VioletRed } }
        scale 1.8 }

#declare calle = superellipsoid { <0.1, 0.1>
                 translate <1, 1, 1> scale .5 scale <1, .2, 1> }

#declare peatonal = union { //where people cross the street
        object { calle scale <15, 1, 2> translate <-5, .05, -15> }
        object { calle scale <15, 1, 2> translate <-5, .05, -20> }
        object { calle scale <15, 1, 2> translate <-5, .05, -25> }
        object { calle scale <15, 1, 2> translate <-5, .05, -30> }
        object { calle scale <15, 1, 2> translate <-5, .05, -35> }
        translate .1*y pigment { color Gray90 } }

#declare street = union { //isn't the street, is where people walk
        object { calle scale <140, 1, 30> translate <-15, .01, -25> }
        object { calle scale <120, 1, 30> rotate 90*y  translate <-15.5, .01, 110> }  
        object { calle scale <120, 1, 30> rotate 90*y  translate <95, .01, 110> }  
        object { calle scale <120, 1, 30> rotate 90*y  translate <150, .01, 110> }  
        object { calle scale <120, 1, 30> translate <150, .01, -25> }
        pigment { color Sienna } }

#declare peaton = union {
        object { peatonal translate <-3, 0, -14> }
        object { peatonal translate <110, 0, -14> }
        object { peatonal translate <165, 0, -14> }
        object { peatonal rotate 90*y translate <161.5, 0, -12> } }


#declare plato = union {
        object { neighboor }
        object { peaton }
        object { street } }

#declare block2 = object { plato rotate -90*y translate <-65, 0, -100> }

#declare block3 = union {
        object { neighboor }
        object { street } }

#declare block3scene = object { block3 rotate -180*y translate <110, 0, -80> }

plane { y, -.2 pigment { color Gray10 }
        normal { bumps 10 scale .1 }
        finish { phong 1 phong_size 90 ambient .1 diffuse 1 } }

light_source { 0*x color rgb 1 area_light <10, 0, 0> <0, 0, 10> 3, 3 adaptive 0
        rotate 45*x translate <135, 40,10> }

//nena box { <-5, 0, -4>, <5, 13.5, 4> pigment {color rgbf .8 } }
//nene box { <-5, 0, -4>, <5, 13.5, 4> pigment {color Red } }