// Persistence of Vision Ray Tracer Scene Description File
// File: nena.pov
// Vers: 3.1g
// Desc: pawn/girl
// Date: Jan 04 2002
// Auth: Gustavo Reyes
//

//*******************************************************BOY DEFINITION
// all objects are centered in 0,0,0 axis for
// later arrange to make different movements

#declare cuerpob = cone { -2.75*y, 3.8,  2.75*y, 1.2 pigment { Blue } }
#declare cabezab = sphere { 0, 4.4 }

#declare hombrorb = object { softsquare (1) scale <.4, 1, .4> }
#declare brazorb = cylinder { <-4, 0, 0>, < 0, 0, 0>, .4 }

#declare hombrolb = object { softsquare (1) scale <.4, 1, .4> }
#declare brazolb = cylinder {  <4, 0, 0>, <0, 0, 0>, .4 }

#declare pelitol = create_spline ( 
   array[5] { 
   < 0.0,  5.0, 0.0>,
   < 1.0,  7.0, 0.0>,
   < 2.0,  6.0, 0.0>,
   < 2.0,  9.0, 0.0>,
   <-2.0, -9.0, 0.0> },
   create_hermite_spline + spline_sampling (on)
   + spline_translate (<0, 4, 0>) ) 
#declare pelitor = create_spline ( 
   array[5] { 
   < 0.0,  5.0, 0.0>,
   <-1.0,  7.0, 0.0>,
   <-2.0,  6.0, 0.0>,
   <-2.0,  9.0, 0.0>,
   < 2.0, -9.0, 0.0> },
   create_hermite_spline + spline_sampling (on)
   + spline_translate (<0, 4, 0>) ) 

#declare pelob = union {
        create_spline_object (pelitor, spline_steps (30) + spline_translate (-4.4*x) )
        create_spline_object (pelitor, spline_steps (30) + spline_rotate (15*y)+ spline_translate (-4.4*x) )
        create_spline_object (pelitor, spline_steps (30) + spline_rotate (30*y)+ spline_translate (-4.4*x) )
        create_spline_object (pelitol, spline_steps (30) + spline_translate (4.4*x) )
        create_spline_object (pelitol, spline_steps (30) + spline_rotate (-15*y)+ spline_translate (4.4*x) )
        create_spline_object (pelitol, spline_steps (30) + spline_rotate (-30*y)+ spline_translate (4.4*x) )
        pigment { color Orange }
        }

#declare pupilab = sphere { 0, .5 scale <2, 2, .3> pigment { color White } }
#declare irisb = sphere { 0, .5 scale <1, 1.2, .55> pigment { color Black } }

#declare parpadorb = difference {
        sphere { 0, .5 scale <2, 2, .6> pigment { color Gray30 } }
        sphere { 0, .5 scale <3, 4, 1> pigment { color Black } translate -1.8*y
                #declare clock_type = "Triangle"
                //#declare clock_start = .1;
                #declare clock_repeat = 3;
                #include "clockmod.inc"
                translate -1*y*mclock
                }
        }
#declare parpadolb = difference {
        sphere { 0, .5 scale <2, 2, .6> pigment { color Gray30 } }
        sphere { 0, .5 scale <3, 4, 1> pigment { color Black } translate -1.8*y
                #declare clock_type = "Triangle"
                //#declare clock_start = .1;
                #declare clock_repeat = 3;
                #include "clockmod.inc"
                translate -1*y*mclock
                }
        }

#declare cejab = difference {
                cylinder { <0, 0, -.2>, <0, 0, .2>, 1 }
                sphere { 0, .6 scale <2, 1.5, 3> translate -.1*y }
                pigment { color Gray20 } }

#declare reyeb = union {
        object { pupilab }
        object { irisb }
        object { parpadorb }
        object { cejab rotate -8*z translate <0, .6, .2> }
        }

#declare leyeb = union {
        object { pupilab }
        object { irisb }
        object { parpadolb }
        object { cejab rotate -10*z translate <-.1, .5, .2> }
        }

//*******************************************BOY STANDING W/EYES MOVING

#declare nenedepie = union {
        object { cuerpob translate 2.75*y }
        object { cabezab translate 8.75*y }
        object { hombrorb rotate 8*z translate <-2, 3.4, 0> }
        object { brazorb rotate 8*z translate <-2, 3.4, 0> }
        object { hombrolb rotate -8*z translate <2, 3.4, 0> }
        object { brazolb rotate -8*z translate <2, 3.4, 0> }
        object { reyeb scale 1.3*x
                       rotate 30*y
                       rotate -8*x
                       scale 1.5
                       translate <-2.2, 8, -3.7> }
        object { leyeb rotate -30*y
                       rotate -8*x
                       scale 1.4
                       translate <2.1, 8, -3.7> }
        object { pelob }
        }

//**********************************************************BOY WALKING
//boy, standing on floor plane 0*y moving her eyes and rotating arms
//in 180 degrees way like she was walking

#version 3

#declare arm_rb = object { brazorb
               /*#declare clock_type = "oscillation"
                        #declare clock_repeat = 0;
                        #declare clock_start = 0;
                        #include "clockmod.inc"
                        rotate  55*y*mclock */
                 rotate 8*z translate <-2, 3.4, 0>
                 }

#declare arm_lb = object { brazolb
               /*#declare clock_type = "oscillation"
                                #declare clock_repeat = 0;
                                #include "clockmod.inc"
                                rotate  55*y*mclock */
                 rotate -8*z translate <2, 3.4, 0>
                 }

#version 3.1
#declare nene_arms = union {        
        object { cuerpob translate 2.75*y }
        object { cabezab translate 8.75*y }
        object { hombrorb rotate 8*z translate <-2, 3.4, 0> }
        object { hombrolb rotate -8*z translate <2, 3.4, 0> }
        object { reyeb scale 1.3*x rotate 30*y 
                       rotate -8*x  scale 1.5
                       translate <-2.2, 8, -3.7>
                        }
        object { leyeb rotate -30*y rotate -8*x
                       scale 1.4 translate <2.1, 8, -3.7>
                        }
        object { arm_rb }
        object { arm_lb }
        object { pelob }
        pigment { color Orange }
        }

//**********************************************************BOY SHEARED
//the same boy as before, in a fast walk, the matrix shears he, to
//make more realistic his walk

#declare nene_jump = object { nene_arms
                   #declare clock_type = "jump"
                                #declare clock_repeat = 10;
                                #include "clockmod.inc"
                                translate 2*y*mclock
                   #declare clock_combine = ""
                   pigment { color Orange } }



//object { nenedepie  pigment { color Orange } }
//object { nene_arms pigment { color Orange } }
#declare nene_jump1= object { nene_jump matrix
        < 1.0, 0.0, 0.0,
          0.0, 1.0, -.5,
          0.0, 0.0, 1.0,
          0.0, 0.0, -1> }

//****************************************BOY MOVING HEAD LEFT TO RIGHT
#include "clockmod.inc"
#declare saynob = union {
                object { cabezab translate 8.75*y }
                object { reyeb scale 1.3*x
                              rotate 30*y
                              rotate -8*x
                              scale 1.5
                              translate <-2.2, 8, -3.7>
                              }
                object { leyeb rotate -30*y
                              rotate -8*x
                              scale 1.4
                              translate <2.1, 8, -3.7> 
                              }
                object { pelob }
                /*#declare clock_type = "recoil"
                                #declare clock_repeat = 1;
                                #include "clockmod.inc"
                                rotate -55*y*mclock */
                }

#declare nene_no = union {
        object { cuerpob translate 2.75*y }
        object { hombrorb rotate 8*z translate <-2, 3.4, 0> }
        object { brazorb rotate 8*z translate <-2, 3.4, 0> }
        object { hombrolb rotate -8*z translate <2, 3.4, 0> }
        object { brazolb rotate -8*z translate <2, 3.4, 0> }
        object { saynob }
        pigment { color Orange }
        }