// Persistence of Vision Ray Tracer Scene Description File
// File: rubik_c2.pov
// Vers: 3.1
// Desc: HiperCube Object
// Date: 12/22/01
// Auth: Gustavo Reyes
//

#declare radio = .5;

#declare ext_cube = union { 
        sphere { <-9.5, -9.5, -9.5>, radio }
        sphere { <-9.5, -9.5,  9.5>, radio }
        sphere { < 9.5, -9.5, -9.5>, radio }
        sphere { < 9.5, -9.5,  9.5>, radio } //4 base corners
        sphere { <-9.5,  9.5, -9.5>, radio }
        sphere { <-9.5,  9.5,  9.5>, radio }
        sphere { < 9.5,  9.5, -9.5>, radio }
        sphere { < 9.5,  9.5,  9.5>, radio } //4 top corners
        
        cylinder { <-9.5,-9.5,-9.5>, < 9.5,-9.5,-9.5>, radio }
        cylinder { <-9.5,-9.5, 9.5>, < 9.5,-9.5, 9.5>, radio }
        cylinder { <-9.5, 9.5,-9.5>, < 9.5, 9.5,-9.5>, radio }
        cylinder { <-9.5, 9.5, 9.5>, < 9.5, 9.5, 9.5>, radio } //4 in x direction

        cylinder { <-9.5,-9.5,-9.5>, <-9.5, 9.5,-9.5>, radio }
        cylinder { < 9.5,-9.5,-9.5>, < 9.5, 9.5,-9.5>, radio }
        cylinder { <-9.5,-9.5, 9.5>, <-9.5, 9.5, 9.5>, radio }
        cylinder { < 9.5,-9.5, 9.5>, < 9.5, 9.5, 9.5>, radio } //4 in y direction
        
        cylinder { <-9.5,-9.5,-9.5>, <-9.5,-9.5, 9.5>, radio }
        cylinder { < 9.5,-9.5,-9.5>, < 9.5,-9.5, 9.5>, radio }
        cylinder { <-9.5, 9.5,-9.5>, <-9.5, 9.5, 9.5>, radio }
        cylinder { < 9.5, 9.5,-9.5>, < 9.5, 9.5, 9.5>, radio } //4 in z direction
        texture { pigment { color rgb<1,0.8,0> }
        finish { ambient 0.45 diffuse 0.55 phong 1 }
        } }

#declare int_cube = union {
        cylinder { <-4.5,-4.5,-4.5>, < 4.5,-4.5,-4.5>, radio }
        cylinder { <-4.5,-4.5, 4.5>, < 4.5,-4.5, 4.5>, radio }
        cylinder { <-4.5, 4.5,-4.5>, < 4.5, 4.5,-4.5>, radio }
        cylinder { <-4.5, 4.5, 4.5>, < 4.5, 4.5, 4.5>, radio } //4 in x direction

        cylinder { <-4.5,-4.5,-4.5>, <-4.5, 4.5,-4.5>, radio }
        cylinder { < 4.5,-4.5,-4.5>, < 4.5, 4.5,-4.5>, radio }
        cylinder { <-4.5,-4.5, 4.5>, <-4.5, 4.5, 4.5>, radio }
        cylinder { < 4.5,-4.5, 4.5>, < 4.5, 4.5, 4.5>, radio } //4 in y direction
        
        cylinder { <-4.5,-4.5,-4.5>, <-4.5,-4.5, 4.5>, radio }
        cylinder { < 4.5,-4.5,-4.5>, < 4.5,-4.5, 4.5>, radio }
        cylinder { <-4.5, 4.5,-4.5>, <-4.5, 4.5, 4.5>, radio }
        cylinder { < 4.5, 4.5,-4.5>, < 4.5, 4.5, 4.5>, radio } //4 in z direction
        texture { pigment { color rgb<1,0.8,0> }
        finish { ambient 0.45 diffuse 0.55 phong 1 }
        } }

#declare diag = union {
        sphere { <-25, 0, 0>,radio }
        sphere { < 25, 0, 0>,radio }
        cylinder { <-25, 0, 0>, <25, 0, 0>, radio }
        pigment { color Red }
        }
#declare diags = union {
        object { diag rotate -35*y rotate  45*z }
        object { diag rotate -35*y rotate -45*z }
        object { diag rotate  35*y rotate  45*z }
        object { diag rotate  35*y rotate -45*z }
        }
#declare get_out = difference {
        box { <-9.8,-9.8,-9.8>, <9.8, 9.8, 9.8> }
        box { <-4.9,-4.9,-4.9>, <4.9, 4.9, 4.9> }
        }
#declare diagonals = intersection {
        object { get_out }
        object { diags }
        }

#declare hipercube = union {
        object { ext_cube }
        object { int_cube }
        object { diagonals }
        }