// Persistence of Vision Ray Tracer Scene Description File
// File: fromsky.pov
// Vers: 3.1g
// Desc: definition file / objets to fall from sky
// Date: Jan 05 2001
// Auth: Gustavo Reyes
//

global_settings { assumed_gamma 1.0 }
default { finish { phong .5 phong_size 50 ambient .09 diffuse .6 }
        pigment { color Red } }

// here are defined a hammer, an anvil and a Rubik's Cube, centered at 0,0,0

#declare acero =  difference {
                object { softrectangle(2.8, 1.8, .7) scale <1.4, 2, .9> rotate -90*x }
                superellipsoid { <0.2, 0.2> scale 3 translate <-4, 3, 0> pigment { color Gray70 }  }
                pigment { color Gray65 } } 
#declare madera = object { softrectangle(.9, 12, .8) scale .6*x rotate -90*x }
#declare hammer = union {
                object { madera }
                object { acero translate 5*y } }

#declare fragua = union {
        difference {
                union {
                        box { <-1, -1, -1>, <1, 1, 1> }
                        sphere { 0, 1 scale <2 , .4, .7> }
                        pigment { color Gray65 }
                        }
          box { <-2, 0, -1.2>, <2, 1.2, 1.2> }
          cylinder { <-1, -1, -3>, <-1, -1, 3>, .7 } 
          cylinder { < 1, -1, -3>, < 1, -1, 3>, .7 }
          box { <-2.4, -1.4, -1.2>, <2.4, -.3, -.7> }
          box { <-2.4, -1.4,  0.7>, <2.4, -.3, 1.2> }
          pigment { color Gray20 } } }

#declare escaque = superellipsoid { <0.1, 0.1> }
#declare front = union {
        object { escaque }
        object { escaque translate -2.1*x }
        object { escaque translate  2.1*x }

        object { escaque translate 2.1*y }
        object { escaque translate <-2.1, 2.1, 0> }
        object { escaque translate < 2.1, 2.1, 0> }

        object { escaque translate 4.2*y }
        object { escaque translate <-2.1, 4.2, 0> }
        object { escaque translate < 2.1, 4.2, 0> }
        scale <1, 1, .2>
        }

#declare rights_side = union {
        object { escaque }
        object { escaque translate -2.1*x }
        object { escaque translate  2.1*x }

        object { escaque translate 2.1*y } 
        object { escaque translate <-2.1, 2.1, 0> }
        object { escaque translate < 2.1, 2.1, 0> }

        object { escaque translate 4.2*y }
        object { escaque translate <-2.1, 4.2, 0> }
        object { escaque translate < 2.1, 4.2, 0> }
        scale <1, 1, .2>
        }

#declare upper_side = union {
        object { escaque }
        object { escaque translate -2.1*x }
        object { escaque translate  2.1*x }

        object { escaque translate 2.1*y }
        object { escaque translate <-2.1, 2.1, 0> }
        object { escaque translate < 2.1, 2.1, 0> }

        object { escaque translate 4.2*y }
        object { escaque translate <-2.1, 4.2, 0> }
        object { escaque translate < 2.1, 4.2, 0> }
        scale <1, 1, .2>
        }

#declare rubik = union {        
        object { front pigment { colour Red } }
        
        object { rights_side scale .4*x
        matrix
        < 1.0, 1.0, 0.0,
          0.0, 1.0, 0.0,
          0.0, 0.0, 1.0,
          0.0, 0.3, 0.0>
          translate <4.5, .95, 0.0> pigment { colour Green }
         }
        
        object { upper_side scale .4*y
        matrix
        < 1.0, 0.0, 0.0,
          1.0, 1.0, 0.0,
          0.0, 0.0, 1.0,
          0.0, 0.3, 0.0>
          translate <0.5, 5.4, 0.0> pigment { colour Blue }
         }
         }

#declare cubo = union {
        object { rubik }
        prism { linear_sweep linear_spline -0.5, 0.5, 6,
                <-3.20, -1.15>, <-3.20,  5.30>, <-0.55,  7.87>,
                < 5.85,  7.87>, < 5.85,  1.40>, < 3.30, -1.15>
                rotate -90*x translate .4*z pigment { colour Black } }
                scale .2 }

//object { hammer scale 2 }
//object { fragua scale 6}
//object { cubo scale 12 }