#declare gas = density {
  spherical sine_wave frequency 2 phase sun_clock
  turbulence 0.5
  scale 1
  color_map {
    [0.0 color rgb <0.0,0.0,0.0>*0.0*0.5]
    [0.5 color rgb <0.0,0.0,0.0>*0.0*0.5]  
    [0.6 color rgb <0.2,0.0,0.0>*0.1*0.5]
    [0.7 color rgb <0.3,0.0,0.0>*0.2*0.5]
    [0.8 color rgb <0.4,0.0,0.0>*0.3*0.5]
    [0.9 color rgb <0.5,0.0,0.0>*0.4*0.5]
    [1.0 color rgb <0.6,0.0,0.0>*0.5*0.5]
    }
  }

#declare flares = density {
  spherical sine_wave frequency 2 phase sun_clock
  turbulence 0.5
  scale 1
  color_map {
    [0.00 color rgb <0.0,0.0,0.0>*0.4]
    [0.95 color rgb <0.0,0.0,0.0>*0.5]  
    [0.96 color rgb <0.5,0.0,0.0>*0.6]
    [0.97 color rgb <0.7,0.0,0.0>*0.7]
    [0.98 color rgb <1.0,0.1,0.0>*0.8]
    [0.99 color rgb <1.0,0.5,0.0>*0.9]
    [1.00 color rgb <1.0,0.7,0.3>*1.0]
    }
  }

#declare halo = density {
  spherical
  color_map {
    [0.0 color 0]
    [0.2 color rgb <0.5,0,0>]
    [0.3 color rgb <1,0.5,0>]
    [0.5 color rgb <1,0.8,0.5>]
    } 
  }
               
#declare corona = media {
  emission 1/10
  intervals 30
  samples 1,1
  density {
    spherical
    density_map {   
      [0.0 color 0]
      [0.1 gas]
      [0.35 flares]
      [0.5 halo]
      [1.0 color rgb <2,0.9,0.5>]
      }
    }
  }
      
 
#declare sun = object {
  union {
    sphere { 0,1
      pigment {
        bumps sine_wave
        phase clock
        color_map {
          [0.0 color rgb <0.9,0.9,0.5>]
          [1.0 color rgb <0.9,0.9,0.6>]
          }
        scale 0.2
        //turbulence 0.2
        }
      finish {
        ambient 1
        diffuse 0
        }
      scale 30
      
      }    
      
    sphere { 0, 1
      pigment { color rgbf<1, 1, 1, 1> }
      finish { ambient 0 diffuse 0 }
      interior {
        //media { flares scale 0.8}
        //media { halo scale 0.7 } 
        media { corona }
        }
      scale 60
      hollow
      }
     
    }
  }
