//      Planet orbits

#declare semiaxis = array[9] {
  57,108,149,228,778,1428,2872,4501,5912
  }

#declare eccentr = array[9] {
  0.205,0.006,0.016,0.093,0.048,0.056,0.047,0.008,0.25
  }

#declare p_size = array[9] {
  4.84/2,12.4/2,12.757/2,6.79/2,142.8/3,120.8/3,52.4/2,44.6/2,20
  }

#declare p_color = array[9] {
  <0.9,0.8,0.4>,<0.7,0.8,0.9>,<0.3,0.3,1>,<1,0.4,0.2>,<0.8,0.4,0>,<0.9,0.8,0.2>,<0.1,0.9,0.6>,<0.5,0.5,1>,<0.6,0.8,1>
  }

#declare scale1=2;
#declare scale2=0.5;
  
#declare p=0;
#while (p<9)
  torus {
    semiaxis[p]*scale1,p_size[p]*scale2
    scale <1,1,1-eccentr[p]>
    #if (p=0) rotate <0,0,5> #end
    translate <-200+semiaxis[p]*eccentr[p],f_sun(semiaxis[p]*scale1*(1+eccentr[p]))+(p_size[p]*scale2),0>
    pigment { color rgbt p_color[p] + <0,0,0,1-show_orbit> }
    finish { ambient 1 diffuse 0}
    no_shadow
    }
  #declare p=p+1;
#end


  