//      Copyright 2001 Andrew Bowcock
#declare quality=10;
#include "colors.inc"
#include "slospace.inc"
#include "fly.inc"
//#include "axes.inc"
#background{colour 0}

#macro maincamera()
        #declare campos=<30,0,10>;
        #declare lookpos=<0,0,0>;
        camera {
                location campos
                sky <0,0,1>
                look_at lookpos
                }
#end

#macro lights1()
        light_source{campos colour .2}
#end


#macro electron(time)
    #declare time=time-int(time);
    #declare sint=sin(2*pi*time);
    union{
        sphere{0,20+10*time pigment{rgbt <.2,.2,1,.9+time*.1>} finish{ambient rgb <.2,.2,.9>}hollow}
        sphere{0,5+15*time pigment{rgbt <.2,.2,1,.8+time*.1>} finish{ambient rgb <.2,.2,.9>}hollow}
        sphere{0,3+2*time pigment{rgbt <.2,.2,.8,.7+time*.1>}finish{ambient .6}hollow}
        sphere{0,2+1*time pigment{rgbt <.2,.2,.8,.6+time*.1>}finish{ambient .6}hollow}
        sphere{0,.5+1.5*time pigment{rgbt <.2,.2,.8,.2+time*.4>}finish{ambient 1.6-time}hollow}
        sphere{0,.5 pigment{rgbt <.2,.2,1,.2>}finish{ambient rgb 2}hollow}
        pigment{rgbt <0,0,1,1>}
        }
#end

#macro atom()
        #declare r1=seed(0);
        #declare rot1=<30,0,10>;
        #declare rot2=<60,0,5>;
        #declare rot3=<90,0,10>;
        #declare rot4=<120,0,5>;
        #declare rot5=<150,0,0>;
        #declare rot6=<150,0,0>;
        #declare rot7=<rand(r1)*360,rand(r1)*360,rand(r1)*360>;
        #if (quality>2)
                union{
                        object{sun()}
                        object{mercury scale 1/80 translate <.3,0,0> rotate <0,240,0> rotate rot1}
                        object{jupiter scale 1/2000 translate <.3,0,0> rotate <0,120,0> rotate rot2}
                        object{saturn scale 1/15000 translate <.3,0,0> rotate <0,180,0> rotate rot3}
                        object{earth rotate z*180 scale 1/200 translate <.3,0,0> rotate <180,240,0> rotate rot5}
                        torus{.3,.002 rotate rot1}
                        torus{.3,.002 rotate rot2}
                        torus{.3,.002 rotate rot3}
                        torus{.3,.002 rotate rot4}
                        torus{.3,.002 rotate rot5}
                        torus{.3,.002 rotate rot6}
                        finish{ambient 4}
                        pigment{White}
                        rotate rot7
                        //translate vib
                      }
        #else sphere{0,.08 pigment{Yellow} finish{ambient 1}}
        #end
#end


maincamera()
lights1()
object{flyingfly(1) rotate z*60 translate <0,4,-16> }
object{electron(0) scale <.1,2,2> translate -x*15}
object{atom() scale 20 translate <0,12,6>}