//      Copyright 2001 Andrew Bowcock
#include "skies.inc"
#include "woods.inc"
#include "chair.pov"
#include "building.inc"
#include "computer.inc"
#include "clutter.inc"
#include "zapper.inc"
#debug "Parsing 'office.inc'\n"


#if (quality>6)
        #declare T_Wallpaper=texture{
                                normal{bump_map{gif "woodchip.gif"}}
                                pigment{rgb <.9,.7,.5>}
                                scale 200
                                rotate y*90
                                }
#else
        #declare T_Wallpaper=texture{pigment {rgb <.8,.6,.8>}}
#end


#macro walls()
        box{0,<wallth,ow,wallh1> texture{T_Wallpaper} translate x*ol } //far wall (bbar)
        object{skirting(ow) rotate z*180 translate <ol,ow,0>}
        box{0,<-wallth,ow/2,wallh1> texture{T_Wallpaper} translate y*ow/2}
        object{skirting(ow/2) translate y*ow/2}
        box{0,<-wallth,ol,wallh1> texture{T_Wallpaper} rotate z*-90 translate y*ow}
        object{skirting(ol) rotate z*-90 translate <0,ow,0>}
        box{0,<wallth,ol/2,wallh1> texture{T_Wallpaper} rotate z*-90 translate y*ow/2}
        object{skirting(ol/2) rotate z*90 translate <ol,0,0>}
        box{0,<-wallth,ow/2,wallh1> texture{T_Wallpaper} translate <ol/2,-1,0> }
        difference{
                box{0,<wallth,ol/2,wallh1> texture{T_Wallpaper} rotate z*-90 translate x*ol/2} //window wall
                box{<ol*5/8,-wallth-1,1100><ol*7/8,1,2000> pigment{White}}
                }
        object{window1(ol/8,950) translate<ol*5/8,-200,1050>}
        object{window1(ol/8,950) translate<ol*6/8,-200,1050>}
        box{<0,0,wallh1><ol,ow,wallh1+1> pigment{White}}// normal {bumps .1 scale 200} finish{reflection 1}}  //ceiling
#end

#macro carpet()
        #declare csq=height_field{gif "carpetmap2.gif" rotate x*-90 }
        #declare nsq=30;
        #declare sqx=0;
        union{
        #while (sqx<nsq)
                #declare sqy=0;
                #while (sqy<nsq)
                        object{csq  scale <ol/nsq+.1,ow/nsq+.1,5> translate<sqx*ol/nsq,sqy*ow/nsq,2>}
                        #declare sqy=sqy+1;
                #end
                #declare sqx=sqx+1;
       #end
       texture{pigment{rgb <.6,.6,.3>} finish{diffuse .2 ambient .2}}
       }
#end

#macro skirting(l)
        union{
        prism{cubic_spline 0,l,11
                <0,0><5,0><5,70><3,75><4,80><3,85><2,90><0,95><0,0><5,0><5,70>
                texture{T_Wood7 scale 100 rotate x*87}
                }
        box{<0,0,97><1,l,99> texture{pigment{gradient z colour_map{[0 colour rgbt<0,0,0,0>] [.4 colour rgbt<0,0,0,.98>] [.5 colour rgbt<.5,.5,.5,1>] [1 colour rgbt<0,0,0,1>]}scale 5 translate z*97 turbulence 1}}}
        }
#end


#macro bbar()
        #declare barl=2000;
        #declare barw=1000;
        #declare barh=30;
     union{
        intersection{
                box{<0,0,0><barl,barw,barh>}
                blob{
                        sphere{<barl*.0,-130,100>,barw*1.4,1.2}
                        sphere{<barl*.6,0,-100>,barw*1.4,1.5}
                        sphere{<barl,0,-300>,barw*1.6,1.2}
                        scale<1,1,.5>
                        pigment{rgb <1,0,0>}
                        texture{T_Wood2 rotate <90,90,0> scale 100}
                        normal{bumps 1 scale 30}
                    }
                    }

        #declare shelfh1=600;
        #declare shelfh2=1000;
        #declare shelfh3=1350;
        #declare shelfh4=1650;
        #declare shelft=20;
        #declare shelfw=300;
        #declare overhang=100;
        #declare r=15;
        #declare pstz1=lathe{cubic_spline 103
                                #declare n=0;
                                #declare r1=seed(0);
                                #while (n<100)
                                        <r+r*rand(r1),shelfh4*n/100>
                                        #declare n=n+1;
                                #end
                                <r/2,shelfh4+60>
                                <0,shelfh4+80>
                                <0,shelfh4+100>
                                rotate x*90 texture{T_Wood1}}
        #declare pstz2=lathe{cubic_spline 103
                                #declare n=0;
                                #declare r1=seed(0);
                                #while (n<100)
                                        <r+r*rand(r1),shelfh3*n/100>
                                        #declare n=n+1;
                                #end
                                <r/2,shelfh3+60>
                                <0,shelfh3+80>
                                <0,shelfh3+100>
                                rotate x*90 texture{T_Wood1}}
        object{pstz1 translate <0,overhang,0>}
        object{pstz2 translate <barl-overhang,overhang,0>}
        object{pstz1 translate <barl/2,overhang,0>}
        object{pstz1 translate <0,shelfw-overhang,0>}
        object{pstz2 translate <barl-overhang,shelfw-overhang,0>}
        object{pstz1 translate <barl/2,shelfw-overhang,0>}
        box{<0,0,shelfh1-shelft><barl,shelfw,shelfh1>}
        box{<0,0,shelfh2-shelft><barl,shelfw,shelfh2>}
        box{<0,0,shelfh3-shelft><barl,shelfw,shelfh3>}
        box{<0,0,shelfh4-shelft><barl/2+overhang,shelfw,shelfh4>}
        
        texture{T_Wood1 scale 100 rotate y*90 }
           }
                                
#end

#macro table()
        #declare tabl=1500;
        #declare tabw=1000;
        #declare tabt=30;
        #declare tabh=800;
        #declare tleg=80;
        union{
                box{<0,0,tabh-tabt><tabl,tabw,tabh>}
                box{<tabl/8,tabw/8,0><tabl/8+tleg,tabw/8+tleg,tabh>}
                box{<tabl*7/8,tabw/8,0><tabl*7/8-tleg,tabw/8+tleg,tabh>}
                box{<tabl/8,tabw*7/8,0><tabl/8+tleg,tabw*7/8-tleg,tabh>}
                box{<tabl*7/8,tabw*7/8,0><tabl*7/8-tleg,tabw*7/8-tleg,tabh>}
                texture{T_Wood5 scale 100 rotate x*85}
                }
#end



#macro furniture(time)
    #if (time<C_showpic) #declare picno= str(mod((100+time-C_showpic)*10,20)+1,-4,0) #end
    #if ((time>=C_showpic)&(time<=C_showpic+20)) #declare picno=str((time-C_showpic)*10+1,-4,0) #end
    #if (time>C_showpic+20) #declare picno= str(mod((100+time-C_showpic)*10,20)+1,-4,0) #end
    #declare pic=concat("onsc",picno,".bmp")            // calculates which picture to use on computer screen
    //#debug concat(pic,"\n")
    object{bbar() rotate z*90 translate <ol,ow-2000,800>}
    object{screen(pic) scale 10 rotate z*120 translate <ol-560,ow-460,990>}
    object{keyboardwire() translate <ol-590,ow-900,860>}
    object{computercase()translate <ol-560,ow-460,840>}
    object{keyboard() scale 13 rotate <-15,0,120> translate<ol-600,ow-1000,890>}
    object{table() translate <ol-2000,40,0>}
    object{chair() scale 1.2 rotate z*60 translate <ol-1000,2500,0>}
    #if (quality>6) object{carpet()} #else plane{z,0 pigment{Green}} #end
#end

#macro clutter1()
        //books behind PC
        object{book1(30,150,250,"book2001.gif") rotate x*10 translate <ol-225,ow-940,840>}
        object{book1(50,150,260,"book_oed.gif") rotate x*12 translate <ol-230,ow-895,840>}
        object{book1(40,150,240,"book_bible.gif") rotate x*14 translate <ol-227,ow-831,840>}
        object{book1(35,150,230,"book_c22.gif") rotate x*15 translate <ol-231,ow-778,840>}
        object{book1(40,150,250,"book_ggs.gif") rotate x*17 translate <ol-222,ow-730,840>}
        object{book1(28,150,255,"book_nakedape.gif") rotate x*20 translate <ol-222,ow-675,840>}
#end

#macro clutter2()
        object{plate() translate  <ol-360,ow-1160,840>}
        object{bowl() translate  <ol-300,ow-1860,840>}
        object{mug() rotate z*120 translate  <ol-690,ow-590,990>}
        //books 1st shelf left
        object{book1(30,150,250,"mietvertrag.gif") rotate x*10 translate <ol-225,ow-1900,1410>}
        object{book1(40,150,260,"digby.gif") rotate x*12 translate <ol-230,ow-1860,1410>}
        object{book1(50,150,240,"morgenstemmning.gif") rotate x*14 translate <ol-227,ow-1806,1410>}
        object{book1(35,150,230,"flybody.gif") rotate x*15 translate <ol-231,ow-1743,1410>}
        object{book1(40,150,250,"wallpaper.gif") rotate x*17 translate <ol-222,ow-1695,1410>}
        object{book1(80,150,260,"misco.gif") rotate x*0 translate <ol-222,ow-1635,1410>}
        object{book1(40,150,210,"marssurface.gif") rotate x*2 translate <ol-222,ow-1550,1410>}
        object{book1(10,150,250,"jupitersurface.gif") rotate x*3 translate <ol-222,ow-1508,1410>}
        object{book1(35,150,230,"uranussurface.gif") rotate x*4 translate <ol-222,ow-1492,1410>}
        object{book1(40,150,255,"jupitersurface.gif") rotate x*5 translate <ol-222,ow-1450,1410>}
        
        object{book1(80,150,260,"venussurface.gif") rotate x*0 translate <ol-222,ow-1335,1410>}
        object{book1(40,150,210,"marssurface.gif") rotate x*2 translate <ol-222,ow-1250,1410>}
        object{book1(10,150,250,"jupitersurface.gif") rotate x*3 translate <ol-222,ow-1308,1410>}
        object{book1(35,150,230,"wallpaper.gif") rotate x*4 translate <ol-222,ow-1292,1410>}
        object{book1(40,150,255,"uranussurface.gif") rotate x*5 translate <ol-222,ow-1150,1410>}
        
        //book stack on 1st shelf
        object{book1(40,150,250,"misco.gif") rotate <90,0,12> translate <ol-222,ow-235,1410>}
        object{book1(20,150,250,"morgenstemmning.gif") rotate <90,0,6> translate <ol-222,ow-235,1452>}
        object{book1(30,150,250,"misco.gif") rotate <90,0,-4> translate <ol-222,ow-235,1474>}
        
        object{picture1(300,300,"earth.gif",White) translate <ol-1390,ow-5,1700>}
        object{picture2(300,250,"digby.gif",rgb<.8,.8,.4>) rotate z*-90 translate <ol-15,ow-800,1200>}
        object{picture2(500,300,"farmstead.gif",rgb<.4,.6,.4>) rotate <-20,0,-90> translate <ol-70,ow-1300,990>}
        
        object{paperstack1() translate  <ol-490,ow-860,840>}            // stack by PC
        object{paperstack2() translate  <ol-890,ow-160,8>}              // stacks on floor
        object{paperstack3() translate  <ol-1690,ow-160,8>}
        object{paperstack4() rotate x*180 translate  <ol-300,ow-1600,1818>}
        object{trophy() scale 1.5 rotate z*110 translate <ol-200,ow-635,1410>}
        
        object{speaker() translate <ol-150,ow-1800,1818>}
        object{speaker() translate <ol-150,ow-300,1818>}
       
        object{zapper() rotate <90,90,0> translate <ol-690,ow,1650>}

#end

#macro incomp()
    object{insidecomp() translate <ol-560,ow-460,840>}
#end
        
#macro office()
        #declare ol=5000;
        #declare ow=4000;
        #declare wallth=400;
        #declare wallh1=2800;
        #declare wallh2=1500;
        sky_sphere{S_Cloud1 rotate x*90}
        walls()
#end
