//      Copyright 2001 Andrew Bowcock
#include "colors.inc"

#declare wingth=.05;

#if (quality>7)
  #declare T_wings=

        texture{pigment {
        crackle
        color_map {
          [0.00, 0.05 color rgbt 0
                      color rgbt 0]
          [0.05, 0.2 color rgbt <.2,.2,.2,.4>
                      color rgbt <.5,.4,.3.8>]
          [0.2, 1.00 color rgbt <.7,.6,.5,.9>
                      color rgbt <.5,.5,.4,.8>]
        }
      scale <.6,3,.6>}
    }
        texture{pigment {
        crackle
        color_map {
          [0.00, 0.05 color rgbt 0
                      color rgbt 0]
          [0.05, 0.2 color rgbt <.2,.2,.2,.4>
                      color rgbt <.5,.4,.3.8>]
          [0.2, 1.00 color rgbt <.7,.6,.5,.9>
                      color rgbt <.5,.5,.4,.8>]
        }
      scale <.2,1,.2>}
    }
#else
  #declare T_wings=texture{pigment{rgb .4} finish{phong 1}}
#end


#declare flyeye=texture{
                pigment{image_map{gif "honeycomb.gif" map_type 1}scale .2}
                finish {phong 1}
                normal{bump_map{gif "honeycomb.gif" map_type 1}scale .2 }
                }


#macro body(pz,px)
     union{
        blob{   threshold 1
                sphere{<px,12,2-pz> 6, 1}      //rear
                sphere{<0,6,4> 6, 1.4 }      //middle
                sphere{<0,3,4+pz> 3, .5}
                sphere{<0,1,5> 5, 1.5}      //head end
                sphere{0, .7, .4 scale<1,3,2> rotate <70,0,10> translate <-2.3,1.3,7>}       //left wing fixing
                sphere{0, .7, .4 scale<1,3,2> rotate <70,0,-10> translate <2.3,1.3,7>}       //right wing fixing
                scale <1,1,.6>
                pigment{image_map{gif "flybody.gif" map_type 2}scale 11 translate y-2}
            }
        blob{   threshold 1
                sphere{<px,12,2-pz> 6, 1}      //rear
                sphere{<0,6,4> 6, 1.6 }      //middle
                sphere{<0,3,4+pz> 3, .7}
                sphere{<0,1,5> 5, 1.8}      //head end
                sphere{0, .7, .6 scale<1,3,2> rotate <70,0,10> translate <-2.3,1.3,7>}       //left wing fixing
                sphere{0, .7, .6 scale<1,3,2> rotate <70,0,-10> translate <2.3,1.3,7>}       //right wing fixing
                scale <1,1,.6>
                
                texture{normal{bumps 1 bump_size 10}scale .1
                        pigment{rgbt <.7,.6,.5,.7>}}
                }
                translate z
          }
#end

#macro head(time)
     union{
        blob{
                sphere{<-2,-2,0> 2.5, 3 texture{flyeye}}   
                sphere{<2,-2,0> 2.5, 3 texture{flyeye}}   
                sphere{<0,-1,0> 2.5, 3 pigment{Black}}
                scale<.6,.4,1>
                
            }
            difference{
                sphere{0 1.2  scale <1.5,.2,1> translate<0,-.5,-1.5>}
                sphere{0 1.205 scale<1,.3,1> translate<0,-.5,-1.5> pigment{rgb<.3,.05,.05>}}
                pigment{Black}
                
                      }
        rotate <-40+5*sin(time*2*pi),0,0>
        translate <0,-.5,4>
        pigment{Black}//?
         }
     
#end

#macro wingsmove(time)
        #declare beatoffset=-.1;
        #declare w1xrot=10;
        #declare w1yrot=10;
        #declare w2xrot=20;
        #declare w2yrot=5;
        #declare w2zrot=5;
        object{wingl1(20+8*sin(time*2*pi))
                rotate y*195
                rotate x*(w1xrot+w1xrot*cos(time*2*pi))
                rotate y*w1yrot*sin(time*2*pi)
                translate<1.4,.6,5.1> }
        object{wingr1(20+8*sin(time*2*pi))
                rotate y*165
                rotate x*(w1xrot+w1xrot*cos(time*2*pi))
                rotate y*w1yrot*sin(time*2*pi)
                translate<-1.4,.6,5.1> }
        object{wingr1(20+8*cos((time+beatoffset)*4*pi))
                rotate <0,210,-20>
                rotate x*(w2xrot+0+w2xrot*cos((time+beatoffset)*2*pi))
                rotate y*w2yrot*sin((time+beatoffset)*4*pi)
                translate<1.4,.9,4.8> }
        object{wingr1(20+8*cos((time+beatoffset)*4*pi))
                rotate <0,150,20>
                rotate x*(w2xrot+0+w2xrot*cos((time+beatoffset)*2*pi))
                rotate y*w2yrot*sin((time+beatoffset)*4*pi)
                //rotate z*w2zrot*
                translate<-1.4,.9,4.8> }
#end

#macro wings()
        object{wingl1(18)  rotate y*200 translate<1.4,.6,5.1> }
        object{wingr1(18)  rotate y*160 translate<-1.4,.6,5.1> }
        object{wingl1(18)  scale <1,1.1,1>rotate y*200 translate<1.4,.9,4.8> }
        object{wingr1(18)  scale <1,1.1,1>rotate y*160 translate<-1.4,.9,4.8> }
#end

#macro wingr1(r)
        intersection{
            union{
                 difference{
                            sphere{<0,0,r> r }
                            sphere{<0,0,r> r-wingth}
                           }
                 difference{
                            sphere{<-.08,-.14,2> 3+wingth}
                            sphere{<0,0,3> 3-wingth}
                           }
                 }
            
            blob{
                sphere{<-1.9,-1.5,0> 16,.8}
                sphere{<1.9,5,0> 8,.7 }
                sphere{<0,10,0>, 7,.52}
                pigment{rgb 0}
                scale <1,1,5>
                }
            scale <.4,1.3,.4>
            texture{T_wings}
            }
#end

#macro wingl1(r)
        intersection{
            union{
                 difference{
                            sphere{<0,0,r> r }
                            sphere{<0,0,r> r-wingth}
                           }
                 difference{
                            sphere{<.08,-.14,2> 3+wingth}
                            sphere{<0,0,3> 3-wingth}
                           }
                 }
            
            blob{
                sphere{<1.9,-1.5,0> 16,.8}
                sphere{<-1.9,5,0> 8,.7 }
                sphere{<0,10,0>, 7,.52}
                pigment{rgb 0}
                scale <1,1,5>
             }
            scale <.4,1.3,.4>
            texture{T_wings}
            }
#end

#macro legs(time)
        #declare ta=2*pi*time;
        object{flyleg(20+6*sin(ta),-90,45+13*cos(ta),-45,-30+15*cos(ta)) translate <1,2,2.5>} 
        object{flyleg(20,90+6*cos(ta),45+15*sin(ta),45+18*cos(ta),-30) translate <-1,2,2.5>} 
        object{flyleg(20-3*sin(ta),-65+5*cos(ta),45,-45+16*sin(ta),-40) translate <1,3,2.5>} 
        object{flyleg(20,65+4*cos(ta),45+13*sin(ta),45,-40-15*cos(ta)) translate <-1,3,2.5>} 
        object{flyleg(20+9*cos(ta),-40+15*sin(ta),45,-45-17*cos(ta),-50) translate <1,4,2.5>} 
        object{flyleg(20,40+4*sin(ta),45+6*cos(ta),45-10*sin(ta),-50) translate <-1,4,2.5>} 
        

#end

#macro flyleg(la1x,la1z,la2x,la2z,la3)
        #declare ll1=2;
        #declare ll2=1.5;
        #declare ll3=.8;
        union{
                union{
                        object{legsect(ll3) rotate x*-la3 translate <0,ll2,0>}
                        object{legsect(ll2)}
                        rotate <-la2x,0,la2z> translate <0,ll1,0>
                     }
                legsect(ll1)
                rotate <-la1x,0,la1z>
             }
#end

#macro legsect(len)
        blob{
                cylinder{0,<0,1,0>,.4,1}
                sphere{<.4,.5,0>,.8,.8}
                sphere{<.4,-.5,0>,.6,-.7}
                sphere{0,.2,.3}
                sphere{<0,1,0>,.2,.3}
                scale <len/2,len,len/2>
                pigment{image_map{gif "flylegs.gif" map_type 2} turbulence 10}
            }
#end

#macro fly()
        union{
                body(0,0)
                wings()
                head(0)
                legs(0)

              }
#end

#macro flyingfly(time)
        union{
                #declare wn=0;
                #declare nw=13;
                body(cos(2*time*pi),sin(time*2*pi))
                wingsmove(time)
                //#while (wn<nw) wingsmove(wn/nw)  #declare wn=wn+1; #end
                head(time)
                legs(time)
                translate z*cos(time*pi/180)
              }
#end

#macro burntbody(pz,px)
        blob{   threshold 1
                sphere{<px,12,2-pz> 6, 1}      //rear
                sphere{<0,6,4> 6, 1.6 }      //middle
                sphere{<0,3,4+pz> 3, .7}
                sphere{<0,1,5> 5, 1.8}      //head end
                sphere{0, .7, .6 scale<1,3,2> rotate <70,0,10> translate <-2.3,1.3,7>}       //left wing fixing
                sphere{0, .7, .6 scale<1,3,2> rotate <70,0,-10> translate <2.3,1.3,7>}       //right wing fixing
                scale <1,1,.6>
                
                texture{normal{bumps 1 bump_size 10}scale .1
                        pigment{rgb <.4,.3,.2>}}
          }
#end

#macro burnthead()
     union{
        blob{
                sphere{<-2,-2,0> 2.5, 3}   
                sphere{<2,-2,0> 2.5, 3}   
                sphere{<0,-1,0> 2.5, 3}
                scale<.6,.4,1>
                pigment{rgb .3}
            }
            difference{
                sphere{0 1.2  scale <1.5,.2,1> translate<0,-.5,-1.5>}
                sphere{0 1.205 scale<1,.3,1> translate<0,-.5,-1.5>}
                pigment{Black}
                
                      }
        rotate <-40,0,0>
        translate <0,-.5,4>
         }
     
#end

#macro burntwings()
        #declare beatoffset=-.1;
        #declare w1xrot=10;
        #declare w1yrot=10;
        #declare w2xrot=20;
        #declare w2yrot=5;
        #declare w2zrot=5;
        object{wingl1(20) rotate y*195 translate<1.4,.6,5.1> }
        object{wingr1(20) rotate y*165 translate<-1.4,.6,5.1> }
        object{wingr1(20) rotate <0,210,-20> translate<1.4,.9,4.8> }
        object{wingr1(20) rotate <0,150,20> translate<-1.4,.9,4.8> }
#end


#macro burntlegs()
        object{burntleg(20,-90,45,-45,-30) translate <1,2,2.5>} 
        object{burntleg(20,90,45,45,-30) translate <-1,2,2.5>} 
        object{burntleg(20,-65,45,-45,-40) translate <1,3,2.5>} 
        object{burntleg(20,65,45,45,-40) translate <-1,3,2.5>} 
        object{burntleg(20,-40+15,45,-45,-50) translate <1,4,2.5>} 
        object{burntleg(20,40,45,45-10,-50) translate <-1,4,2.5>} 
        

#end

#macro burntleg(la1x,la1z,la2x,la2z,la3)
        #declare ll1=2;
        #declare ll2=1.5;
        #declare ll3=.8;
        union{
                union{
                        object{legsect(ll3) rotate x*-la3 translate <0,ll2,0>}
                        object{legsect(ll2)}
                        rotate <-la2x,0,la2z> translate <0,ll1,0>
                     }
                burntlegsect(ll1)
                rotate <-la1x,0,la1z>
             }
#end

#macro burntlegsect(len)
        blob{
                cylinder{0,<0,1,0>,.4,1}
                sphere{<.4,.5,0>,.8,.8}
                sphere{<.4,-.5,0>,.6,-.7}
                sphere{0,.2,.3}
                sphere{<0,1,0>,.2,.3}
                scale <len/2,len,len/2>
                pigment{Black}
            }
#end

#macro burntfly()
        union{
                burntbody(0,0)
                burntwings()
                burnthead()
                burntlegs()

              }
#end